/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.meta.IndexProperty;
import com.gridnine.xtrip.common.meta.IndexType;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.profile.BaseProfile;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.CashRegister;
import com.gridnine.xtrip.common.model.profile.CashRegisterWorkplace;
import com.gridnine.xtrip.common.model.profile.Contract;
import com.gridnine.xtrip.common.model.profile.Holding;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.security.acl.helper.AclModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclQueryable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import com.gridnine.xtrip.common.util.DateInterval;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.xml.XHelper;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModelAclIndexResourcePropertyProperty
implements AclResourceProperty,
AclQueryable {
    private static final Logger log = LoggerFactory.getLogger(ModelAclIndexResourcePropertyProperty.class);
    private final IndexType index;
    private final IndexProperty property;

    public ModelAclIndexResourcePropertyProperty(IndexType index, IndexProperty property) {
        this.index = index;
        this.property = property;
    }

    public String getId() {
        return TextUtil.concat((String[])new String[]{this.index.getId(), ".", this.property.getId()});
    }

    public String getName() {
        return this.property.getDisplayName();
    }

    public Class<?> getType() {
        Class type = this.resolveStandardType();
        if (type == null) {
            try {
                if (this.property.getType().contains("||")) {
                    String[] classNames = this.property.getType().split("[|]{2}");
                    type = XHelper.getClass((String)classNames[1]);
                } else {
                    type = XHelper.getClass((String)this.property.getType());
                }
            }
            catch (ClassNotFoundException e) {
                log.error(String.format("failed loading property %s class of index %s", this.property.getId(), this.index.getId()), (Throwable)e);
                throw new Error(String.format("failed loading property %s class of index %s", this.property.getId(), this.index.getId()), e);
            }
        }
        return type;
    }

    public String getResourceId() {
        return this.index.getId();
    }

    public Set<String> getConditionIds() {
        Class<?> type = this.getType();
        if (Boolean.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }
        if (String.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (Locale.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId()));
        }
        if (Number.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId()));
        }
        if (type.isEnum()) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        if (BaseDictionary.class.isAssignableFrom(type)) {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }
        if (BaseEntity.class.isAssignableFrom(type)) {
            if (Contract.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId()));
            }
            if (Holding.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId(), ModelAclResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId()));
            }
            if (Organization.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId()));
            }
            if (Branch.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId()));
            }
            if (SalesPoint.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId()));
            }
            if (CashRegister.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId()));
            }
            if (CashRegisterWorkplace.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId()));
            }
            if (Person.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId()));
            }
            if (BaseProfile.class.isAssignableFrom(type)) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId(), ModelAclResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId(), ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId(), ModelAclResourcePropertyConditions.MY_PERSONS.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }
        if (Date.class.isAssignableFrom(type)) {
            String format = this.property.getFormat();
            if (format != null && format.equals("dd.MM.yyyy HH:mm")) {
                return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId(), StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId(), StandardAclResourcePropertyConditions.TODAY.getId(), StandardAclResourcePropertyConditions.YESTERDAY.getId(), StandardAclResourcePropertyConditions.CURRENT_DECADE.getId(), StandardAclResourcePropertyConditions.LAST_DECADE.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
            }
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId(), StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId(), StandardAclResourcePropertyConditions.TODAY.getId(), StandardAclResourcePropertyConditions.YESTERDAY.getId(), StandardAclResourcePropertyConditions.CURRENT_DECADE.getId(), StandardAclResourcePropertyConditions.LAST_DECADE.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }
        return Collections.emptySet();
    }

    public String getRendererId(String conditionId) {
        Class<?> type = this.getType();
        if (Boolean.class.isAssignableFrom(type)) {
            return AclResourcePropertyType.NULL.name();
        }
        if (String.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (Locale.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.LOCALE.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.LOCALE_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (BigDecimal.class.isAssignableFrom(type)) {
            return AclResourcePropertyType.DECIMAL.name();
        }
        if (Number.class.isAssignableFrom(type)) {
            return AclResourcePropertyType.NUMBER.name();
        }
        if (type.isEnum()) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (BaseDictionary.class.isAssignableFrom(type)) {
            return AclResourcePropertyType.DICTIONARY_LIST.name();
        }
        if (BaseEntity.class.isAssignableFrom(type)) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        if (Date.class.isAssignableFrom(type)) {
            String format = this.property.getFormat();
            if (format != null && format.equals("dd.MM.yyyy HH:mm")) {
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                    return AclResourcePropertyType.DATE_TIME.name();
                }
                if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId) || StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                    return AclResourcePropertyType.DATE_TIME_INTERVAL.name();
                }
                return AclResourcePropertyType.NULL.name();
            }
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE.name();
            }
            if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(conditionId) || StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(conditionId)) {
                return AclResourcePropertyType.DATE_INTERVAL.name();
            }
            return AclResourcePropertyType.NULL.name();
        }
        return AclResourcePropertyType.STUB.name();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        return AclRulesHelper.getInfo((String)String.format("%s", this.getName()), (AclResourcePropertyCondition)condition, (Object)value);
    }

    public SearchCriterion getQuery(AclResourcePropertyCondition condition, Object value, String userId) {
        if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
            return AclRulesHelper.createEqualsCriterion((String)this.property.getId(), (Object)value);
        }
        if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
            return AclRulesHelper.createNotEqualsCriterion((String)this.property.getId(), (Object)value);
        }
        if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
            return AclRulesHelper.createIncludesCriterion((String)this.property.getId(), (Iterable)((Iterable)value), (boolean)false);
        }
        if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
            return AclRulesHelper.createNotIncludesCriterion((String)this.property.getId(), (Iterable)((Iterable)value), (boolean)false);
        }
        if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
            return AclRulesHelper.createEqualsCriterion((String)this.property.getId(), (Object)Boolean.TRUE);
        }
        if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
            return AclRulesHelper.createEqualsCriterion((String)this.property.getId(), (Object)Boolean.FALSE);
        }
        if (StandardAclResourcePropertyConditions.PERIOD_WITHIN.getId().equals(condition.getId())) {
            return AclRulesHelper.createPeriodWithinCriterion((String)this.property.getId(), (DateInterval)((DateInterval)value));
        }
        if (StandardAclResourcePropertyConditions.PERIOD_BEYOND.getId().equals(condition.getId())) {
            return AclRulesHelper.createPeriodBeyondCriterion((String)this.property.getId(), (DateInterval)((DateInterval)value));
        }
        if (StandardAclResourcePropertyConditions.TODAY.getId().equals(condition.getId())) {
            return AclRulesHelper.createTodayCriterion((String)this.property.getId());
        }
        if (StandardAclResourcePropertyConditions.YESTERDAY.getId().equals(condition.getId())) {
            return AclRulesHelper.createYesterdayCriterion((String)this.property.getId());
        }
        if (StandardAclResourcePropertyConditions.CURRENT_DECADE.getId().equals(condition.getId())) {
            return AclRulesHelper.createCurrentDecadeCriterion((String)this.property.getId());
        }
        if (StandardAclResourcePropertyConditions.LAST_DECADE.getId().equals(condition.getId())) {
            return AclRulesHelper.createLastDecadeCriterion((String)this.property.getId());
        }
        if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
            return AclRulesHelper.createIsNullCriterion((String)this.property.getId(), (boolean)false);
        }
        if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
            return AclRulesHelper.createIsNotNullCriterion((String)this.property.getId(), (boolean)false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CONTRACTS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsContractsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsHoldingsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_CHILDREN_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyChildrenOrganizationsHoldingsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsHoldingsOrganizationsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsChildrenOrganizationsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsCustomersCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsCustomersPersonsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrgnizationsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_BRANCHES.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsBranchesCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_SALES_POINTS_BRANCHES.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMySalesPointsBranchesCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_SALES_POINTS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyOrganizationsSalesPointsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_SALES_POINTS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMySalesPointsCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTERS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMySalesPointsCashRegistersCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_SALES_POINTS_CASH_REGISTER_WORKPLACES.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMySalesPointsCashRegisterWorkplacesCriterion(this.property.getId(), userId, false);
        }
        if (ModelAclResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
            return AclModelRulesHelper.createMyPersonsCriterion(this.property.getId(), userId, false);
        }
        return null;
    }

    private Class<?> resolveStandardType() {
        String type = this.property.getType();
        if ("byte[]".equals(type)) {
            return byte[].class;
        }
        if ("text".equals(type) || "String".equals(type)) {
            return String.class;
        }
        if ("boolean".equals(type) || "Boolean".equals(type)) {
            return Boolean.class;
        }
        if ("byte".equals(type) || "Byte".equals(type)) {
            return Byte.class;
        }
        if ("char".equals(type) || "Character".equals(type)) {
            return Character.class;
        }
        if ("short".equals(type) || "Short".equals(type)) {
            return Short.class;
        }
        if ("int".equals(type) || "Integer".equals(type)) {
            return Integer.class;
        }
        if ("long".equals(type) || "Long".equals(type)) {
            return Long.class;
        }
        if ("float".equals(type) || "Float".equals(type)) {
            return Float.class;
        }
        if ("double".equals(type) || "Double".equals(type)) {
            return Double.class;
        }
        return null;
    }
}

