/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.security.acl.resource;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionResourcePropertyConditions;
import com.gridnine.xtrip.common.model.restriction.resource.helper.RestrictionModelRulesHelper;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclEntityResources;
import com.gridnine.xtrip.common.model.security.acl.resource.ModelAclResourcePropertyConditions;
import com.gridnine.xtrip.common.security.acl.helper.AclRulesHelper;
import com.gridnine.xtrip.common.security.acl.resource.AclMatchable;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProperty;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyCondition;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcePropertyType;
import com.gridnine.xtrip.common.security.acl.resource.AclResourceProxy;
import com.gridnine.xtrip.common.security.acl.resource.AclResourcesEnvironment;
import com.gridnine.xtrip.common.security.acl.resource.StandardAclResourcePropertyConditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public enum ModelAclOrganizationResourceProperties implements AclResourceProperty,
AclMatchable
{
    OWNERSHIP{

        @Override
        public String getIdSuffix() {
            return "ownership";
        }

        public String getName() {
            return "\u041f\u0440\u0438\u043d\u0430\u0434\u043b\u0435\u0436\u043d\u043e\u0441\u0442\u044c";
        }

        public Class<?> getType() {
            return Organization.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(conditionId) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId().equals(conditionId) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS.getId().equals(conditionId) || ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Organization)object).getUid());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            EntityContainer orgCtr = EntityStorage.get().find(OrganizationIndex.class, "navigationKey", (Object)proxy.getId());
            if (orgCtr == null) {
                return false;
            }
            EntityContainer person = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)userId);
            if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS.getId().equals(condition.getId())) {
                return ProfileHelper.getPersonOrganizations(Collections.singletonList(person.toReference()), null, new Date()).contains(orgCtr.toReference());
            }
            if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN.getId().equals(condition.getId())) {
                return ProfileHelper.getOrganizationChildren(ProfileHelper.getPersonOrganizations(Collections.singletonList(person.toReference()), null, new Date())).contains(orgCtr.toReference());
            }
            if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS.getId().equals(condition.getId())) {
                return ProfileHelper.getHoldingOrganizations(ProfileHelper.getOrganizationHoldings(ProfileHelper.getPersonOrganizations(Collections.singletonList(person.toReference()), null, new Date()))).contains(orgCtr.toReference());
            }
            if (ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS.getId().equals(condition.getId())) {
                return ProfileHelper.getPersonsOrganizationsCustomers((EntityContainer<Person>)person).contains(orgCtr.toReference());
            }
            return true;
        }
    }
    ,
    CODE{

        @Override
        public String getIdSuffix() {
            return "code";
        }

        public String getName() {
            return "\u041a\u043e\u0434";
        }

        public Class<?> getType() {
            return String.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.STRING_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Organization)object).getCode());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                String code = (String)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)code, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)code, (Object)((String)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Object)code, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Object)code, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return AclRulesHelper.isNull((Object)code);
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isNull((Object)code);
                }
            }
            return true;
        }
    }
    ,
    TYPE{

        @Override
        public String getIdSuffix() {
            return "type";
        }

        public String getName() {
            return "\u0422\u0438\u043f";
        }

        public Class<?> getType() {
            return OrganizationType.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.INCLUDES.getId(), StandardAclResourcePropertyConditions.NOT_INCLUDES.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM.name();
            }
            if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENUM_LIST.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Organization)object).getTypes());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Set types = (Set)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Collection)types, (Object)((OrganizationType)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Collection)types, (Object)((OrganizationType)value));
                }
                if (StandardAclResourcePropertyConditions.INCLUDES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isIncludes((Collection)types, (Collection)((List)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_INCLUDES.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isIncludes((Collection)types, (Collection)((List)value));
                }
            }
            return true;
        }
    }
    ,
    DISABLED{

        @Override
        public String getIdSuffix() {
            return "disabled";
        }

        public String getName() {
            return "\u041d\u0435 \u043e\u0442\u043e\u0431\u0440\u0430\u0436\u0430\u0442\u044c \u0432 \u0441\u043f\u0438\u0441\u043a\u0430\u0445";
        }

        public Class<?> getType() {
            return Boolean.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.YES.getId(), StandardAclResourcePropertyConditions.NO.getId()));
        }

        public String getRendererId(String conditionId) {
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Organization)object).isDisabled());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            if (proxy.getProperties().containsKey(this.getId())) {
                Boolean disabled = (Boolean)proxy.getProperties().get(this.getId());
                if (StandardAclResourcePropertyConditions.YES.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.TRUE);
                }
                if (StandardAclResourcePropertyConditions.NO.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)disabled, (Object)Boolean.FALSE);
                }
            }
            return true;
        }
    }
    ,
    AUTHOR{

        @Override
        public String getIdSuffix() {
            return "author";
        }

        public String getName() {
            return "\u0410\u0432\u0442\u043e\u0440";
        }

        public Class<?> getType() {
            return Person.class;
        }

        public Set<String> getConditionIds() {
            return new HashSet<String>(Arrays.asList(StandardAclResourcePropertyConditions.EQUALS.getId(), StandardAclResourcePropertyConditions.NOT_EQUALS.getId(), StandardAclResourcePropertyConditions.NULL.getId(), StandardAclResourcePropertyConditions.NOT_NULL.getId(), ModelRestrictionResourcePropertyConditions.MY_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId(), ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId(), ModelAclResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId()));
        }

        public String getRendererId(String conditionId) {
            if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(conditionId) || StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(conditionId)) {
                return AclResourcePropertyType.ENTITY.name();
            }
            return AclResourcePropertyType.NULL.name();
        }

        public void init(AclResourceProxy proxy, Object object) {
            proxy.getProperties().put(this.getId(), ((Organization)object).getAuthor());
        }

        public boolean match(AclResourceProxy proxy, AclResourcePropertyCondition condition, Object value, String userId) {
            Person author;
            if (proxy.getProperties().containsKey(this.getId()) && (author = (Person)proxy.getProperties().get(this.getId())) != null) {
                if (StandardAclResourcePropertyConditions.EQUALS.getId().equals(condition.getId())) {
                    return AclRulesHelper.isEquals((Object)author, (Object)((Person)value));
                }
                if (StandardAclResourcePropertyConditions.NOT_EQUALS.getId().equals(condition.getId())) {
                    return !AclRulesHelper.isEquals((Object)author, (Object)((Person)value));
                }
                if (StandardAclResourcePropertyConditions.NULL.getId().equals(condition.getId())) {
                    return false;
                }
                if (StandardAclResourcePropertyConditions.NOT_NULL.getId().equals(condition.getId())) {
                    return true;
                }
                if (ModelRestrictionResourcePropertyConditions.MY_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyPersons(author, userId, false, RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CUSTOMERS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsCustomersPersons(author, userId, false, RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsPersons(author, userId);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_CHILDREN_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsChildrenPersons(author, userId);
                }
                if (ModelRestrictionResourcePropertyConditions.MY_ORGANIZATIONS_HOLDINGS_ORGANIZATIONS_PERSONS.getId().equals(condition.getId())) {
                    return RestrictionModelRulesHelper.isMyOrganizationsHoldingsOrganizationsPersons(author, userId, false, RestrictionModelRulesHelper.EntityCondition.EQUALS);
                }
            }
            return true;
        }
    };


    public abstract String getIdSuffix();

    public String getId() {
        return String.format("%s.%s", this.getResourceId(), this.getIdSuffix());
    }

    public String getResourceId() {
        return ModelAclEntityResources.ENTITY_ORGANIZATION.getId();
    }

    public String getInfo(AclResourcePropertyCondition condition, Object value) {
        AclResourcesEnvironment environment = (AclResourcesEnvironment)Environment.getPublished(AclResourcesEnvironment.class);
        String propertyName = this.getName();
        String resourceName = environment.getResource(this.getResourceId()).getName();
        return AclRulesHelper.getInfo((String)String.format("%s (%s)", propertyName, resourceName), (AclResourcePropertyCondition)condition, (Object)value);
    }
}

