/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.AeroexpressTicket;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.GdsName;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.AeroexpressTicketHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.ContractRelationDescription;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class AeroexpressReceiptRender {
    private static final String DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String TICKET_NUMBER = "TICKET_NUMBER";
    private static final String ORDER_NUMBER = "ORDER_NUMBER";
    private static final String FARE_TYPE = "FARE_TYPE";
    private static final String PRICE = "PRICE";
    private static final String VAT = "VAT";
    private static final String PASSENGER_NAME = "PASSENGER_NAME";
    private static final String PASSENGER_DOCUMENT = "PASSENGER_DOCUMENT";
    private static final String TIME_OF_PAYMENT = "TIME_OF_PAYMENT";
    private static final String DOCUMENT_NUMBER = "DOCUMENT_NUMBER";
    private static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String AGENCY_FULLNAME = "AGENCY_FULLNAME";
    private static final String TKP_CODE = "TKP_CODE";
    private static final String VALIDATOR = "VALIDATOR";
    private static final String AGENT_CODE = "AGENT_CODE";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, AeroexpressTicket product, EntityContainer<TemplateDocument> template, List<InformationNote> notes) throws Exception {
        JRDataSource dataSource;
        Locale locale;
        Map<String, Object> parameters;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters = this.getParameters(product, locale = this.getLocale((TemplateDocument)template.getEntity())), (JRDataSource)(dataSource = this.getDataSource(product, locale)), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(AeroexpressTicket product, Locale locale) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(DEPARTURE_DATE, product.getDepartureDate());
        parameters.put(TICKET_NUMBER, product.getSystemNumber());
        parameters.put(ORDER_NUMBER, product.getReservationId());
        parameters.put(FARE_TYPE, this.getFareType(product, locale));
        parameters.put(PRICE, product.getEquivalentFare());
        parameters.put(VAT, this.getVat(product));
        parameters.put(PASSENGER_NAME, this.getFullName(product.getTraveller(), locale));
        parameters.put(PASSENGER_DOCUMENT, this.getPassportNumber(product));
        parameters.put(TIME_OF_PAYMENT, product.getIssueDate());
        parameters.put(DOCUMENT_NUMBER, this.getDocumentNumber(product));
        parameters.put(PAYMENT_TYPE, this.getPaymentType(product, locale));
        parameters.put(AGENCY_FULLNAME, this.getAgencyFullName(product, locale));
        parameters.put(TKP_CODE, this.getTkpCode(product));
        parameters.put(VALIDATOR, this.getSirena(product, product.getValidator()));
        parameters.put(AGENT_CODE, this.getSirena(product, product.getAgentCode()));
        return parameters;
    }

    private String getDocumentNumber(AeroexpressTicket product) {
        if (product.getReservation() == null || product.getReservation().getBookingFile() == null) {
            return null;
        }
        return product.getReservation().getBookingFile().getNumber();
    }

    private String getFareType(AeroexpressTicket product, Locale locale) {
        if (product.getClassOfService() != null) {
            return product.getClassOfService().toString(locale);
        }
        return null;
    }

    private String getSirena(AeroexpressTicket product, String str) {
        if (TextUtil.isBlank((String)str)) {
            return null;
        }
        if (product.getReservation() != null && CommonReservationGdsNameInfoHelper.containsGds(product.getReservation(), GdsName.SIRENA)) {
            return str;
        }
        return null;
    }

    private String getTkpCode(AeroexpressTicket product) {
        EntityContainer resolve;
        EntityReference agency;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null && CommonReservationGdsNameInfoHelper.containsGds(product.getReservation(), GdsName.SIRENA) && (agency = product.getReservation().getBookingFile().getAgency()) != null && (resolve = EntityStorage.get().resolve(agency)) != null && resolve.getEntity() != null) {
            return ((Organization)resolve.getEntity()).getMetadata().stream().filter(Objects::nonNull).filter(m -> m.getKey() != null && m.getKey().getCode() != null).filter(m -> MetadataKey.KEY_TCH_AGENCY_CODE.name().equals(m.getKey().getCode())).map(m -> m.getValue().toString()).findFirst().orElse(null);
        }
        return null;
    }

    private String getAgencyFullName(AeroexpressTicket product, Locale locale) {
        EntityContainer resolve;
        EntityReference agency;
        if (product.getReservation() != null && product.getReservation().getBookingFile() != null && CommonReservationGdsNameInfoHelper.containsGds(product.getReservation(), GdsName.SIRENA) && (agency = product.getReservation().getBookingFile().getAgency()) != null && (resolve = EntityStorage.get().resolve(agency)) != null && resolve.getEntity() != null) {
            String name = (String)((Organization)resolve.getEntity()).getFullName().getValues().get(locale);
            if (TextUtil.isBlank((String)name)) {
                name = (String)((Organization)resolve.getEntity()).getShortName().getValues().get(locale);
            }
            if (TextUtil.isBlank((String)name)) {
                name = ((Organization)resolve.getEntity()).getFullName().getValues().values().stream().findFirst().orElse(null);
            }
            if (TextUtil.isBlank((String)name)) {
                name = ((Organization)resolve.getEntity()).getShortName().getValues().values().stream().findFirst().orElse(null);
            }
            return name;
        }
        return null;
    }

    private String getPaymentType(AeroexpressTicket product, Locale locale) {
        List<GeneralProductContractRelationData> contractRelations = AeroexpressTicketHelper.getContractRelations(product);
        for (GeneralProductContractRelationData item : contractRelations) {
            if (GeneralProductHelper.getContractType((EntityReference<ContractRelationDescription>)item.getDescription()) != ContractType.CLIENT || item.getFops().isEmpty()) continue;
            GeneralProductFop result = item.getFops().stream().filter(Objects::nonNull).filter(f -> f.getType() != null).findFirst().orElse(null);
            return result != null ? result.getType().toString(locale) : null;
        }
        return null;
    }

    private String getPassportNumber(AeroexpressTicket product) {
        if (product.getTraveller() != null && product.getTraveller().getPassport() != null) {
            Passport passport = product.getTraveller().getPassport();
            String passNumber = passport.getNumber();
            if (TextUtil.nonBlank((String)passNumber) && passNumber.length() > 2) {
                int visibleLeangth = passNumber.length() / 3;
                int cipher = passNumber.length() - visibleLeangth * 2;
                StringBuilder pn = new StringBuilder();
                pn.append(passNumber, 0, visibleLeangth);
                for (int i = cipher; i > 0; --i) {
                    pn.append("*");
                }
                pn.append(passNumber.substring(visibleLeangth + cipher));
                passNumber = pn.toString();
            }
            StringBuilder result = new StringBuilder();
            result.append(passport.getType() != null ? passport.getType().toString() : "").append(passport.getType() != null && TextUtil.nonBlank((String)passNumber) ? " " : "").append(TextUtil.nonBlank((String)passNumber) ? passNumber : "");
            return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
        }
        return null;
    }

    private Double getVat(AeroexpressTicket product) {
        if (product.getEquivalentFareVatValue() == null) {
            return null;
        }
        return product.getEquivalentFareVatValue().getRate();
    }

    private JRDataSource getDataSource(AeroexpressTicket product, Locale locale) {
        ArrayList data = new ArrayList();
        HashMap record = new HashMap();
        data.add(record);
        return new JRMapCollectionDataSource(data);
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getReportTitle(AeroexpressTicket product, TemplateDocument templateDocument) {
        return templateDocument.getTitle() + " " + product.getSystemNumber() + " " + (product.getTraveller() != null ? product.getTraveller().getName() : "") + " (" + new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + ")";
    }

    private String getFileName(AeroexpressTicket product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument) + ".pdf";
    }

    private String getFullName(Traveller traveller, Locale locale) {
        if (traveller == null) {
            return null;
        }
        String contactPerson = null;
        EntityReference passenger = traveller.getPassenger();
        EntityContainer resolve = EntityStorage.get().resolve(passenger);
        if (resolve != null && resolve.getEntity() != null) {
            Person person = (Person)resolve.getEntity();
            if (person == null) {
                return null;
            }
            contactPerson = this.getPersonName((String)person.getLastName().getValues().get(locale), (String)person.getFirstName().getValues().get(locale), (String)person.getMiddleName().getValues().get(locale));
            if (TextUtil.isBlank((String)contactPerson)) {
                contactPerson = this.getPersonName(person.getLastName().getValues().values().stream().findFirst().orElse(null), person.getFirstName().getValues().values().stream().findFirst().orElse(null), person.getMiddleName().getValues().values().stream().findFirst().orElse(null));
            }
        } else {
            Passport passport = traveller.getPassport();
            if (passport != null) {
                contactPerson = this.getPersonName(passport.getLastName(), passport.getFirstName(), passport.getMiddleName());
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getCyrillicName();
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getName();
            }
        }
        return contactPerson;
    }

    private String getPersonName(String lastName, String firstName, String middleName) {
        return TextUtil.nonEmptyStr((String)lastName) + (TextUtil.nonBlank((String)lastName) ? (TextUtil.nonBlank((String)firstName) ? " " + firstName : "") : (TextUtil.nonBlank((String)firstName) ? firstName : "")) + (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) ? "" : (TextUtil.nonBlank((String)middleName) ? " " + middleName : ""));
    }
}

