/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.jr.ReportParametersProvider;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleManager;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverter;
import com.gridnine.xtrip.common.l10n.model.Number2WordsConverterRegistry;
import com.gridnine.xtrip.common.l10n.model.PersonalLocalizableName;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.HistoricalValueHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BaseTicketProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.Payment;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.dict.AddressType;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.LegalForm;
import com.gridnine.xtrip.common.model.dict.ManagerType;
import com.gridnine.xtrip.common.model.dict.PreferenceKey;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.AirProductHelper;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.PersonalLocalizableNameFormatter;
import com.gridnine.xtrip.common.model.helpers.ProfileDao;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.StatisticsHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Address;
import com.gridnine.xtrip.common.model.profile.BankAccount;
import com.gridnine.xtrip.common.model.profile.BillingItemSettings;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.ContractCustomerIndex;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentSettings;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.Signature;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.user.UserData;
import com.gridnine.xtrip.common.util.CompositeNumber;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class PaymentJRDocumentRender {
    private static final String KEY_CURRENT_DATE = "CURRENT_DATE";
    private static final String KEY_CURRENT_PERSON = "CURRENT_PERSON";
    private static final String KEY_CUSTOMER = "CUSTOMER";
    private static final String KEY_AGENCY_FULLNAME = "AGENCY_FULLNAME";
    private static final String KEY_AGENCY_FULLNAME_FACTUAL = "AGENCY_FULLNAME_FACTUAL";
    private static final String KEY_AGENCY = "AGENCY";
    private static final String KEY_AGENCY_NAME = "AGENCY_NAME";
    private static final String KEY_AGENCY_FULL_LEGAL_FORM = "AGENCY_FULL_LEGAL_FORM";
    private static final String KEY_PAYMENT_NUMBER = "NUMBER";
    private static final String KEY_PAYMENT_DATE = "DATE";
    private static final String KEY_CONTRACT_NUMBER = "CONTRACT_NUMBER";
    private static final String KEY_CONTRACT_START_DATE = "CONTRACT_START_DATE";
    private static final String KEY_CONTRACT_END_DATE = "CONTRACT_END_DATE";
    private static final String FIELD_BILLING_ITEM_NUMBER = "NUMBER";
    private static final String FIELD_BILLING_ITEM_NAME = "NAME";
    private static final String FIELD_BILLING_ITEM_TOTAL = "TOTAL";
    private static final String FIELD_BILLING_ITEM_VAT = "VAT";
    private static final String FIELD_BILLING_ITEM_VAT_PERCENT = "VAT_PERCENT";
    private static final String FIELD_BILLING_ITEM_COUNT = "COUNT";
    private static final String FIELD_BILLING_ITEM_IS_SERVICE = "IS_SERVICE";
    private static final String KEY_CUSTOMER_FULLNAME = "CUSTOMER_FULLNAME";
    private static final String KEY_CUSTOMER_FULLNAME_FACTUAL = "CUSTOMER_FULLNAME_FACTUAL";
    private static final String KEY_CUSTOMER_DIRECTOR = "CUSTOMER_DIRECTOR";
    private static final String KEY_TOTAL_PRICE_STRING = "TOTAL_PRICE_STRING";
    private static final String KEY_TOTAL_VAT_STRING = "TOTAL_VAT_STRING";
    private static final String KEY_TOTAL_VAT = "TOTAL_VAT";
    private static final String KEY_TOTAL_PRICE = "TOTAL_PRICE";
    private static final String KEY_TOTAL_COMMISSION_STRING = "TOTAL_COMMISSION_STRING";
    private static final String KEY_MONEY_CODE = "MONEY_CODE";
    private static final String KEY_MONEY_SYMBOL = "MONEY_SYMBOL";
    private static final String KEY_FIN_DOC_NUMBER = "FIN_DOC_NUMBER";
    private static final String KEY_FIN_DOC_DATE = "FIN_DOC_DATE";
    private static final String KEY_AGENCY_ADDRESS = "AGENCY_ADDRESS";
    private static final String KEY_AGENCY_PHONE = "AGENCY_PHONE";
    private static final String KEY_AGENCY_FAX = "AGENCY_FAX";
    private static final String KEY_CUSTOMER_ADDRESS = "CUSTOMER_ADDRESS";
    private static final String KEY_CUSTOMER_PHONE = "CUSTOMER_PHONE";
    private static final String KEY_CUSTOMER_FAX = "CUSTOMER_FAX";
    private static final String KEY_AGENCY_INN = "AGENCY_INN";
    private static final String KEY_AGENCY_KPP = "AGENCY_KPP";
    private static final String KEY_AGENCY_OKPO = "AGENCY_OKPO";
    private static final String KEY_AGENCY_TAX_LICENSE_NUMBER = "AGENCY_TAX_LICENSE_NUMBER";
    private static final String KEY_AGENCY_BANK_BIK = "AGENCY_BANK_BIK";
    private static final String KEY_AGENCY_BANK_LORO_ACCAUNT = "AGENCY_BANK_LORO_ACCAUNT";
    private static final String KEY_AGENCY_BANK_SETTLEMENT_ACCAUNT = "AGENCY_BANK_SETTLEMENT_ACCAUNT";
    private static final String KEY_AGENCY_BANK_CITY = "AGENCY_BANK_CITY";
    private static final String KEY_AGENCY_BANK_NAME = "AGENCY_BANK_NAME";
    private static final String KEY_CUSTOMER_INN = "CUSTOMER_INN";
    private static final String KEY_CUSTOMER_KPP = "CUSTOMER_KPP";
    private static final String KEY_CUSTOMER_OKPO = "CUSTOMER_OKPO";
    private static final String KEY_CUSTOMER_BANK_NAME = "CUSTOMER_BANK_NAME";
    private static final String KEY_CUSTOMER_BANK_CITY = "CUSTOMER_BANK_CITY";
    private static final String KEY_CUSTOMER_BANK_BIK = "CUSTOMER_BANK_BIK";
    private static final String KEY_CUSTOMER_BANK_LORO_ACCOUNT = "CUSTOMER_BANK_LORO_ACCOUNT";
    private static final String KEY_CUSTOMER_BANK_SETTLEMENT_ACCOUNT = "CUSTOMER_BANK_SETTLEMENT_ACCOUNT";
    private static final String KEY_CASH_ORDER_TOTAL = "CASH_ORDER_TOTAL";
    private static final String KEY_CASH_ORDER_TOTAL_STRING = "CASH_ORDER_TOTAL_STRING";
    private static final String KEY_CASH_ORDER_SUBJECT = "CASH_ORDER_SUBJECT";
    private static final String KEY_IS_REFUND = "IS_REFUND";
    private static final String KEY_IS_RETAIL_CUSTOMER = "IS_RETAIL_CUSTOMER";
    private static final String KEY_IS_PAYER_RETAIL = "IS_PAYER_RETAIL";
    private static final String KEY_STAMP = "STAMP";
    private static final String KEY_PAYER_NAME = "PAYER_NAME";
    private static final String KEY_PAYER_FULLNAME = "PAYER_FULLNAME";
    private static final String KEY_PAYER_FULLNAME_FACTUAL = "PAYER_FULLNAME_FACTUAL";
    private static final String KEY_PAYER_ADDRESS = "PAYER_ADDRESS";
    private static final String KEY_PAYER_PHONE = "PAYER_PHONE";
    private static final String KEY_PAYER_FAX = "PAYER_FAX";
    private static final String KEY_PAYER_INN = "PAYER_INN";
    private static final String KEY_PAYER_KPP = "PAYER_KPP";
    private static final PersonalLocalizableNameFormatter nameFormatter = new PersonalLocalizableNameFormatter("L f m");

    private static void addSignatureAndStamp(HashMap<String, Object> parameters, EntityContainer<Person> agent, boolean printSignature, FinanceDocumentSettings fds, Locale locale) {
        for (Signature signature : fds.getSignatures()) {
            String title;
            EntityContainer signerContainer;
            if (signature.getPosition() == null) continue;
            EntityContainer entityContainer = signerContainer = signature.isUseAgent() ? agent : EntityStorage.get().resolve(signature.getSigner());
            if (signerContainer != null) {
                String name = nameFormatter.format((PersonalLocalizableName)signerContainer.getEntity(), locale, false);
                if (!TextUtil.isBlank((String)signature.getComment())) {
                    name = name + " " + signature.getComment();
                }
                parameters.put("AGENCY_" + signature.getPosition().getCode() + "_NAME", name);
            }
            if (TextUtil.isBlank((String)(title = signature.getTitle().toString()))) {
                title = signature.getPosition().toString();
            }
            parameters.put("AGENCY_" + signature.getPosition().getCode() + "_TITLE", title);
            parameters.put("AGENCY_" + signature.getPosition().getCode() + "_COMMENT", signature.getComment());
            if (!printSignature || signature.getSignature() == null) continue;
            ImageData signatureImageData = new ImageData(signature.getSignature());
            parameters.put("AGENCY_" + signature.getPosition().getCode() + "_SIGNATURE", new ByteArrayInputStream(signature.getSignature()));
            parameters.put("AGENCY_" + signature.getPosition().getCode() + "_SIGNATURE_WIDTH", signatureImageData.getWidth());
            parameters.put("AGENCY_" + signature.getPosition().getCode() + "_SIGNATURE_HEIGHT", signatureImageData.getWidth());
        }
        if (fds.isUseFacsimile() && fds.getStamp() != null) {
            parameters.put(KEY_STAMP, new ByteArrayInputStream(fds.getStamp()));
        }
    }

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bfCtr, Payment payment, FinanceDocument doc, EntityContainer<TemplateDocument> template, ReportParametersProvider callback) throws Exception {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        return this.renderReport(bfCtr, payment, doc, template, callback, parameters);
    }

    private static void someCommentedCode() {
    }

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bfCtr, Payment payment, FinanceDocument doc, EntityContainer<TemplateDocument> template, ReportParametersProvider callback, Map<String, Object> parameters) throws Exception {
        FinanceDocumentSettings fds;
        LinkedHashSet<Message> messages = new LinkedHashSet<Message>();
        JasperReport report = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        Locale locale = this.getLocale((TemplateDocument)template.getEntity());
        FinanceDocumentsProperties fdp = FinanceDocumentsHelper.getFinanceDocumentProperties((BookingFile)bfCtr.getEntity(), payment);
        Map<String, Object> xtripParams = this.getParameters(bfCtr, payment, doc, fdp, fds = FinanceDocumentsHelper.getFinanceDocumentSettings((BookingFile)bfCtr.getEntity(), doc.getType()), report, locale, messages);
        if (xtripParams == null) {
            return PaymentJRDocumentRender.createErrorDocument(messages);
        }
        parameters.putAll(xtripParams);
        byte[] content = JasperUtil.fillReport((JasperReport)report, parameters, (JRDataSource)this.getDataSource(payment, doc, fdp, fds, report, locale, messages), (ReportParametersProvider)callback);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(payment, doc));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(payment, doc));
        file.setType(DocumentType.INVOICE);
        file.setCreated(date);
        file.setNavigationKey(payment.getUid());
        file.setOwner(bfCtr.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(EntityContainer<BookingFile> bfCtr, Payment payment, FinanceDocument doc, FinanceDocumentsProperties fdp, FinanceDocumentSettings fds, JasperReport jasperReport, Locale locale, Set<Message> messages) throws Exception {
        BankAccount bankAccount;
        EntityContainer personContainer;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        EntityContainer customerCtr = EntityStorage.get().resolve(((BookingFile)bfCtr.getEntity()).getCustomerProfile());
        if (customerCtr == null) {
            this.addMessage(messages, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u0437\u0430\u0433\u0440\u0443\u0437\u0438\u0442\u044c \u043f\u0440\u043e\u0444\u0438\u043b\u044c \u043f\u043e\u043a\u0443\u043f\u0430\u0442\u0435\u043b\u044f", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        parameters.put(KEY_IS_RETAIL_CUSTOMER, ((Organization)customerCtr.getEntity()).getCode() != null && ((Organization)customerCtr.getEntity()).getCode().equals(DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null)));
        if (payment == null) {
            this.addMessage(messages, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u043f\u043b\u0430\u0442\u0435\u0436", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        EntityContainer<Organization> agencyCtr = FinanceDocumentsHelper.getAgency((BookingFile)bfCtr.getEntity(), payment);
        if (agencyCtr == null) {
            this.addMessage(messages, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0441\u0443\u0431\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e/\u0430\u0433\u0435\u043d\u0442\u0441\u0442\u0432\u043e, \u043e\u0442 \u043b\u0438\u0446\u0430 \u043a\u043e\u0442\u043e\u0440\u043e\u0433\u043e \u0432\u044b\u0441\u0442\u0430\u0432\u043b\u044f\u0435\u0442\u0441\u044f \u0441\u0447\u0435\u0442", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        if (doc == null) {
            this.addMessage(messages, "\u043d\u0435 \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0435\u043d \u0442\u0438\u043f \u0444\u0438\u043d\u0430\u043d\u0441\u043e\u0432\u043e\u0433\u043e \u0434\u043e\u043a\u0443\u043c\u0435\u043d\u0442\u0430", null, MessageType.ERROR, new Object[0]);
            return null;
        }
        Date date = new Date();
        parameters.put("REPORT_LOCALE", locale);
        parameters.put(KEY_CURRENT_DATE, date);
        String user = UserData.get().getCurrentUser();
        if (user != null && (personContainer = EntityStorage.get().find(PersonIndex.class, PersonIndex.Property.loginName.name(), (Object)user)) != null) {
            parameters.put(KEY_CURRENT_PERSON, nameFormatter.format((PersonalLocalizableName)personContainer.getEntity(), locale, false));
        }
        EntityReference customerReference = customerCtr.toReference();
        Organization customer = (Organization)customerCtr.getEntity();
        List<Address> customerAddresses = ProfileHelper.getOrganizationAddresses(customer, doc.getDate());
        parameters.put(KEY_CUSTOMER, ProfileHelper.getFullName(customer.getCode(), customer.getShortName(), customer.getFullName(), (DictionaryReference<LegalForm>)customer.getLegalForm(), locale, false));
        boolean refund = FinanceDocumentsHelper.isPaymentForRefund(payment);
        parameters.put(KEY_IS_REFUND, refund);
        parameters.put(KEY_CUSTOMER_FULLNAME, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference<LegalForm>)customer.getLegalForm(), locale), customer.getFullName(), (String)HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)payment.getDate()), (String)HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)payment.getDate()), customerAddresses, AddressType.LEGAL, customer.getBankAccounts(), locale, false));
        parameters.put(KEY_CUSTOMER_FULLNAME_FACTUAL, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference<LegalForm>)customer.getLegalForm(), locale), customer.getFullName(), (String)HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)payment.getDate()), (String)HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)payment.getDate()), customerAddresses, AddressType.FACTUAL, customer.getBankAccounts(), locale, false));
        parameters.put("NUMBER", TextUtil.buildFullNumber((CompositeNumber)payment));
        parameters.put(KEY_FIN_DOC_NUMBER, TextUtil.buildFullNumber((CompositeNumber)doc));
        parameters.put(KEY_FIN_DOC_DATE, doc.getDate());
        parameters.put(KEY_PAYMENT_DATE, payment.getDate());
        SearchQuery query = new SearchQuery();
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.contractType.name(), (Object)ContractType.CLIENT));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.supplier.name(), (Object)agencyCtr.toReference()));
        query.getCriteria().getCriterions().add(SearchCriterion.eq((String)ContractCustomerIndex.Property.customer.name(), (Object)customerCtr.toReference()));
        List indexes = EntityStorage.get().search(ContractCustomerIndex.class, query).getData();
        if (indexes.size() > 0) {
            ContractCustomerIndex index = (ContractCustomerIndex)indexes.get(0);
            parameters.put(KEY_CONTRACT_NUMBER, index.getNumber());
            SimpleDateFormat format = new SimpleDateFormat("dd.MM.yyyy");
            parameters.put(KEY_CONTRACT_START_DATE, index.getStartDate() != null ? format.format(index.getStartDate()) : null);
            parameters.put(KEY_CONTRACT_END_DATE, index.getEndDate() != null ? format.format(index.getEndDate()) : null);
        }
        BigDecimal totalPrice = BigDecimal.ZERO;
        BigDecimal totalVat = BigDecimal.ZERO;
        BigDecimal totalCashOrder = BigDecimal.ZERO;
        BigDecimal totalCommission = BigDecimal.ZERO;
        HashSet<String> returnedTicketNumbers = new HashSet<String>();
        HashSet<EntityReference> returnedBlankOwners = new HashSet<EntityReference>();
        for (BillingItem item : doc.getBillingItems()) {
            if (item.getAmount() == null || item.getAmount().getTotal() == null) continue;
            BillingItemSettings bis = fds != null ? FinanceDocumentsHelper.getBillingItemSettings(fds.getBillingItemsSettings(), item.getServiceType()) : null;
            totalPrice = totalPrice.add(item.getAmount().getTotal());
            if (item.getServiceType() == ServiceType.TICKET) {
                totalCommission = totalCommission.add(this.getTotalCommission(item, payment.getBookingFile()));
            }
            if (item.getAmount().getVatAmount() != null && (item.getServiceType() == ServiceType.FEE && !((Organization)agencyCtr.getEntity()).isSimpleTaxed() || bis == null || bis.isIncludeVat())) {
                totalVat = totalVat.add(item.getAmount().getVatAmount());
            }
            if (doc.getType() != FinanceDocumentType.CASH_ORDER) continue;
            if (item.getServiceType() == ServiceType.TICKET) {
                for (String uid : item.getProductUids()) {
                    BaseTicketProduct baseTicketProduct;
                    BaseProduct baseProduct = BookingHelper.findProduct(payment.getBookingFile(), uid);
                    if (!(baseProduct instanceof BaseTicketProduct) || (baseTicketProduct = (BaseTicketProduct)baseProduct).getStatus() != ProductStatus.REFUND) continue;
                    if (baseTicketProduct.getBlankOwnerRef() != null) {
                        returnedBlankOwners.add(baseTicketProduct.getBlankOwnerRef());
                    }
                    if (TextUtil.isBlank((String)baseTicketProduct.getSystemNumber())) continue;
                    returnedTicketNumbers.add(baseTicketProduct.getSystemNumber());
                }
            }
            totalCashOrder = totalCashOrder.subtract(item.getAmount().getTotal());
        }
        if (doc.getType() == FinanceDocumentType.STANDARD_BILL && refund) {
            totalPrice = totalPrice.negate();
            totalVat = totalVat.negate();
        }
        String currencyCode = DictHelper.getPreferenceValue(PreferenceKey.EQUIVE_CURRENCY, "RUB");
        parameters.put(KEY_MONEY_CODE, currencyCode);
        parameters.put(KEY_MONEY_SYMBOL, currencyCode != null ? MiscUtil.getCurrencySymbol((String)currencyCode) : null);
        parameters.put(KEY_TOTAL_PRICE, totalPrice);
        parameters.put(KEY_TOTAL_VAT, totalVat);
        parameters.put(KEY_TOTAL_PRICE_STRING, this.getMoneyStr(totalPrice, locale, currencyCode));
        parameters.put(KEY_TOTAL_VAT_STRING, this.getMoneyStr(totalVat, locale, currencyCode));
        parameters.put(KEY_TOTAL_COMMISSION_STRING, this.getMoneyStr(totalCommission, locale, currencyCode));
        if (doc.getType() == FinanceDocumentType.CASH_ORDER) {
            parameters.put(KEY_CASH_ORDER_TOTAL, totalCashOrder);
            parameters.put(KEY_CASH_ORDER_TOTAL_STRING, this.getMoneyStr(totalCashOrder, locale, currencyCode));
            StringBuilder sb = new StringBuilder("\u0432\u043e\u0437\u0432\u0440\u0430\u0442 \u0441\u0442\u043e\u0438\u043c\u043e\u0441\u0442\u0438 \u0431\u0438\u043b\u0435\u0442\u043e\u0432");
            if (!returnedBlankOwners.isEmpty()) {
                sb.append(" ");
            }
            boolean first = true;
            for (EntityReference bo : returnedBlankOwners) {
                sb.append(first ? " " : ", ");
                sb.append(bo.toString());
                first = false;
            }
            first = true;
            for (String tn : returnedTicketNumbers) {
                sb.append(first ? " " : ", ");
                sb.append(tn);
                first = false;
            }
            parameters.put(KEY_CASH_ORDER_SUBJECT, sb.toString());
        }
        Organization agency = (Organization)agencyCtr.getEntity();
        List agencyAddresses = ProfileHelper.getOrganizationAddresses(agency, doc.getDate());
        EntityContainer<Branch> branchCtr = FinanceDocumentsHelper.getBranch((BookingFile)bfCtr.getEntity(), payment);
        Branch branch = branchCtr != null ? (Branch)branchCtr.getEntity() : null;
        parameters.put(KEY_AGENCY, ProfileHelper.getFullName(agency.getCode(), agency.getShortName(), agency.getFullName(), (DictionaryReference<LegalForm>)agency.getLegalForm(), locale, false));
        parameters.put(KEY_AGENCY_NAME, ProfileHelper.getFullName(agency.getCode(), agency.getShortName(), agency.getFullName(), null, locale, false));
        parameters.put(KEY_AGENCY_FULL_LEGAL_FORM, this.getFullLegalForm((DictionaryReference<LegalForm>)agency.getLegalForm(), locale));
        parameters.put(KEY_AGENCY_FULLNAME, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference<LegalForm>)agency.getLegalForm(), locale), agency.getFullName(), (String)HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)payment.getDate()), (String)HistoricalValueHelper.getValue((List)agency.getKppHistory(), (Date)payment.getDate()), agencyAddresses, AddressType.LEGAL, agency.getBankAccounts(), locale, false));
        parameters.put(KEY_AGENCY_FULLNAME_FACTUAL, this.buildOrganizationFullName(DictHelper.getShortLegalForm((DictionaryReference<LegalForm>)agency.getLegalForm(), locale), agency.getFullName(), (String)HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)payment.getDate()), (String)HistoricalValueHelper.getValue((List)agency.getKppHistory(), (Date)payment.getDate()), agencyAddresses, AddressType.FACTUAL, agency.getBankAccounts(), locale, false));
        parameters.put(KEY_AGENCY_ADDRESS, this.buildAddress(branch != null ? branch.getAddresses() : agencyAddresses, AddressType.LEGAL, locale));
        parameters.put(KEY_AGENCY_PHONE, this.buildPhone(branch != null ? branch.getCommunications() : agency.getCommunications(), false));
        parameters.put(KEY_AGENCY_FAX, this.buildPhone(branch != null ? branch.getCommunications() : agency.getCommunications(), true));
        parameters.put(KEY_AGENCY_INN, HistoricalValueHelper.getValue((List)agency.getRegistrationIdHistory(), (Date)payment.getDate()));
        parameters.put(KEY_AGENCY_KPP, HistoricalValueHelper.getValue((List)(branch != null ? branch.getKppHistory() : agency.getKppHistory()), (Date)payment.getDate()));
        parameters.put(KEY_AGENCY_OKPO, agency.getOkpoCode());
        parameters.put(KEY_AGENCY_TAX_LICENSE_NUMBER, HistoricalValueHelper.getValue((List)agency.getVatLicenseNumberHistory(), (Date)payment.getDate()));
        parameters.put(KEY_CUSTOMER_ADDRESS, this.buildAddress(customerAddresses, AddressType.LEGAL, locale));
        parameters.put(KEY_CUSTOMER_PHONE, this.buildPhone(customer.getCommunications(), false));
        parameters.put(KEY_CUSTOMER_FAX, this.buildPhone(customer.getCommunications(), true));
        parameters.put(KEY_CUSTOMER_INN, HistoricalValueHelper.getValue((List)customer.getRegistrationIdHistory(), (Date)payment.getDate()));
        parameters.put(KEY_CUSTOMER_KPP, HistoricalValueHelper.getValue((List)customer.getKppHistory(), (Date)payment.getDate()));
        parameters.put(KEY_CUSTOMER_OKPO, customer.getOkpoCode());
        BankAccount customerBankAccount = null;
        List bankAccounts = customer.getBankAccounts();
        if (bankAccounts != null && bankAccounts.size() > 0) {
            customerBankAccount = (BankAccount)bankAccounts.get(0);
        }
        if (customerBankAccount != null) {
            parameters.put(KEY_CUSTOMER_BANK_NAME, customerBankAccount.getBankName());
            parameters.put(KEY_CUSTOMER_BANK_BIK, customerBankAccount.getBik());
            parameters.put(KEY_CUSTOMER_BANK_CITY, customerBankAccount.getCity() != null ? customerBankAccount.getCity().toString() : null);
            parameters.put(KEY_CUSTOMER_BANK_LORO_ACCOUNT, customerBankAccount.getCorrespondentAccount());
            parameters.put(KEY_CUSTOMER_BANK_SETTLEMENT_ACCOUNT, customerBankAccount.getSettlementAccount());
        }
        if ((bankAccount = payment.getBankAccount()) == null) {
            bankAccount = agency.getFinanceDocumentProperties().getBankAccount();
        }
        if (bankAccount == null && !agency.getBankAccounts().isEmpty()) {
            bankAccount = (BankAccount)agency.getBankAccounts().get(0);
        }
        if (bankAccount != null) {
            parameters.put(KEY_AGENCY_BANK_NAME, bankAccount.getBankName());
            parameters.put(KEY_AGENCY_BANK_BIK, bankAccount.getBik());
            parameters.put(KEY_AGENCY_BANK_CITY, bankAccount.getCity() != null ? bankAccount.getCity().toString() : null);
            parameters.put(KEY_AGENCY_BANK_LORO_ACCAUNT, bankAccount.getCorrespondentAccount());
            parameters.put(KEY_AGENCY_BANK_SETTLEMENT_ACCAUNT, bankAccount.getSettlementAccount());
        }
        PaymentJRDocumentRender.someCommentedCode();
        if (fds != null) {
            PaymentJRDocumentRender.addSignatureAndStamp(parameters, FinanceDocumentsHelper.getAgent((BookingFile)bfCtr.getEntity(), payment), doc.isIncludeStamp() && fds.isUseFacsimile(), fds, locale);
        }
        List<Person> customerEmployees = ProfileDao.getEmployees((EntityReference<Organization>)customerReference, new ManagerType[0], null);
        block4: for (Person employee : customerEmployees) {
            String fullName = ProfileHelper.getFullName(employee, locale, false);
            Set<ManagerType> standardPositions = ProfileHelper.getStandardPositions(employee.getEmployments(), (EntityReference<Organization>)customerReference);
            for (ManagerType standardPosition : standardPositions) {
                if (standardPosition != ManagerType.DIRECTOR) continue;
                parameters.put(KEY_CUSTOMER_DIRECTOR, fullName);
                continue block4;
            }
        }
        EntityContainer payerContainer = EntityStorage.get().resolve(this.getPayer(doc, (BookingFile)bfCtr.getEntity()));
        if (payerContainer != null) {
            this.addPayerValues(parameters, (EntityContainer<Organization>)payerContainer, payment, locale);
        }
        return parameters;
    }

    private void addPayerValues(HashMap<String, Object> parameters, EntityContainer<Organization> payerContainer, Payment payment, Locale locale) {
        Organization payer = (Organization)payerContainer.getEntity();
        List<Address> payerAddresses = ProfileHelper.getOrganizationAddresses(payer, payment.getDate());
        parameters.put(KEY_IS_PAYER_RETAIL, payer.getCode() != null && payer.getCode().equals(DictHelper.getPreferenceValue(PreferenceKey.RETAIL_PROFILE_CODE, null)));
        parameters.put(KEY_PAYER_NAME, ProfileHelper.getFullName(payer.getCode(), payer.getShortName(), payer.getFullName(), (DictionaryReference<LegalForm>)payer.getLegalForm(), locale, false));
        String registrationIdValue = (String)HistoricalValueHelper.getValue((List)payer.getRegistrationIdHistory(), (Date)payment.getDate());
        String kppValue = (String)HistoricalValueHelper.getValue((List)payer.getKppHistory(), (Date)payment.getDate());
        String shortLegalForm = DictHelper.getShortLegalForm((DictionaryReference<LegalForm>)payer.getLegalForm(), locale);
        parameters.put(KEY_PAYER_FULLNAME, this.buildOrganizationFullName(shortLegalForm, payer.getFullName(), registrationIdValue, kppValue, payerAddresses, AddressType.LEGAL, payer.getBankAccounts(), locale, false));
        parameters.put(KEY_PAYER_FULLNAME_FACTUAL, this.buildOrganizationFullName(shortLegalForm, payer.getFullName(), registrationIdValue, kppValue, payerAddresses, AddressType.FACTUAL, payer.getBankAccounts(), locale, false));
        parameters.put(KEY_PAYER_ADDRESS, this.buildAddress(payerAddresses, AddressType.LEGAL, locale));
        parameters.put(KEY_PAYER_PHONE, this.buildPhone(payer.getCommunications(), false));
        parameters.put(KEY_PAYER_FAX, this.buildPhone(payer.getCommunications(), true));
        parameters.put(KEY_PAYER_INN, registrationIdValue);
        parameters.put(KEY_PAYER_KPP, kppValue);
    }

    private JRDataSource getDataSource(Payment payment, FinanceDocument doc, FinanceDocumentsProperties fdp, FinanceDocumentSettings fds, JasperReport jasperReport, Locale locale, Set<Message> messages) {
        boolean group;
        if (doc.getType() == FinanceDocumentType.CASH_ORDER) {
            return new JREmptyDataSource();
        }
        ArrayList data = new ArrayList();
        boolean refund = FinanceDocumentsHelper.isPaymentForRefund(payment);
        EntityContainer agencyContainer = EntityStorage.get().resolve(payment.getBookingFile().getAgency());
        boolean noVat = agencyContainer != null && ((Organization)agencyContainer.getEntity()).isSimpleTaxed();
        Map<String, List<BillingItem>> maps = new LinkedHashMap<String, List<BillingItem>>();
        for (BillingItem billingItem : doc.getBillingItems()) {
            if (billingItem.getProductUids().isEmpty()) continue;
            String uid = (String)billingItem.getProductUids().iterator().next();
            List billingItems = maps.computeIfAbsent(uid, k -> new ArrayList());
            billingItems.add(billingItem);
        }
        boolean merge = fds != null && fds.isMergeBillingItems();
        boolean bl = group = fds != null && fds.isGroupBillingItems();
        if (merge) {
            maps = this.mergeBillingItems(maps);
        }
        if (group) {
            maps = this.groupBillingItems(maps);
        }
        Map<ServiceType, List<BillingItem>> billingItemsMap = this.groupBillingItemsByServiceType(maps);
        int count = 0;
        for (List<BillingItem> billingItems : billingItemsMap.values()) {
            for (BillingItem item : billingItems) {
                BillingItemSettings bis = fds != null ? FinanceDocumentsHelper.getBillingItemSettings(fds.getBillingItemsSettings(), item.getServiceType()) : null;
                BigDecimal coeff = BigDecimal.ONE;
                if (refund && doc.getType() == FinanceDocumentType.STANDARD_BILL) {
                    coeff = coeff.negate();
                }
                HashMap<String, Object> record = new HashMap<String, Object>();
                record.put("NUMBER", count + 1);
                int size = item.getProductUids().size();
                if (size <= 0) {
                    messages.add(SystemHelper.createMessage(MessageType.WARNING, "\u043d\u0435 \u0443\u0434\u0430\u0435\u0442\u0441\u044f \u043e\u043f\u0440\u0435\u0434\u0435\u043b\u0438\u0442\u044c \u0447\u0438\u0441\u043b\u043e \u043f\u043e\u0437\u0438\u0446\u0438\u0439 \u0434\u043b\u044f \u0443\u0441\u043b\u0443\u0433\u0438 \"{0}\", \u0431\u0443\u0434\u0435\u0442 \u0438\u0441\u043f\u043e\u043b\u044c\u0437\u043e\u0432\u0430\u043d\u043e 1", item.getName()));
                }
                record.put(FIELD_BILLING_ITEM_COUNT, size);
                record.put(FIELD_BILLING_ITEM_IS_SERVICE, item.getServiceType() != ServiceType.TICKET);
                record.put(FIELD_BILLING_ITEM_NAME, item.getName());
                if (item.getAmount() != null) {
                    if (item.getAmount().getTotal() != null) {
                        record.put(FIELD_BILLING_ITEM_TOTAL, item.getAmount().getTotal().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP).multiply(coeff));
                    }
                    if (bis == null || bis.isIncludeVat() || item.getServiceType() == ServiceType.FEE && !noVat) {
                        Double vat;
                        if (item.getAmount().getVatAmount() != null) {
                            record.put(FIELD_BILLING_ITEM_VAT, item.getAmount().getVatAmount().divide(BigDecimal.valueOf(size), 2, RoundingMode.HALF_UP).multiply(coeff));
                        }
                        if ((vat = item.getAmount().getVat()) != null) {
                            vat = BigDecimal.valueOf(vat).divide(BigDecimal.ONE, 1, RoundingMode.HALF_UP).doubleValue();
                        }
                        record.put(FIELD_BILLING_ITEM_VAT_PERCENT, vat);
                    }
                }
                HashMap<String, String> costCodeVaues = new HashMap<String, String>();
                for (String string : item.getProductUids()) {
                    StatisticalData statisticalData;
                    Product product = BookingHelper.findProductByUid(string, payment.getBookingFile(), Product.class);
                    if (product == null || (statisticalData = product.getStatisticalData()) == null) continue;
                    for (CostCode costCode : StatisticsHelper.getAllCostCodes(statisticalData)) {
                        CostCodeProperties costCodeProperties = costCode.getCostCodeProperties();
                        String costCodeValue = costCode.getValue();
                        if (costCodeProperties == null || costCodeProperties.getType() == null || costCodeValue == null) continue;
                        costCodeVaues.put(costCodeProperties.getType().name(), costCodeValue);
                    }
                }
                for (Map.Entry entry : costCodeVaues.entrySet()) {
                    record.put((String)entry.getKey(), entry.getValue());
                }
                data.add(record);
                ++count;
            }
        }
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }

    private Map<String, List<BillingItem>> mergeBillingItems(Map<String, List<BillingItem>> map) {
        LinkedHashMap<String, List<BillingItem>> mergedBillingItemDatasMap = new LinkedHashMap<String, List<BillingItem>>();
        for (Map.Entry<String, List<BillingItem>> entry : map.entrySet()) {
            String uid = entry.getKey();
            List<BillingItem> billingItems = entry.getValue();
            BillingItem mergedBillingItem = new BillingItem();
            for (BillingItem billingItem : billingItems) {
                if (mergedBillingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() == ServiceType.TICKET) {
                    mergedBillingItem.setName(billingItem.getName());
                    mergedBillingItem.setCommissionType(billingItem.getCommissionType());
                    mergedBillingItem.setServiceType(billingItem.getServiceType());
                    mergedBillingItem.getProductUids().clear();
                    mergedBillingItem.getProductUids().addAll(billingItem.getProductUids());
                }
                if (billingItem.getAmount() == null) continue;
                VatAmount amount = mergedBillingItem.getAmount();
                if (amount == null) {
                    amount = new VatAmount();
                    mergedBillingItem.setAmount(amount);
                }
                BigDecimal totalAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount.getTotal(), billingItem.getAmount().getTotal()});
                BigDecimal vatAmount = MiscUtil.sum((BigDecimal[])new BigDecimal[]{amount.getVatAmount(), billingItem.getAmount().getVatAmount()});
                amount.setTotalVatAmount(totalAmount, vatAmount);
            }
            mergedBillingItemDatasMap.put(uid, Collections.singletonList(mergedBillingItem));
        }
        return mergedBillingItemDatasMap;
    }

    private Map<String, List<BillingItem>> groupBillingItems(Map<String, List<BillingItem>> map) {
        return map;
    }

    private Map<ServiceType, List<BillingItem>> groupBillingItemsByServiceType(Map<String, List<BillingItem>> map) {
        TreeMap<ServiceType, List<BillingItem>> groupedMap = new TreeMap<ServiceType, List<BillingItem>>(new Comparator<ServiceType>(){
            List<ServiceType> indexes = new ArrayList<ServiceType>();
            {
                this.indexes.add(ServiceType.TICKET);
                this.indexes.add(ServiceType.PENALTY);
                this.indexes.add(ServiceType.FEE);
                this.indexes.add(ServiceType.DISCOUNT);
            }

            @Override
            public int compare(ServiceType o1, ServiceType o2) {
                int index1 = this.indexes.indexOf(o1);
                int index2 = this.indexes.indexOf(o2);
                return Integer.compare(index1, index2);
            }
        });
        for (List<BillingItem> items : map.values()) {
            for (BillingItem item : items) {
                ServiceType serviceType = item.getServiceType();
                List billingItems = groupedMap.computeIfAbsent(serviceType, k -> new ArrayList());
                billingItems.add(item);
            }
        }
        return groupedMap;
    }

    private EntityReference<Organization> getPayer(FinanceDocument document, BookingFile bookingFile) {
        for (BillingItem billingItem : document.getBillingItems()) {
            for (String productUid : billingItem.getProductUids()) {
                ProductHandler<?> handler;
                Object baseProduct = BookingHelper.findProductByUid(productUid, bookingFile);
                if (baseProduct == null || (handler = HandlersRegistry.get().findProductHandler(baseProduct.getClass())) == null) continue;
                for (GeneralProductFop fop : GeneralProductHelper.getUnmodifiableFops(baseProduct, ContractType.CLIENT)) {
                    if (fop.getPayer() == null) continue;
                    return fop.getPayer();
                }
            }
        }
        return null;
    }

    private BigDecimal getTotalCommission(BillingItem item, BookingFile bookingFile) throws Exception {
        BigDecimal result = BigDecimal.ZERO;
        for (String uid : item.getProductUids()) {
            Product product;
            BigDecimal commValue;
            BaseProduct bp = BookingHelper.findProduct(bookingFile, uid);
            if (!(bp instanceof Product) || (commValue = AirProductHelper.calculateCommissionsEquivalentValue(GeneralProductHelper.filterCommissions(AirProductHelper.getUnmodifiableCommissions(product = (Product)bp, ContractType.CLIENT), GeneralProductHelper.commissionCommissionPropertyTypes, new HashSet<GeneralProductHelper.CommissionType>(Arrays.asList(GeneralProductHelper.CommissionType.values())), null))) == null) continue;
            commValue = commValue.divide(BigDecimal.ONE, 2, RoundingMode.HALF_UP);
            result = product.getStatus() == ProductStatus.REFUND || product.getStatus() == ProductStatus.EXCHANGE ? result.subtract(commValue) : result.add(commValue);
        }
        return result;
    }

    private String getFullLegalForm(DictionaryReference<LegalForm> legalForm, Locale loc) {
        Locale locale;
        LegalForm form = (LegalForm)DictionaryCache.get().resolveReference(legalForm);
        if (form == null || form.getTranslations().isEmpty()) {
            return null;
        }
        Locale locale2 = locale = loc != null ? loc : LocaleManager.get().getCurrentLocale();
        if (form.getTranslations().containsKey(locale)) {
            return (String)form.getTranslations().get(locale);
        }
        return (String)form.getTranslations().values().iterator().next();
    }

    private String getMoneyStr(BigDecimal price, Locale locale, String currency) {
        Number2WordsConverter number2WordsConverter = ((Number2WordsConverterRegistry)Environment.getPublished(Number2WordsConverterRegistry.class)).findConverter(locale, currency);
        if (number2WordsConverter != null) {
            try {
                return TextUtil.capitalize((String)number2WordsConverter.toCurrencyWords(price, currency, false, false, false));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    private String buildOrganizationFullName(String legalForm, L10nString fullName, String inn, String kpp, List<Address> addresses, AddressType addressType, List<BankAccount> accounts, Locale locale, boolean strict) {
        String bankAccounts;
        String address;
        StringBuilder sb = new StringBuilder();
        String name = this.buildOrganizationName(legalForm, fullName, locale, strict);
        if (!TextUtil.isBlank((String)name)) {
            sb.append(name);
        }
        if (!TextUtil.isBlank((String)(address = this.buildAddress(addresses, addressType, locale)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(address);
        }
        if (!TextUtil.isBlank((String)inn) && !TextUtil.isBlank((String)kpp)) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(String.format("\u0418\u041d\u041d/\u041a\u041f\u041f %s/%s", inn.trim(), kpp.trim()));
        }
        if (!TextUtil.isBlank((String)(bankAccounts = this.buildBankAccounts(accounts)))) {
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(bankAccounts);
        }
        return sb.toString();
    }

    private String buildBankAccounts(List<BankAccount> bankAccounts) {
        if (bankAccounts.isEmpty()) {
            return null;
        }
        BankAccount account = bankAccounts.get(0);
        StringBuilder result = new StringBuilder();
        if (!TextUtil.isBlank((String)account.getBankName())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append(account.getBankName());
        }
        if (!TextUtil.isBlank((String)account.getSettlementAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0440\u0430\u0441\u0447.\u0441\u0447\u0435\u0442:").append(account.getSettlementAccount());
        }
        if (!TextUtil.isBlank((String)account.getBik())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u0411\u0418\u041a:").append(account.getBik());
        }
        if (!TextUtil.isBlank((String)account.getCorrespondentAccount())) {
            if (result.length() > 0) {
                result.append(", ");
            }
            result.append("\u043a\u043e\u0440.\u0441\u0447\u0435\u0442:").append(account.getCorrespondentAccount());
        }
        return result.toString();
    }

    private String buildAddress(List<Address> addresses, AddressType addressType, Locale locale) {
        for (Address address : addresses) {
            if (address.getAddressType() != addressType) continue;
            return ProfileHelper.buildFullAddress(address, locale, false);
        }
        return null;
    }

    private String buildPhone(List<Communication> communications, boolean fax) {
        Communication communication = null;
        CommunicationType type = fax ? CommunicationType.FAX : CommunicationType.WORK_PHONE;
        for (Communication comm : communications) {
            if (comm.getType() != type) continue;
            communication = comm;
            break;
        }
        if (communication == null) {
            return null;
        }
        return communication.getSense();
    }

    private String buildOrganizationName(String legalForm, L10nString fullName, Locale locale, boolean strict) {
        String fullNameString;
        StringBuilder sb = new StringBuilder();
        if (!TextUtil.isBlank((String)legalForm)) {
            sb.append(legalForm);
        }
        if (!TextUtil.isBlank((String)(fullNameString = L10nStringHelper.getValue((L10nString)fullName, (Locale)locale, (boolean)strict)))) {
            if (sb.length() > 0) {
                sb.append(" ");
            }
            sb.append(fullNameString.trim());
        }
        return sb.toString();
    }

    private void addMessage(Set<Message> messages, String message, String details, MessageType type, Object ... parameters) {
        if (messages == null) {
            return;
        }
        Message result = new Message();
        result.setType(type);
        result.setMessage(L10nResourcesManager.createL10nMessage((String)message, (Object[])parameters));
        result.setDetails(details);
        if (messages.contains(result)) {
            return;
        }
        messages.add(result);
    }

    public static FilledTemplateDocument createErrorDocument(Set<Message> messages) {
        FilledTemplateDocument result = new FilledTemplateDocument();
        result.getMessages().addAll(messages);
        return result;
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getFileName(Payment payment, FinanceDocument doc) {
        StringBuilder sb = new StringBuilder(doc.getType().name()).append(' ').append(TextUtil.buildFullNumber((CompositeNumber)doc));
        sb.append('(').append(new SimpleDateFormat("yyyyMMdd_hh:mm").format(new Date())).append(')');
        sb.append(".pdf");
        return sb.toString();
    }

    private String getReportTitle(Payment payment, FinanceDocument doc) {
        StringBuilder sb = new StringBuilder().append(doc.getTemplate()).append(' ').append(TextUtil.buildFullNumber((CompositeNumber)doc));
        sb.append('(').append(new SimpleDateFormat("yyyyMMdd_hh:mm").format(new Date())).append(')');
        return sb.toString();
    }

    private static class ImageData {
        private final InputStream data;
        private final int width;
        private final int height;

        public ImageData(byte[] data) {
            ByteArrayInputStream is = null;
            BufferedImage image = null;
            if (data != null) {
                is = new ByteArrayInputStream(data);
                try {
                    image = ImageIO.read(is);
                    ((InputStream)is).reset();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.data = is;
            this.width = image != null ? image.getWidth() : 0;
            this.height = image != null ? image.getHeight() : 0;
        }

        public int getWidth() {
            return this.width;
        }
    }
}

