/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.l10n.model.L10nString;
import com.gridnine.xtrip.common.l10n.model.L10nStringHelper;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.PassengerTypeCategoryValue;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.railway.PassengerTypeReference;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.BaseDictionary;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.Gender;
import com.gridnine.xtrip.common.model.dict.PassportType;
import com.gridnine.xtrip.common.model.dict.Principal;
import com.gridnine.xtrip.common.model.dict.railway.RailwayCarrier;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.ItineraryReceiptHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.BaseBonusCard;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.DateUtils;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class RailwayReceiptRenderHelper {
    private static Map<PassportType, String> passport = new HashMap<PassportType, String>(){
        {
            this.put(PassportType.INTERNAL, "\u041f\u041d");
            this.put(PassportType.PASSPORT, "\u041f\u041d");
            this.put(PassportType.BIRTHDAY_NOTIFICATION, "\u0421\u0420");
            this.put(PassportType.FOREIGN, "\u0417\u041f");
            this.put(PassportType.FOREIGN_NATIONAL_PASSPORT, "\u0417\u0417");
        }
    };

    public static Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    public static String getFileName(RailwayProduct product, TemplateDocument templateDocument) {
        return RailwayReceiptRenderHelper.getReportTitle(product, templateDocument) + ".pdf";
    }

    public static String getReportTitle(RailwayProduct product, TemplateDocument templateDocument) {
        return templateDocument.getTitle() + " " + product.getSystemNumber() + " " + (!product.getPassengers().isEmpty() ? ((Traveller)product.getPassengers().get(0)).getName() : "") + " (" + new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + ")";
    }

    public static Date getDepartureDate(RailwayProduct product) {
        RailwaySegment rws;
        RailwaySegment railwaySegment = rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(0) : null;
        if (rws == null) {
            return null;
        }
        return rws.getDepartureDate();
    }

    public static Date getArriveDate(RailwayProduct product) {
        RailwaySegment rws;
        RailwaySegment railwaySegment = rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(product.getSegments().size() - 1) : null;
        if (rws == null) {
            return null;
        }
        return rws.getArriveDate();
    }

    public static String getVat(RailwayProduct product) {
        HashMap<BigDecimal, BigDecimal> result = new HashMap<BigDecimal, BigDecimal>();
        HashMap<BigDecimal, BigDecimal> penalty = new HashMap<BigDecimal, BigDecimal>();
        if (product.getVendorVatDetalization() != null) {
            for (VatComponent component : product.getVendorVatDetalization().getComponents()) {
                BigDecimal sum;
                BigDecimal rate;
                if (component.getRate() == null) continue;
                if (component.getBasisTypes().contains(VatBasisType.PENALTY)) {
                    rate = BigDecimal.valueOf(component.getRate());
                    sum = (BigDecimal)penalty.get(rate);
                    sum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sum, component.getSum()});
                    penalty.put(rate, sum);
                    continue;
                }
                rate = BigDecimal.valueOf(component.getRate());
                sum = (BigDecimal)result.get(rate);
                sum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sum, component.getSum()});
                result.put(rate, sum);
            }
        }
        if (result.isEmpty() && penalty.isEmpty()) {
            return null;
        }
        StringBuilder vatString = new StringBuilder();
        if (!result.isEmpty()) {
            vatString.append("(\u0432 \u0442.\u0447. \u041d\u0414\u0421 ");
            int i = result.entrySet().size();
            for (Map.Entry entries : result.entrySet()) {
                vatString.append(entries.getKey()).append("% - ").append(entries.getValue());
                vatString.append(--i != 0 ? ", " : "");
            }
        }
        if (!penalty.isEmpty()) {
            if (result.isEmpty()) {
                vatString.append("(\u043f\u043e\u043b\u0443\u0447\u0435\u043d \u041d\u0414\u0421 ");
            } else {
                vatString.append(" \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u041d\u0414\u0421 ");
            }
            int j = penalty.entrySet().size();
            for (Map.Entry entries : penalty.entrySet()) {
                vatString.append(entries.getKey()).append("% - ").append(MiscUtil.abs((BigDecimal)((BigDecimal)entries.getValue())));
                vatString.append(--j != 0 ? ", " : "");
            }
        }
        return vatString.append(")").toString();
    }

    public static String getVatKZ(RailwayProduct product, VatBasisType vatBasisType) {
        HashMap<BigDecimal, BigDecimal> result = new HashMap<BigDecimal, BigDecimal>();
        HashMap<BigDecimal, BigDecimal> penalty = new HashMap<BigDecimal, BigDecimal>();
        if (product.getVendorVatDetalization() != null) {
            for (VatComponent component : product.getVendorVatDetalization().getComponents()) {
                BigDecimal sum;
                BigDecimal rate;
                if (component.getRate() == null) continue;
                if (component.getBasisTypes().contains(VatBasisType.PENALTY)) {
                    rate = BigDecimal.valueOf(component.getRate());
                    sum = (BigDecimal)penalty.get(rate);
                    sum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sum, component.getSum()});
                    penalty.put(rate, sum);
                    continue;
                }
                if (!component.getBasisTypes().contains(vatBasisType)) continue;
                rate = BigDecimal.valueOf(component.getRate());
                sum = (BigDecimal)result.get(rate);
                sum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sum, component.getSum()});
                result.put(rate, sum);
            }
        }
        if (result.isEmpty() && penalty.isEmpty()) {
            return null;
        }
        StringBuilder vatString = new StringBuilder();
        if (!result.isEmpty()) {
            vatString.append("(o.i. \u049a\u049aC / \u041d\u0414\u0421 ");
            int i = result.entrySet().size();
            for (Map.Entry entries : result.entrySet()) {
                vatString.append(((BigDecimal)entries.getKey()).setScale(0, RoundingMode.HALF_UP)).append("% ").append(entries.getValue());
                vatString.append(--i != 0 ? ", " : "");
            }
        }
        if (!penalty.isEmpty()) {
            if (result.isEmpty()) {
                vatString.append("(\u043f\u043e\u043b\u0443\u0447\u0435\u043d \u049a\u049aC / \u041d\u0414\u0421 ");
            } else {
                vatString.append(" \u043f\u043e\u043b\u0443\u0447\u0435\u043d \u049a\u049aC / \u041d\u0414\u0421 ");
            }
            int j = penalty.entrySet().size();
            for (Map.Entry entries : penalty.entrySet()) {
                vatString.append(entries.getKey()).append("% ").append(MiscUtil.abs((BigDecimal)((BigDecimal)entries.getValue())));
                vatString.append(--j != 0 ? ", " : "");
            }
        }
        return vatString.append(")").toString();
    }

    public static List<String> getTravellersIIN(RailwayProduct product) {
        return product.getPassengers().stream().map(Traveller::getIIN).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static String getTravellersString(RailwayProduct product, Locale locale) {
        StringBuilder result = new StringBuilder();
        int i = 0;
        for (Traveller traveller : product.getPassengers()) {
            ++i;
            EntityContainer resolve = EntityStorage.get().resolve(traveller.getPassenger());
            if (resolve != null && resolve.getEntity() != null) {
                Person person = (Person)resolve.getEntity();
                String name = RailwayReceiptRenderHelper.getPersonName(L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale));
                if (TextUtil.nonBlank((String)name)) {
                    result.append(name).append("\n");
                    String passportStr = RailwayReceiptRenderHelper.getPassport(passport, traveller);
                    result.append(TextUtil.nonBlank((String)passportStr) ? passportStr + "\n" : "");
                    String birthday = RailwayReceiptRenderHelper.getBirthday(traveller);
                    result.append(TextUtil.nonBlank((String)birthday) ? birthday : "");
                    result.append(i != product.getPassengers().size() ? "\n" : "");
                }
            } else {
                String name = RailwayReceiptRenderHelper.getPersonName(traveller.getPassport().getLastName(), traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName());
                if (TextUtil.nonBlank((String)name)) {
                    result.append(name).append("\n");
                    String passportStr = RailwayReceiptRenderHelper.getPassport(passport, traveller);
                    result.append(TextUtil.nonBlank((String)passportStr) ? passportStr + "\n" : "");
                    String birthday = RailwayReceiptRenderHelper.getBirthday(traveller);
                    result.append(TextUtil.nonBlank((String)birthday) ? birthday : "");
                    result.append(i != product.getPassengers().size() ? "\n" : "");
                }
            }
            result.append(TextUtil.nonBlank((String)result.toString()) && i != product.getPassengers().size() ? "\n" : "");
        }
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    public static String getTravellersNames(RailwayProduct product, Locale locale) {
        ArrayList<String> result = new ArrayList<String>();
        for (Traveller traveller : product.getPassengers()) {
            EntityContainer resolve = EntityStorage.get().resolve(traveller.getPassenger());
            if (resolve != null && resolve.getEntity() != null) {
                Person person = (Person)resolve.getEntity();
                String name = RailwayReceiptRenderHelper.getPersonName(L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale));
                if (!TextUtil.nonBlank((String)name)) continue;
                result.add(name);
                continue;
            }
            String name = traveller.getPassport() != null ? RailwayReceiptRenderHelper.getPersonName(traveller.getPassport().getLastName(), traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName()) : traveller.getName();
            if (!TextUtil.nonBlank((String)name)) continue;
            result.add(name);
        }
        return String.join((CharSequence)", ", result);
    }

    public static String getTravellersInfoKZ(RailwayProduct product, Locale locale) {
        StringBuilder result = new StringBuilder();
        RailwayStation departureStation = null;
        RailwayStation arriveStation = null;
        if (!product.getSegments().isEmpty()) {
            departureStation = (RailwayStation)DictionaryCache.get().resolveReference(((RailwaySegment)product.getSegments().get(0)).getDepartureStation());
            arriveStation = (RailwayStation)DictionaryCache.get().resolveReference(((RailwaySegment)product.getSegments().get(product.getSegments().size() - 1)).getArriveStation());
        }
        for (int i = 0; i < product.getPassengers().size(); ++i) {
            Traveller traveller = (Traveller)product.getPassengers().get(i);
            EntityContainer resolve = EntityStorage.get().resolve(traveller.getPassenger());
            String name = null;
            if (resolve != null && resolve.getEntity() != null) {
                String nameCandidate;
                Person person = (Person)resolve.getEntity();
                name = RailwayReceiptRenderHelper.getPersonName(L10nStringHelper.getValue((L10nString)person.getLastName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getFirstName(), (Locale)locale), L10nStringHelper.getValue((L10nString)person.getMiddleName(), (Locale)locale));
                if (TextUtil.isBlank((String)name) && locale != null && LocaleHelper.RU_LOCALE.getLanguage().equals(locale.getLanguage()) && TextUtil.isCyrillic((String)(nameCandidate = RailwayReceiptRenderHelper.getPersonName(traveller.getPassport().getLastName(), traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName())), (boolean)true)) {
                    name = nameCandidate;
                }
            } else {
                name = RailwayReceiptRenderHelper.getPersonName(traveller.getPassport().getLastName(), traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName());
            }
            if (!TextUtil.nonBlank((String)name)) continue;
            if (i != 0) {
                result.append("\n\n");
            }
            result.append("<style isBold='true' size='7' pdfFontName='Helvetica-Bold'>");
            result.append(name.toUpperCase());
            result.append("</style>");
            String passportStr = RailwayReceiptRenderHelper.getPassportKZ(traveller);
            if (TextUtil.nonBlank((String)passportStr)) {
                result.append("\n");
                result.append("<style isBold='true' size='7' pdfFontName='Helvetica-Bold'>");
                result.append(passportStr.toUpperCase());
                result.append("</style>");
            }
            if (DictHelper.isChildPassengerTypeCategory(ProductHandler.of(product).getPassengerType(product, traveller))) {
                SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
                result.append(TextUtil.nonBlank((String)sdf.format(traveller.getPassport().getBirthday())) ? "\n\u0422\u0443\u0493\u0430\u043d \u043a\u04af\u043di / \u0414\u0430\u0442\u0430 \u0440\u043e\u0436\u0434\u0435\u043d\u0438\u044f: " + sdf.format(traveller.getPassport().getBirthday()) : "");
            }
            if ((departureStation == null || departureStation.getCountry() == null || departureStation.getCountry().equals((Object)DictHelper.getKzRef())) && (arriveStation == null || arriveStation.getCountry() == null || arriveStation.getCountry().equals((Object)DictHelper.getKzRef()))) continue;
            String birthday = RailwayReceiptRenderHelper.getBirthday(traveller);
            result.append(TextUtil.nonBlank((String)birthday) ? "\n" + birthday : "");
        }
        return result.toString();
    }

    public static String getTravellersPassports(RailwayProduct product) {
        ArrayList<String> result = new ArrayList<String>();
        for (Traveller traveller : product.getPassengers()) {
            String passportStr = RailwayReceiptRenderHelper.getPassport(passport, traveller);
            if (!TextUtil.nonBlank((String)passportStr)) continue;
            result.add(passportStr.toUpperCase());
        }
        return String.join((CharSequence)", ", result);
    }

    public static String getTravellersPassportsKZ(RailwayProduct product) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < product.getPassengers().size(); ++i) {
            String passportStr = RailwayReceiptRenderHelper.getPassportKZ((Traveller)product.getPassengers().get(i));
            if (!TextUtil.nonBlank((String)passportStr)) continue;
            if (i != 0) {
                result.append("\n\n");
            }
            result.append(passportStr.toUpperCase());
        }
        return result.toString();
    }

    public static String getPaymentType(RailwayProduct product) {
        PaymentType paymentType = GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(Objects::nonNull).map(Fop::getType).filter(Objects::nonNull).findFirst().orElse(null);
        return paymentType != null ? paymentType.toString() : null;
    }

    public static String getPaymentTypeLocalized(RailwayProduct product, Locale locale) {
        PaymentType paymentType = GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(Objects::nonNull).map(Fop::getType).filter(Objects::nonNull).findFirst().orElse(null);
        return paymentType != null ? ItineraryReceiptHelper.getLocalizedPaymentType(paymentType, locale) : null;
    }

    public static String getPaymentTypeKZ(RailwayProduct product) {
        return RailwayReceiptRenderHelper.getPaymentTypeLocalized(product, LocaleHelper.getLocale((String)"KZ"));
    }

    public static String getAgency(RailwayProduct product, Locale locale) {
        EntityReference<Organization> agencyRef = GeneralProductHelper.getAgency((BaseProduct)product);
        if (agencyRef == null) {
            return null;
        }
        Organization agency = ProfileHelper.resolveReference(agencyRef);
        if (agency == null) {
            return null;
        }
        return ProfileHelper.getFullName(agency, locale, false);
    }

    public static String getBonusCard(RailwayProduct product) {
        return product.getPassengers().stream().map(Traveller::getRailwayBonusCard).filter(Objects::nonNull).map(BaseBonusCard::getNumber).filter(TextUtil::nonBlank).distinct().collect(Collectors.joining(", "));
    }

    public static PassengerTypeCategoryValue getTicketType(RailwayProduct product) {
        List passengerTypes = product.getPassengers().stream().map(p -> ProductHandler.of(product).getPassengerType(product, (Traveller)p)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
        if (passengerTypes.contains(DictHelper.getInfantPassengerType())) {
            return PassengerTypeCategoryValue.INFANT;
        }
        if (passengerTypes.contains(DictHelper.getChildPassengerType())) {
            return PassengerTypeCategoryValue.CHILD;
        }
        return PassengerTypeCategoryValue.ADULT;
    }

    public static String getCarrierBIN(RailwayProduct product) {
        Principal principal = (Principal)DictionaryCache.get().resolveReference(product.getCarrier());
        if (principal != null && !TextUtil.isBlank((String)principal.getBin())) {
            return principal.getBin();
        }
        return null;
    }

    public static String getVatSeriesNumber(RailwayProduct product) {
        Principal principal = (Principal)DictionaryCache.get().resolveReference(product.getCarrier());
        if (principal == null) {
            return null;
        }
        String vatSeriesNumber = principal.getVatSeriesNumber();
        if (vatSeriesNumber == null) {
            return null;
        }
        String result = vatSeriesNumber.replaceAll("\\D+", "");
        if (TextUtil.isBlank((String)result)) {
            return null;
        }
        return result;
    }

    public static String getCityName(DictionaryReference<RailwayStation> locationRef, Locale locale) {
        if (locationRef == null) {
            return null;
        }
        RailwayStation railwayStation = (RailwayStation)DictionaryCache.get().resolveReference(locationRef);
        if (railwayStation == null) {
            return null;
        }
        return DictHelper.getTranslation((BaseDictionary)railwayStation, locale, true);
    }

    public static String getINN(RailwayProduct product) {
        if (product.getSegments().isEmpty()) {
            return null;
        }
        DictionaryReference carrier = ((RailwaySegment)product.getSegments().get(0)).getCarrier();
        if (carrier == null) {
            return null;
        }
        RailwayCarrier railwayCarrier = (RailwayCarrier)DictionaryCache.get().resolveReference(carrier);
        if (railwayCarrier == null || TextUtil.isBlank((String)railwayCarrier.getCode()) && TextUtil.isBlank((String)railwayCarrier.getInn())) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        result.append(TextUtil.nonBlank((String)railwayCarrier.getCode()) ? railwayCarrier.getCode() : "");
        result.append(TextUtil.nonBlank((String)railwayCarrier.getInn()) ? (TextUtil.nonBlank((String)railwayCarrier.getCode()) ? " / " + railwayCarrier.getInn() : railwayCarrier.getInn()) : "");
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    public static String getPersonName(String lastName, String firstName, String middleName) {
        return TextUtil.nonEmptyStr((String)lastName) + (TextUtil.nonBlank((String)lastName) ? (TextUtil.nonBlank((String)firstName) ? " " + firstName.substring(0, 1).toUpperCase() + "." : "") : (TextUtil.nonBlank((String)firstName) ? firstName : "")) + (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) ? "" : (TextUtil.nonBlank((String)middleName) ? " " + middleName.substring(0, 1).toUpperCase() + "." : ""));
    }

    public static String getTravellersPersonNames(RailwayProduct product, Locale locale) {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < product.getPassengers().size(); ++i) {
            Person person;
            Traveller traveller = (Traveller)product.getPassengers().get(i);
            String name = "";
            EntityContainer personContainer = EntityStorage.get().resolve(traveller.getPassenger());
            name = personContainer != null && personContainer.getEntity() != null ? RailwayReceiptRenderHelper.getPersonName((person = (Person)personContainer.getEntity()).getLastName() != null ? (String)MiscUtil.findByLocale((Map)person.getLastName().getValues(), (Locale)locale) : null, person.getFirstName() != null ? (String)MiscUtil.findByLocale((Map)person.getFirstName().getValues(), (Locale)locale) : null, person.getMiddleName() != null ? (String)MiscUtil.findByLocale((Map)person.getMiddleName().getValues(), (Locale)locale) : null) : RailwayReceiptRenderHelper.getPersonName(traveller.getPassport().getLastName(), traveller.getPassport().getFirstName(), traveller.getPassport().getMiddleName());
            if (!TextUtil.nonBlank((String)name)) continue;
            if (i != 0) {
                result.append("\n\n");
            }
            result.append(name);
        }
        return result.toString();
    }

    public static String getPassport(Map<PassportType, String> passport, Traveller traveller) {
        String passportType = TextUtil.nonBlank((String)passport.get(traveller.getPassport().getType())) ? passport.get(traveller.getPassport().getType()) : "";
        String passportNumber = TextUtil.nonBlank((String)traveller.getPassport().getNumber()) ? traveller.getPassport().getNumber() : "";
        String safePassportNumber = null;
        if (TextUtil.nonBlank((String)passportNumber)) {
            StringBuilder str = new StringBuilder();
            if (passportNumber.length() > 4) {
                for (int i = 0; i < passportNumber.length() - 4; ++i) {
                    str.append("*");
                }
                str.append(passportNumber, passportNumber.length() - 4, passportNumber.length());
            }
            String string = safePassportNumber = TextUtil.nonBlank((String)str.toString()) ? str.toString() : passportNumber;
        }
        return TextUtil.nonBlank(safePassportNumber) ? (TextUtil.nonBlank((String)passportType) ? passportType + " " + safePassportNumber : safePassportNumber) : "";
    }

    public static String getPassportKZ(Traveller traveller) {
        HashMap<PassportType, String> passport = new HashMap<PassportType, String>(){
            {
                this.put(PassportType.INTERNAL, "\u041f\u041d");
                this.put(PassportType.PASSPORT, "\u041f\u041d");
                this.put(PassportType.BIRTHDAY_NOTIFICATION, "\u0421\u0420");
                this.put(PassportType.FOREIGN, "\u0417\u041f");
                this.put(PassportType.FOREIGN_NATIONAL_PASSPORT, "\u0417\u0417");
                this.put(PassportType.IDENTITYCARD, "\u0423\u041b");
                this.put(PassportType.MILITARYID, "\u0412\u0411");
                this.put(PassportType.PASSPORTLOSSCERTIFICATE, "\u0421\u0423");
                this.put(PassportType.RESIDENCEPERMIT, "\u0412\u0416");
                this.put(PassportType.CERTIFICATEOFRELEASE, "\u0421\u041e");
            }
        };
        String passportType = "";
        String passportNumber = "";
        if (traveller.getPassport() != null) {
            String string = passportType = TextUtil.nonBlank((String)((String)passport.get(traveller.getPassport().getType()))) ? (String)passport.get(traveller.getPassport().getType()) : "";
            if (traveller.getPassport().getType() == PassportType.PASSPORT && traveller.getPassport().getCitizenship() != null) {
                if (traveller.getPassport().getCitizenship().equals((Object)DictHelper.getKzRef())) {
                    passportType = "\u041f\u041a";
                }
                if (traveller.getPassport().getCitizenship().equals((Object)DictHelper.getUzRef())) {
                    passportType = "\u041f\u0423";
                }
            }
            String string2 = passportNumber = TextUtil.nonBlank((String)traveller.getPassport().getNumber()) ? traveller.getPassport().getNumber() : "";
        }
        return TextUtil.nonBlank((String)passportNumber) ? (TextUtil.nonBlank((String)passportType) ? passportType + "/" + passportNumber : passportNumber) : "";
    }

    public static String getBirthday(Traveller traveller) {
        StringBuilder str = new StringBuilder();
        Passport pass = traveller.getPassport();
        if (pass.getBirthday() != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
            str.append(TextUtil.nonBlank((String)sdf.format(pass.getBirthday())) ? sdf.format(pass.getBirthday()) : "");
            Country country = (Country)DictionaryCache.get().resolveReference(pass.getCitizenship());
            if (country != null) {
                String countryCode;
                Map codeVariants = country.getCodeVariants();
                String string = codeVariants.get(CodeSystem.ISO_ALPHA3.name()) != null ? (String)codeVariants.get(CodeSystem.ISO_ALPHA3.name()) : (codeVariants.get(CodeSystem.IATA.name()) != null ? (String)codeVariants.get(CodeSystem.IATA.name()) : (countryCode = codeVariants.get(CodeSystem.CRT.name()) != null ? (String)codeVariants.get(CodeSystem.CRT.name()) : ""));
                str.append(TextUtil.nonBlank((String)countryCode) ? (TextUtil.nonBlank((String)str.toString()) ? " / " + countryCode : countryCode) : "");
            }
            if (pass.getGender() != null) {
                String gen = pass.getGender() == Gender.FEMALE ? "F" : "M";
                str.append(TextUtil.nonBlank((String)str.toString()) ? " / " + gen : gen);
            }
        }
        return str.toString();
    }

    public static String getSeat(RailwayProduct product) {
        RailwaySegment rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(0) : null;
        return rws != null ? String.join((CharSequence)", ", rws.getPlaces()) : null;
    }

    public static String getFare(RailwayProduct product) {
        RailwaySegment rws;
        RailwaySegment railwaySegment = rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(0) : null;
        if (rws == null) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        BigDecimal ef = rws.getEquivalentFare() != null ? rws.getEquivalentFare() : BigDecimal.ZERO;
        BigDecimal total = product.getTotalEquivalentFare();
        str.append(new DecimalFormat("###0.00").format(ef));
        str.append(" / ");
        str.append(new DecimalFormat("###0.00").format(MiscUtil.sub((BigDecimal)total, (BigDecimal[])new BigDecimal[]{ef})));
        return str.toString();
    }

    public static BigDecimal getEquivalentFare(RailwayProduct product) {
        RailwaySegment rws;
        RailwaySegment railwaySegment = rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(0) : null;
        if (rws == null) {
            return null;
        }
        return (BigDecimal)MiscUtil.guarded((Object)rws.getEquivalentFare(), (Object)BigDecimal.ZERO);
    }

    public static BigDecimal getSegmentFare(RailwayProduct product) {
        RailwaySegment rws;
        RailwaySegment railwaySegment = rws = !product.getSegments().isEmpty() ? (RailwaySegment)product.getSegments().get(0) : null;
        if (rws == null) {
            return null;
        }
        return rws.getEquivalentFare();
    }

    public static BigDecimal getReservedSeatsFare(RailwayProduct product) {
        List reservedSeats = product.getReservedSeats();
        return reservedSeats.stream().map(reservedSeat -> MiscUtil.sub((BigDecimal)reservedSeat.getEquivalentFare(), (BigDecimal[])new BigDecimal[]{reservedSeat.getEquivalentDeduction()})).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public static int getAdultsCount(RailwayProduct product) {
        return (int)product.getPassengerTypes().stream().map(PassengerTypeReference::getPassengerType).filter(DictHelper::isAdultPassengerType).count();
    }

    public static String getTimeBeforeDeparture(RailwayProduct product) {
        StringBuilder result = new StringBuilder();
        Date issueDate = product.getIssueDate();
        Date departureDate = null;
        if (product.getPreviousProduct() != null) {
            for (RailwaySegment segment : product.getPreviousProduct().getSegments()) {
                departureDate = segment.getDepartureDate();
            }
        }
        if (issueDate != null && departureDate != null) {
            issueDate = MiscUtil.clearTime((Date)issueDate, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
            departureDate = MiscUtil.clearTime((Date)departureDate, (boolean)false, (boolean)false, (boolean)true, (boolean)true);
            int k = 1;
            Date temp = null;
            if (issueDate.after(departureDate)) {
                k = -1;
                temp = issueDate;
                issueDate = departureDate;
                departureDate = temp;
            }
            int days = (int)MiscUtil.getDuration((Date)issueDate, (Date)departureDate, (int)5);
            int hours = (int)MiscUtil.getDuration((Date)issueDate, (Date)departureDate, (int)10);
            int minutes = (int)MiscUtil.getDuration((Date)issueDate, (Date)departureDate, (int)12);
            if (days != 0) {
                result.append(days * k).append(" \u0434\u043d. ");
                departureDate = MiscUtil.addDaysToDate((Date)departureDate, (int)(days * -1));
                hours = (int)MiscUtil.getDuration((Date)issueDate, (Date)departureDate, (int)10);
            }
            if (hours != 0) {
                result.append(hours * k).append(" \u0447. ");
                departureDate = MiscUtil.addHoursToDate((Date)departureDate, (int)(hours * -1));
                minutes = (int)MiscUtil.getDuration((Date)issueDate, (Date)departureDate, (int)12);
            }
            if (minutes != 0) {
                result.append(minutes * k).append(" \u043c. ");
            }
        }
        return result.toString();
    }

    public static String getTravelTime(RailwaySegment segment) {
        Duration duration = segment.getDurationInMinutes() != null ? Duration.ofMinutes(segment.getDurationInMinutes().intValue()) : Duration.between(DateUtils.toLocalDateTime((Date)segment.getDepartureDate()), DateUtils.toLocalDateTime((Date)segment.getArriveDate()));
        StringBuilder result = new StringBuilder();
        if (duration.toDays() > 0L) {
            result.append(TextUtil.fillLeft((String)String.valueOf(duration.toDays()), (char)'0', (int)2)).append(":");
        }
        if (duration.toHours() > 0L) {
            result.append(TextUtil.fillLeft((String)String.valueOf(duration.toHours() % 24L), (char)'0', (int)2)).append(":");
        }
        result.append(TextUtil.fillLeft((String)String.valueOf(duration.toMinutes() % 60L), (char)'0', (int)2));
        return result.toString();
    }

    public static String getSubagencyPhoneNumber(RailwayProduct product) {
        StringBuilder result = new StringBuilder();
        EntityReference<Organization> subAgencyRef = GeneralProductHelper.getSubagency((BaseProduct)product);
        if (subAgencyRef == null) {
            return null;
        }
        Organization subagency = ProfileHelper.resolveReference(subAgencyRef);
        if (subagency == null) {
            return null;
        }
        Collection communications = ProfileHelper.getPhoneCommunications(subagency.getCommunications());
        Object communication = ProfileHelper.getPreferredCommunication(communications = (Collection)communications.stream().filter(c -> c.getType() != CommunicationType.FAX).collect(Collectors.toList()), CommunicationType.AGENCY, CommunicationType.WORK_PHONE);
        if (communication == null) {
            return null;
        }
        result.append(TextUtil.nonBlank((String)communication.getCountryCode()) ? "+" + communication.getCountryCode().replaceAll("\\D+", "") : "");
        result.append(TextUtil.nonBlank((String)communication.getCityCode()) ? "(" + communication.getCityCode().replaceAll("\\D+", "") + ") " : "");
        String sense = communication.getSense();
        if (sense != null) {
            if ((sense = sense.replaceAll("\\D+", "")).length() == 7) {
                result.append(sense, 0, 3).append(" ").append(sense, 3, 5).append(" ").append(sense, 5, 7);
            } else {
                result.append(sense);
            }
        }
        return result.toString();
    }
}

