/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.Xeption;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.railway.RailwaySegment;
import com.gridnine.xtrip.common.model.dict.CodeSystem;
import com.gridnine.xtrip.common.model.dict.CurrencyInfo;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.dict.railway.RailwayStation;
import com.gridnine.xtrip.common.model.handlers.HandlersRegistry;
import com.gridnine.xtrip.common.model.handlers.RailwayRefundReceiptHandler;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.l10n.Messages;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.model.templates.jr.RailwayReceiptRenderHelper;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class RailwayRefundReceiptRender {
    private static final String RESERVATION_NUMBER = "RESERVATION_NUMBER";
    private static final String TICKET_NUMBER = "TICKET_NUMBER";
    private static final String ISSUE_DATE = "ISSUE_DATE";
    private static final String DEPART_DATE = "DEPART_DATE";
    private static final String ARRIVE_DATE = "ARRIVE_DATE";
    private static final String TRAVELLERS_COUNT = "TRAVELLERS_COUNT";
    private static final String TOTAL_EQUIVALENT_FARE = "TOTAL_EQUIVALENT_FARE";
    private static final String VAT = "VAT";
    private static final String TIME_LIMIT = "TIME_LIMIT";
    private static final String IS_REFUND = "IS_REFUND";
    private static final String INN = "INN";
    private static final String FARE = "FARE";
    private static final String TRAVELLERS_NAMES = "TRAVELLERS_NAMES";
    private static final String TRAVELLERS_PERSON_NAMES = "TRAVELLERS_PERSON_NAMES";
    private static final String TRAVELLERS_PASSPORTS_KZ = "TRAVELLERS_PASSPORTS_KZ";
    private static final String PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String PAYMENT_TYPE_LOCALIZED = "PAYMENT_TYPE_LOCALIZED";
    private static final String PAYMENT_TYPE_KZ = "PAYMENT_TYPE_KZ";
    private static final String SEAT = "SEAT";
    private static final String SERVICE_FARE = "SERVICE_FARE";
    private static final String KRS_NUMBER = "KRS_NUMBER";
    private static final String TICKET_TYPE = "TICKET_TYPE";
    private static final String CARRIER = "CARRIER";
    private static final String CARRIER_BIN = "CARRIER_BIN";
    private static final String CARRIER_VAT_SERIES_NUMBER = "CARRIER_VAT_SERIES_NUMBER";
    private static final String TOTAL_FARE_REF = "TOTAL_FARE_REF";
    private static final String VAT_REF = "VAT_REF";
    private static final String ISSUE_DATE_REF = "ISSUE_DATE_REF";
    private static final String PENALTY = "PENALTY";
    private static final String CURRENCY = "CURRENCY";
    private static final String CURRENCY_INFO = "CURRENCY_INFO";
    private static final String TIME_BEFORE_DEPARTURE = "TIME_BEFORE_DEPARTURE";
    private static final String FIELD_DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String FIELD_LOCAL_DEPARTURE_DATE = "LOCAL_DEPARTURE_DATE";
    private static final String FIELD_ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FIELD_LOCAL_ARRIVE_DATE = "LOCAL_ARRIVE_DATE";
    private static final String FIELD_TRAIN_NUMBER = "TRAIN_NUMBER";
    private static final String FIELD_TRAIN_CATEGORY = "TRAIN_CATEGORY";
    private static final String FIELD_CARRIAGE = "CARRIAGE";
    private static final String FIELD_SERVISE_CLASS = "SERVISE_CLASS";
    private static final String FIELD_DEPARTURE_LOCATION = "DEPARTURE_LOCATION";
    private static final String FIELD_ARRIVE_LOCATION = "ARRIVE_LOCATION";
    private static final String FIELD_DEPARTURE_LOCATION_EN = "DEPARTURE_LOCATION_EN";
    private static final String FIELD_ARRIVE_LOCATION_EN = "ARRIVE_LOCATION_EN";
    private static final String FIELD_DEPARTURE_LOCATION_EXPRESS_CODE = "DEPARTURE_LOCATION_EXPRESS_CODE";
    private static final String FIELD_ARRIVE_LOCATION_EXPRESS_CODE = "ARRIVE_LOCATION_EXPRESS_CODE";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, RailwayProduct product, EntityContainer<TemplateDocument> template, List<InformationNote> notes) throws Exception {
        Locale locale;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = RailwayReceiptRenderHelper.getLocale((TemplateDocument)template.getEntity())), (JRDataSource)this.getDataSource(product, locale), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(RailwayReceiptRenderHelper.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(RailwayReceiptRenderHelper.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(DocumentType.RECEIPT);
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(RailwayProduct product, Locale locale) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("REPORT_LOCALE", locale);
        parameters.put(RESERVATION_NUMBER, product.getPreviousProduct().getReservation() != null ? CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getPreviousProduct().getReservation()) : null);
        parameters.put(TICKET_NUMBER, product.getPreviousProduct().getSystemNumber());
        parameters.put(ISSUE_DATE, product.getPreviousProduct().getIssueDate());
        parameters.put(DEPART_DATE, RailwayReceiptRenderHelper.getDepartureDate(product.getPreviousProduct()));
        parameters.put("ARRIVE_DATE", RailwayReceiptRenderHelper.getArriveDate(product.getPreviousProduct()));
        parameters.put(TRAVELLERS_COUNT, product.getPreviousProduct().getPassengers().size());
        parameters.put(TOTAL_EQUIVALENT_FARE, product.getPreviousProduct().getTotalEquivalentFare());
        parameters.put(VAT, RailwayReceiptRenderHelper.getVat(product.getPreviousProduct()));
        parameters.put(TIME_LIMIT, product.getPreviousProduct().getReservation().getTimeLimit());
        parameters.put(IS_REFUND, product.getPreviousProduct().getNextProduct() != null && product.getPreviousProduct().getNextProduct().getStatus() == ProductStatus.REFUND);
        parameters.put(INN, RailwayReceiptRenderHelper.getINN(product.getPreviousProduct()));
        parameters.put(FARE, RailwayReceiptRenderHelper.getFare(product.getPreviousProduct()));
        parameters.put(TRAVELLERS_NAMES, RailwayReceiptRenderHelper.getTravellersString(product.getPreviousProduct(), locale));
        parameters.put(TRAVELLERS_PERSON_NAMES, RailwayReceiptRenderHelper.getTravellersPersonNames(product.getPreviousProduct(), locale));
        parameters.put(TRAVELLERS_PASSPORTS_KZ, RailwayReceiptRenderHelper.getTravellersPassportsKZ(product.getPreviousProduct()));
        parameters.put(PAYMENT_TYPE, RailwayReceiptRenderHelper.getPaymentType(product.getPreviousProduct()));
        parameters.put(PAYMENT_TYPE_LOCALIZED, RailwayReceiptRenderHelper.getPaymentTypeLocalized(product.getPreviousProduct(), locale));
        parameters.put(PAYMENT_TYPE_KZ, RailwayReceiptRenderHelper.getPaymentTypeKZ(product.getPreviousProduct()));
        parameters.put(SEAT, RailwayReceiptRenderHelper.getSeat(product.getPreviousProduct()));
        parameters.put(SERVICE_FARE, product.getPreviousProduct().getServiceFare());
        parameters.put(KRS_NUMBER, product.getKrsNumber());
        parameters.put(TICKET_TYPE, RailwayReceiptRenderHelper.getTicketType(product.getPreviousProduct()));
        parameters.put(CARRIER, product.getPreviousProduct().getCarrier() != null ? product.getPreviousProduct().getCarrier().toString(locale) : null);
        parameters.put(CARRIER_BIN, RailwayReceiptRenderHelper.getCarrierBIN(product.getPreviousProduct()));
        parameters.put(CARRIER_VAT_SERIES_NUMBER, RailwayReceiptRenderHelper.getVatSeriesNumber(product.getPreviousProduct()));
        CurrencyInfo currencyInfo = DictHelper.getCurrencyInfoByAnyCode(DictHelper.getLocalCurrencyCode());
        parameters.put(TOTAL_FARE_REF, product.getTotalEquivalentFare());
        parameters.put(VAT_REF, RailwayReceiptRenderHelper.getVat(product));
        parameters.put(ISSUE_DATE_REF, product.getIssueDate());
        parameters.put(PENALTY, product.getPenalty());
        parameters.put(CURRENCY, Objects.requireNonNull(currencyInfo).toString(locale));
        parameters.put(CURRENCY_INFO, currencyInfo);
        parameters.put(TIME_BEFORE_DEPARTURE, RailwayReceiptRenderHelper.getTimeBeforeDeparture(product));
        for (RailwayRefundReceiptHandler handler : HandlersRegistry.get().getAllRailwayRefundReceiptHandlers()) {
            handler.fillParameters(parameters, product, locale);
        }
        return parameters;
    }

    private JRDataSource getDataSource(RailwayProduct product, Locale locale) {
        ArrayList data = new ArrayList();
        for (RailwaySegment segment : product.getPreviousProduct().getSegments()) {
            HashMap<String, Object> record = new HashMap<String, Object>();
            record.put(FIELD_DEPARTURE_DATE, segment.getDepartureDate());
            record.put(FIELD_LOCAL_DEPARTURE_DATE, segment.getLocalDepartureDate());
            record.put("ARRIVE_DATE", segment.getArriveDate());
            record.put(FIELD_LOCAL_ARRIVE_DATE, segment.getLocalArriveDate());
            record.put(FIELD_TRAIN_NUMBER, segment.getTrainNumber() != null ? (segment.getSlot() != null ? segment.getTrainNumber() + segment.getSlot() : segment.getTrainNumber()) : null);
            record.put(FIELD_TRAIN_CATEGORY, segment.getTrainCategory());
            record.put(FIELD_CARRIAGE, segment.getCarriageNumber() != null ? (segment.getCarriageType() != null ? segment.getCarriageNumber() + " " + segment.getCarriageType() : segment.getCarriageNumber()) : null);
            if (segment.getServiceClass() == null) {
                throw Xeption.forEndUser((String)Messages.RailwayRefundReceiptRender_NoServiceClassException, (Object[])new Object[0]);
            }
            record.put(FIELD_SERVISE_CLASS, segment.getServiceClass().toString());
            record.put(FIELD_DEPARTURE_LOCATION, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getDepartureStation(), locale));
            record.put(FIELD_ARRIVE_LOCATION, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getArriveStation(), locale));
            record.put(FIELD_DEPARTURE_LOCATION_EN, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getDepartureStation(), Locale.ENGLISH));
            record.put(FIELD_ARRIVE_LOCATION_EN, RailwayReceiptRenderHelper.getCityName((DictionaryReference<RailwayStation>)segment.getArriveStation(), Locale.ENGLISH));
            record.put(FIELD_DEPARTURE_LOCATION_EXPRESS_CODE, DictHelper.getCodeVariant(segment.getDepartureStation(), CodeSystem.EXPRESS));
            record.put(FIELD_ARRIVE_LOCATION_EXPRESS_CODE, DictHelper.getCodeVariant(segment.getArriveStation(), CodeSystem.EXPRESS));
            data.add(record);
        }
        if (data.isEmpty()) {
            data.add(new HashMap());
        }
        return new JRMapCollectionDataSource(data);
    }
}

