/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.transfers.Transfer;
import com.gridnine.xtrip.common.model.dict.CarClass;
import com.gridnine.xtrip.common.model.dict.CommunicationType;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.OrganizationLogotypeHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.ImageUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.QRCodeUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.data.JRMapCollectionDataSource;

public class TransferItineraryReceiptRender {
    private static final String RESERVATION_NUMBER = "RESERVATION_NUMBER";
    private static final String RESERVATION_DATE = "RESERVATION_DATE";
    private static final String FULL_NAME = "FULL_NAME";
    private static final String TRAVELLER_NUMBER = "TRAVELLER_NUMBER";
    private static final String NOTES = "NOTES";
    private static final String START_ADDRESS = "START_ADDRESS";
    private static final String START_CITY = "START_CITY";
    private static final String END_ADDRESS = "END_ADDRESS";
    private static final String END_CITY = "END_CITY";
    private static final String CAR_CLASS = "CAR_CLASS";
    private static final String PASSENGER_COUNT = "PASSENGER_COUNT";
    private static final String DEPARTURE_DATE_STR = "DEPARTURE_DATE_STR";
    private static final String DEPARTURE_DATE = "DEPARTURE_DATE";
    private static final String ARRIVE_DATE_STR = "ARRIVE_DATE_STR";
    private static final String ARRIVE_DATE = "ARRIVE_DATE";
    private static final String FREE_CAANCELATION_DATE = "FREE_CAANCELATION_DATE";
    private static final String FREE_CAANCELATION_TIME = "FREE_CAANCELATION_TIME";
    private static final String TABLE_TEXT = "TABLE_TEXT";
    private static final String LOGOTYPE = "LOGOTYPE";
    private static final String BOOKING_NUMBER = "BOOKING_NUMBER";
    private static final String ISSUE_DATE = "ISSUE_DATE";
    private static final String AGENCY_PHONES = "AGENCY_PHONES";
    private static final String KEY_DOWNLOAD_QR_CODE = "DOWNLOAD_QR_CODE";
    private static final Map<String, String> STRING_MONTH_RU = new HashMap<String, String>(){
        {
            this.put("01", "\u044f\u043d\u0432\u0430\u0440\u044f");
            this.put("02", "\u0444\u0435\u0432\u0440\u0430\u043b\u044f");
            this.put("03", "\u043c\u0430\u0440\u0442\u0430");
            this.put("04", "\u0430\u043f\u0440\u0435\u043b\u044f");
            this.put("05", "\u043c\u0430\u044f");
            this.put("06", "\u0438\u044e\u043d\u044f");
            this.put("07", "\u0438\u044e\u043b\u044f");
            this.put("08", "\u0430\u0432\u0433\u0443\u0441\u0442\u0430");
            this.put("09", "\u0441\u0435\u043d\u0442\u044f\u0431\u0440\u044f");
            this.put("10", "\u043e\u043a\u0442\u044f\u0431\u0440\u044f");
            this.put("11", "\u043d\u043e\u044f\u0431\u0440\u044f");
            this.put("12", "\u0434\u0435\u043a\u0430\u0431\u0440\u044f");
        }
    };

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, Transfer product, EntityContainer<TemplateDocument> template, List<InformationNote> notes) throws Exception {
        Locale locale;
        LinkedHashSet messages = new LinkedHashSet();
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, this.getParameters(product, locale = this.getLocale((TemplateDocument)template.getEntity()), bookingFile.getUid(), Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean(((TemplateDocument)template.getEntity()).getMetadata(), MetadataKey.KEY_HAS_DOWNLOAD_QR_CODE))), (JRDataSource)this.getDataSource(product, locale), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity()));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity()));
        file.setType(TransferItineraryReceiptRender.getDocumentType());
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        file.getMessages().clear();
        file.getMessages().addAll(messages);
        return file;
    }

    private Map<String, Object> getParameters(Transfer product, Locale locale, String bookingFileUid, boolean showDownloadQrCode) throws Exception {
        String url;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(RESERVATION_NUMBER, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getReservation()));
        parameters.put(RESERVATION_DATE, this.getDateToString(product.getIssueDate()));
        parameters.put(FULL_NAME, this.getFullName(product, locale));
        parameters.put(TRAVELLER_NUMBER, this.getPhone(product));
        parameters.put(TABLE_TEXT, this.getTableText(product));
        parameters.put(NOTES, this.getNotes(product));
        parameters.put(START_ADDRESS, this.getStartAddress(product));
        parameters.put(START_CITY, this.getCityName((DictionaryReference<GeoLocation>)product.getStartCity(), locale));
        parameters.put(END_ADDRESS, this.getEndAddress(product));
        parameters.put(END_CITY, this.getCityName((DictionaryReference<GeoLocation>)product.getEndCity(), locale));
        parameters.put(CAR_CLASS, this.getCarClass(product, locale));
        parameters.put(PASSENGER_COUNT, this.getPassengerCount(product));
        parameters.put(DEPARTURE_DATE_STR, this.getDateToString(product.getStartDate()));
        parameters.put(DEPARTURE_DATE, product.getStartDate());
        parameters.put(ARRIVE_DATE_STR, this.getDateToString(product.getEndDate()));
        parameters.put(ARRIVE_DATE, product.getEndDate());
        parameters.put(FREE_CAANCELATION_DATE, this.getFreeCancellationDate(product));
        parameters.put(FREE_CAANCELATION_TIME, this.getFreeCancellationTime(product));
        BinaryData logo = OrganizationLogotypeHelper.getLogotype((BaseProduct)product, parameters);
        if (logo != null && logo.getData() != null) {
            parameters.put(LOGOTYPE, new ByteArrayInputStream(logo.getData()));
        }
        parameters.put(BOOKING_NUMBER, product.getReservation().getBookingFile().getNumber());
        parameters.put(ISSUE_DATE, product.getIssueDate());
        parameters.put(AGENCY_PHONES, this.getAgencyPhones(product));
        if (showDownloadQrCode && (url = BookingHelper.createBookingDocumentUrl(bookingFileUid, (BaseProduct)product, TransferItineraryReceiptRender.getDocumentType())) != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeUtil.generateToStream((String)url, (int)200, (int)200, (OutputStream)os, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(os.toByteArray());
                parameters.put(KEY_DOWNLOAD_QR_CODE, imageData.getData());
            }
        }
        return parameters;
    }

    private String getPhone(Transfer product) {
        String phone = "";
        for (Traveller traveller : product.getTravellers()) {
            for (Communication communication : traveller.getCommunications()) {
                if (communication.getType() != CommunicationType.MOBILE && communication.getType() != CommunicationType.WORK_PHONE && communication.getType() != CommunicationType.HOTEL && communication.getType() != CommunicationType.CELL) continue;
                phone = phone + "+" + communication.getCountryCode() + communication.getCityCode() + communication.getSense() + "\n\n";
            }
        }
        return phone.length() > 2 ? phone.substring(0, phone.length() - 2) : null;
    }

    private JRDataSource getDataSource(Transfer product, Locale locale) {
        ArrayList data = new ArrayList();
        HashMap record = new HashMap();
        data.add(record);
        return new JRMapCollectionDataSource(data);
    }

    private Locale getLocale(TemplateDocument templateDocument) {
        String language = SystemHelper.findMetadataAsString(templateDocument.getMetadata(), MetadataKey.KEY_LOCALE);
        if (!TextUtil.isBlank((String)language)) {
            return LocaleHelper.getLocale((String)language);
        }
        return LocaleHelper.getCurrentLocale();
    }

    private String getReportTitle(Transfer product, TemplateDocument templateDocument) {
        return templateDocument.getTitle() + " " + product.getSystemNumber() + " " + (!product.getTravellers().isEmpty() ? ((Traveller)product.getTravellers().get(0)).getName() : "") + " (" + new SimpleDateFormat("yyyyMMdd_HHmm").format(new Date()) + ")";
    }

    private String getFileName(Transfer product, TemplateDocument templateDocument) {
        return this.getReportTitle(product, templateDocument) + ".pdf";
    }

    private static DocumentType getDocumentType() {
        return DocumentType.RECEIPT;
    }

    private String getDateToString(Date date) {
        if (date == null) {
            return null;
        }
        return new SimpleDateFormat("dd").format(date) + " " + STRING_MONTH_RU.get(new SimpleDateFormat("MM").format(date)) + " " + new SimpleDateFormat("yyyy").format(date);
    }

    private String getFullName(Transfer product, Locale locale) {
        String contactPersons = "";
        for (Traveller traveller : product.getTravellers()) {
            if (traveller.getName() == null) continue;
            contactPersons = contactPersons + traveller.getName() + "\n\n";
        }
        return contactPersons.length() > 2 ? contactPersons.substring(0, contactPersons.length() - 2) : null;
    }

    private String getPersonName(String lastName, String firstName, String middleName) {
        return TextUtil.nonEmptyStr((String)lastName) + (TextUtil.nonBlank((String)lastName) ? (TextUtil.nonBlank((String)firstName) ? " " + firstName : "") : (TextUtil.nonBlank((String)firstName) ? firstName : "")) + (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) ? "" : (TextUtil.nonBlank((String)middleName) ? " " + middleName : ""));
    }

    private Object getTableText(Transfer product) {
        if (TextUtil.nonBlank((String)product.getTableCaption())) {
            return product.getTableCaption();
        }
        return null;
    }

    private String getNotes(Transfer product) {
        if (TextUtil.nonBlank((String)product.getNotes())) {
            return product.getNotes();
        }
        return null;
    }

    private String getStartAddress(Transfer product) {
        return this.getAddress(product.getStartAddress());
    }

    private String getEndAddress(Transfer product) {
        return this.getAddress(product.getEndAddress());
    }

    private String getAddress(String address) {
        StringBuilder result = new StringBuilder();
        if (TextUtil.nonBlank((String)address)) {
            result.append(address);
        }
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    private String getCityName(DictionaryReference<GeoLocation> city, Locale locale) {
        GeoLocation location;
        StringBuilder result = new StringBuilder();
        if (city != null && (location = (GeoLocation)DictionaryCache.get().resolveReference(city)) != null) {
            String cityName = (String)location.getTranslations().get(locale);
            if (TextUtil.isBlank((String)cityName)) {
                cityName = location.getTranslations().values().stream().findFirst().orElse(null);
            }
            if (TextUtil.nonBlank((String)cityName)) {
                result.append(cityName);
            }
        }
        return TextUtil.nonBlank((String)result.toString()) ? result.toString() : null;
    }

    private String getCarClass(Transfer product, Locale locale) {
        CarClass carClass = (CarClass)DictionaryCache.get().resolveReference(product.getCarClass());
        if (carClass == null) {
            return null;
        }
        String result = (String)carClass.getTranslations().get(locale);
        if (TextUtil.isBlank((String)result)) {
            result = carClass.getTranslations().values().stream().findFirst().orElse(null);
        }
        return result;
    }

    private String getPassengerCount(Transfer product) {
        if (product.getPassengersCount() != null) {
            return product.getPassengersCount() + " " + this.passengersString(product.getPassengersCount());
        }
        return null;
    }

    private String passengersString(Integer count) {
        if (count == null) {
            return "";
        }
        if (count == 1) {
            return "\u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440";
        }
        if (count < 5) {
            return "\u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u0430";
        }
        return "\u043f\u0430\u0441\u0441\u0430\u0436\u0438\u0440\u043e\u0432";
    }

    private String getFreeCancellationTime(Transfer product) {
        Integer hours = product.getCancellationNoPenaltyHours();
        if (hours == null) {
            return null;
        }
        String result = String.valueOf(hours);
        if (hours == 1) {
            return result + " \u0447\u0430\u0441";
        }
        if (hours < 5) {
            return result + " \u0447\u0430\u0441\u0430";
        }
        return result + " \u0447\u0430\u0441\u043e\u0432";
    }

    private Date getFreeCancellationDate(Transfer product) {
        Date startDate = product.getStartDate();
        Integer hours = product.getCancellationNoPenaltyHours();
        if (startDate == null || hours == null) {
            return null;
        }
        return MiscUtil.addHoursToDate((Date)startDate, (int)(-1 * hours));
    }

    private int hoursBetween(Date d1, Date d2) {
        return (int)(((double)d1.getTime() - ((double)d2.getTime() - 1.0)) / 3600000.0);
    }

    private List<String> getAgencyPhones(Transfer product) {
        EntityContainer agency = EntityStorage.get().resolve(GeneralProductHelper.getAgency((BaseProduct)product));
        if (agency != null) {
            return ((Organization)agency.getEntity()).getCommunications().stream().filter(c -> c.getType() == CommunicationType.WORK_PHONE).map(ProfileHelper::buildFullPhoneNumber).filter(TextUtil::nonBlank).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

