/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.templates.jr;

import com.gridnine.xtrip.common.jr.JasperUtil;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.l10n.model.LocaleHelper;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseContractRelationData;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.Fop;
import com.gridnine.xtrip.common.model.booking.FopType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.commission.BaseCommissionProperties;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalService;
import com.gridnine.xtrip.common.model.booking.xtriphotels.AdditionalServiceType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.CancellationCharge;
import com.gridnine.xtrip.common.model.booking.xtriphotels.EssentialInfoDataType;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.Room;
import com.gridnine.xtrip.common.model.dict.BusinessTripCurrencies;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictSearchCriterion;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.GeoLocation;
import com.gridnine.xtrip.common.model.dict.InformationNote;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.CancellationChargeHelper;
import com.gridnine.xtrip.common.model.helpers.CommonReservationGdsNameInfoHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.helpers.HotelProductHelper;
import com.gridnine.xtrip.common.model.helpers.ItineraryReceiptHelper;
import com.gridnine.xtrip.common.model.helpers.MoneyHelper;
import com.gridnine.xtrip.common.model.helpers.OrganizationLogotypeHelper;
import com.gridnine.xtrip.common.model.helpers.ProfileHelper;
import com.gridnine.xtrip.common.model.helpers.SystemHelper;
import com.gridnine.xtrip.common.model.profile.Communication;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Passport;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.system.BinaryData;
import com.gridnine.xtrip.common.model.system.ContentType;
import com.gridnine.xtrip.common.model.system.DocumentType;
import com.gridnine.xtrip.common.model.system.FilledTemplateDocument;
import com.gridnine.xtrip.common.model.system.Metadata;
import com.gridnine.xtrip.common.model.system.MetadataKey;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.TemplateDocument;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.ImageUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.QRCodeUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JasperReport;

public class VoucherRender {
    private static final String LOGO_LOCATION = "/plugins/com.gridnine.xtrip.server.ibecorp.ru.config/config/setup-ibecorp-ru/entity/templates/tuiKz/logoForVoucher.jpg";
    private static final String KEY_LOCALE = "KEY_LOCALE";
    private static final String KEY_HOTEL_CONFIRMATION_NUMBER = "HOTEL_CONFIRMATION_NUMBER";
    private static final String KEY_HOTEL_NAME = "HOTEL_NAME";
    private static final String KEY_CITY = "CITY";
    private static final String KEY_ORDER_CREATED = "ORDER_CREATED";
    private static final String KEY_ADDRESS = "ADDRESS";
    private static final String KEY_PHONE_NUMBER = "PHONE_NUMBER";
    private static final String KEY_ARRIVAL = "ARRIVAL";
    private static final String KEY_DEPARTURE = "DEPARTURE";
    private static final String KEY_CHECK_IN = "CHECK_IN";
    private static final String KEY_CHECK_OUT = "CHECK_OUT";
    private static final String KEY_ROOM_TYPE = "ROOM_TYPE";
    private static final String KEY_MEAL = "MEAL";
    private static final String KEY_GUESTS = "GUESTS";
    private static final String KEY_PERIOD_OF_STAY = "PERIOD_OF_STAY";
    private static final String KEY_INFORMATION_NOTES = "INFORMATION_NOTES";
    private static final String KEY_ADDITIONAL_SERVICES_INFO = "ADDITIONAL_SERVICES_INFO";
    private static final String KEY_ADDITIONAL_SERVICES_INFO_WITHOUT_TYPE = "ADDITIONAL_SERVICES_INFO_WITHOUT_TYPE";
    private static final String KEY_PROVIDER_INFO = "PROVIDER_INFO";
    private static final String KEY_ROOMS = "ROOMS";
    private static final String KEY_RESERVATION_NUMBER = "RESERVATION_NUMBER";
    private static final String KEY_BOOKING_NUMBER = "BOOKING_NUMBER";
    private static final String KEY_HOTEL_EMAIL = "HOTEL_EMAIL";
    private static final String KEY_EMAIL = "EMAIL";
    private static final String KEY_PHONES = "PHONES";
    private static final String KEY_FULL_NAME = "FULL_NAME";
    private static final String KEY_PRICE = "PRICE";
    private static final String KEY_PRICE_IN_DAY = "PRICE_IN_DAY";
    private static final String KEY_SERVICE_FEE_PRICE = "SERVICE_FEE_PRICE";
    private static final String KEY_SERVICE_FEE_PRICE_IN_DAY = "SERVICE_FEE_PRICE_IN_DAY";
    private static final String KEY_TOTAL_PRICE = "TOTAL_PRICE";
    private static final String KEY_CURRENCY = "CURRENCY";
    private static final String KEY_IS_CURRENCY = "IS_CURRENCY";
    private static final String KEY_CURRENCY_VALUE = "CURRENCY_VALUE";
    private static final String KEY_CURRENCY_PRICE = "CURRENCY_PRICE";
    private static final String KEY_CURRENCY_PRICE_IN_DAY = "CURRENCY_PRICE_IN_DAY";
    private static final String KEY_BUSINESS_TRIP_CURRENCY = "BUSINESS_TRIP_CURRENCY";
    private static final String KEY_PRICE_IN_BUSINESS_TRIP_CURRENCY = "PRICE_IN_BUSINESS_TRIP_CURRENCY";
    private static final String KEY_PRICE_PER_NIGHT_IN_BUSINESS_TRIP_CURRENCY = "PRICE_PER_NIGHT_IN_BUSINESS_TRIP_CURRENCY";
    private static final String KEY_TIME_LIMIT = "TIME_LIMIT";
    private static final String KEY_EARLY_CHECK_IN = "EARLY_CHECK_IN";
    private static final String KEY_LATE_CHECK_OUT = "LATE_CHECK_OUT";
    private static final String KEY_IS_EARLY_CHECK_IN = "IS_EARLY_CHECK_IN";
    private static final String KEY_IS_LATE_CHECK_OUT = "IS_LATE_CHECK_OUT";
    private static final String KEY_VAUCHER_NUMBER = "VAUCHER_NUMBER";
    private static final String KEY_PAYMENT_TYPE = "PAYMENT_TYPE";
    private static final String KEY_PAYMENT_TYPE_LOCALIZED = "PAYMENT_TYPE_LOCALIZED";
    private static final String KEY_ORDER_STATUS = "ORDER_STATUS";
    private static final String KEY_BLANKOWNER = "BLANKOWNER";
    private static final String KEY_CANCELLATION_POLICY = "CANCELLATION_POLICY";
    private static final String KEY_IS_FULLY_PAYED = "IS_FULLY_PAYED";
    private static final String KEY_NOT_PAYED_ITEMS = "NOT_PAYED_ITEMS";
    private static final String KEY_AGENCY_LOGO = "AGENCY_LOGO";
    private static final String KEY_LOGO = "LOGO";
    private static final String KEY_AGENCY_CONTACTS = "AGENCY_CONTACTS";
    private static final String KEY_CUSTOMER_CODE = "CUSTOMER_CODE";
    private static final String KEY_DOWNLOAD_QR_CODE = "DOWNLOAD_QR_CODE";

    public FilledTemplateDocument renderReport(EntityContainer<BookingFile> bookingFile, HotelProduct product, EntityContainer<TemplateDocument> template, String agencyContacts, List<InformationNote> notes, boolean hidePrice, boolean hideMeal, boolean hideBasicEssentialInfo, boolean hideAmenities, boolean includeFeesInTotalPrice) throws Exception {
        Map<String, Object> parameters;
        JasperReport jasperReport = JasperUtil.getReport((byte[])((TemplateDocument)template.getEntity()).getContent());
        byte[] content = JasperUtil.fillReport((JasperReport)jasperReport, parameters = TextUtil.isSame((String)template.getUid(), (String)"voucher_ru") || this.isRuLocale(((TemplateDocument)template.getEntity()).getMetadata()) ? this.getRuParameters(product, agencyContacts, notes, hidePrice, hideMeal, hideBasicEssentialInfo, hideAmenities, includeFeesInTotalPrice, bookingFile.getUid(), Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean(((TemplateDocument)template.getEntity()).getMetadata(), MetadataKey.KEY_HAS_DOWNLOAD_QR_CODE))) : this.getEnParameters(product, agencyContacts, notes, hidePrice, hideMeal, hideBasicEssentialInfo, hideAmenities, includeFeesInTotalPrice, bookingFile.getUid(), Boolean.TRUE.equals(SystemHelper.getMetadataAsBoolean(((TemplateDocument)template.getEntity()).getMetadata(), MetadataKey.KEY_HAS_DOWNLOAD_QR_CODE))), (JRDataSource)this.getDataSource(), null);
        if (content == null) {
            return null;
        }
        Date date = new Date();
        Locale locale = this.isRuLocale(((TemplateDocument)template.getEntity()).getMetadata()) ? LocaleHelper.getLocale((String)"RU") : Locale.ENGLISH;
        FilledTemplateDocument file = new FilledTemplateDocument();
        file.setTitle(this.getReportTitle(product, (TemplateDocument)template.getEntity(), parameters, locale));
        file.setContentType(ContentType.JASPERPRINT);
        file.setContent(content);
        file.setType(VoucherRender.getDocumentType());
        file.setName(this.getFileName(product, (TemplateDocument)template.getEntity(), parameters, locale));
        file.setCreated(date);
        file.setNavigationKey(product.getUid());
        file.setOwner(bookingFile.toReference());
        file.setCheckSum(MiscUtil.getCheckSum((byte[])file.getContent()));
        file.setTemplate(template.toReference());
        return file;
    }

    private Map<String, Object> getEnParameters(HotelProduct product, String agencyContacts, List<InformationNote> notes, boolean hidePrice, boolean hideMeal, boolean hideBasicEssentialInfo, boolean hideAmenities, boolean includeFeesInTotalPrice, String bookingFileUid, boolean showDownloadQrCode) throws Exception {
        String url;
        String additionalServicesInfoWithoutType;
        GeoLocation hotelLocation;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (product.getCF() != null) {
            parameters.put(KEY_HOTEL_CONFIRMATION_NUMBER, product.getCF());
        }
        StringBuilder sb = new StringBuilder();
        notes.forEach(note -> {
            String notification = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)Locale.ENGLISH);
            sb.append(notification != null ? notification + "\n" : "");
        });
        parameters.put(KEY_INFORMATION_NOTES, sb.toString());
        if (product.getIssueDate() != null) {
            parameters.put(KEY_ORDER_CREATED, product.getIssueDate());
        }
        if (product.getHotelName() != null) {
            parameters.put(KEY_HOTEL_NAME, product.getHotelName());
        }
        if ((hotelLocation = (GeoLocation)DictHelper.resolve(product.getHotelLocation())) != null) {
            parameters.put(KEY_CITY, hotelLocation.getTranslations().get(Locale.ENGLISH));
        }
        if (product.getHotelAddress() != null) {
            parameters.put(KEY_ADDRESS, product.getHotelAddress());
        }
        if (product.getHotelPhone() != null) {
            parameters.put(KEY_PHONE_NUMBER, product.getHotelPhone());
        }
        if (!product.getRooms().isEmpty()) {
            Date checkInDate;
            Room room = (Room)product.getRooms().get(0);
            parameters.put(KEY_ROOM_TYPE, room.getRoomName());
            MiscUtil.Pair<String, BigDecimal> meal = this.getMealOfAdditionalService(product);
            if (!hideMeal) {
                if (TextUtil.nonBlank((String)((String)meal.getFirst()))) {
                    if (room.getMeal() != null && !"-1".equals(room.getMeal().getCode()) && TextUtil.nonBlank((String)room.getMeal().getCaption())) {
                        parameters.put(KEY_MEAL, room.getMeal().getCaption() + ", " + (String)meal.getFirst());
                    } else {
                        parameters.put(KEY_MEAL, meal.getFirst());
                    }
                } else if (room.getMeal() != null) {
                    parameters.put(KEY_MEAL, room.getMeal().getCaption());
                }
            }
            Integer checkInTime = room.getCheckInTime() != null ? room.getCheckInTime() : room.getStandardCheckInTime();
            Integer checkOutTime = room.getCheckOutTime() != null ? room.getCheckOutTime() : room.getStandardCheckOutTime();
            parameters.put(KEY_CHECK_IN, MiscUtil.formatTime((Number)checkInTime));
            parameters.put(KEY_CHECK_OUT, MiscUtil.formatTime((Number)checkOutTime));
            int days = HotelProductHelper.calculateNights(room.getCheckInDate(), room.getCheckOutDate());
            String periodOfStay = days + " night(s)";
            parameters.put(KEY_PERIOD_OF_STAY, periodOfStay);
            Date date = room.getCheckInDate() != null ? new Date(room.getCheckInDate().getTime() + (long)(room.getCheckInTime() != null ? room.getCheckInTime() * 60 * 1000 : 0)) : (checkInDate = null);
            Date checkOutDate = room.getCheckOutDate() != null ? new Date(room.getCheckOutDate().getTime() + (long)(room.getCheckOutTime() != null ? room.getCheckOutTime() * 60 * 1000 : 0)) : null;
            parameters.put(KEY_ARRIVAL, checkInDate);
            parameters.put(KEY_DEPARTURE, checkOutDate);
            BigDecimal mealTotal = (BigDecimal)meal.getSecond();
            BigDecimal mealInDay = ((BigDecimal)meal.getSecond()).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ((BigDecimal)meal.getSecond()).divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP);
            GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
            BigDecimal price = null;
            String currency = null;
            if (clientContractRelation != null && clientContractRelation.getServiceData() != null && clientContractRelation.getServiceData().getDetalization() != null) {
                price = this.getPrice(clientContractRelation);
                currency = GeneralProductHelper.getCurrency((BaseContractRelationData)clientContractRelation).getCode();
            }
            if (!hidePrice) {
                this.fillPrices(parameters, product, includeFeesInTotalPrice, hotelLocation, room, days, mealTotal, mealInDay, price, currency);
            }
        }
        if (product.getTicketType() == TicketType.REFERRAL) {
            parameters.put(KEY_PAYMENT_TYPE_LOCALIZED, "Payment in hotel");
        } else {
            PaymentType paymentType = VoucherRender.getPaymentType(product);
            if (paymentType != null) {
                parameters.put(KEY_PAYMENT_TYPE, paymentType.toString(Locale.ENGLISH));
                parameters.put(KEY_PAYMENT_TYPE_LOCALIZED, ItineraryReceiptHelper.getLocalizedPaymentType(paymentType, Locale.ENGLISH));
            }
        }
        List<String> guests = product.getTravellers().stream().map(traveller -> this.getFullName((Traveller)traveller, Locale.ENGLISH)).filter(Objects::nonNull).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        if (guests.size() == 1) {
            parameters.put(KEY_GUESTS, guests.get(0));
        } else {
            guests.forEach(guest -> stringBuilder.append((String)guest).append("\n"));
            parameters.put(KEY_GUESTS, stringBuilder.toString());
        }
        parameters.put(KEY_ROOMS, String.valueOf(product.getRooms().size()));
        parameters.put(KEY_RESERVATION_NUMBER, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getReservation()));
        parameters.put(KEY_BOOKING_NUMBER, product.getReservation().getBookingFile().getNumber());
        parameters.put(KEY_HOTEL_EMAIL, product.getHotelEmail());
        this.fillAgencyCommunication(parameters, product);
        parameters.put(KEY_FULL_NAME, this.getFullName(!product.getTravellers().isEmpty() ? (Traveller)product.getTravellers().get(0) : null, Locale.ENGLISH));
        parameters.put(KEY_TIME_LIMIT, this.getTimeLimit(product));
        parameters.put(KEY_VAUCHER_NUMBER, product.getSystemNumber());
        parameters.put(KEY_ORDER_STATUS, product.getStatus() != null ? product.getStatus().toString() : null);
        parameters.put(KEY_BLANKOWNER, this.getBlankOwnerName((EntityReference<Organization>)product.getBlankOwnerRef(), Locale.ENGLISH));
        parameters.put(KEY_CANCELLATION_POLICY, this.getCancellationPolicy(product, Locale.ENGLISH));
        parameters.put(KEY_IS_FULLY_PAYED, this.isFullyPayed(product));
        parameters.put(KEY_NOT_PAYED_ITEMS, this.getNotPayedTaxes(product));
        parameters.put(KEY_AGENCY_LOGO, this.getLogoStream(product, parameters));
        parameters.put(KEY_AGENCY_CONTACTS, this.getAgencyContacts(product, agencyContacts));
        parameters.put(KEY_IS_EARLY_CHECK_IN, this.getServiceIsIncluded(product.getAdditionalServices(), AdditionalServiceType.EARLIER_CHECKIN));
        parameters.put(KEY_IS_LATE_CHECK_OUT, this.getServiceIsIncluded(product.getAdditionalServices(), AdditionalServiceType.LATER_CHECKOUT));
        String additionalServicesInfo = this.getAdditionalServicesInfo(product, LocaleHelper.EN_LOCALE, false);
        if (TextUtil.nonBlank((String)additionalServicesInfo)) {
            parameters.put(KEY_ADDITIONAL_SERVICES_INFO, additionalServicesInfo);
        }
        if (TextUtil.nonBlank((String)(additionalServicesInfoWithoutType = this.getAdditionalServicesInfo(product, LocaleHelper.EN_LOCALE, true)))) {
            parameters.put(KEY_ADDITIONAL_SERVICES_INFO_WITHOUT_TYPE, additionalServicesInfoWithoutType);
        }
        try {
            parameters.put(KEY_LOGO, this.getLogoIS(LOGO_LOCATION));
        }
        catch (Exception e) {
            parameters.put(KEY_LOGO, null);
        }
        VoucherRender.fillProviderInfoParameter(product, parameters, hideBasicEssentialInfo, hideAmenities);
        parameters.put(KEY_CUSTOMER_CODE, VoucherRender.getCustomerCode(product));
        if (showDownloadQrCode && (url = BookingHelper.createBookingDocumentUrl(bookingFileUid, (BaseProduct)product, VoucherRender.getDocumentType())) != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeUtil.generateToStream((String)url, (int)200, (int)200, (OutputStream)os, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(os.toByteArray());
                parameters.put(KEY_DOWNLOAD_QR_CODE, imageData.getData());
            }
        }
        return parameters;
    }

    private Map<String, Object> getRuParameters(HotelProduct product, String agencyContacts, List<InformationNote> notes, boolean hidePrice, boolean hideMeal, boolean hideBasicEssentialInfo, boolean hideAmenities, boolean includeFeesInTotalPrice, String bookingFileUid, boolean showDownloadQrCode) throws Exception {
        String url;
        String additionalServicesInfoWithoutType;
        GeoLocation hotelLocation;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        Locale ruLocale = new Locale("ru");
        if (product.getCF() != null) {
            parameters.put(KEY_HOTEL_CONFIRMATION_NUMBER, product.getCF());
        }
        StringBuilder sb = new StringBuilder();
        notes.forEach(note -> {
            String notification = (String)MiscUtil.findByLocale((Map)note.getNotes(), (Locale)ruLocale, (Locale)Locale.ENGLISH);
            sb.append(notification != null ? notification + "\n" : "");
        });
        parameters.put(KEY_INFORMATION_NOTES, sb.toString());
        if (product.getIssueDate() != null) {
            parameters.put(KEY_ORDER_CREATED, product.getIssueDate());
        }
        if (product.getHotelName() != null) {
            parameters.put(KEY_HOTEL_NAME, product.getHotelName());
        }
        if ((hotelLocation = (GeoLocation)DictHelper.resolve(product.getHotelLocation())) != null) {
            parameters.put(KEY_CITY, hotelLocation.getTranslations().get(ruLocale));
        }
        if (product.getHotelAddress() != null) {
            parameters.put(KEY_ADDRESS, product.getHotelAddress());
        }
        if (product.getHotelPhone() != null) {
            parameters.put(KEY_PHONE_NUMBER, product.getHotelPhone());
        }
        if (!product.getRooms().isEmpty()) {
            Date checkInDate;
            Room room = (Room)product.getRooms().get(0);
            parameters.put(KEY_ROOM_TYPE, room.getRoomName());
            MiscUtil.Pair<String, BigDecimal> meal = this.getMealOfAdditionalService(product);
            if (!hideMeal) {
                if (TextUtil.nonBlank((String)((String)meal.getFirst()))) {
                    if (room.getMeal() != null && !"-1".equals(room.getMeal().getCode()) && TextUtil.nonBlank((String)room.getMeal().getCaption())) {
                        parameters.put(KEY_MEAL, room.getMeal().getCaption() + ", " + (String)meal.getFirst());
                    } else {
                        parameters.put(KEY_MEAL, meal.getFirst());
                    }
                } else if (room.getMeal() != null) {
                    parameters.put(KEY_MEAL, room.getMeal().getCaption());
                }
            }
            Integer checkInTime = room.getCheckInTime() != null ? room.getCheckInTime() : room.getStandardCheckInTime();
            Integer checkOutTime = room.getCheckOutTime() != null ? room.getCheckOutTime() : room.getStandardCheckOutTime();
            parameters.put(KEY_CHECK_IN, MiscUtil.formatTime((Number)checkInTime));
            parameters.put(KEY_CHECK_OUT, MiscUtil.formatTime((Number)checkOutTime));
            int days = HotelProductHelper.calculateNights(room.getCheckInDate(), room.getCheckOutDate());
            String periodOfStay = String.valueOf(days);
            parameters.put(KEY_PERIOD_OF_STAY, periodOfStay);
            Date date = room.getCheckInDate() != null ? new Date(room.getCheckInDate().getTime() + (long)(room.getCheckInTime() != null ? room.getCheckInTime() * 60 * 1000 : 0)) : (checkInDate = null);
            Date checkOutDate = room.getCheckOutDate() != null ? new Date(room.getCheckOutDate().getTime() + (long)(room.getCheckOutTime() != null ? room.getCheckOutTime() * 60 * 1000 : 0)) : null;
            parameters.put(KEY_ARRIVAL, checkInDate);
            parameters.put(KEY_DEPARTURE, checkOutDate);
            BigDecimal mealTotal = (BigDecimal)meal.getSecond();
            BigDecimal mealInDay = ((BigDecimal)meal.getSecond()).compareTo(BigDecimal.ZERO) == 0 ? BigDecimal.ZERO : ((BigDecimal)meal.getSecond()).divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP);
            GeneralProductContractRelationData clientContractRelation = GeneralProductHelper.getClientContractRelation((BaseProduct)product);
            BigDecimal price = null;
            String currency = null;
            if (clientContractRelation != null) {
                price = this.getPrice(clientContractRelation);
                currency = GeneralProductHelper.getCurrency((BaseContractRelationData)clientContractRelation).getCode();
            }
            if (!hidePrice) {
                this.fillPrices(parameters, product, includeFeesInTotalPrice, hotelLocation, room, days, mealTotal, mealInDay, price, currency);
            }
        }
        if (product.getTicketType() == TicketType.REFERRAL) {
            parameters.put(KEY_PAYMENT_TYPE_LOCALIZED, "\u041e\u043f\u043b\u0430\u0442\u0430 \u0432 \u043e\u0442\u0435\u043b\u0435");
        } else {
            PaymentType paymentType = VoucherRender.getPaymentType(product);
            if (paymentType != null) {
                parameters.put(KEY_PAYMENT_TYPE, paymentType.toString(ruLocale));
                parameters.put(KEY_PAYMENT_TYPE_LOCALIZED, ItineraryReceiptHelper.getLocalizedPaymentType(paymentType, ruLocale));
            }
        }
        List<String> guests = product.getTravellers().stream().map(traveller -> this.getFullName((Traveller)traveller, ruLocale)).filter(Objects::nonNull).collect(Collectors.toList());
        StringBuilder stringBuilder = new StringBuilder();
        if (guests.size() == 1) {
            parameters.put(KEY_GUESTS, guests.get(0));
        } else {
            guests.forEach(guest -> stringBuilder.append((String)guest).append("\n"));
            parameters.put(KEY_GUESTS, stringBuilder.toString());
        }
        parameters.put(KEY_ROOMS, String.valueOf(product.getRooms().size()));
        parameters.put(KEY_RESERVATION_NUMBER, CommonReservationGdsNameInfoHelper.getDisplayedRecordLocator(product.getReservation()));
        parameters.put(KEY_BOOKING_NUMBER, product.getReservation().getBookingFile().getNumber());
        parameters.put(KEY_HOTEL_EMAIL, product.getHotelEmail());
        this.fillAgencyCommunication(parameters, product);
        parameters.put(KEY_FULL_NAME, this.getFullName(!product.getTravellers().isEmpty() ? (Traveller)product.getTravellers().get(0) : null, LocaleHelper.getLocale((String)"RU")));
        parameters.put(KEY_TIME_LIMIT, this.getTimeLimit(product));
        parameters.put(KEY_VAUCHER_NUMBER, product.getSystemNumber());
        parameters.put(KEY_ORDER_STATUS, product.getStatus() != null ? product.getStatus().toString(LocaleHelper.getLocale((String)"RU")) : null);
        parameters.put(KEY_BLANKOWNER, this.getBlankOwnerName((EntityReference<Organization>)product.getBlankOwnerRef(), LocaleHelper.getLocale((String)"RU")));
        parameters.put(KEY_CANCELLATION_POLICY, this.getCancellationPolicy(product, LocaleHelper.RU_LOCALE));
        parameters.put(KEY_IS_FULLY_PAYED, this.isFullyPayed(product));
        parameters.put(KEY_NOT_PAYED_ITEMS, this.getNotPayedTaxes(product));
        parameters.put(KEY_AGENCY_LOGO, this.getLogoStream(product, parameters));
        parameters.put(KEY_AGENCY_CONTACTS, this.getAgencyContacts(product, agencyContacts));
        parameters.put(KEY_IS_EARLY_CHECK_IN, this.getServiceIsIncluded(product.getAdditionalServices(), AdditionalServiceType.EARLIER_CHECKIN));
        parameters.put(KEY_IS_LATE_CHECK_OUT, this.getServiceIsIncluded(product.getAdditionalServices(), AdditionalServiceType.LATER_CHECKOUT));
        String additionalServicesInfo = this.getAdditionalServicesInfo(product, LocaleHelper.RU_LOCALE, false);
        if (TextUtil.nonBlank((String)additionalServicesInfo)) {
            parameters.put(KEY_ADDITIONAL_SERVICES_INFO, additionalServicesInfo);
        }
        if (TextUtil.nonBlank((String)(additionalServicesInfoWithoutType = this.getAdditionalServicesInfo(product, LocaleHelper.RU_LOCALE, true)))) {
            parameters.put(KEY_ADDITIONAL_SERVICES_INFO_WITHOUT_TYPE, additionalServicesInfoWithoutType);
        }
        try {
            parameters.put(KEY_LOGO, this.getLogoIS(LOGO_LOCATION));
        }
        catch (Exception e) {
            parameters.put(KEY_LOGO, null);
        }
        VoucherRender.fillProviderInfoParameter(product, parameters, hideBasicEssentialInfo, hideAmenities);
        parameters.put(KEY_CUSTOMER_CODE, VoucherRender.getCustomerCode(product));
        if (showDownloadQrCode && (url = BookingHelper.createBookingDocumentUrl(bookingFileUid, (BaseProduct)product, VoucherRender.getDocumentType())) != null) {
            try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
                QRCodeUtil.generateToStream((String)url, (int)200, (int)200, (OutputStream)os, (QRCodeUtil.ImageFormat)QRCodeUtil.ImageFormat.PNG);
                ImageUtil.ImageData imageData = new ImageUtil.ImageData(os.toByteArray());
                parameters.put(KEY_DOWNLOAD_QR_CODE, imageData.getData());
            }
        }
        return parameters;
    }

    private BigDecimal getPrice(GeneralProductContractRelationData clientContractRelation) {
        BigDecimal price = null;
        if (clientContractRelation.getServiceData() != null && clientContractRelation.getServiceData().getDetalization() != null) {
            price = clientContractRelation.getServiceData().getDetalization().getFare();
        }
        for (GeneralProductCommission commission : clientContractRelation.getCommissions()) {
            if (!GeneralProductHelper.isHiddenFee((EntityReference<? extends BaseCommissionProperties>)commission.getCommissionProperties())) continue;
            price = MiscUtil.sum((BigDecimal[])new BigDecimal[]{price, commission.getEquivalentAmount()});
        }
        return price;
    }

    private void fillPrices(Map<String, Object> parameters, HotelProduct product, boolean includeFeesInTotalPrice, GeoLocation hotelLocation, Room room, int days, BigDecimal mealTotal, BigDecimal mealInDay, BigDecimal price, String currency) {
        Set businessTripCurrencies;
        BusinessTripCurrencies businessTripCurrency;
        parameters.put(KEY_PRICE, MiscUtil.sum((BigDecimal[])new BigDecimal[]{price, mealTotal}));
        Money priceInDay = this.getPriceInDay(room, days, mealInDay, price, currency);
        if (priceInDay != null) {
            parameters.put(KEY_PRICE_IN_DAY, priceInDay.getValue());
        }
        parameters.put(KEY_IS_CURRENCY, room.getBasePrice() != null ? Boolean.valueOf(!room.getBasePrice().getCurrency().equals("RUB")) : null);
        parameters.put(KEY_CURRENCY_VALUE, room.getBasePrice() != null ? room.getBasePrice().getCurrency() : null);
        BigDecimal currencyMeal = this.getMealOfAdditionalServiceCurrencyAmount(product);
        BigDecimal currencyMealInDay = currencyMeal.compareTo(BigDecimal.ZERO) != 0 ? currencyMeal.divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP) : BigDecimal.ZERO;
        parameters.put(KEY_CURRENCY_PRICE_IN_DAY, room.getBaseRate() != null ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{room.getBaseRate().getValue(), currencyMealInDay}) : null);
        parameters.put(KEY_CURRENCY_PRICE, room.getBasePrice() != null ? MiscUtil.sum((BigDecimal[])new BigDecimal[]{room.getBasePrice().getValue(), currencyMeal}) : null);
        parameters.put(KEY_EARLY_CHECK_IN, this.getServiceEquivalentAmount(product.getAdditionalServices(), AdditionalServiceType.EARLIER_CHECKIN));
        parameters.put(KEY_LATE_CHECK_OUT, this.getServiceEquivalentAmount(product.getAdditionalServices(), AdditionalServiceType.LATER_CHECKOUT));
        BigDecimal totalPrice = this.getTotalPrice(product, includeFeesInTotalPrice);
        BigDecimal serviceFeePrice = this.getServiceFeePrice(product);
        parameters.put(KEY_SERVICE_FEE_PRICE, serviceFeePrice);
        parameters.put(KEY_SERVICE_FEE_PRICE_IN_DAY, serviceFeePrice.divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP));
        parameters.put(KEY_TOTAL_PRICE, totalPrice);
        parameters.put(KEY_CURRENCY, currency);
        if (hotelLocation != null && hotelLocation.getCountry() != null && (businessTripCurrency = (BusinessTripCurrencies)CollectionUtil.head((Iterable)(businessTripCurrencies = DictionaryCache.get().search(BusinessTripCurrencies.class, DictSearchCriterion.eq((String)BusinessTripCurrencies.Property.country.name(), (Object)hotelLocation.getCountry()))))) != null) {
            parameters.put(KEY_BUSINESS_TRIP_CURRENCY, businessTripCurrency.getCurrency().getCode());
            parameters.put(KEY_PRICE_IN_BUSINESS_TRIP_CURRENCY, MoneyHelper.exchange(MoneyHelper.buildMoney(totalPrice, currency), businessTripCurrency.getCurrency().getCode(), product.getIssueDate()));
            if (priceInDay != null) {
                parameters.put(KEY_PRICE_PER_NIGHT_IN_BUSINESS_TRIP_CURRENCY, MoneyHelper.exchange(priceInDay, businessTripCurrency.getCurrency().getCode(), product.getIssueDate()));
            }
        }
    }

    private Money getPriceInDay(Room room, int days, BigDecimal mealInDay, BigDecimal price, String currency) {
        if (price != null) {
            if (price.compareTo(BigDecimal.ZERO) != 0) {
                return MoneyHelper.buildMoney(MiscUtil.sum((BigDecimal[])new BigDecimal[]{price.divide(BigDecimal.valueOf(days), 2, RoundingMode.HALF_UP), mealInDay}), currency);
            }
            return MoneyHelper.buildMoney(MiscUtil.sum((BigDecimal[])new BigDecimal[]{BigDecimal.ZERO, mealInDay}), currency);
        }
        if (room.getBaseRate() != null) {
            return room.getBaseRate();
        }
        return null;
    }

    private String getBlankOwnerName(EntityReference<Organization> blankOwnerRef, Locale locale) {
        if (blankOwnerRef == null) {
            return null;
        }
        EntityContainer resolve = EntityStorage.get().resolve(blankOwnerRef);
        if (resolve == null || resolve.getEntity() == null) {
            return null;
        }
        String result = null;
        Organization organization = (Organization)resolve.getEntity();
        if (organization.getFullName() != null) {
            result = (String)organization.getFullName().getValues().get(locale);
            String string = result = TextUtil.nonBlank((String)result) ? result : (String)organization.getFullName().getValues().values().stream().filter(TextUtil::nonBlank).findFirst().orElse(null);
        }
        if (TextUtil.isBlank(result)) {
            result = (String)organization.getShortName().getValues().get(locale);
            result = TextUtil.nonBlank((String)result) ? result : (String)organization.getShortName().getValues().values().stream().filter(TextUtil::nonBlank).findFirst().orElse(null);
        }
        return result;
    }

    private BigDecimal getTotalPrice(HotelProduct product, boolean includeFeesInTotalPrice) {
        HashSet<FopType> filters = new HashSet<FopType>(GeneralProductHelper.productFopTypes);
        if (includeFeesInTotalPrice) {
            filters.addAll(GeneralProductHelper.serviceFeeFopTypes);
        }
        return GeneralProductHelper.filterFops(GeneralProductHelper.getUnmodifiableFops(product, ContractType.CLIENT), filters, null, null).stream().map(GeneralProductFop::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
    }

    private BigDecimal getServiceFeePrice(HotelProduct product) {
        HashSet<FopType> filters = new HashSet<FopType>(GeneralProductHelper.serviceFeeFopTypes);
        return GeneralProductHelper.filterFops(GeneralProductHelper.getUnmodifiableFops(product, ContractType.CLIENT), filters, null, null).stream().map(GeneralProductFop::getEquivalentAmount).filter(Objects::nonNull).reduce((xva$0, xva$1) -> MiscUtil.sum((BigDecimal[])new BigDecimal[]{xva$0, xva$1})).orElse(BigDecimal.ZERO);
    }

    private String getCancellationPolicy(HotelProduct product, Locale locale) {
        if (!product.isCancellable()) {
            return L10nResourcesManager.getStr((String)"HOTELS_BOOKING_CANCELLATION_IMPOSSIBLE", (Locale)locale, (Object[])new Object[0]);
        }
        List<CancellationCharge> cancellationCharges = CancellationChargeHelper.normalize(new Date(), product.getCancellationCharges(), MiscUtil.toLocalDate((Date)HotelProductHelper.getCheckInDate(product)));
        if (cancellationCharges.isEmpty()) {
            return L10nResourcesManager.getStr((String)"HOTELS_BOOKING_CANCELLATION_IMPOSSIBLE", (Locale)locale, (Object[])new Object[0]);
        }
        Money hiddenNotRefundedFees = CancellationChargeHelper.calcHiddenNotRefundedFeesAmount(GeneralProductHelper.getUnmodifiableContractRelations((BaseProduct)product), product.getGdsCurrency());
        return CancellationChargeHelper.buildCancellationPolicy(cancellationCharges, HotelProductHelper.calcBasePrice(product), hiddenNotRefundedFees, product.getCancellationPolicyText(), locale);
    }

    private boolean isFullyPayed(HotelProduct product) {
        return HotelProductHelper.isFareFopsRelevant(product) && this.getNotPayedTaxes(product).isEmpty();
    }

    private List<String> getNotPayedTaxes(HotelProduct product) {
        return product.getTaxInfoList().stream().filter(taxInfo -> !taxInfo.isIncludedInTariff()).filter(taxInfo -> taxInfo.getAmount() != null && !MiscUtil.isZero((BigDecimal)taxInfo.getAmount().getValue(), (boolean)true)).map(taxInfo -> String.format("%s (%s %s)", taxInfo.getName(), taxInfo.getAmount().getValue(), taxInfo.getAmount().getCurrency())).collect(Collectors.toList());
    }

    private InputStream getLogoStream(HotelProduct product, Map<String, Object> parameters) {
        BinaryData logo = OrganizationLogotypeHelper.getLogotype((BaseProduct)product, parameters);
        if (logo != null && logo.getData() != null) {
            return new ByteArrayInputStream(logo.getData());
        }
        return null;
    }

    private InputStream getLogoIS(String path) throws IOException {
        File file = new File(System.getProperty("user.dir") + path);
        BufferedImage bufferimage = ImageIO.read(file);
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)bufferimage, "jpg", output);
        byte[] data = output.toByteArray();
        return new ByteArrayInputStream(data);
    }

    private String getAgencyContacts(HotelProduct product, String agencyContacts) {
        if (TextUtil.nonBlank((String)agencyContacts)) {
            return agencyContacts;
        }
        EntityContainer organization = EntityStorage.get().resolve(HotelProductHelper.getSubagency(product));
        if (organization == null) {
            organization = EntityStorage.get().resolve(HotelProductHelper.getAgency(product));
        }
        if (organization == null) {
            return null;
        }
        ArrayList<String> communications = new ArrayList<String>();
        for (Communication communication : ((Organization)organization.getEntity()).getCommunications()) {
            if (communication == null) continue;
            switch (communication.getType()) {
                case EMAIL: {
                    communications.add(communication.getSense());
                    break;
                }
                case AGENCY: 
                case WORK_PHONE: {
                    communications.add(ProfileHelper.buildFullPhoneNumber(communication));
                }
            }
        }
        String result = communications.stream().filter(TextUtil::nonBlank).collect(Collectors.joining(System.lineSeparator()));
        return TextUtil.nonBlank((String)result) ? result : null;
    }

    private JRDataSource getDataSource() {
        return new JREmptyDataSource();
    }

    private String getFileName(HotelProduct product, TemplateDocument templateDocument, Map<String, Object> parameters, Locale locale) {
        return this.getReportTitle(product, templateDocument, parameters, locale) + ".pdf";
    }

    private static DocumentType getDocumentType() {
        return DocumentType.VOUCHER;
    }

    private String getReportTitle(HotelProduct product, TemplateDocument templateDocument, Map<String, Object> parameters, Locale locale) {
        StringBuilder reportTitle = new StringBuilder();
        reportTitle.append(DocumentType.VOUCHER.toString(locale)).append(" ").append(TextUtil.nonBlank((String)((String)parameters.get(KEY_FULL_NAME))) ? (String)parameters.get(KEY_FULL_NAME) + " " : "").append(TextUtil.nonBlank((String)((String)parameters.get(KEY_HOTEL_NAME))) ? (String)parameters.get(KEY_HOTEL_NAME) + " " : "").append((Date)parameters.get(KEY_ARRIVAL) != null ? new SimpleDateFormat("dd.MM").format((Date)parameters.get(KEY_ARRIVAL)) : "").append("-").append((Date)parameters.get(KEY_DEPARTURE) != null ? new SimpleDateFormat("dd.MM.yyyy").format((Date)parameters.get(KEY_DEPARTURE)) : "");
        return reportTitle.toString();
    }

    private void fillAgencyCommunication(Map<String, Object> parameters, HotelProduct product) {
        EntityReference<Organization> agency = GeneralProductHelper.getAgency((BaseProduct)product);
        if (agency == null) {
            return;
        }
        EntityContainer resolve = EntityStorage.get().resolve(agency);
        if (resolve == null || resolve.getEntity() == null) {
            return;
        }
        ArrayList<String> emails = new ArrayList<String>();
        ArrayList<String> phones = new ArrayList<String>();
        Organization entity = (Organization)resolve.getEntity();
        for (Communication communication : entity.getCommunications()) {
            if (communication == null) continue;
            switch (communication.getType()) {
                case EMAIL: {
                    emails.add(communication.getSense());
                    break;
                }
                case AGENCY: 
                case WORK_PHONE: {
                    phones.add(ProfileHelper.buildFullPhoneNumber(communication));
                }
            }
        }
        parameters.put(KEY_EMAIL, !emails.isEmpty() ? String.join((CharSequence)",\n", emails) : null);
        parameters.put(KEY_PHONES, !phones.isEmpty() ? String.join((CharSequence)",\n", phones) : null);
    }

    private String getFullName(Traveller traveller, Locale locale) {
        if (traveller == null) {
            return null;
        }
        String contactPerson = null;
        EntityReference passenger = traveller.getPassenger();
        EntityContainer resolve = EntityStorage.get().resolve(passenger);
        if (resolve != null && resolve.getEntity() != null) {
            Person person = (Person)resolve.getEntity();
            if (person == null) {
                return null;
            }
            contactPerson = this.getPersonName((String)person.getLastName().getValues().get(locale), (String)person.getFirstName().getValues().get(locale), (String)person.getMiddleName().getValues().get(locale));
            if (TextUtil.isBlank((String)contactPerson)) {
                contactPerson = this.getPersonName(person.getLastName().getValues().values().stream().findFirst().orElse(null), person.getFirstName().getValues().values().stream().findFirst().orElse(null), person.getMiddleName().getValues().values().stream().findFirst().orElse(null));
            }
        } else {
            Passport passport = traveller.getPassport();
            if (passport != null) {
                contactPerson = this.getPersonName(passport.getLastName(), passport.getFirstName(), passport.getMiddleName());
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getCyrillicName();
            }
            if (TextUtil.isBlank(contactPerson)) {
                contactPerson = traveller.getName();
            }
        }
        return contactPerson;
    }

    private String getPersonName(String lastName, String firstName, String middleName) {
        return TextUtil.nonEmptyStr((String)lastName) + (TextUtil.nonBlank((String)lastName) ? (TextUtil.nonBlank((String)firstName) ? " " + firstName : "") : (TextUtil.nonBlank((String)firstName) ? firstName : "")) + (TextUtil.isBlank((String)lastName) && TextUtil.isBlank((String)firstName) ? "" : (TextUtil.nonBlank((String)middleName) ? " " + middleName : ""));
    }

    private boolean isRuLocale(List<Metadata> metadata) {
        for (Metadata m : metadata) {
            if (m == null || m.getKey() == null || !m.getKey().getCode().equals(KEY_LOCALE)) continue;
            return m.getValue().equals("RU");
        }
        return false;
    }

    private BigDecimal getServiceEquivalentAmount(List<AdditionalService> additionalServices, AdditionalServiceType serviceType) {
        BigDecimal result = BigDecimal.ZERO;
        for (AdditionalService service : additionalServices) {
            if (service.getType() != serviceType) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, service.getEquivalentAmount()});
        }
        return result;
    }

    private boolean getServiceIsIncluded(List<AdditionalService> additionalServices, AdditionalServiceType serviceType) {
        boolean result = false;
        for (AdditionalService service : additionalServices) {
            if (service.getType() != serviceType) continue;
            result = true;
            break;
        }
        return result;
    }

    private MiscUtil.Pair<String, BigDecimal> getMealOfAdditionalService(HotelProduct product) {
        MiscUtil.Pair result = new MiscUtil.Pair();
        StringJoiner joiner = new StringJoiner(", ");
        BigDecimal sum = BigDecimal.ZERO;
        for (AdditionalService as : product.getAdditionalServices()) {
            if (as.getType() != AdditionalServiceType.MEAL) continue;
            if (TextUtil.nonBlank((String)as.getName())) {
                joiner.add(as.getName());
            }
            sum = MiscUtil.sum((BigDecimal[])new BigDecimal[]{sum, as.getEquivalentAmount()});
        }
        result.setFirst((Object)(TextUtil.nonBlank((String)joiner.toString()) ? joiner.toString() : null));
        result.setSecond((Object)sum);
        return result;
    }

    private BigDecimal getMealOfAdditionalServiceCurrencyAmount(HotelProduct product) {
        BigDecimal result = BigDecimal.ZERO;
        for (AdditionalService as : product.getAdditionalServices()) {
            if (as.getType() != AdditionalServiceType.MEAL || as.getBaseAmount() == null || as.getBaseAmount().getValue() == null) continue;
            result = MiscUtil.sum((BigDecimal[])new BigDecimal[]{result, as.getBaseAmount().getValue()});
        }
        return result;
    }

    private String getAdditionalServicesInfo(HotelProduct product, Locale local, boolean notDisplayType) {
        StringBuilder result = new StringBuilder();
        for (AdditionalService service : product.getAdditionalServices()) {
            if (service.getType() == null || service.getBaseAmount() == null && service.getEquivalentAmount() == null) continue;
            if (result.length() != 0) {
                result.append("\n");
            }
            if (notDisplayType) {
                result.append(TextUtil.nonBlank((String)service.getName()) ? service.getName() : service.getType().toString(local));
                continue;
            }
            result.append(service.getType().toString(local));
            if (!TextUtil.nonBlank((String)service.getName())) continue;
            result.append(" (").append(service.getName()).append(")");
        }
        return result.toString();
    }

    private Date getTimeLimit(HotelProduct product) {
        return product.getCancellationCharges().stream().filter(cancellationCharge -> cancellationCharge.getPenalty() != null).filter(cancellationCharge -> {
            if (cancellationCharge.getPenalty().getMoney() != null && cancellationCharge.getPenalty().getMoney().getValue() != null && cancellationCharge.getPenalty().getMoney().getValue().compareTo(BigDecimal.ZERO) > 0) {
                return true;
            }
            if (cancellationCharge.getPenalty().getRate() != null) {
                return cancellationCharge.getPenalty().getRate() > 0.0;
            }
            return false;
        }).findFirst().map(CancellationCharge::getStartDate).orElseGet(() -> product.isCancellable() ? HotelProductHelper.getCheckInDate(product) : product.getIssueDate());
    }

    private static PaymentType getPaymentType(HotelProduct product) {
        return GeneralProductHelper.getClientFops((BaseProduct)product).stream().filter(Objects::nonNull).map(Fop::getType).filter(Objects::nonNull).findFirst().orElse(null);
    }

    private static String getCustomerCode(HotelProduct product) {
        EntityReference customerRef = product.getReservation().getBookingFile().getCustomerProfile();
        EntityContainer customerCtr = EntityStorage.get().resolve(customerRef);
        return Optional.ofNullable(customerCtr).map(ctr -> ((Organization)ctr.getEntity()).getCode()).orElse(null);
    }

    private static void fillProviderInfoParameter(HotelProduct product, Map<String, Object> parameters, boolean hideBasicEssentialInfo, boolean hideAmenities) {
        if (CollectionUtil.isNotEmpty((Collection)product.getEssentialInfoData())) {
            StringBuilder essentialInfo = new StringBuilder();
            if (!hideBasicEssentialInfo) {
                essentialInfo.append(product.getEssentialInfoData().stream().filter(data -> data.getType() != EssentialInfoDataType.ROOM_AMENITIES).flatMap(data -> data.getInfoValue().stream()).collect(Collectors.joining("\n")));
            }
            if (!hideAmenities) {
                if (essentialInfo.length() != 0) {
                    essentialInfo.append("\n");
                }
                essentialInfo.append(product.getEssentialInfoData().stream().filter(data -> data.getType() == EssentialInfoDataType.ROOM_AMENITIES).flatMap(data -> data.getInfoValue().stream()).collect(Collectors.joining(", ")));
            }
            if (essentialInfo.length() != 0) {
                parameters.put(KEY_PROVIDER_INFO, essentialInfo.toString());
            }
        }
    }
}

