/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.model.util;

import com.gridnine.xtrip.common.model.dict.AircraftEngine;
import com.gridnine.xtrip.common.test.TestBase;
import com.gridnine.xtrip.common.util.IoUtil;
import com.gridnine.xtrip.common.util.XmlUtil;
import com.gridnine.xtrip.common.xml.DocumentBuilderHelper;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.junit.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class XTripExporter
extends TestBase {
    @Test
    public void exportAircrafts() throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        Document inputDocument = XTripExporter.getInputXML(IoUtil.url2file((URL)XTripExporter.class.getResource("resources/aircraftInput.xml")));
        Document outputDocument = DocumentBuilderHelper.newDocument();
        Element root = outputDocument.createElement("objects");
        outputDocument.appendChild(root);
        Element rootElement = (Element)XmlUtil.safeGetNode((NodeList)inputDocument.getChildNodes(), (int)0);
        NodeList objectElements = rootElement.getElementsByTagName("inputobject");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            String maxSeatsString;
            String seatsString;
            String engineString;
            Element inputObject = (Element)XmlUtil.safeGetNode((NodeList)objectElements, (int)i);
            Element outputObject = (Element)root.appendChild(outputDocument.createElement("object"));
            outputObject.setAttribute("class", "com.gridnine.xtrip.common.model.dict.Aircraft");
            Element name = (Element)outputObject.appendChild(outputDocument.createElement("name"));
            name.setTextContent(inputObject.getElementsByTagName("name").item(0).getTextContent().trim());
            Element code = (Element)outputObject.appendChild(outputDocument.createElement("code"));
            code.setTextContent(inputObject.getElementsByTagName("codesubtype").item(0).getTextContent().trim());
            Element codeVariants = (Element)outputObject.appendChild(outputDocument.createElement("codeVariants"));
            Element item = (Element)codeVariants.appendChild(outputDocument.createElement("item"));
            String codeValue = inputObject.getElementsByTagName("codesubtype").item(0).getTextContent().trim();
            if (this.isIATA(codeValue)) {
                item.setAttribute("codeSystem", "IATA");
            } else {
                item.setAttribute("codeSystem", "CRT");
            }
            item.setTextContent(codeValue);
            Element translations = (Element)outputObject.appendChild(outputDocument.createElement("translations"));
            Element itemRussian = (Element)translations.appendChild(outputDocument.createElement("item"));
            itemRussian.setAttribute("lang", "ru");
            itemRussian.setTextContent(inputObject.getElementsByTagName("name").item(0).getTextContent().trim());
            String nameEnglish = inputObject.getElementsByTagName("nameenglish").item(0).getTextContent().trim();
            if (!nameEnglish.equals("")) {
                Element itemEnglish = (Element)translations.appendChild(outputDocument.createElement("item"));
                itemEnglish.setAttribute("lang", "en");
                itemEnglish.setTextContent(nameEnglish);
            }
            if ((engineString = XTripExporter.convertToEngine(inputObject.getElementsByTagName("type").item(0).getTextContent().trim())) != null && !engineString.equals("")) {
                Element engine = (Element)outputObject.appendChild(outputDocument.createElement("engine"));
                engine.setTextContent(engineString);
            }
            if (!(seatsString = inputObject.getElementsByTagName("seats").item(0).getTextContent().trim()).equals("") && !seatsString.equals("0")) {
                Element seats = (Element)outputObject.appendChild(outputDocument.createElement("seats"));
                seats.setTextContent(seatsString);
            }
            if ((maxSeatsString = inputObject.getElementsByTagName("masseats").item(0).getTextContent().trim()).equals("") || maxSeatsString.equals("0")) continue;
            Element maxSeats = (Element)outputObject.appendChild(outputDocument.createElement("maxSeats"));
            maxSeats.setTextContent(maxSeatsString);
        }
        XTripExporter.writeXmlFile(outputDocument, "./test/aircraftOutput.xml");
    }

    @Test
    public void exportCountries() throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        Document inputDocument = XTripExporter.getInputXML(IoUtil.url2file((URL)XTripExporter.class.getResource("resources/country.xml")));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        Document outputDocument = builder.newDocument();
        Element root = outputDocument.createElement("objects");
        outputDocument.appendChild(root);
        Element rootElement = (Element)inputDocument.getChildNodes().item(0);
        NodeList objectElements = rootElement.getElementsByTagName("data");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            Node _node = objectElements.item(i);
            if (_node == null) {
                _node = objectElements.item(i);
            }
            Element inputObject = (Element)_node;
            Element outputObject = (Element)root.appendChild(outputDocument.createElement("object"));
            outputObject.setAttribute("class", "com.gridnine.xtrip.common.model.dict.Country");
            String codeRussian = inputObject.getElementsByTagName("code").item(0).getTextContent().trim();
            String codeEnglish = inputObject.getElementsByTagName("code").item(1).getTextContent().trim();
            Element code = (Element)outputObject.appendChild(outputDocument.createElement("code"));
            code.setTextContent(codeEnglish);
            Element domestic = (Element)outputObject.appendChild(outputDocument.createElement("domestic"));
            if (codeEnglish.equals("RU")) {
                domestic.setTextContent("true");
            } else {
                domestic.setTextContent("false");
            }
            Element codeVariants = (Element)outputObject.appendChild(outputDocument.createElement("codeVariants"));
            Element itemCodeRussian = (Element)codeVariants.appendChild(outputDocument.createElement("item"));
            Element itemCodeEnglish = (Element)codeVariants.appendChild(outputDocument.createElement("item"));
            itemCodeRussian.setAttribute("codeSystem", "CRT");
            itemCodeEnglish.setAttribute("codeSystem", "IATA");
            itemCodeRussian.setTextContent(codeRussian);
            itemCodeEnglish.setTextContent(codeEnglish);
            Element translations = (Element)outputObject.appendChild(outputDocument.createElement("translations"));
            Element itemRussian = (Element)translations.appendChild(outputDocument.createElement("item"));
            itemRussian.setAttribute("lang", "ru");
            itemRussian.setTextContent(inputObject.getElementsByTagName("name").item(0).getTextContent().trim());
            Element itemEnglish = (Element)translations.appendChild(outputDocument.createElement("item"));
            itemEnglish.setAttribute("lang", "en");
            itemEnglish.setTextContent(inputObject.getElementsByTagName("name").item(1).getTextContent().trim());
        }
        XTripExporter.writeXmlFile(outputDocument, "./test/countryOutput.xml");
    }

    public void exportGeoLocations() throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        Document inputDocument = XTripExporter.getInputXML(IoUtil.url2file((URL)XTripExporter.class.getResource("resources/GeoLocationsInput.xml")));
        Document outputDocument = DocumentBuilderHelper.newDocument();
        Element root = outputDocument.createElement("objects");
        outputDocument.appendChild(root);
        Element rootElement = (Element)inputDocument.getChildNodes().item(0);
        NodeList objectElements = rootElement.getElementsByTagName("object");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            String maxSeatsString;
            String seatsString;
            String engineString;
            Node _node = objectElements.item(i);
            if (_node == null) {
                _node = objectElements.item(i);
            }
            Element inputObject = (Element)_node;
            Element outputObject = (Element)root.appendChild(outputDocument.createElement("object"));
            outputObject.setAttribute("class", "com.gridnine.xtrip.common.model.dict.GeoLocation");
            Element name = (Element)outputObject.appendChild(outputDocument.createElement("name"));
            name.setTextContent(inputObject.getElementsByTagName("name").item(0).getTextContent().trim());
            Element code = (Element)outputObject.appendChild(outputDocument.createElement("code"));
            code.setTextContent(inputObject.getElementsByTagName("codesubtype").item(0).getTextContent().trim());
            Element codeVariants = (Element)outputObject.appendChild(outputDocument.createElement("codeVariants"));
            Element item = (Element)codeVariants.appendChild(outputDocument.createElement("item"));
            String codeValue = inputObject.getElementsByTagName("codesubtype").item(0).getTextContent().trim();
            if (this.isIATA(codeValue)) {
                item.setAttribute("codeSystem", "IATA");
            } else {
                item.setAttribute("codeSystem", "CRT");
            }
            item.setTextContent(codeValue);
            Element translations = (Element)outputObject.appendChild(outputDocument.createElement("translations"));
            Element itemRussian = (Element)translations.appendChild(outputDocument.createElement("item"));
            itemRussian.setAttribute("lang", "ru");
            itemRussian.setTextContent(inputObject.getElementsByTagName("name").item(0).getTextContent().trim());
            String nameEnglish = inputObject.getElementsByTagName("nameenglish").item(0).getTextContent().trim();
            if (!nameEnglish.equals("")) {
                Element itemEnglish = (Element)translations.appendChild(outputDocument.createElement("item"));
                itemEnglish.setAttribute("lang", "en");
                itemEnglish.setTextContent(nameEnglish);
            }
            if ((engineString = XTripExporter.convertToEngine(inputObject.getElementsByTagName("type").item(0).getTextContent().trim())) != null && !engineString.equals("")) {
                Element engine = (Element)outputObject.appendChild(outputDocument.createElement("engine"));
                engine.setTextContent(engineString);
            }
            if (!(seatsString = inputObject.getElementsByTagName("seats").item(0).getTextContent().trim()).equals("") && !seatsString.equals("0")) {
                Element seats = (Element)outputObject.appendChild(outputDocument.createElement("seats"));
                seats.setTextContent(seatsString);
            }
            if ((maxSeatsString = inputObject.getElementsByTagName("masseats").item(0).getTextContent().trim()).equals("") || maxSeatsString.equals("0")) continue;
            Element maxSeats = (Element)outputObject.appendChild(outputDocument.createElement("maxSeats"));
            maxSeats.setTextContent(maxSeatsString);
        }
        XTripExporter.writeXmlFile(outputDocument, "./test/GeoLocationOutput.xml");
    }

    public static List<String> getCityCodes() throws ParserConfigurationException, SAXException, IOException, TransformerFactoryConfigurationError, TransformerException {
        Document inputDocument = XTripExporter.getInputXML(IoUtil.url2file((URL)XTripExporter.class.getResource("resources/codes_input.xml")));
        ArrayList<String> cityCodes = new ArrayList<String>();
        Element rootElement = (Element)inputDocument.getChildNodes().item(0);
        NodeList objectElements = rootElement.getElementsByTagName("code");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            Node _node = objectElements.item(i);
            if (_node == null) {
                _node = objectElements.item(i);
            }
            Element inputObject = (Element)_node;
            cityCodes.add(inputObject.getElementsByTagName("iata_code").item(0).getTextContent().trim());
        }
        return cityCodes;
    }

    private boolean isIATA(String codeValue) {
        char[] cArray = codeValue.toCharArray();
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            boolean isLatin;
            Character character = Character.valueOf(cArray[i]);
            Character.UnicodeBlock block = Character.UnicodeBlock.of(character.charValue());
            boolean isDigit = Character.isDigit(character.charValue());
            boolean bl = isLatin = block != null && Character.UnicodeBlock.BASIC_LATIN.equals(block);
            if (isDigit || isLatin) continue;
            return false;
        }
        return true;
    }

    private static String convertToEngine(String type) {
        if (type.equals("\u0412\u0438\u043d\u0442\u043e\u0432\u043e\u0439")) {
            return AircraftEngine.PROPELLER.name();
        }
        if (type.equals("\u041f\u043e\u0440\u0448\u043d\u0435\u0432\u043e\u0439")) {
            return AircraftEngine.PISTON.name();
        }
        if (type.equals("\u0420\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439")) {
            return AircraftEngine.JET.name();
        }
        if (type.equals("\u0422\u0443\u0440\u0431\u043e\u0440\u0435\u0430\u043a\u0442\u0438\u0432\u043d\u044b\u0439")) {
            return AircraftEngine.TURBOJET.name();
        }
        return null;
    }

    private static Document getInputXML(File file) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(file);
    }

    private static void writeXmlFile(Document doc, String filename) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource source = new DOMSource(doc);
        File file = new File(filename);
        StreamResult result = new StreamResult(file);
        Transformer xformer = TransformerFactory.newInstance().newTransformer();
        xformer.transform(source, result);
    }

    public static String extractCityName(String string) {
        if (string.indexOf("NOT IN TBL") != -1) {
            return "NOT IN TBL";
        }
        int commaIndex = string.indexOf(",");
        int doubleSpaceIndex = string.indexOf("  ");
        int endIndex = doubleSpaceIndex == -1 || commaIndex < doubleSpaceIndex ? commaIndex : doubleSpaceIndex;
        return string.substring(5, endIndex);
    }

    public static void makeGeoLocationsCityMatching() throws ParserConfigurationException, SAXException, IOException {
        Document inputDocument = XTripExporter.getInputXML(IoUtil.url2file((URL)XTripExporter.class.getResource("resources/GeoLocationsCityMatching.xml")));
        Element rootElement = (Element)inputDocument.getChildNodes().item(0);
        NodeList objectElements = rootElement.getElementsByTagName("city");
        for (int i = 0; i < objectElements.getLength(); ++i) {
            Element inputObject;
            String cityNameFromExcel;
            Node _node = objectElements.item(i);
            if (_node == null) {
                _node = objectElements.item(i);
            }
            if ((cityNameFromExcel = (inputObject = (Element)_node).getElementsByTagName("city_name_en").item(0).getTextContent()).equals("")) {
                System.out.println();
                continue;
            }
            String cityNameFromSabre = inputObject.getElementsByTagName("city_name_en_from_sabre").item(0).getTextContent().split(",")[0].substring(4);
            if (cityNameFromExcel.equalsIgnoreCase(cityNameFromSabre)) {
                System.out.println("YES");
                continue;
            }
            System.out.println("NO");
        }
    }

    public static void main(String[] args) throws ParserConfigurationException, SAXException, IOException {
        XTripExporter.makeGeoLocationsCityMatching();
    }
}

