/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.DCT;
import com.idrsolutions.image.jpeg.JpegHuffman;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.io.IOException;
import java.io.OutputStream;

public class JpegEncoder {
    private static final int[] sampleFrequency = new int[]{1, 1, 1};
    private static final int[] TableNumber = new int[]{0, 1, 1};

    public void write(BufferedImage bufferedImage, OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = bufferedImage.getHeight();
        int n6 = bufferedImage.getWidth();
        int n7 = 3;
        JpegHuffman jpegHuffman = new JpegHuffman();
        JpegEncoder.WriteHeaders(outputStream, jpegHuffman, n6, n5, n7);
        int[] nArray = new int[n7];
        int[] nArray2 = new int[n7];
        int n8 = 1;
        for (n4 = 0; n4 < sampleFrequency.length; ++n4) {
            n8 = Math.max(n8, sampleFrequency[n4]);
        }
        for (n4 = 0; n4 < n7; ++n4) {
            double d = Math.ceil(1.0 * (double)n5 * (double)sampleFrequency[n4] / (double)n8);
            double d2 = Math.ceil(1.0 * (double)n6 * (double)sampleFrequency[n4] / (double)n8);
            nArray[n4] = (int)(d % 8.0 != 0.0 ? (Math.floor(d / 8.0) + 1.0) * 8.0 : d);
            nArray2[n4] = (int)(d2 % 8.0 != 0.0 ? (Math.floor(d2 / 8.0) + 1.0) * 8.0 : d2);
        }
        n4 = 0;
        int n9 = nArray2[0];
        int n10 = nArray[0];
        int n11 = nArray2[0] - n6;
        int n12 = n9 * n10;
        byte[] byArray = new byte[n12];
        byte[] byArray2 = new byte[n12];
        byte[] byArray3 = new byte[n12];
        switch (bufferedImage.getType()) {
            case 1: 
            case 2: {
                int[] nArray3 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                n3 = 0;
                for (n2 = 0; n2 < n5; ++n2) {
                    for (n = 0; n < n6; ++n) {
                        byte[] byArray4 = JpegEncoder.intToBytes(nArray3[n3]);
                        byArray[n4] = byArray4[1];
                        byArray2[n4] = byArray4[2];
                        byArray3[n4] = byArray4[3];
                        ++n3;
                        ++n4;
                    }
                    n4 += n11;
                }
                break;
            }
            case 4: {
                int n13;
                int[] nArray4 = ((DataBufferInt)bufferedImage.getRaster().getDataBuffer()).getData();
                n = 0;
                for (int i = 0; i < n5; ++i) {
                    for (n13 = 0; n13 < n6; ++n13) {
                        byte[] byArray5 = JpegEncoder.intToBytes(nArray4[n]);
                        byArray[n4] = byArray5[3];
                        byArray2[n4] = byArray5[2];
                        byArray3[n4] = byArray5[1];
                        ++n;
                        ++n4;
                    }
                    n4 += n11;
                }
                break;
            }
            case 5: {
                int n14;
                byte[] byArray6 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n13 = 0;
                for (int i = 0; i < n5; ++i) {
                    for (n14 = 0; n14 < n6; ++n14) {
                        byArray[n4] = byArray6[n13 + 2];
                        byArray2[n4] = byArray6[n13 + 1];
                        byArray3[n4] = byArray6[n13];
                        n13 += 3;
                        ++n4;
                    }
                    n4 += n11;
                }
                break;
            }
            case 6: {
                byte[] byArray7 = ((DataBufferByte)bufferedImage.getRaster().getDataBuffer()).getData();
                int n14 = 0;
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        byArray[n4] = byArray7[n14 + 3];
                        byArray2[n4] = byArray7[n14 + 2];
                        byArray3[n4] = byArray7[n14 + 1];
                        n14 += 4;
                        ++n4;
                    }
                    n4 += n11;
                }
                break;
            }
            default: {
                BufferedImage bufferedImage2 = new BufferedImage(n6, n5, 1);
                bufferedImage2.createGraphics().drawImage((Image)bufferedImage, 0, 0, null);
                int[] nArray5 = ((DataBufferInt)bufferedImage2.getRaster().getDataBuffer()).getData();
                int n15 = 0;
                for (int i = 0; i < n5; ++i) {
                    for (int j = 0; j < n6; ++j) {
                        byte[] byArray8 = JpegEncoder.intToBytes(nArray5[n15]);
                        byArray[n4] = byArray8[1];
                        byArray2[n4] = byArray8[2];
                        byArray3[n4] = byArray8[3];
                        ++n15;
                        ++n4;
                    }
                    n4 += n11;
                }
            }
        }
        n4 = 0;
        n = n9 * n10;
        for (int i = 0; i < n; ++i) {
            int n16 = byArray[n4] & 0xFF;
            int n17 = byArray2[n4] & 0xFF;
            int n18 = byArray3[n4] & 0xFF;
            int n19 = 128 + 76 * n16 + 150 * n17 + 29 * n18 >> 8;
            n3 = 128 + 127 * n18 - 84 * n17 - 43 * n16 >> 8;
            n2 = 128 + 127 * n16 - 106 * n17 - 21 * n18 >> 8;
            byArray[n4] = (byte)(n19 -= 128);
            byArray2[n4] = (byte)n3;
            byArray3[n4] = (byte)n2;
            ++n4;
        }
        Object[] objectArray = new Object[]{byArray, byArray2, byArray3};
        JpegEncoder.WriteCompressedData(outputStream, jpegHuffman, objectArray, n10, n9, n7);
        JpegEncoder.WriteEOI(outputStream);
    }

    private static void WriteCompressedData(OutputStream outputStream, JpegHuffman jpegHuffman, Object[] objectArray, int n, int n2, int n3) throws IOException {
        int[] nArray = new int[64];
        int n4 = n / 8;
        int n5 = n2 / 8;
        int[] nArray2 = new int[n3];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n5; ++j) {
                int n6 = (j + i * n2) * 8;
                for (int k = 0; k < n3; ++k) {
                    byte[] byArray = (byte[])objectArray[k];
                    int n7 = 0;
                    int n8 = n6;
                    for (int i2 = 0; i2 < 8; ++i2) {
                        for (int i3 = 0; i3 < 8; ++i3) {
                            nArray[n7++] = byArray[n8 + i3];
                        }
                        n8 += n2;
                    }
                    DCT.FDCTQ(nArray, TableNumber[k]);
                    jpegHuffman.encodeBlock(outputStream, nArray, nArray2[k], TableNumber[k]);
                    nArray2[k] = nArray[0];
                }
            }
        }
        jpegHuffman.end(outputStream);
    }

    private static void WriteEOI(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[]{-1, -39};
        outputStream.write(byArray);
    }

    private static void WriteHeaders(OutputStream outputStream, JpegHuffman jpegHuffman, int n, int n2, int n3) throws IOException {
        int n4;
        JpegEncoder.writeMarker(outputStream, 65496);
        byte[] byArray = new byte[]{-1, -32, 0, 16, 74, 70, 73, 70, 0, 1, 0, 0, 0, 1, 0, 1, 0, 0};
        outputStream.write(byArray);
        byte[] byArray2 = new byte[134];
        byArray2[0] = -1;
        byArray2[1] = -37;
        byArray2[2] = 0;
        byArray2[3] = -124;
        int n5 = 4;
        for (int i = 0; i < 2; ++i) {
            int n6;
            byte[] byArray3;
            byArray2[n5++] = (byte)i;
            if (i == 0) {
                byArray3 = JpegLUT.QL;
                for (n6 = 0; n6 < 64; ++n6) {
                    byArray2[n5++] = byArray3[JpegLUT.ZIGZAGORDER[n6]];
                }
                continue;
            }
            byArray3 = JpegLUT.QC;
            for (n6 = 0; n6 < 64; ++n6) {
                byArray2[n5++] = byArray3[JpegLUT.ZIGZAGORDER[n6]];
            }
        }
        outputStream.write(byArray2);
        JpegEncoder.writeMarker(outputStream, 65472);
        JpegEncoder.writeLength(outputStream, 17);
        byte[] byArray4 = new byte[15];
        byArray4[0] = 8;
        byArray4[1] = (byte)(n2 >> 8 & 0xFF);
        byArray4[2] = (byte)(n2 & 0xFF);
        byArray4[3] = (byte)(n >> 8 & 0xFF);
        byArray4[4] = (byte)(n & 0xFF);
        byArray4[5] = (byte)n3;
        int n7 = 6;
        for (int i = 0; i < n3; ++i) {
            byArray4[n7++] = (byte)(i + 1);
            byArray4[n7++] = (byte)((sampleFrequency[i] << 4) + sampleFrequency[i]);
            byArray4[n7++] = (byte)TableNumber[i];
        }
        outputStream.write(byArray4);
        n7 = 4;
        int n8 = 4;
        byte[] byArray5 = new byte[17];
        byte[] byArray6 = new byte[4];
        byArray6[0] = -1;
        byArray6[1] = -60;
        for (int i = 0; i < 4; ++i) {
            int n9 = 0;
            byArray5[n7++ - n8] = (byte)jpegHuffman.bitList.get(i)[0];
            for (n4 = 1; n4 < 17; ++n4) {
                int n10 = jpegHuffman.bitList.get(i)[n4];
                byArray5[n7++ - n8] = (byte)n10;
                n9 += n10;
            }
            int n11 = n7;
            byte[] byArray7 = new byte[n9];
            for (n4 = 0; n4 < n9; ++n4) {
                byArray7[n7++ - n11] = (byte)jpegHuffman.valList.get(i)[n4];
            }
            byte[] byArray8 = new byte[n7];
            System.arraycopy(byArray6, 0, byArray8, 0, n8);
            System.arraycopy(byArray5, 0, byArray8, n8, 17);
            System.arraycopy(byArray7, 0, byArray8, n8 + 17, n9);
            byArray6 = byArray8;
            n8 = n7;
        }
        byArray6[2] = (byte)(n7 - 2 >> 8 & 0xFF);
        byArray6[3] = (byte)(n7 - 2 & 0xFF);
        outputStream.write(byArray6);
        byte[] byArray9 = new byte[14];
        byArray9[0] = -1;
        byArray9[1] = -38;
        byArray9[2] = 0;
        byArray9[3] = 12;
        byArray9[4] = (byte)n3;
        n7 = 5;
        for (n4 = 0; n4 < byArray9[4]; ++n4) {
            byArray9[n7++] = (byte)(n4 + 1);
            byArray9[n7++] = (byte)((TableNumber[n4] << 4) + TableNumber[n4]);
        }
        byArray9[n7++] = 0;
        byArray9[n7++] = 63;
        byArray9[n7++] = 0;
        outputStream.write(byArray9);
    }

    private static void writeMarker(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)n >> 8);
        outputStream.write((byte)n);
    }

    private static void writeLength(OutputStream outputStream, int n) throws IOException {
        outputStream.write((byte)n >> 8);
        outputStream.write((byte)n);
    }

    private static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    public static int[] rgbToYCBCR(int n, int n2, int n3) {
        int n4 = (int)(0.299f * (float)n + 0.587f * (float)n2 + 0.114f * (float)n3);
        int n5 = (int)(128.0f - 0.169f * (float)n - 0.331f * (float)n2 + 0.5f * (float)n3);
        int n6 = (int)(128.0f + 0.5f * (float)n - 0.419f * (float)n2 - 0.081f * (float)n3);
        return new int[]{n4, n5, n6};
    }
}

