/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.jpeg;

import com.idrsolutions.image.jpeg.IndexMap;
import com.idrsolutions.image.jpeg.JpegLUT;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Stack;

public class JpegHuffman {
    private int bitsToPut;
    private int bufferToPut;
    private final int[] DC_matrix0;
    private final int[] AC_matrix0;
    private final int[] DC_matrix1;
    private final int[] AC_matrix1;
    public ArrayList<int[]> bitList = new ArrayList();
    public ArrayList<int[]> valList;
    private static final int[] bitsDCchrominance = new int[]{1, 0, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0};
    private static final int[] bitsDCluminance = new int[]{0, 0, 1, 5, 1, 1, 1, 1, 1, 1, 0, 0, 0, 0, 0, 0, 0};
    private static final int[] bitsACchrominance = new int[]{17, 0, 2, 1, 2, 4, 4, 3, 4, 7, 5, 4, 4, 0, 1, 2, 119};
    private static final int[] bitsACluminance = new int[]{16, 0, 2, 1, 3, 3, 2, 4, 3, 5, 5, 4, 4, 0, 0, 1, 125};
    private static final int[] valDCchrominance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] valDCluminance = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11};
    private static final int[] valACchrominance = new int[]{0, 1, 2, 3, 17, 4, 5, 33, 49, 6, 18, 65, 81, 7, 97, 113, 19, 34, 50, 129, 8, 20, 66, 145, 161, 177, 193, 9, 35, 51, 82, 240, 21, 98, 114, 209, 10, 22, 36, 52, 225, 37, 241, 23, 24, 25, 26, 38, 39, 40, 41, 42, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 130, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 226, 227, 228, 229, 230, 231, 232, 233, 234, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private static final int[] valACluminance = new int[]{1, 2, 3, 0, 4, 17, 5, 18, 33, 49, 65, 6, 19, 81, 97, 7, 34, 113, 20, 50, 129, 145, 161, 8, 35, 66, 177, 193, 21, 82, 209, 240, 36, 51, 98, 114, 130, 9, 10, 22, 23, 24, 25, 26, 37, 38, 39, 40, 41, 42, 52, 53, 54, 55, 56, 57, 58, 67, 68, 69, 70, 71, 72, 73, 74, 83, 84, 85, 86, 87, 88, 89, 90, 99, 100, 101, 102, 103, 104, 105, 106, 115, 116, 117, 118, 119, 120, 121, 122, 131, 132, 133, 134, 135, 136, 137, 138, 146, 147, 148, 149, 150, 151, 152, 153, 154, 162, 163, 164, 165, 166, 167, 168, 169, 170, 178, 179, 180, 181, 182, 183, 184, 185, 186, 194, 195, 196, 197, 198, 199, 200, 201, 202, 210, 211, 212, 213, 214, 215, 216, 217, 218, 225, 226, 227, 228, 229, 230, 231, 232, 233, 234, 241, 242, 243, 244, 245, 246, 247, 248, 249, 250};
    private final int AC0_0;
    private final int AC0_1;
    private final int AC0_480;
    private final int AC0_481;
    private final int AC1_0;
    private final int AC1_1;
    private final int AC1_480;
    private final int AC1_481;

    public JpegHuffman() {
        int n;
        int n2;
        int n3;
        this.bitList.add(bitsDCluminance);
        this.bitList.add(bitsACluminance);
        this.bitList.add(bitsDCchrominance);
        this.bitList.add(bitsACchrominance);
        this.valList = new ArrayList();
        this.valList.add(valDCluminance);
        this.valList.add(valACluminance);
        this.valList.add(valDCchrominance);
        this.valList.add(valACchrominance);
        this.DC_matrix0 = new int[24];
        this.DC_matrix1 = new int[24];
        this.AC_matrix0 = new int[510];
        this.AC_matrix1 = new int[510];
        int[] nArray = new int[257];
        int[] nArray2 = new int[257];
        int n4 = 0;
        for (n3 = 1; n3 <= 16; ++n3) {
            for (n2 = 1; n2 <= bitsDCchrominance[n3]; ++n2) {
                nArray[n4++] = n3;
            }
        }
        nArray[n4] = 0;
        int n5 = n4;
        int n6 = 0;
        int n7 = nArray[0];
        n4 = 0;
        while (nArray[n4] != 0) {
            while (nArray[n4] == n7) {
                nArray2[n4++] = n6++;
            }
            n6 <<= 1;
            ++n7;
        }
        n3 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            this.DC_matrix1[n3++] = nArray2[n4];
            this.DC_matrix1[n3++] = nArray[n4];
        }
        n4 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            for (n = 1; n <= bitsACchrominance[n2]; ++n) {
                nArray[n4++] = n2;
            }
        }
        nArray[n4] = 0;
        n5 = n4;
        n6 = 0;
        n7 = nArray[0];
        n4 = 0;
        while (nArray[n4] != 0) {
            while (nArray[n4] == n7) {
                nArray2[n4++] = n6++;
            }
            n6 <<= 1;
            ++n7;
        }
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = valACchrominance[n4] << 1;
            this.AC_matrix1[n3] = nArray2[n4];
            this.AC_matrix1[n3 + 1] = nArray[n4];
        }
        n4 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            for (n = 1; n <= bitsDCluminance[n2]; ++n) {
                nArray[n4++] = n2;
            }
        }
        nArray[n4] = 0;
        n5 = n4;
        n6 = 0;
        n7 = nArray[0];
        n4 = 0;
        while (nArray[n4] != 0) {
            while (nArray[n4] == n7) {
                nArray2[n4++] = n6++;
            }
            n6 <<= 1;
            ++n7;
        }
        n3 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            this.DC_matrix0[n3++] = nArray2[n4];
            this.DC_matrix0[n3++] = nArray[n4];
        }
        n4 = 0;
        for (n2 = 1; n2 <= 16; ++n2) {
            for (n = 1; n <= bitsACluminance[n2]; ++n) {
                nArray[n4++] = n2;
            }
        }
        nArray[n4] = 0;
        n5 = n4;
        n6 = 0;
        n7 = nArray[0];
        n4 = 0;
        while (nArray[n4] != 0) {
            while (nArray[n4] == n7) {
                nArray2[n4++] = n6++;
            }
            n6 <<= 1;
            ++n7;
        }
        for (n2 = 0; n2 < n5; ++n2) {
            n3 = valACluminance[n2] << 1;
            this.AC_matrix0[n3] = nArray2[n2];
            this.AC_matrix0[n3 + 1] = nArray[n2];
        }
        this.AC0_0 = this.AC_matrix0[0];
        this.AC0_1 = this.AC_matrix0[1];
        this.AC0_480 = this.AC_matrix0[480];
        this.AC0_481 = this.AC_matrix0[481];
        this.AC1_0 = this.AC_matrix1[0];
        this.AC1_1 = this.AC_matrix1[1];
        this.AC1_480 = this.AC_matrix1[480];
        this.AC1_481 = this.AC_matrix1[481];
    }

    public void encodeBlock(OutputStream outputStream, int[] nArray, int n, int n2) throws IOException {
        if (n2 == 0) {
            int n3 = nArray[0] - n;
            int n4 = n3;
            if (n4 < 0) {
                n4 = -n4;
                --n3;
            }
            int n5 = 0;
            while (n4 != 0) {
                ++n5;
                n4 >>= 1;
            }
            int n6 = n5 << 1;
            this.accumulate(outputStream, this.DC_matrix0[n6], this.DC_matrix0[n6 + 1]);
            if (n5 != 0) {
                this.accumulate(outputStream, n3, n5);
            }
            int n7 = 0;
            for (int i = 1; i < 64; ++i) {
                n4 = nArray[JpegLUT.ZIGZAGORDER[i]];
                if (n4 == 0) {
                    ++n7;
                    continue;
                }
                while (n7 > 15) {
                    this.accumulate(outputStream, this.AC0_480, this.AC0_481);
                    n7 -= 16;
                }
                n3 = n4;
                if (n4 < 0) {
                    n4 = -n4;
                    --n3;
                }
                n5 = 1;
                while ((n4 >>= 1) != 0) {
                    ++n5;
                }
                n6 = (n7 << 4) + n5 << 1;
                this.accumulate(outputStream, this.AC_matrix0[n6], this.AC_matrix0[n6 + 1]);
                this.accumulate(outputStream, n3, n5);
                n7 = 0;
            }
            if (n7 > 0) {
                this.accumulate(outputStream, this.AC0_0, this.AC0_1);
            }
        } else {
            int n8 = nArray[0] - n;
            int n9 = n8;
            if (n9 < 0) {
                n9 = -n9;
                --n8;
            }
            int n10 = 0;
            while (n9 != 0) {
                ++n10;
                n9 >>= 1;
            }
            int n11 = n10 << 1;
            this.accumulate(outputStream, this.DC_matrix1[n11], this.DC_matrix1[n11 + 1]);
            if (n10 != 0) {
                this.accumulate(outputStream, n8, n10);
            }
            int n12 = 0;
            for (int i = 1; i < 64; ++i) {
                n9 = nArray[JpegLUT.ZIGZAGORDER[i]];
                if (n9 == 0) {
                    ++n12;
                    continue;
                }
                while (n12 > 15) {
                    this.accumulate(outputStream, this.AC1_480, this.AC1_481);
                    n12 -= 16;
                }
                n8 = n9;
                if (n9 < 0) {
                    n9 = -n9;
                    --n8;
                }
                n10 = 1;
                while ((n9 >>= 1) != 0) {
                    ++n10;
                }
                n11 = (n12 << 4) + n10 << 1;
                this.accumulate(outputStream, this.AC_matrix1[n11], this.AC_matrix1[n11 + 1]);
                this.accumulate(outputStream, n8, n10);
                n12 = 0;
            }
            if (n12 > 0) {
                this.accumulate(outputStream, this.AC1_0, this.AC1_1);
            }
        }
    }

    private void accumulate(OutputStream outputStream, int n, int n2) throws IOException {
        int n3 = n;
        int n4 = this.bitsToPut;
        n3 &= (1 << n2) - 1;
        n3 <<= 24 - (n4 += n2);
        n3 |= this.bufferToPut;
        while (n4 >= 8) {
            int n5 = n3 >> 16 & 0xFF;
            outputStream.write(n5);
            if (n5 == 255) {
                outputStream.write(0);
            }
            n3 <<= 8;
            n4 -= 8;
        }
        this.bufferToPut = n3;
        this.bitsToPut = n4;
    }

    public void end(OutputStream outputStream) throws IOException {
        int n;
        int n2;
        int n3 = this.bufferToPut;
        for (n2 = this.bitsToPut; n2 >= 8; n2 -= 8) {
            n = n3 >> 16 & 0xFF;
            outputStream.write(n);
            if (n == 255) {
                outputStream.write(0);
            }
            n3 <<= 8;
        }
        if (n2 > 0) {
            n = n3 >> 16 & 0xFF;
            outputStream.write(n);
        }
    }

    public static Object[] generateHuffmanTable(int[] nArray, int[] nArray2) {
        int n;
        int n2 = 0;
        Stack<IndexMap> stack = new Stack<IndexMap>();
        for (n = 16; n > 0 && nArray[n - 1] == 0; --n) {
        }
        IndexMap indexMap = new IndexMap(0, new Object[2]);
        stack.push(indexMap);
        for (int i = 0; i < n; ++i) {
            IndexMap indexMap2;
            int n3 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                indexMap = (IndexMap)stack.pop();
                indexMap.children[indexMap.index] = nArray2[n2];
                while (indexMap.index > 0) {
                    indexMap = (IndexMap)stack.pop();
                }
                ++indexMap.index;
                stack.push(indexMap);
                while (stack.size() <= i) {
                    indexMap2 = new IndexMap(0, new Object[2]);
                    stack.push(indexMap2);
                    indexMap.children[indexMap.index] = indexMap2.children;
                    indexMap = indexMap2;
                }
                ++n2;
            }
            if (i + 1 >= n) continue;
            indexMap2 = new IndexMap(0, new Object[2]);
            stack.push(indexMap2);
            indexMap.children[indexMap.index] = indexMap2.children;
            indexMap = indexMap2;
        }
        return ((IndexMap)stack.elementAt((int)0)).children;
    }
}

