/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

import java.nio.ByteBuffer;
import java.util.zip.CRC32;

public class PngChunk {
    public static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    public static final byte[] IHDR = new byte[]{73, 72, 68, 82};
    public static final byte[] PLTE = new byte[]{80, 76, 84, 69};
    public static final byte[] tRNS = new byte[]{116, 82, 78, 83};
    public static final byte[] IDAT = new byte[]{73, 68, 65, 84};
    public static final byte[] IEND = new byte[]{73, 69, 78, 68};
    private final byte[] length;
    private final byte[] name;
    private final byte[] data;

    public PngChunk(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        this.length = byArray;
        this.name = byArray2;
        this.data = byArray3;
    }

    public static PngChunk createHeaderChunk(int n, int n2, byte by, byte by2, byte by3, byte by4, byte by5) {
        ByteBuffer byteBuffer = ByteBuffer.allocate(13);
        byteBuffer.putInt(n);
        byteBuffer.putInt(n2);
        byteBuffer.put(by);
        byteBuffer.put(by2);
        byteBuffer.put(by3);
        byteBuffer.put(by4);
        byteBuffer.put(by5);
        byte[] byArray = byteBuffer.array();
        return new PngChunk(PngChunk.intToBytes(13), IHDR, byArray);
    }

    public static PngChunk createPaleteChunk(byte[] byArray) {
        return new PngChunk(PngChunk.intToBytes(byArray.length), PLTE, byArray);
    }

    public static PngChunk createTrnsChunk(byte[] byArray) {
        return new PngChunk(PngChunk.intToBytes(byArray.length), tRNS, byArray);
    }

    public static PngChunk createDataChunk(byte[] byArray) {
        return new PngChunk(PngChunk.intToBytes(byArray.length), IDAT, byArray);
    }

    public static PngChunk createEndChunk() {
        return new PngChunk(PngChunk.intToBytes(0), IEND, new byte[0]);
    }

    public byte[] getCRCValue() {
        CRC32 cRC32 = new CRC32();
        cRC32.update(this.name);
        cRC32.update(this.data);
        byte[] byArray = PngChunk.longToBytes(cRC32.getValue());
        return new byte[]{byArray[4], byArray[5], byArray[6], byArray[7]};
    }

    public static byte[] intToBytes(int n) {
        return new byte[]{(byte)(n >> 24), (byte)(n >> 16), (byte)(n >> 8), (byte)n};
    }

    private static byte[] longToBytes(long l) {
        return new byte[]{(byte)(l >> 56), (byte)(l >> 48), (byte)(l >> 40), (byte)(l >> 32), (byte)(l >> 24), (byte)(l >> 16), (byte)(l >> 8), (byte)l};
    }

    public byte[] getLength() {
        return this.length;
    }

    public byte[] getName() {
        return this.name;
    }

    public byte[] getData() {
        return this.data;
    }
}

