/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.image.png;

public class Quant24 {
    private static final int IndexBits = 7;
    private static final int IndexBitsPlus = 8;
    private static final int DoubleIndexBits = 14;
    private static final int IndexCount = 129;
    private static final int TableLength = 2146689;
    private final long[] vwt = new long[2146689];
    private final long[] vmr = new long[2146689];
    private final long[] vmg = new long[2146689];
    private final long[] vmb = new long[2146689];
    private final double[] m2 = new double[2146689];
    private final byte[] tag = new byte[2146689];

    public byte[] getPalette(int[][] nArray) {
        int n = 256;
        this.histogram(nArray);
        this.M3d();
        Cube[] cubeArray = new Cube[n];
        this.buildCube(cubeArray, n);
        byte[] byArray = new byte[768];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = Quant24.volume(cubeArray[i], this.vwt);
            if (d != 0.0) {
                byArray[n2++] = (byte)(Quant24.volume(cubeArray[i], this.vmr) / d);
                byArray[n2++] = (byte)(Quant24.volume(cubeArray[i], this.vmg) / d);
                byArray[n2++] = (byte)(Quant24.volume(cubeArray[i], this.vmb) / d);
                continue;
            }
            n2 += 3;
        }
        return byArray;
    }

    public byte findMatch(int n) {
        int n2 = 1;
        int n3 = (n >> 16 & 0xFF) >> n2;
        int n4 = (n >> 8 & 0xFF) >> n2;
        int n5 = (n & 0xFF) >> n2;
        int n6 = Quant24.indexify(n3 + 1, n4 + 1, n5 + 1);
        return this.tag[n6];
    }

    private static int indexify(int n, int n2, int n3) {
        return (n << 14) + (n << 8) + (n2 << 7) + n + n2 + n3;
    }

    private static double volume(Cube cube, long[] lArray) {
        return lArray[Quant24.indexify(cube.R1, cube.G1, cube.B1)] - lArray[Quant24.indexify(cube.R1, cube.G1, cube.B0)] - lArray[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + lArray[Quant24.indexify(cube.R1, cube.G0, cube.B0)] - lArray[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + lArray[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + lArray[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - lArray[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
    }

    private static long base(Cube cube, int n, long[] lArray) {
        switch (n) {
            case 2: {
                return -lArray[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + lArray[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + lArray[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - lArray[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
            case 1: {
                return -lArray[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + lArray[Quant24.indexify(cube.R1, cube.G0, cube.B0)] + lArray[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - lArray[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
            case 0: {
                return -lArray[Quant24.indexify(cube.R1, cube.G1, cube.B0)] + lArray[Quant24.indexify(cube.R1, cube.G0, cube.B0)] + lArray[Quant24.indexify(cube.R0, cube.G1, cube.B0)] - lArray[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
            }
        }
        return 0L;
    }

    private static long findTop(Cube cube, int n, int n2, long[] lArray) {
        switch (n) {
            case 2: {
                return lArray[Quant24.indexify(n2, cube.G1, cube.B1)] - lArray[Quant24.indexify(n2, cube.G1, cube.B0)] - lArray[Quant24.indexify(n2, cube.G0, cube.B1)] + lArray[Quant24.indexify(n2, cube.G0, cube.B0)];
            }
            case 1: {
                return lArray[Quant24.indexify(cube.R1, n2, cube.B1)] - lArray[Quant24.indexify(cube.R1, n2, cube.B0)] - lArray[Quant24.indexify(cube.R0, n2, cube.B1)] + lArray[Quant24.indexify(cube.R0, n2, cube.B0)];
            }
            case 0: {
                return lArray[Quant24.indexify(cube.R1, cube.G1, n2)] - lArray[Quant24.indexify(cube.R1, cube.G0, n2)] - lArray[Quant24.indexify(cube.R0, cube.G1, n2)] + lArray[Quant24.indexify(cube.R0, cube.G0, n2)];
            }
        }
        return 0L;
    }

    private void histogram(int[][] nArray) {
        int n = 1;
        int n2 = nArray.length;
        int n3 = nArray[0].length;
        for (int i = 0; i < n2; ++i) {
            int[] nArray2 = nArray[i];
            for (int j = 0; j < n3; ++j) {
                int n4;
                int n5 = nArray2[j];
                int n6 = n5 >> 16 & 0xFF;
                int n7 = n5 >> 8 & 0xFF;
                int n8 = n5 & 0xFF;
                int n9 = n6 >> n;
                int n10 = n7 >> n;
                int n11 = n8 >> n;
                int n12 = n4 = Quant24.indexify(n9 + 1, n10 + 1, n11 + 1);
                this.vwt[n12] = this.vwt[n12] + 1L;
                int n13 = n4;
                this.vmr[n13] = this.vmr[n13] + (long)n6;
                int n14 = n4;
                this.vmg[n14] = this.vmg[n14] + (long)n7;
                int n15 = n4;
                this.vmb[n15] = this.vmb[n15] + (long)n8;
                int n16 = n4;
                this.m2[n16] = this.m2[n16] + (double)(n6 * n6 + n7 * n7 + n8 * n8);
            }
        }
    }

    private void M3d() {
        for (int i = 1; i < 129; ++i) {
            long[] lArray = new long[129];
            long[] lArray2 = new long[129];
            long[] lArray3 = new long[129];
            long[] lArray4 = new long[129];
            double[] dArray = new double[129];
            for (int j = 1; j < 129; ++j) {
                long l = 0L;
                long l2 = 0L;
                long l3 = 0L;
                long l4 = 0L;
                double d = 0.0;
                for (int k = 1; k < 129; ++k) {
                    int n = Quant24.indexify(i, j, k);
                    l += this.vwt[n];
                    l2 += this.vmr[n];
                    l3 += this.vmg[n];
                    l4 += this.vmb[n];
                    d += this.m2[n];
                    int n2 = k;
                    lArray[n2] = lArray[n2] + l;
                    int n3 = k;
                    lArray2[n3] = lArray2[n3] + l2;
                    int n4 = k;
                    lArray3[n4] = lArray3[n4] + l3;
                    int n5 = k;
                    lArray4[n5] = lArray4[n5] + l4;
                    int n6 = k;
                    dArray[n6] = dArray[n6] + d;
                    int n7 = n - Quant24.indexify(1, 0, 0);
                    this.vwt[n] = this.vwt[n7] + lArray[k];
                    this.vmr[n] = this.vmr[n7] + lArray2[k];
                    this.vmg[n] = this.vmg[n7] + lArray3[k];
                    this.vmb[n] = this.vmb[n7] + lArray4[k];
                    this.m2[n] = this.m2[n7] + dArray[k];
                }
            }
        }
    }

    private double variance(Cube cube) {
        double d = Quant24.volume(cube, this.vmr);
        double d2 = Quant24.volume(cube, this.vmg);
        double d3 = Quant24.volume(cube, this.vmb);
        double d4 = this.m2[Quant24.indexify(cube.R1, cube.G1, cube.B1)] - this.m2[Quant24.indexify(cube.R1, cube.G1, cube.B0)] - this.m2[Quant24.indexify(cube.R1, cube.G0, cube.B1)] + this.m2[Quant24.indexify(cube.R1, cube.G0, cube.B0)] - this.m2[Quant24.indexify(cube.R0, cube.G1, cube.B1)] + this.m2[Quant24.indexify(cube.R0, cube.G1, cube.B0)] + this.m2[Quant24.indexify(cube.R0, cube.G0, cube.B1)] - this.m2[Quant24.indexify(cube.R0, cube.G0, cube.B0)];
        return d4 - (d * d + d2 * d2 + d3 * d3) / Quant24.volume(cube, this.vwt);
    }

    private Object[] maximize(Cube cube, int n, int n2, int n3, double d, double d2, double d3, double d4) {
        long l = Quant24.base(cube, n, this.vmr);
        long l2 = Quant24.base(cube, n, this.vmg);
        long l3 = Quant24.base(cube, n, this.vmb);
        long l4 = Quant24.base(cube, n, this.vwt);
        double d5 = 0.0;
        int n4 = -1;
        for (int i = n2; i < n3; ++i) {
            double d6 = l + Quant24.findTop(cube, n, i, this.vmr);
            double d7 = l2 + Quant24.findTop(cube, n, i, this.vmg);
            double d8 = l3 + Quant24.findTop(cube, n, i, this.vmb);
            double d9 = l4 + Quant24.findTop(cube, n, i, this.vwt);
            if (d9 == 0.0) continue;
            double d10 = (d6 * d6 + d7 * d7 + d8 * d8) / d9;
            d6 = d - d6;
            d7 = d2 - d7;
            d8 = d3 - d8;
            if ((d9 = d4 - d9) == 0.0 || !((d10 += (d6 * d6 + d7 * d7 + d8 * d8) / d9) > d5)) continue;
            d5 = d10;
            n4 = i;
        }
        return new Object[]{n4, d5};
    }

    private boolean cut(Cube cube, Cube cube2) {
        int n;
        double d = Quant24.volume(cube, this.vmr);
        double d2 = Quant24.volume(cube, this.vmg);
        double d3 = Quant24.volume(cube, this.vmb);
        double d4 = Quant24.volume(cube, this.vwt);
        Object[] objectArray = this.maximize(cube, 2, cube.R0 + 1, cube.R1, d, d2, d3, d4);
        int n2 = (Integer)objectArray[0];
        double d5 = (Double)objectArray[1];
        objectArray = this.maximize(cube, 1, cube.G0 + 1, cube.G1, d, d2, d3, d4);
        int n3 = (Integer)objectArray[0];
        double d6 = (Double)objectArray[1];
        objectArray = this.maximize(cube, 0, cube.B0 + 1, cube.B1, d, d2, d3, d4);
        int n4 = (Integer)objectArray[0];
        double d7 = (Double)objectArray[1];
        if (d5 >= d6 && d5 >= d7) {
            n = 2;
            if (n2 < 0) {
                return false;
            }
        } else {
            n = d6 >= d5 && d6 >= d7 ? 1 : 0;
        }
        cube2.R1 = cube.R1;
        cube2.G1 = cube.G1;
        cube2.B1 = cube.B1;
        switch (n) {
            case 2: {
                cube2.R0 = cube.R1 = n2;
                cube2.G0 = cube.G0;
                cube2.B0 = cube.B0;
                break;
            }
            case 1: {
                cube2.G0 = cube.G1 = n3;
                cube2.R0 = cube.R0;
                cube2.B0 = cube.B0;
                break;
            }
            case 0: {
                cube2.B0 = cube.B1 = n4;
                cube2.R0 = cube.R0;
                cube2.G0 = cube.G0;
            }
        }
        cube.Volume = (cube.R1 - cube.R0) * (cube.G1 - cube.G0) * (cube.B1 - cube.B0);
        cube2.Volume = (cube2.R1 - cube2.R0) * (cube2.G1 - cube2.G0) * (cube2.B1 - cube2.B0);
        return true;
    }

    private void buildCube(Cube[] cubeArray, int n) {
        int n2;
        double[] dArray = new double[n];
        for (n2 = 0; n2 < n; ++n2) {
            cubeArray[n2] = new Cube();
        }
        cubeArray[0].B0 = 0;
        cubeArray[0].G0 = 0;
        cubeArray[0].R0 = 0;
        cubeArray[0].B1 = 128;
        cubeArray[0].G1 = 128;
        cubeArray[0].R1 = 128;
        n2 = 0;
        for (int i = 1; i < n; ++i) {
            if (this.cut(cubeArray[n2], cubeArray[i])) {
                dArray[n2] = cubeArray[n2].Volume > 1 ? this.variance(cubeArray[n2]) : 0.0;
                dArray[i] = cubeArray[i].Volume > 1 ? this.variance(cubeArray[i]) : 0.0;
            } else {
                dArray[n2] = 0.0;
                --i;
            }
            n2 = 0;
            double d = dArray[0];
            for (int j = 1; j <= i; ++j) {
                if (!(dArray[j] > d)) continue;
                d = dArray[j];
                n2 = j;
            }
            if (d <= 0.0) break;
        }
    }

    private class Cube {
        int A0;
        int A1;
        int R0;
        int R1;
        int G0;
        int G1;
        int B0;
        int B1;
        int Volume;

        private Cube() {
        }
    }
}

