/*
 * Decompiled with CFR 0.152.
 */
package com.idrsolutions.pdf.color.shading;

import com.idrsolutions.pdf.color.shading.ShadingFactory;
import com.idrsolutions.pdf.color.shading.ShadingUtils;
import java.awt.Color;
import java.awt.PaintContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.function.PDFFunction;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;

public class AxialShadeContext
implements PaintContext {
    private final GenericColorSpace shadingColorSpace;
    private final PDFFunction[] function;
    private final float[] background;
    private float[] domain;
    private boolean[] extension;
    float t0;
    float t1;
    double x0;
    double y0;
    double x1;
    double y1;
    double deltaX;
    double deltaY;
    double deltaT;
    double multiXY;
    double textX;
    double textY;
    private final AffineTransform shadeAffine;
    private AffineTransform inversed;

    public AxialShadeContext(AffineTransform affineTransform, GenericColorSpace genericColorSpace, float[] fArray, PdfObject pdfObject, float[][] fArray2, PDFFunction[] pDFFunctionArray, int n, int n2) {
        block5: {
            this.domain = new float[]{0.0f, 1.0f};
            this.shadingColorSpace = genericColorSpace;
            this.function = pDFFunctionArray;
            this.textX = n;
            this.textY = n2;
            float[] fArray3 = pdfObject.getFloatArray(1026641277);
            if (fArray3 != null) {
                this.domain = fArray3;
            }
            this.background = fArray;
            this.extension = pdfObject.getBooleanArray(1144345468);
            if (this.extension == null) {
                this.extension = new boolean[]{false, false};
            }
            this.t0 = this.domain[0];
            this.t1 = this.domain[1];
            this.deltaT = Math.abs(this.t1 - this.t0);
            this.shadeAffine = fArray2 == null ? new AffineTransform() : new AffineTransform(fArray2[0][0], fArray2[0][1], fArray2[1][0], fArray2[1][1], fArray2[2][0], fArray2[2][1]);
            try {
                this.inversed = affineTransform.createInverse();
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception " + noninvertibleTransformException + ' ');
                }
                if (this.inversed != null) break block5;
                this.inversed = new AffineTransform();
            }
        }
        float[] fArray4 = pdfObject.getFloatArray(1061308290);
        GeneralPath generalPath = ShadingUtils.getPathFromBBox(fArray4);
        PathIterator pathIterator = generalPath.getPathIterator(this.shadeAffine);
        double[] dArray = new double[6];
        pathIterator.currentSegment(dArray);
        this.x0 = dArray[0];
        this.y0 = dArray[1];
        pathIterator.next();
        pathIterator.currentSegment(dArray);
        this.x1 = dArray[0];
        this.y1 = dArray[1];
        this.deltaX = this.x1 - this.x0;
        this.deltaY = this.y1 - this.y0;
        this.multiXY = this.deltaX * this.deltaX + this.deltaY * this.deltaY;
    }

    @Override
    public void dispose() {
    }

    @Override
    public ColorModel getColorModel() {
        return ColorModel.getRGBdefault();
    }

    @Override
    public Raster getRaster(int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7 = n3 * n4 * 4;
        int[] nArray = new int[n7];
        if (this.background != null) {
            this.shadingColorSpace.setColor(this.background, 4);
            Color color = (Color)((Object)this.shadingColorSpace.getColor());
            for (n6 = 0; n6 < n4; ++n6) {
                for (n5 = 0; n5 < n3; ++n5) {
                    int n8 = (n6 * n3 + n5) * 4;
                    nArray[n8] = color.getRed();
                    nArray[n8 + 1] = color.getGreen();
                    nArray[n8 + 2] = color.getBlue();
                    nArray[n8 + 3] = 255;
                }
            }
        }
        for (int i = 0; i < n4; ++i) {
            for (n6 = 0; n6 < n3; ++n6) {
                n5 = 1;
                double[] dArray = new double[]{n + n6, n2 + i};
                this.inversed.transform(dArray, 0, dArray, 0, 1);
                double d = dArray[0];
                double d2 = dArray[1];
                float f = 0.0f;
                double d3 = (this.deltaX * (d - this.x0) + this.deltaY * (d2 - this.y0)) / this.multiXY;
                if (d3 >= 0.0 && d3 <= 1.0) {
                    f = (float)((double)this.t0 + (double)(this.t1 - this.t0) * d3);
                } else if (d3 < 0.0 && this.extension[0]) {
                    f = this.t0;
                } else if (d3 > 1.0 && this.extension[1]) {
                    f = this.t1;
                } else {
                    n5 = 0;
                }
                if (n5 == 0) continue;
                Color color = this.calculateColor(f);
                int n9 = (i * n3 + n6) * 4;
                nArray[n9] = color.getRed();
                nArray[n9 + 1] = color.getGreen();
                nArray[n9 + 2] = color.getBlue();
                nArray[n9 + 3] = 255;
            }
        }
        WritableRaster writableRaster = new BufferedImage(n3, n4, 2).getRaster();
        writableRaster.setPixels(0, 0, n3, n4, nArray);
        return writableRaster;
    }

    private Color calculateColor(float f) {
        float[] fArray = ShadingFactory.applyFunctions(this.function, new float[]{f});
        this.shadingColorSpace.setColor(fArray, fArray.length);
        Color color = (Color)((Object)this.shadingColorSpace.getColor());
        return color;
    }
}

