/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.color.JPEGDecoder;
import org.jpedal.color.PdfColor;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;

public class DeviceGrayColorSpace
extends GenericColorSpace {
    private static final long serialVersionUID = -8160089076145994695L;

    public DeviceGrayColorSpace() {
        this.setType(1568372915);
        this.cs = ColorSpace.getInstance(1003);
    }

    @Override
    public final void setColor(String[] stringArray, int n) {
        float[] fArray = new float[]{Float.parseFloat(stringArray[0])};
        this.setColor(fArray, 1);
    }

    @Override
    public final void setColor(float[] fArray, int n) {
        float f = fArray[0];
        int n2 = f <= 1.0f ? (int)(255.0f * f) : (int)f;
        if (n2 < 0) {
            n2 = 0;
        }
        this.currentColor = new PdfColor(n2, n2, n2);
    }

    @Override
    public byte[] dataToRGBByteArray(byte[] byArray, int n, int n2, boolean bl) {
        int n3 = byArray.length;
        byte[] byArray2 = new byte[n3 * 3];
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < 3; ++j) {
                byArray2[n4] = byArray[i];
                ++n4;
            }
        }
        return byArray2;
    }

    @Override
    public byte[] convertIndexToRGB(byte[] byArray) {
        this.isConverted = true;
        int n = byArray.length;
        byte[] byArray2 = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            for (int j = 0; j < 3; ++j) {
                byArray2[i * 3 + j] = by;
            }
        }
        return byArray2;
    }

    @Override
    public BufferedImage JPEGToRGBImage(byte[] byArray, int n, int n2, float[] fArray, int n3, int n4, boolean bl, PdfObject pdfObject) {
        if (pdfObject instanceof MaskObject) {
            return super.JPEGToRGBImage(byArray, n, n2, fArray, n3, n4, bl, pdfObject);
        }
        return JPEGDecoder.grayJPEGToRGBImage(byArray, n3, n4, bl);
    }
}

