/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.color;

import com.idrsolutions.image.jpeg.JpegDecoder;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import org.jpedal.color.GenericColorSpace;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.objects.raw.MaskObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.image.utils.ArrayUtils;
import org.jpedal.utils.LogWriter;

public class JPEGDecoder {
    static BufferedImage JPEGToRGBImageFromLUV(byte[] byArray, int n, int n2) {
        BufferedImage bufferedImage;
        block14: {
            try {
                Raster raster = DefaultImageHelper.readRasterFromJPeg(byArray);
                if (raster == null) {
                    return null;
                }
                raster = GenericColorSpace.cleanupRaster(raster, n, n2, 3);
                int n3 = raster.getWidth();
                int n4 = raster.getHeight();
                int n5 = n3 * n4;
                byte[] byArray2 = ((DataBufferByte)raster.getDataBuffer()).getData();
                float f = 0.0f;
                float f2 = 0.0f;
                float f3 = 0.0f;
                float f4 = -1.0f;
                float f5 = -1.0f;
                float f6 = -1.0f;
                for (int i = 0; i < n5 * 3; i += 3) {
                    float f7 = byArray2[i] & 0xFF;
                    float f8 = byArray2[i + 1] & 0xFF;
                    float f9 = byArray2[i + 2] & 0xFF;
                    if (f7 != f4 || f8 != f5 || f9 != f6) {
                        f = f7 + 1.402f * (f9 - 128.0f);
                        if (f < 0.0f) {
                            f = 0.0f;
                        } else if (f > 255.0f) {
                            f = 255.0f;
                        }
                        f2 = f7 - 0.344f * (f8 - 128.0f) - 0.714f * (f9 - 128.0f);
                        if (f2 < 0.0f) {
                            f2 = 0.0f;
                        } else if (f2 > 255.0f) {
                            f2 = 255.0f;
                        }
                        f3 = f7 + 1.772f * (f8 - 128.0f);
                        if (f3 < 0.0f) {
                            f3 = 0.0f;
                        } else if (f3 > 255.0f) {
                            f3 = 255.0f;
                        }
                        f4 = f7;
                        f5 = f8;
                        f6 = f9;
                    }
                    byArray2[i] = (byte)f;
                    byArray2[i + 1] = (byte)f2;
                    byArray2[i + 2] = (byte)f3;
                }
                DataBufferByte dataBufferByte = new DataBufferByte(byArray2, byArray2.length);
                int[] nArray = new int[]{0, 1, 2};
                bufferedImage = new BufferedImage(n3, n4, 1);
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * 3, 3, nArray, null);
                bufferedImage.setData(writableRaster);
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block14;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
        }
        return bufferedImage;
    }

    public static void write(BufferedImage bufferedImage, String string, String string2) {
        block2: {
            try {
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(new File(string2)));
                ImageIO.write((RenderedImage)bufferedImage, string, bufferedOutputStream);
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    public static void write(BufferedImage bufferedImage, String string, OutputStream outputStream) {
        block2: {
            try {
                ImageIO.write((RenderedImage)bufferedImage, string, outputStream);
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block2;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    public static Raster getRasterFromJPEG(byte[] byArray, String string) {
        Raster raster;
        block3: {
            ImageReader imageReader = null;
            raster = null;
            try {
                ImageReader imageReader2;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                Iterator<ImageReader> iterator = ImageIO.getImageReadersByFormatName(string);
                while (iterator.hasNext() && !(imageReader = (imageReader2 = iterator.next())).canReadRaster()) {
                }
                ImageIO.setUseCache(false);
                ImageInputStream imageInputStream = ImageIO.createImageInputStream(byteArrayInputStream);
                imageReader.setInput(imageInputStream, true);
                raster = imageReader.readRaster(0, null);
                byteArrayInputStream.close();
                imageReader.dispose();
                imageInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Problem closing  " + exception);
            }
        }
        return raster;
    }

    static BufferedImage grayJPEGToRGBImage(byte[] byArray, int n, int n2, boolean bl) {
        BufferedImage bufferedImage;
        block5: {
            bufferedImage = null;
            try {
                Raster raster = JPEGDecoder.getRasterFromJPEG(byArray, "JPEG");
                if (raster != null) {
                    raster = GenericColorSpace.cleanupRaster(raster, n, n2, 1);
                    int n3 = raster.getWidth();
                    int n4 = raster.getHeight();
                    DataBufferByte dataBufferByte = (DataBufferByte)raster.getDataBuffer();
                    byte[] byArray2 = dataBufferByte.getData();
                    int n5 = byArray2.length;
                    byte[] byArray3 = new byte[n5 * 3];
                    int n6 = 0;
                    for (int i = 0; i < n5; ++i) {
                        if (bl) {
                            byArray2[i] = (byte)(byArray2[i] ^ 0xFF);
                        }
                        byArray3[n6] = byArray2[i];
                        byArray3[++n6] = byArray2[i];
                        byArray3[++n6] = byArray2[i];
                        ++n6;
                    }
                    int[] nArray = new int[]{0, 1, 2};
                    bufferedImage = new BufferedImage(n3, n4, 1);
                    WritableRaster writableRaster = Raster.createInterleavedRaster(new DataBufferByte(byArray3, byArray3.length), n3, n4, n3 * 3, 3, nArray, null);
                    bufferedImage.setData(writableRaster);
                }
            }
            catch (Exception exception) {
                bufferedImage = null;
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Couldn't read JPEG, not even raster: " + exception);
            }
        }
        return bufferedImage;
    }

    public static byte[] getBytesFromJPEG(byte[] byArray, GenericColorSpace genericColorSpace, PdfObject pdfObject) {
        byte[] byArray2 = null;
        try {
            boolean bl = ArrayUtils.isArrayInverted(pdfObject.getFloatArray(859785322));
            JpegDecoder jpegDecoder = new JpegDecoder();
            jpegDecoder.setInverted(bl);
            byte[] byArray3 = jpegDecoder.readComponentsAsConvertedBytes(byArray);
            int n = jpegDecoder.getInfo().nComp;
            if (n == 3 || n == 4) {
                byArray2 = byArray3;
            } else if (pdfObject instanceof MaskObject) {
                byArray2 = byArray3;
            } else {
                byArray2 = new byte[byArray3.length * 3];
                int n2 = 0;
                for (int i = 0; i < byArray3.length; ++i) {
                    byte by = byArray3[i];
                    byArray2[n2++] = by;
                    byArray2[n2++] = by;
                    byArray2[n2++] = by;
                }
            }
            return byArray2;
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception with JPeg Image " + exception);
            }
            return byArray2;
        }
    }
}

