/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.TTGlyphs;
import org.jpedal.utils.LogWriter;

public class StandardFonts {
    private static Map unicode_name_mapping_table = new HashMap();
    private static String[][] unicode_char_decoding_table = new String[7][335];
    public static final int PDF = 6;
    public static final int ZAPF = 5;
    public static final int SYMBOL = 4;
    public static final int MACEXPERT = 3;
    public static final int WIN = 2;
    public static final int STD = 1;
    public static final int MAC = 0;
    public static final int TYPE0 = 1228944676;
    public static final int TYPE1 = 1228944677;
    public static final int TRUETYPE = 1217103210;
    public static final int TYPE3 = 1228944679;
    public static final int CIDTYPE0 = -1684566726;
    public static final int CIDTYPE2 = -1684566724;
    public static final int OPENTYPE = 6;
    public static final int TRUETYPE_COLLECTION = 7;
    public static final int FONT_UNSUPPORTED = 8;
    private static final String ellipsis = String.valueOf((char)Integer.parseInt("2026", 16));
    private static final String enc = "Cp1252";
    private static Map[] glyphToChar = new HashMap[7];
    private static String[] MAC_char_encoding_table;
    private static String[] WIN_char_encoding_table;
    private static String[] STD_char_encoding_table;
    private static String[] PDF_char_encoding_table;
    private static String[] ZAPF_char_encoding_table;
    private static String[] SYMBOL_char_encoding_table;
    private static String[] MACEXPERT_char_encoding_table;
    private static final Map<String, String> unicodeToName;
    private static ClassLoader loader;
    private static Map standardFileList;
    private static Map standardFontLoaded;
    private static Map widthTableStandard;
    protected static Map javaFontList;
    protected static String[] javaFonts;
    protected static String[] files_names;
    protected static String[] files_names_bis;
    private static HashMap adobeMap;
    private static Map fontBounds;
    public static boolean usesGlyphlist;
    private static final HashMap<String, HashMap<Integer, Integer>> mappedCharacters;
    private static final HashMap<String, ArrayList<Integer>> takenChars;
    private static final int MAX_CHAR_CODE = 55296;
    public static String[] CMAP;

    public static void dispose() {
        unicode_name_mapping_table = null;
        unicode_char_decoding_table = null;
        glyphToChar = null;
        MAC_char_encoding_table = null;
        WIN_char_encoding_table = null;
        STD_char_encoding_table = null;
        PDF_char_encoding_table = null;
        ZAPF_char_encoding_table = null;
        SYMBOL_char_encoding_table = null;
        MACEXPERT_char_encoding_table = null;
        loader = null;
        standardFileList = null;
        standardFontLoaded = null;
        widthTableStandard = null;
        javaFontList = null;
        javaFonts = null;
        files_names = null;
        files_names_bis = null;
        adobeMap = null;
        fontBounds = null;
    }

    public static int getFontType(String string) {
        int n = 8;
        if (string.endsWith(".ttf")) {
            n = 1217103210;
        } else if (string.endsWith(".otf")) {
            n = 6;
        } else if (string.endsWith(".ttc")) {
            n = 7;
        } else if (string.endsWith(".pfb")) {
            n = 1228944677;
        }
        return n;
    }

    public static float[] getFontBounds(String string) {
        return (float[])fontBounds.get(string);
    }

    public static String getUnicodeName(String string) {
        return (String)unicode_name_mapping_table.get(string);
    }

    public static String getUnicodeChar(int n, int n2) {
        return unicode_char_decoding_table[n][n2];
    }

    public static Float getStandardWidth(String string, String string2) {
        String string3;
        int n;
        Object v = widthTableStandard.get((string = string.toLowerCase()) + string2);
        if (v == null && (n = (string3 = string).indexOf(44)) != -1) {
            string3 = string3.substring(0, n);
            v = widthTableStandard.get(string3 + string2);
        }
        return (Float)v;
    }

    private static void readStandardMappingTable(int n, String string) {
        block19: {
            BufferedReader bufferedReader;
            block18: {
                bufferedReader = null;
                StandardFonts.glyphToChar[n] = new HashMap();
                try {
                    String string2;
                    BufferedReader bufferedReader2 = bufferedReader = string.equals("symbol.cfg") ? new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), enc)) : new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/" + string), "UTF-16"));
                    if (bufferedReader == null && LogWriter.isOutput()) {
                        LogWriter.writeLog("Unable to open " + string + " to read standard encoding");
                    }
                    while ((string2 = bufferedReader.readLine()) != null) {
                        String string3;
                        String string4;
                        String string5;
                        StringTokenizer stringTokenizer = new StringTokenizer(string2);
                        if (string2.contains("space") || stringTokenizer.countTokens() <= 1) continue;
                        if (stringTokenizer.countTokens() == 3) {
                            string5 = stringTokenizer.nextToken();
                            string4 = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        } else if (stringTokenizer.countTokens() == 4) {
                            String string6 = stringTokenizer.nextToken();
                            stringTokenizer.nextToken();
                            string4 = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                            string5 = Character.toString((char)Integer.parseInt(string6, 16));
                        } else if (stringTokenizer.countTokens() == 2) {
                            string5 = " ";
                            string4 = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        } else {
                            string5 = stringTokenizer.nextToken();
                            string4 = stringTokenizer.nextToken();
                            string3 = stringTokenizer.nextToken();
                        }
                        unicode_name_mapping_table.put(n + string4, string5);
                        glyphToChar[n].put(string4, Integer.parseInt(string3));
                        unicode_name_mapping_table.put(string4, string5);
                        if (!Character.isDigit(string3.charAt(0))) continue;
                        int n2 = Integer.parseInt(string3, 8);
                        if (n == 5) {
                            StandardFonts.ZAPF_char_encoding_table[n2] = string5;
                        } else if (n == 4) {
                            StandardFonts.SYMBOL_char_encoding_table[n2] = string5;
                        } else if (n == 3) {
                            StandardFonts.MACEXPERT_char_encoding_table[n2] = string5;
                        }
                        StandardFonts.unicode_char_decoding_table[n][n2] = string4;
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block18;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf");
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block19;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                }
            }
        }
    }

    private static void readStandardMappingTable(int n) {
        block22: {
            BufferedReader bufferedReader;
            block21: {
                bufferedReader = null;
                if (n == 0) {
                    StandardFonts.checkLoaded(2);
                }
                try {
                    String string;
                    StandardFonts.glyphToChar[n] = new HashMap();
                    bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/standard_encoding.cfg"), enc));
                    usesGlyphlist = true;
                    if (bufferedReader == null && LogWriter.isOutput()) {
                        LogWriter.writeLog("Unable to open standard_encoding.cfg from jar");
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        int n2;
                        StringTokenizer stringTokenizer = new StringTokenizer(string);
                        int n3 = stringTokenizer.countTokens();
                        String string2 = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        String string4 = stringTokenizer.nextToken();
                        String string5 = stringTokenizer.nextToken();
                        String string6 = stringTokenizer.nextToken();
                        String string7 = stringTokenizer.nextToken();
                        String string8 = n3 == 7 ? Character.toString((char)Integer.parseInt(string7, 16)) : string7;
                        unicodeToName.put(string8, string2);
                        if (n == 0 && Character.isDigit(string4.charAt(0))) {
                            int n4 = Integer.parseInt(string4, 8);
                            if (n4 == 201) {
                                string8 = ellipsis;
                            }
                            StandardFonts.MAC_char_encoding_table[n4] = string8;
                            StandardFonts.unicode_char_decoding_table[0][n4] = string2;
                            glyphToChar[0].put(string2, n4);
                        } else if (n == 1 && Character.isDigit(string3.charAt(0))) {
                            n2 = Integer.parseInt(string3, 8);
                            if (n2 == 188) {
                                string8 = ellipsis;
                            }
                            StandardFonts.STD_char_encoding_table[n2] = string8;
                            StandardFonts.unicode_char_decoding_table[1][n2] = string2;
                            glyphToChar[1].put(string2, n2);
                        } else if (n == 6 && Character.isDigit(string6.charAt(0))) {
                            n2 = Integer.parseInt(string6, 8);
                            if (n2 == 131) {
                                string8 = ellipsis;
                            }
                            StandardFonts.PDF_char_encoding_table[n2] = string8;
                            StandardFonts.unicode_char_decoding_table[6][n2] = string2;
                        } else if (n == 2 && Character.isDigit(string5.charAt(0))) {
                            int n5 = Integer.parseInt(string5, 8);
                            if (n5 == 133) {
                                string8 = ellipsis;
                            }
                            StandardFonts.WIN_char_encoding_table[n5] = string8;
                            StandardFonts.unicode_char_decoding_table[2][n5] = string2;
                            glyphToChar[2].put(string2, n5);
                        }
                        unicode_name_mapping_table.put(string2, string8);
                    }
                    if (n == 0) {
                        StandardFonts.MAC_char_encoding_table[202] = " ";
                    }
                    if (n == 2) {
                        StandardFonts.WIN_char_encoding_table[160] = " ";
                        StandardFonts.WIN_char_encoding_table[255] = "-";
                        StandardFonts.unicode_char_decoding_table[2][160] = "space";
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block21;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for " + n);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                }
            }
        }
    }

    public static String getNameFromUnicode(String string) {
        return unicodeToName.get(string);
    }

    public static String getEncodedChar(int n, int n2) {
        String string = null;
        if (n == 2) {
            string = WIN_char_encoding_table[n2];
        } else if (n == 1) {
            string = STD_char_encoding_table[n2];
        } else if (n == 0) {
            string = MAC_char_encoding_table[n2];
        } else if (n == 6) {
            string = PDF_char_encoding_table[n2];
        } else if (n == 5) {
            string = ZAPF_char_encoding_table[n2];
        } else if (n == 4) {
            string = SYMBOL_char_encoding_table[n2];
        } else if (n == 3) {
            string = MACEXPERT_char_encoding_table[n2];
        }
        if (string == null) {
            string = "&#" + n2 + ';';
        }
        return string;
    }

    public static void checkLoaded(int n) {
        if (n == 0 && MAC_char_encoding_table == null) {
            MAC_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 2 && WIN_char_encoding_table == null) {
            WIN_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 1 && STD_char_encoding_table == null) {
            STD_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 6 && PDF_char_encoding_table == null) {
            PDF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(n);
        } else if (n == 4 && SYMBOL_char_encoding_table == null) {
            SYMBOL_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(4, "symbol.cfg");
        } else if (n == 5 && ZAPF_char_encoding_table == null) {
            ZAPF_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(5, "zapf.cfg");
        } else if (n == 3 && MACEXPERT_char_encoding_table == null) {
            MACEXPERT_char_encoding_table = new String[335];
            StandardFonts.readStandardMappingTable(3, "mac_expert.cfg");
        }
    }

    static final synchronized void loadStandardFont(int n) throws IOException {
        block11: {
            String string;
            String string2 = "";
            float f = 200.0f;
            if (standardFontLoaded.get(n) != null) {
                return;
            }
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/defaults/" + files_names[n] + ".afm"), enc));
            boolean bl = false;
            while ((string = bufferedReader.readLine()) != null) {
                Object object;
                if (string.startsWith("EndCharMetrics")) {
                    bl = false;
                }
                if (string.startsWith("FontBBox")) {
                    object = new float[4];
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    for (int i = 0; i < 4; ++i) {
                        object[i] = (float)Integer.parseInt(stringTokenizer.nextToken());
                    }
                    fontBounds.put(files_names[n], object);
                }
                if (bl) {
                    object = new StringTokenizer(string, " ;");
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string3 = ((StringTokenizer)object).nextToken();
                        if (string3.equals("WX")) {
                            f = Float.parseFloat(((StringTokenizer)object).nextToken()) / 1000.0f;
                            continue;
                        }
                        if (!string3.equals("N")) continue;
                        string2 = ((StringTokenizer)object).nextToken();
                    }
                    widthTableStandard.put(files_names_bis[n].toLowerCase() + string2, Float.valueOf(f));
                    widthTableStandard.put(files_names[n].toLowerCase() + string2, Float.valueOf(f));
                }
                if (!string.startsWith("StartCharMetrics")) continue;
                bl = true;
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block11;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                }
            }
        }
        standardFontLoaded.put(n, "x");
    }

    protected static void loadStandardFontWidth(String string) {
        block3: {
            Integer n = (Integer)standardFileList.get(string);
            if (n != null && standardFontLoaded.get(n) == null) {
                try {
                    StandardFonts.loadStandardFont(n);
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block3;
                    LogWriter.writeLog("[PDF] " + exception + " problem reading lookup table for pdf font " + string + ' ' + string);
                }
            }
        }
    }

    public static int lookupCharacterIndex(String string, int n) {
        Object v = glyphToChar[n].get(string);
        if (v == null) {
            return 0;
        }
        return (Integer)v;
    }

    private static void loadAdobeMap() {
        block10: {
            BufferedReader bufferedReader = null;
            if (adobeMap == null) {
                try {
                    String string;
                    adobeMap = new HashMap();
                    bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/glyphlist.cfg"), enc));
                    if (bufferedReader == null && LogWriter.isOutput()) {
                        LogWriter.writeLog("Unable to open glyphlist.cfg from jar");
                    }
                    while ((string = bufferedReader.readLine()) != null) {
                        if (string.startsWith("#") || string.indexOf(59) == -1) continue;
                        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
                        String string2 = stringTokenizer.nextToken();
                        String string3 = stringTokenizer.nextToken();
                        int n = string3.indexOf(32);
                        if (n != -1) {
                            string3 = string3.substring(0, n);
                        }
                        int n2 = Integer.parseInt(string3, 16);
                        adobeMap.put(string2, n2);
                        unicode_name_mapping_table.put(string2, Character.toString((char)n2));
                    }
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                    }
                    exception.printStackTrace(System.out);
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception " + exception + " reading lookup table for pdf  for abobe map");
                }
            }
        }
    }

    public static int getAdobeMap(String string) {
        Object v = adobeMap.get(string);
        if (v == null) {
            return -1;
        }
        return (Integer)v;
    }

    public static boolean isValidGlyphName(String string) {
        if (string == null) {
            return false;
        }
        return adobeMap.get(string) != null;
    }

    public static boolean isStandardFont(String string, boolean bl) {
        int n;
        boolean bl2;
        boolean bl3 = bl2 = standardFileList.get(string) != null;
        if (!bl2 && bl && (n = string.indexOf(45)) != -1) {
            String string2 = string.substring(0, n);
            bl2 = standardFileList.get(string2) != null;
        }
        return bl2;
    }

    public static Map getFontDetails(int n, String string) {
        HashMap hashMap = new HashMap();
        if (n == 1217103210 || n == 7) {
            TTGlyphs.addStringValues(new FontData(string), hashMap);
        }
        return hashMap;
    }

    public static String[] readNamesFromFont(int n, String string, int n2) throws Exception {
        String[] stringArray = new String[]{""};
        if (n == 1217103210 || n == 7) {
            stringArray = TTGlyphs.readFontNames(new FontData(string), n2);
        } else if (n == 1228944677) {
            stringArray = T1Glyphs.readFontNames(new FontData(string));
        }
        return stringArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String convertNumberToGlyph(String string, boolean bl, boolean bl2) {
        int n;
        int n2 = string.length();
        boolean bl3 = true;
        boolean bl4 = false;
        if (n2 == 2 || n2 == 3 || bl2 && n2 == 1) {
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                if (c >= '0' && c <= '9') continue;
                if (bl && c >= 'A' && c <= 'F') {
                    bl4 = true;
                    continue;
                }
                bl3 = false;
                i = n2;
            }
            if (!bl3) return string;
            if (n2 != 3) {
                if (bl) return String.valueOf((char)Integer.parseInt(string, 16));
            }
            if (bl4) return string;
            return String.valueOf((char)Integer.parseInt(string));
        }
        boolean bl5 = false;
        boolean bl6 = false;
        for (int i = 0; i < n2; ++i) {
            n = string.charAt(i);
            if (n == 35) {
                bl5 = true;
            }
            if (n < 65 || n > 90) continue;
            bl6 = true;
        }
        if (!bl5) return string;
        StringBuilder stringBuilder = new StringBuilder(string);
        if (bl6) {
            try {
                n = 0;
                while (n < n2) {
                    char c = stringBuilder.charAt(n);
                    if (c == '#' && n < n2) {
                        for (int i = 0; i < 2; ++i) {
                            stringBuilder.deleteCharAt(n + 1);
                            --n2;
                        }
                    }
                    ++n;
                }
                return stringBuilder.toString();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) return stringBuilder.toString();
                LogWriter.writeLog("Exception: " + exception.getMessage());
                return stringBuilder.toString();
            }
        } else {
            n = 0;
            while (n < n2) {
                char c = stringBuilder.charAt(n);
                if (c == '#') {
                    if ((n += 3) < n2) {
                        char c2 = stringBuilder.charAt(n);
                        while (c2 >= '0' && c2 <= '9') {
                            stringBuilder.deleteCharAt(n);
                            if (n >= --n2) break;
                            c2 = stringBuilder.charAt(n);
                        }
                    }
                    --n;
                }
                ++n;
            }
            return stringBuilder.toString();
        }
    }

    public static String getFontypeAsString(int n) {
        switch (n) {
            case 1217103210: {
                return "TrueType";
            }
            case 1228944677: {
                return "Type1";
            }
            case 1228944679: {
                return "Type3";
            }
            case -1684566726: {
                return "CIDFontType0";
            }
            case -1684566724: {
                return "CIDFontType2";
            }
        }
        return "Unknown";
    }

    private static void blockForbiddenRanges(ArrayList<Integer> arrayList) {
        int n;
        for (n = 0; n <= 31; ++n) {
            arrayList.add(n);
        }
        for (n = 127; n <= 160; ++n) {
            arrayList.add(n);
        }
        for (n = 8204; n <= 8207; ++n) {
            arrayList.add(n);
        }
    }

    public static int mapCIDToValidUnicode(String string, int n) {
        Integer n2;
        HashMap<Integer, Integer> hashMap = mappedCharacters.get(string);
        ArrayList<Integer> arrayList = takenChars.get(string);
        if (hashMap == null) {
            hashMap = new HashMap();
            mappedCharacters.put(string, hashMap);
            arrayList = new ArrayList();
            takenChars.put(string, arrayList);
            StandardFonts.blockForbiddenRanges(arrayList);
        }
        if ((n2 = hashMap.get(n)) != null) {
            return n2;
        }
        int n3 = n;
        if (n < 32) {
            n3 += 32;
        }
        while (arrayList.contains(n3) && arrayList.size() < 55296) {
            n3 = (n3 + 1) % 55296;
        }
        hashMap.put(n, n3);
        arrayList.add(n3);
        return n3;
    }

    public static int getIDForGlyphName(String string, String string2) {
        boolean bl = false;
        int n = StandardFonts.getAdobeMap(string2);
        if (n >= 0) {
            return n;
        }
        if (string2.startsWith("uni")) {
            string2 = string2.substring(3);
        } else if (string2.charAt(0) == 'u' || string2.charAt(0) == 'G') {
            string2 = string2.substring(1);
        } else {
            bl = true;
        }
        try {
            int n2;
            if (bl) {
                n2 = Integer.parseInt(string2, 10);
                n2 = StandardFonts.mapCIDToValidUnicode(string, n2);
            } else {
                n2 = Integer.parseInt(string2, 16);
            }
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception in handling cid id " + numberFormatException);
            }
            return -1;
        }
    }

    public static String expandName(String string) {
        String string2 = string.toLowerCase();
        if (string2.equals("cour")) {
            string = "Courier";
        } else if (string2.equals("helv")) {
            string = "Helvetica";
        } else if (string2.equals("hebo")) {
            string = "Helvetica-BOLD";
        } else if (string2.equals("zadb")) {
            string = "ZapfDingbats";
        } else if (string2.equals("tiro")) {
            string = "Times";
        }
        return string;
    }

    public static void readCMAP() {
        block3: {
            CMAP = new String[65536];
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(loader.getResourceAsStream("org/jpedal/res/pdf/jis.cfg")));
                while ((string = bufferedReader.readLine()) != null) {
                    if (!string.startsWith("0") || !string.contains("#")) continue;
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    String string2 = stringTokenizer.nextToken().substring(2);
                    int n = Integer.parseInt(string2, 16);
                    int n2 = Integer.parseInt(stringTokenizer.nextToken().substring(2), 16);
                    StandardFonts.CMAP[n] = String.valueOf((char)n2);
                }
                bufferedReader.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
    }

    static {
        unicodeToName = new HashMap<String, String>();
        loader = StandardFonts.class.getClassLoader();
        standardFileList = new HashMap();
        standardFontLoaded = new HashMap();
        widthTableStandard = new Hashtable();
        javaFontList = new HashMap();
        javaFonts = new String[]{"Courier", "Courier-Bold", "Courier", "Courier-Bold", "Arial", "Arial-Bold", "Arial", "Arial-Italic", "Symbol", "Times New Roman", "Times New Roman", "Times New Roman", "Times New Roman", "Wingdings"};
        files_names = new String[]{"Courier", "Courier-Bold", "Courier-BoldOblique", "Courier-Oblique", "Helvetica", "Helvetica-Bold", "Helvetica-BoldOblique", "Helvetica-Oblique", "Symbol", "Times-Bold", "Times-BoldItalic", "Times-Italic", "Times-Roman", "ZapfDingbats"};
        files_names_bis = new String[]{"CourierNew", "CourierNew,Bold", "CourierNew,BoldItalic", "CourierNew,Italic", "Arial", "Arial,Bold", "Arial,BoldItalic", "Arial,Italic", "Symbol", "TimesNewRoman,Bold", "TimesNewRoman,BoldItalic", "TimesNewRoman,Italic", "TimesNewRoman", "ZapfDingbats"};
        fontBounds = new Hashtable();
        for (int i = 0; i < files_names.length; ++i) {
            standardFileList.put(files_names_bis[i], i);
            standardFileList.put(files_names[i], i);
        }
        StandardFonts.loadAdobeMap();
        mappedCharacters = new HashMap();
        takenChars = new HashMap();
    }
}

