/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class Type1
extends PdfFont {
    protected boolean isCID;
    private static final int c1 = 52845;
    private static final int c2 = 22719;
    private int skipBytes = 4;
    protected int[] blueValues;
    protected int[] otherBlues;
    protected int[] familyBlues;
    protected int[] familyOtherBlues;
    protected Double blueScale;
    protected Integer blueShift;
    protected Integer blueFuzz;
    protected Double stdHW;
    protected Double stdVW;
    protected int[] stemSnapH;
    protected int[] stemSnapV;
    protected Boolean forceBold;
    protected Integer languageGroup;
    public static final String[] T1CcharCodes1Byte = new String[]{"-Reserved-", "hstem", "-Reserved-", "vstem", "vmoveto", "rlineto", "hlineto", "vlineto", "rrcurveto", "closePathT1", "callsubr", "return", "escape", "hsbwT1", "endchar", "-Reserved-", "blend", "-Reserved-", "hstemhm", "hintmask", "cntrmask", "rmoveto", "hmoveto", "vstemhm", "rcurveline", "rlinecurve", "vvcurveto", "hhcurveto", "intint", "callgsubr", "vhcurveto", "hvcurveto"};
    public static final String[] T1C = new String[]{"dotSection", "vstem3", "hstem3", "and", "or", "not", "seacT1", "swbT1", "store", "abs", "add", "sub", "div", "load", "neg", "eq", "callothersubT1", "pop", "drop", "-Reserved-", "put", "get", "ifelse", "random", "mul", "-Reserved-", "sqrt", "dup", "exch", "index", "roll", "-Reserved-", "-Reserved-", "setcurrentpointT1", "hflex", "flex", "hflex1", "flex1"};
    boolean trackIndices;
    public static final char[] DEF_CHARS = "def".toCharArray();

    protected final void readType1FontFile(byte[] byArray) throws Exception {
        block13: {
            String string;
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Embedded Type1 font used " + this.getBaseFontName());
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
            while ((string = bufferedReader.readLine()) != null) {
                int n;
                if (string.startsWith("/Encoding 256 array")) {
                    this.readDiffEncoding(bufferedReader);
                    continue;
                }
                if (string.startsWith("/lenIV")) {
                    StringTokenizer stringTokenizer = new StringTokenizer(string);
                    stringTokenizer.nextToken();
                    this.skipBytes = Integer.parseInt(stringTokenizer.nextToken());
                    continue;
                }
                if (!string.contains("/FontMatrix")) continue;
                String string2 = "";
                int n2 = string.indexOf(91);
                if (n2 != -1) {
                    n = string.indexOf(93);
                    string2 = string.substring(n2 + 1, n);
                } else {
                    n2 = string.indexOf(123);
                    if (n2 != -1) {
                        n = string.indexOf(125);
                        string2 = string.substring(n2 + 1, n);
                    }
                }
                StringTokenizer stringTokenizer = new StringTokenizer(string2);
                for (int i = 0; i < 6; ++i) {
                    this.FontMatrix[i] = Double.parseDouble(stringTokenizer.nextToken());
                }
            }
            if (bufferedReader != null) {
                try {
                    bufferedReader.close();
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block13;
                    LogWriter.writeLog("Exception " + exception + " closing stream");
                }
            }
        }
        int n = 0;
        if (this.renderPage) {
            n = this.readEncodedContent(byArray);
        }
        this.glyphs.setGlyphCount(n);
        if (!this.renderPage || n > 0) {
            this.isFontEmbedded = true;
        }
        this.glyphs.setFontEmbedded(true);
    }

    private void readDiffEncoding(BufferedReader bufferedReader) throws Exception {
        String string;
        while ((string = bufferedReader.readLine()) != null && !(string = string.trim()).startsWith("readonly")) {
            int n;
            StringTokenizer stringTokenizer;
            if (!string.startsWith("dup") || !string.contains("/") || (stringTokenizer = new StringTokenizer(string, " /")).countTokens() < 3) continue;
            stringTokenizer.nextToken();
            String string2 = stringTokenizer.nextToken();
            int n2 = string2.indexOf(35);
            if (n2 == -1) {
                n = Integer.parseInt(string2);
            } else {
                String string3 = string2.substring(0, n2);
                String string4 = string2.substring(n2 + 1, string2.length());
                n = Integer.parseInt(string4, Integer.parseInt(string3));
            }
            String string5 = stringTokenizer.nextToken();
            this.putChar(n, string5);
            char c = string5.charAt(0);
            if (c != 'B' && c != 'C' && c != 'c' && c != 'G') continue;
            int n3 = 1;
            int n4 = string5.length();
            while (!this.isHex && n3 < n4) {
                this.isHex = Character.isLetter(string5.charAt(n3++));
            }
        }
    }

    protected final void putChar(int n, String string) {
        if (this.diffs == null) {
            this.diffs = new String[this.maxCharCount];
        }
        this.diffs[n] = string;
        if (!this.hasEncoding && !this.isCID) {
            if (StandardFonts.getUnicodeName(string) != null) {
                this.putMappedChar(n, string);
            } else if (!this.isHex) {
                this.nonStandardMappings.put(string, n);
            }
        }
    }

    private int readEncodedContent(byte[] byArray) throws Exception {
        int n;
        int n2;
        block64: {
            String string;
            int n3;
            n2 = 0;
            int n4 = byArray.length;
            int n5 = -1;
            int n6 = -1;
            for (n3 = 4; n3 < n4; ++n3) {
                if (byArray[n3 - 3] != 101 || byArray[n3 - 2] != 120 || byArray[n3 - 1] != 101 || byArray[n3] != 99) continue;
                n5 = n3 + 1;
                while (byArray[n5] == 10 || byArray[n5] == 13) {
                    ++n5;
                }
                n3 = n4;
            }
            if (n5 != -1) {
                for (n3 = n5; n3 < n4 - 10; ++n3) {
                    if (byArray[n3] != 99 || byArray[n3 + 1] != 108 || byArray[n3 + 2] != 101 || byArray[n3 + 3] != 97 || byArray[n3 + 4] != 114 || byArray[n3 + 5] != 116 || byArray[n3 + 6] != 111 || byArray[n3 + 7] != 109 || byArray[n3 + 8] != 97 || byArray[n3 + 9] != 114 || byArray[n3 + 10] != 107) continue;
                    n6 = n3 - 1;
                    while (byArray[n6] == 10 || byArray[n6] == 13) {
                        --n6;
                    }
                    n3 = n4;
                }
            }
            if (n6 == -1) {
                n6 = n4;
            }
            int n7 = 55665;
            boolean bl = true;
            for (n3 = n5; n3 < n5 + 8; ++n3) {
                char c = (char)byArray[n3];
                if (c >= '0' && c <= '9' || c >= 'A' && c <= 'F' || c >= 'a' && c <= 'f') continue;
                bl = false;
                break;
            }
            if (n5 != -1) {
                FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream(n6 - n5);
                if (this.isFontSubstituted && !bl) {
                    n5 = n5 + 2 + this.skipBytes;
                }
                for (n3 = n5; n3 < n6; ++n3) {
                    int n8;
                    if (!bl) {
                        n8 = byArray[n3] & 0xFF;
                    } else {
                        int n9 = 0;
                        StringBuilder stringBuilder = new StringBuilder();
                        while (n9 < 2) {
                            n8 = byArray[n3] & 0xFF;
                            ++n3;
                            if (n8 == 10 || n8 == 13 || n8 == 9 || n8 == 32) continue;
                            stringBuilder.append((char)n8);
                            ++n9;
                        }
                        --n3;
                        n8 = Integer.parseInt(stringBuilder.toString(), 16);
                    }
                    int n10 = n8 ^ n7 >> 8;
                    n7 = (n8 + n7) * 52845 + 22719 & 0xFFFF;
                    if (n3 <= n5 + 4) continue;
                    fastByteArrayOutputStream.write(n10);
                }
                byArray = fastByteArrayOutputStream.toByteArray();
            }
            BufferedReader bufferedReader = new BufferedReader(new StringReader(new String(byArray)));
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("/lenIV")) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string);
                stringTokenizer.nextToken();
                this.skipBytes = Integer.parseInt(stringTokenizer.nextToken());
            }
            bufferedReader.close();
            int n11 = byArray.length;
            n5 = -1;
            int n12 = -1;
            int n13 = -1;
            int n14 = -1;
            int n15 = -1;
            int n16 = -1;
            int n17 = -1;
            int n18 = -1;
            int n19 = -1;
            int n20 = -1;
            int n21 = -1;
            int n22 = -1;
            int n23 = -1;
            int n24 = -1;
            n = -1;
            char[] cArray = "/CharStrings".toCharArray();
            char[] cArray2 = "/Subrs".toCharArray();
            char[] cArray3 = "/BlueValues".toCharArray();
            char[] cArray4 = "/OtherBlues".toCharArray();
            char[] cArray5 = "/FamilyBlues".toCharArray();
            char[] cArray6 = "/FamilyOtherBlues".toCharArray();
            char[] cArray7 = "/BlueScale".toCharArray();
            char[] cArray8 = "/BlueShift".toCharArray();
            char[] cArray9 = "/BlueFuzz".toCharArray();
            char[] cArray10 = "/StdHW".toCharArray();
            char[] cArray11 = "/StdVW".toCharArray();
            char[] cArray12 = "/StemSnapH".toCharArray();
            char[] cArray13 = "/StemSnapV".toCharArray();
            char[] cArray14 = "/ForceBold".toCharArray();
            char[] cArray15 = "/LanguageGroup".toCharArray();
            for (int i = 0; i < n11 && i != n11; ++i) {
                if (n5 == -1 && i + 11 < n11 && Type1.checkForString(byArray, i, cArray)) {
                    n5 = i + 11;
                } else if (n12 == -1 && i + 5 < n11 && Type1.checkForString(byArray, i, cArray2)) {
                    n12 = i + 6;
                } else if (n13 == -1 && i + 11 < n11 && Type1.checkForString(byArray, i, cArray3)) {
                    n13 = i + 11;
                } else if (n14 == -1 && i + 11 < n11 && Type1.checkForString(byArray, i, cArray4)) {
                    n14 = i + 11;
                } else if (n15 == -1 && i + 12 < n11 && Type1.checkForString(byArray, i, cArray5)) {
                    n15 = i + 12;
                } else if (n16 == -1 && i + 17 < n11 && Type1.checkForString(byArray, i, cArray6)) {
                    n16 = i + 17;
                } else if (n17 == -1 && i + 10 < n11 && Type1.checkForString(byArray, i, cArray7)) {
                    n17 = i + 10;
                } else if (n18 == -1 && i + 10 < n11 && Type1.checkForString(byArray, i, cArray8)) {
                    n18 = i + 10;
                } else if (n19 == -1 && i + 9 < n11 && Type1.checkForString(byArray, i, cArray9)) {
                    n19 = i + 9;
                } else if (n20 == -1 && i + 6 < n11 && Type1.checkForString(byArray, i, cArray10)) {
                    n20 = i + 6;
                } else if (n21 == -1 && i + 6 < n11 && Type1.checkForString(byArray, i, cArray11)) {
                    n21 = i + 6;
                } else if (n22 == -1 && i + 10 < n11 && Type1.checkForString(byArray, i, cArray12)) {
                    n22 = i + 10;
                } else if (n23 == -1 && i + 10 < n11 && Type1.checkForString(byArray, i, cArray13)) {
                    n23 = i + 10;
                } else if (n24 == -1 && i + 10 < n11 && Type1.checkForString(byArray, i, cArray14)) {
                    n24 = i + 10;
                } else if (n == -1 && i + 14 < n11 && Type1.checkForString(byArray, i, cArray15)) {
                    n = i + 14;
                }
                if (n12 > -1 && n5 > -1 && n13 > -1 && n14 > -1 && n15 > -1 && n16 > -1 && n17 > -1 && n18 > -1 && n19 > -1 && n20 > -1 && n21 > -1 && n22 > -1 && n23 > -1 && n24 > -1 && n > -1) break;
            }
            if (n5 == -1) {
                this.isFontSubstituted = false;
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("No glyph data found");
                }
            } else {
                n2 = this.extractFontData(this.skipBytes, byArray, n5, "rd", n11, "nd");
            }
            if (n12 > -1) {
                this.extractSubroutineData(this.skipBytes, byArray, n12, n5, "rd", n11, "nd");
            }
            if (n13 > -1) {
                this.blueValues = Type1.readIntArray(byArray, n13);
            }
            if (n14 > -1) {
                this.otherBlues = Type1.readIntArray(byArray, n14);
            }
            if (n15 > -1) {
                this.familyBlues = Type1.readIntArray(byArray, n15);
            }
            if (n16 > -1) {
                this.familyOtherBlues = Type1.readIntArray(byArray, n16);
            }
            if (n20 > -1) {
                this.stdHW = Type1.readReal(byArray, n20);
            }
            if (n21 > -1) {
                this.stdVW = Type1.readReal(byArray, n21);
            }
            if (n22 > -1) {
                this.stemSnapH = Type1.readIntArray(byArray, n22);
            }
            if (n23 > -1) {
                this.stemSnapV = Type1.readIntArray(byArray, n23);
            }
            if (n17 > -1) {
                this.blueScale = Type1.readReal(byArray, n17);
            }
            if (n18 > -1) {
                this.blueShift = Type1.readInteger(byArray, n18);
            }
            if (n19 > -1) {
                this.blueFuzz = Type1.readInteger(byArray, n19);
            }
            if (n24 > -1) {
                int n25 = -1;
                for (int i = n24; i < n11 && n25 == -1; ++i) {
                    if (!Type1.checkForString(byArray, i, DEF_CHARS)) continue;
                    n25 = i;
                }
                String string2 = new String(byArray, n24, n25 - n24);
                try {
                    this.forceBold = Boolean.parseBoolean(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    if (!LogWriter.isOutput()) break block64;
                    LogWriter.writeLog("Caught an Exception " + numberFormatException);
                }
            }
        }
        if (n > -1) {
            this.languageGroup = Type1.readInteger(byArray, n);
        }
        return n2;
    }

    static Integer readInteger(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = -1;
        for (int i = n; i < n2 && n3 == -1; ++i) {
            if (!Type1.checkForString(byArray, i, DEF_CHARS)) continue;
            n3 = i;
        }
        String string = new String(byArray, n, n3 - n);
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception in handling Integer in Type1 " + numberFormatException);
            }
            return null;
        }
    }

    static Double readReal(byte[] byArray, int n) {
        int n2 = byArray.length;
        int n3 = -1;
        for (int i = n; i < n2 && n3 == -1; ++i) {
            if (!Type1.checkForString(byArray, i, DEF_CHARS) && byArray[i] != 93 && byArray[i] != 10) continue;
            n3 = i;
        }
        String string = new String(byArray, n, n3 - n);
        if (string.contains("[")) {
            String[] stringArray = string.split("\\[");
            if (stringArray.length < 2) {
                return null;
            }
            string = stringArray[1];
        }
        try {
            return Double.parseDouble(string);
        }
        catch (NumberFormatException numberFormatException) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception in handling real in Type1 " + numberFormatException);
            }
            return null;
        }
    }

    private static int[] readIntArray(byte[] byArray, int n) {
        int n2;
        int[] nArray = null;
        int n3 = byArray.length;
        int n4 = -1;
        for (n2 = n; n2 < n3 && n4 == -1; ++n2) {
            if (byArray[n2] != 93 && byArray[n2] != 47 && byArray[n2] != 10) continue;
            n4 = n2;
        }
        if (n4 != -1) {
            String[] stringArray;
            String string = new String(byArray, n, n4 - n);
            if (string.contains("[")) {
                stringArray = string.split("\\[");
                if (stringArray.length < 2) {
                    return null;
                }
                string = stringArray[1];
            }
            string = string.trim();
            stringArray = string.split(" ");
            nArray = new int[stringArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                try {
                    nArray[n2] = Integer.parseInt(stringArray[n2].split("\\.")[0]);
                    continue;
                }
                catch (NumberFormatException numberFormatException) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception in handling IntArray " + numberFormatException);
                    }
                    nArray[n2] = -1;
                }
            }
        }
        return nArray;
    }

    private static boolean checkForString(byte[] byArray, int n, char[] cArray) {
        for (int i = 0; i < cArray.length; ++i) {
            if (byArray[n + i] == cArray[i]) continue;
            return false;
        }
        return true;
    }

    private void extractSubroutineData(int n, byte[] byArray, int n2, int n3, String string, int n4, String string2) {
        int n5;
        while (byArray[n2] == 32 || byArray[n2] == 10 || byArray[n2] == 13) {
            ++n2;
        }
        StringBuilder stringBuilder = new StringBuilder();
        while ((n5 = (int)byArray[n2]) != 32) {
            stringBuilder.append((char)n5);
            ++n2;
        }
        int n6 = Integer.parseInt(stringBuilder.toString());
        for (n5 = 0; n5 < n6; ++n5) {
            int n7;
            while (n2 < n4 && !((byArray[n2 - 2] == 100 && byArray[n2 - 1] == 117 && byArray[n2] == 112) | n2 == n3)) {
                ++n2;
            }
            if (n2 == n3) {
                n5 = n6;
                continue;
            }
            while (byArray[n2 + 1] == 32) {
                ++n2;
            }
            StringBuilder stringBuilder2 = new StringBuilder("subrs");
            while ((n7 = (int)byArray[++n2]) != 32) {
                stringBuilder2.append((char)n7);
            }
            stringBuilder = new StringBuilder();
            while ((n7 = (char)byArray[++n2]) != 32) {
                stringBuilder.append((char)n7);
            }
            n7 = Integer.parseInt(stringBuilder.toString());
            while (byArray[n2] == 32) {
                ++n2;
            }
            n2 = n2 + string.length() + 1;
            byte[] byArray2 = Type1.getStream(n, n2, n7, byArray);
            this.glyphs.setCharString(stringBuilder2.toString(), byArray2, n5);
            n2 = n2 + n7 + string2.length();
        }
    }

    private int extractFontData(int n, byte[] byArray, int n2, String string, int n3, String string2) {
        int n4 = byArray.length;
        int n5 = 0;
        while (n2 < n4 && byArray[n2] != 47) {
            ++n2;
        }
        int n6 = n2;
        while (n2 < n3) {
            if (byArray[n6] == 47) {
                n6 += 2;
                while (n6 < n4 && (byArray[n6 - 1] != 124 || byArray[n6] != 45 && byArray[n6] != 48 || byArray[n6 + 1] != 10 && byArray[n6 + 1] != 13) && (byArray[n6 - 1] != 78 || byArray[n6] != 68)) {
                    ++n6;
                }
            }
            if (n4 - n6 < 3 || byArray[n6 - 1] != 47 && byArray[n6] == 101 && byArray[n6 + 1] == 110 && byArray[n6 + 2] == 100) break;
            ++n6;
        }
        while (n2 <= n6) {
            int n7;
            char c;
            StringBuilder stringBuilder = new StringBuilder(20);
            while ((c = (char)byArray[++n2]) != ' ') {
                stringBuilder.append(c);
            }
            if (this.trackIndices) {
                this.glyphs.setIndexForCharString(n5, stringBuilder.toString());
            }
            ++n2;
            StringBuilder stringBuilder2 = new StringBuilder();
            while ((n7 = (int)byArray[n2]) != 32) {
                stringBuilder2.append((char)n7);
                ++n2;
            }
            n7 = Integer.parseInt(stringBuilder2.toString());
            while (byArray[n2] == 32) {
                ++n2;
            }
            n2 = n2 + string.length() + 1;
            byte[] byArray2 = Type1.getStream(n, n2, n7, byArray);
            this.glyphs.setCharString(stringBuilder.toString(), byArray2, n5);
            ++n5;
            for (n2 = n2 + n7 + string2.length(); n2 <= n6 && byArray[n2] != 47; ++n2) {
            }
        }
        return n5;
    }

    private static byte[] getStream(int n, int n2, int n3, byte[] byArray) {
        FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
        int n4 = 4330;
        for (int i = 0; i < n3; ++i) {
            int n5 = byArray[n2 + i] & 0xFF;
            int n6 = n5 ^ n4 >> 8;
            n4 = (n5 + n4) * 52845 + 22719 & 0xFFFF;
            if (i < n) continue;
            fastByteArrayOutputStream.write(n6);
        }
        return fastByteArrayOutputStream.toByteArray();
    }
}

