/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.awt.Rectangle;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.Type1;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.glyph.T1Glyphs;
import org.jpedal.fonts.glyph.objects.T1GlyphNumber;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.FastByteArrayOutputStream;

public class Type1C
extends Type1 {
    static final boolean debugFont = false;
    static final boolean debugDictionary = false;
    int ros = -1;
    int CIDFontVersion;
    int CIDFontRevision;
    int CIDFontType;
    int CIDcount;
    int UIDBase = -1;
    int FDArray = -1;
    int FDSelect = -1;
    private int top;
    private int charset;
    private int enc;
    private int charstrings;
    private int stringIdx;
    private int stringStart;
    private int stringOffSize;
    private Rectangle BBox;
    private boolean hasFontMatrix;
    private int[] privateDictOffset = new int[]{-1};
    private int[] privateDictLength = new int[]{-1};
    private int currentFD = -1;
    private int[] defaultWidthX = new int[]{0};
    private int[] nominalWidthX = new int[]{0};
    private int[] fdSelect;
    private static final int[] ExpertSubCharset = new int[]{0, 1, 231, 232, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 272, 300, 301, 302, 305, 314, 315, 158, 155, 163, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346};
    public static final String[] type1CStdStrings = new String[]{".notdef", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "exclamdown", "cent", "sterling", "fraction", "yen", "florin", "section", "currency", "quotesingle", "quotedblleft", "guillemotleft", "guilsinglleft", "guilsinglright", "fi", "fl", "endash", "dagger", "daggerdbl", "periodcentered", "paragraph", "bullet", "quotesinglbase", "quotedblbase", "quotedblright", "guillemotright", "ellipsis", "perthousand", "questiondown", "grave", "acute", "circumflex", "tilde", "macron", "breve", "dotaccent", "dieresis", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "emdash", "AE", "ordfeminine", "Lslash", "Oslash", "OE", "ordmasculine", "ae", "dotlessi", "lslash", "oslash", "oe", "germandbls", "onesuperior", "logicalnot", "mu", "trademark", "Eth", "onehalf", "plusminus", "Thorn", "onequarter", "divide", "brokenbar", "degree", "thorn", "threequarters", "twosuperior", "registered", "minus", "eth", "multiply", "threesuperior", "copyright", "Aacute", "Acircumflex", "Adieresis", "Agrave", "Aring", "Atilde", "Ccedilla", "Eacute", "Ecircumflex", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Ntilde", "Oacute", "Ocircumflex", "Odieresis", "Ograve", "Otilde", "Scaron", "Uacute", "Ucircumflex", "Udieresis", "Ugrave", "Yacute", "Ydieresis", "Zcaron", "aacute", "acircumflex", "adieresis", "agrave", "aring", "atilde", "ccedilla", "eacute", "ecircumflex", "edieresis", "egrave", "iacute", "icircumflex", "idieresis", "igrave", "ntilde", "oacute", "ocircumflex", "odieresis", "ograve", "otilde", "scaron", "uacute", "ucircumflex", "udieresis", "ugrave", "yacute", "ydieresis", "zcaron", "exclamsmall", "Hungarumlautsmall", "dollaroldstyle", "dollarsuperior", "ampersandsmall", "Acutesmall", "parenleftsuperior", "parenrightsuperior", "twodotenleader", "onedotenleader", "zerooldstyle", "oneoldstyle", "twooldstyle", "threeoldstyle", "fouroldstyle", "fiveoldstyle", "sixoldstyle", "sevenoldstyle", "eightoldstyle", "nineoldstyle", "commasuperior", "threequartersemdash", "periodsuperior", "questionsmall", "asuperior", "bsuperior", "centsuperior", "dsuperior", "esuperior", "isuperior", "lsuperior", "msuperior", "nsuperior", "osuperior", "rsuperior", "ssuperior", "tsuperior", "ff", "ffi", "ffl", "parenleftinferior", "parenrightinferior", "Circumflexsmall", "hyphensuperior", "Gravesmall", "Asmall", "Bsmall", "Csmall", "Dsmall", "Esmall", "Fsmall", "Gsmall", "Hsmall", "Ismall", "Jsmall", "Ksmall", "Lsmall", "Msmall", "Nsmall", "Osmall", "Psmall", "Qsmall", "Rsmall", "Ssmall", "Tsmall", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Ysmall", "Zsmall", "colonmonetary", "onefitted", "rupiah", "Tildesmall", "exclamdownsmall", "centoldstyle", "Lslashsmall", "Scaronsmall", "Zcaronsmall", "Dieresissmall", "Brevesmall", "Caronsmall", "Dotaccentsmall", "Macronsmall", "figuredash", "hypheninferior", "Ogoneksmall", "Ringsmall", "Cedillasmall", "questiondownsmall", "oneeighth", "threeeighths", "fiveeighths", "seveneighths", "onethird", "twothirds", "zerosuperior", "foursuperior", "fivesuperior", "sixsuperior", "sevensuperior", "eightsuperior", "ninesuperior", "zeroinferior", "oneinferior", "twoinferior", "threeinferior", "fourinferior", "fiveinferior", "sixinferior", "seveninferior", "eightinferior", "nineinferior", "centinferior", "dollarinferior", "periodinferior", "commainferior", "Agravesmall", "Aacutesmall", "Acircumflexsmall", "Atildesmall", "Adieresissmall", "Aringsmall", "AEsmall", "Ccedillasmall", "Egravesmall", "Eacutesmall", "Ecircumflexsmall", "Edieresissmall", "Igravesmall", "Iacutesmall", "Icircumflexsmall", "Idieresissmall", "Ethsmall", "Ntildesmall", "Ogravesmall", "Oacutesmall", "Ocircumflexsmall", "Otildesmall", "Odieresissmall", "OEsmall", "Oslashsmall", "Ugravesmall", "Uacutesmall", "Ucircumflexsmall", "Udieresissmall", "Yacutesmall", "Thornsmall", "Ydieresissmall", "001.000", "001.001", "001.002", "001.003", "Black", "Bold", "Book", "Light", "Medium", "Regular", "Roman", "Semibold"};
    private static final int[] ISOAdobeCharset = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 62, 63, 64, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 91, 92, 93, 94, 95, 96, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 123, 124, 125, 126, 127, 128, 129, 130, 131, 132, 133, 134, 135, 136, 137, 138, 139, 140, 141, 142, 143, 144, 145, 146, 147, 148, 149, 150, 151, 152, 153, 154, 155, 156, 157, 158, 159, 160, 161, 162, 163, 164, 165, 166, 167, 168, 169, 170, 171, 172, 173, 174, 175, 176, 177, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194, 195, 196, 197, 198, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 215, 216, 217, 218, 219, 220, 221, 222, 223, 224, 225, 226, 227, 228};
    private static final int[] ExpertCharset = new int[]{0, 1, 229, 230, 231, 232, 233, 234, 235, 236, 237, 238, 13, 14, 15, 99, 239, 240, 241, 242, 243, 244, 245, 246, 247, 248, 27, 28, 249, 250, 251, 252, 253, 254, 255, 256, 257, 258, 259, 260, 261, 262, 263, 264, 265, 266, 109, 110, 267, 268, 269, 270, 271, 272, 273, 274, 275, 276, 277, 278, 279, 280, 281, 282, 283, 284, 285, 286, 287, 288, 289, 290, 291, 292, 293, 294, 295, 296, 297, 298, 299, 300, 301, 302, 303, 304, 305, 306, 307, 308, 309, 310, 311, 312, 313, 314, 315, 316, 317, 318, 158, 155, 163, 319, 320, 321, 322, 323, 324, 325, 326, 150, 164, 169, 327, 328, 329, 330, 331, 332, 333, 334, 335, 336, 337, 338, 339, 340, 341, 342, 343, 344, 345, 346, 347, 348, 349, 350, 351, 352, 353, 354, 355, 356, 357, 358, 359, 360, 361, 362, 363, 364, 365, 366, 367, 368, 369, 370, 371, 372, 373, 374, 375, 376, 377, 378};
    public static final int VERSION = 0;
    public static final int NOTICE = 1;
    public static final int FULLNAME = 2;
    public static final int FAMILYNAME = 3;
    public static final int WEIGHT = 4;
    public static final int FONTBBOX = 5;
    public static final int BLUEVALUES = 6;
    public static final int OTHERBLUES = 7;
    public static final int FAMILYBLUES = 8;
    public static final int FAMILYOTHERBLUES = 9;
    public static final int STDHW = 10;
    public static final int STDVW = 11;
    public static final int ESCAPE = 12;
    public static final int UNIQUEID = 13;
    public static final int XUID = 14;
    public static final int CHARSET = 15;
    public static final int ENCODING = 16;
    public static final int CHARSTRINGS = 17;
    public static final int PRIVATE = 18;
    public static final int SUBRS = 19;
    public static final int DEFAULTWIDTHX = 20;
    public static final int NOMINALWIDTHX = 21;
    public static final int RESERVED = 22;
    public static final int SHORTINT = 28;
    public static final int LONGINT = 29;
    public static final int BCD = 30;
    public static final int COPYRIGHT = 3072;
    public static final int ISFIXEDPITCH = 3073;
    public static final int ITALICANGLE = 3074;
    public static final int UNDERLINEPOSITION = 3075;
    public static final int UNDERLINETHICKNESS = 3076;
    public static final int PAINTTYPE = 3077;
    public static final int CHARSTRINGTYPE = 3078;
    public static final int FONTMATRIX = 3079;
    public static final int STROKEWIDTH = 3080;
    public static final int BLUESCALE = 3081;
    public static final int BLUESHIFT = 3082;
    public static final int BLUEFUZZ = 3083;
    public static final int STEMSNAPH = 3084;
    public static final int STEMSNAPV = 3085;
    public static final int FORCEBOLD = 3086;
    public static final int LANGUAGEGROUP = 3089;
    public static final int EXPANSIONFACTOR = 3090;
    public static final int INITIALRANDOMSEED = 3091;
    public static final int SYNTHETICBASE = 3092;
    public static final int POSTSCRIPT = 3093;
    public static final int BASEFONTNAME = 3094;
    public static final int BASEFONTBLEND = 3095;
    public static final int ROS = 3102;
    public static final int CIDFONTVERSION = 3103;
    public static final int CIDFONTREVISION = 3104;
    public static final int CIDFONTTYPE = 3105;
    public static final int CIDCOUNT = 3106;
    public static final int UIDBASE = 3107;
    public static final int FDARRAY = 3108;
    public static final int FDSELECT = 3109;
    public static final int FONTNAME = 3110;
    private static final int weight = 388;
    private int[] blueValues;
    private int[] familyBlues;
    private int[] familyOtherBlues;
    private int[] subrs = new int[]{-1};
    private int stdHW = -1;
    private int stdVW = -1;
    private final int[] rosArray = new int[3];

    public Type1C() {
    }

    public Type1C(PdfObjectReader pdfObjectReader, String string) {
        this.glyphs = new T1Glyphs(false);
        this.init(pdfObjectReader);
        this.substituteFont = string;
    }

    protected void readEmbeddedFont(PdfObject pdfObject) throws Exception {
        block22: {
            if (this.substituteFont != null) {
                byte[] byArray;
                Object object;
                InputStream inputStream;
                FastByteArrayOutputStream fastByteArrayOutputStream;
                block21: {
                    fastByteArrayOutputStream = new FastByteArrayOutputStream();
                    inputStream = null;
                    try {
                        inputStream = this.substituteFont.startsWith("jar:") || this.substituteFont.startsWith("http:") ? this.loader.getResourceAsStream(this.substituteFont) : this.loader.getResourceAsStream("file:///" + this.substituteFont);
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("3.Unable to open " + this.substituteFont + ' ' + exception);
                        }
                    }
                    catch (Error error) {
                        if (!LogWriter.isOutput()) break block21;
                        LogWriter.writeLog("3.Unable to open " + this.substituteFont + ' ' + error);
                    }
                }
                if (inputStream == null) {
                    int n;
                    int n2;
                    object = new File(this.substituteFont);
                    FileInputStream fileInputStream = new FileInputStream((File)object);
                    long l = ((File)object).length();
                    if (l > Integer.MAX_VALUE) {
                        System.out.println("Sorry! Your given file is too large.");
                        return;
                    }
                    byArray = new byte[(int)l];
                    for (n = 0; n < byArray.length && (n2 = ((InputStream)fileInputStream).read(byArray, n, byArray.length - n)) >= 0; n += n2) {
                    }
                    if (n < byArray.length) {
                        throw new IOException("Could not completely read file " + ((File)object).getName());
                    }
                    ((InputStream)fileInputStream).close();
                } else {
                    int n;
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
                    object = new byte[65535];
                    while ((n = bufferedInputStream.read((byte[])object)) != -1) {
                        fastByteArrayOutputStream.write((byte[])object, 0, n);
                    }
                    bufferedInputStream.close();
                    byArray = fastByteArrayOutputStream.toByteArray();
                }
                try {
                    this.isFontSubstituted = true;
                    this.readType1FontFile(byArray);
                }
                catch (Exception exception) {
                    exception.printStackTrace(System.out);
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("[PDF]Substitute font=" + this.substituteFont + "Type 1 exception=" + exception);
                    }
                    break block22;
                }
            }
            if (pdfObject != null) {
                byte[] byArray;
                PdfObject pdfObject2 = pdfObject.getDictionary(746093177);
                if (pdfObject2 != null) {
                    try {
                        byte[] byArray2 = this.currentPdfFile.readStream(pdfObject2, true, true, false, false, false, pdfObject2.getCacheName(this.currentPdfFile.getObjectReader()));
                        if (byArray2 != null) {
                            this.readType1FontFile(byArray2);
                        }
                        break block22;
                    }
                    catch (Exception exception) {
                        if (LogWriter.isOutput()) {
                            LogWriter.writeLog("Exception: " + exception.getMessage());
                        }
                        break block22;
                    }
                }
                PdfObject pdfObject3 = pdfObject.getDictionary(2021292335);
                if (pdfObject3 != null && (byArray = this.currentPdfFile.readStream(pdfObject3, true, true, false, false, false, pdfObject3.getCacheName(this.currentPdfFile.getObjectReader()))) != null && (byArray.length <= 3 || byArray[0] != 70 || byArray[1] != 84 || byArray[2] != 84 || byArray[3] != 79)) {
                    this.readType1CFontFile(byArray, null);
                }
            }
        }
    }

    @Override
    public void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        block3: {
            this.fontTypes = 1228944677;
            this.init(string, bl);
            PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
            this.setBoundsAndMatrix(pdfObject2);
            this.setName(pdfObject);
            this.setEncoding(pdfObject, pdfObject2);
            try {
                this.readEmbeddedFont(pdfObject2);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block3;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.readWidths(pdfObject, true);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    public Type1C(byte[] byArray, PdfJavaGlyphs pdfJavaGlyphs, boolean bl) throws Exception {
        this.glyphs = pdfJavaGlyphs;
        this.trackIndices = true;
        this.renderPage = true;
        if (bl) {
            this.readType1CFontFile(byArray, null);
        } else {
            this.readType1FontFile(byArray);
        }
    }

    public Type1C(byte[] byArray, FontData fontData, PdfJavaGlyphs pdfJavaGlyphs) throws Exception {
        this.glyphs = pdfJavaGlyphs;
        this.readType1CFontFile(byArray, fontData);
    }

    private void readType1CFontFile(byte[] byArray, FontData fontData) throws Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        int n6;
        byte by;
        int n7;
        byte by2;
        byte by3;
        boolean bl;
        if (LogWriter.isOutput()) {
            LogWriter.writeLog("Embedded Type1C font used");
        }
        this.glyphs.setis1C(true);
        boolean bl2 = bl = byArray != null;
        if (bl) {
            by3 = byArray[0];
            by2 = byArray[1];
        } else {
            by3 = fontData.getByte(0);
            by2 = fontData.getByte(1);
        }
        if ((by3 != 1 || by2 != 0) && LogWriter.isOutput()) {
            LogWriter.writeLog("1C  format " + by3 + ':' + by2 + " not fully supported");
        }
        this.top = bl ? byArray[2] : (int)fontData.getByte(2);
        if (bl) {
            n7 = Type1C.getWord(byArray, this.top, 2);
            by = byArray[this.top + 2];
        } else {
            n7 = Type1C.getWord(fontData, this.top, 2);
            by = fontData.getByte(this.top + 2);
        }
        this.top += 3;
        int n8 = this.top + (n7 + 1) * by - 1;
        this.top = bl ? n8 + Type1C.getWord(byArray, this.top + n7 * by, (int)by) : n8 + Type1C.getWord(fontData, this.top + n7 * by, (int)by);
        if (bl) {
            n7 = Type1C.getWord(byArray, this.top, 2);
            by = byArray[this.top + 2];
        } else {
            n7 = Type1C.getWord(fontData, this.top, 2);
            by = fontData.getByte(this.top + 2);
        }
        this.top += 3;
        n8 = this.top + (n7 + 1) * by - 1;
        if (bl) {
            n6 = n8 + Type1C.getWord(byArray, this.top, (int)by);
            n5 = n8 + Type1C.getWord(byArray, this.top + by, (int)by);
        } else {
            n6 = n8 + Type1C.getWord(fontData, this.top, (int)by);
            n5 = n8 + Type1C.getWord(fontData, this.top + by, (int)by);
        }
        String[] stringArray = this.readStringIndex(byArray, fontData, n8, by, n7);
        this.readGlobalSubRoutines(byArray, fontData);
        this.decodeDictionary(byArray, fontData, n6, n5, stringArray);
        if (this.FDSelect != -1) {
            n4 = this.FDSelect;
            int n9 = bl ? Type1C.getWord(byArray, n4, 1) : Type1C.getWord(fontData, n4, 1);
            n3 = bl ? Type1C.getWord(byArray, this.charstrings, 2) : Type1C.getWord(fontData, this.charstrings, 2);
            this.fdSelect = new int[n3];
            if (n9 == 0) {
                for (n2 = 0; n2 < n3; ++n2) {
                    this.fdSelect[n2] = bl ? Type1C.getWord(byArray, n4 + 1 + n2, 1) : Type1C.getWord(fontData, n4 + 1 + n2, 1);
                }
            } else if (n9 == 3) {
                n2 = bl ? Type1C.getWord(byArray, n4 + 1, 2) : Type1C.getWord(fontData, n4 + 1, 2);
                int[] nArray = new int[n2 + 1];
                int[] nArray2 = new int[n2];
                for (n = 0; n < n2; ++n) {
                    if (bl) {
                        nArray[n] = Type1C.getWord(byArray, n4 + 3 + 3 * n, 2);
                        nArray2[n] = Type1C.getWord(byArray, n4 + 5 + 3 * n, 1);
                        continue;
                    }
                    nArray[n] = Type1C.getWord(fontData, n4 + 3 + 3 * n, 2);
                    nArray2[n] = Type1C.getWord(fontData, n4 + 5 + 3 * n, 1);
                }
                nArray[nArray.length - 1] = n3;
                for (n = 0; n < n2; ++n) {
                    for (int i = nArray[n]; i < nArray[n + 1]; ++i) {
                        this.fdSelect[i] = nArray2[n];
                    }
                }
            }
            ((T1Glyphs)this.glyphs).setFDSelect(this.fdSelect);
            n4 = this.FDArray;
            if (bl) {
                n7 = Type1C.getWord(byArray, n4, 2);
                by = byArray[n4 + 2];
            } else {
                n7 = Type1C.getWord(fontData, n4, 2);
                by = fontData.getByte(n4 + 2);
            }
            n8 = (n4 += 3) + (n7 + 1) * by - 1;
            this.privateDictOffset = new int[n7];
            this.privateDictLength = new int[n7];
            this.subrs = new int[n7];
            this.defaultWidthX = new int[n7];
            this.nominalWidthX = new int[n7];
            for (n2 = 0; n2 < n7; ++n2) {
                this.currentFD = n2;
                this.privateDictOffset[n2] = -1;
                this.privateDictLength[n2] = -1;
                this.subrs[n2] = -1;
                if (bl) {
                    n6 = n8 + Type1C.getWord(byArray, n4 + n2 * by, (int)by);
                    n5 = n8 + Type1C.getWord(byArray, n4 + (n2 + 1) * by, (int)by);
                } else {
                    n6 = n8 + Type1C.getWord(fontData, n4 + n2 * by, (int)by);
                    n5 = n8 + Type1C.getWord(fontData, n4 + (n2 + 1) * by, (int)by);
                }
                this.decodeDictionary(byArray, fontData, n6, n5, stringArray);
            }
            this.currentFD = -1;
        }
        this.top = this.charstrings;
        n4 = bl ? Type1C.getWord(byArray, this.top, 2) : Type1C.getWord(fontData, this.top, 2);
        this.glyphs.setGlyphCount(n4);
        int[] nArray = this.readCharset(this.charset, n4, fontData, byArray);
        this.setEncoding(byArray, fontData, n4, nArray);
        this.top = this.charstrings;
        this.readGlyphs(byArray, fontData, n4, nArray);
        for (n3 = 0; n3 < this.privateDictOffset.length; ++n3) {
            this.currentFD = n3;
            n2 = this.privateDictOffset[n3];
            if (n2 == -1) continue;
            int n10 = this.privateDictLength[n3];
            this.decodeDictionary(byArray, fontData, n2, n2 + n10, stringArray);
            int n11 = bl ? byArray.length : fontData.length();
            if (this.subrs[this.currentFD] == -1 || this.subrs[this.currentFD] >= n11) continue;
            this.top = this.subrs[this.currentFD];
            n = bl ? Type1C.getWord(byArray, this.top, 2) : Type1C.getWord(fontData, this.top, 2);
            if (n <= 0) continue;
            this.readSubrs(byArray, fontData, n);
        }
        this.currentFD = -1;
        this.isFontEmbedded = true;
        this.glyphs.setFontEmbedded(true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setEncoding(byte[] byArray, FontData fontData, int n, int[] nArray) {
        int n2;
        String string;
        int n3;
        int n4;
        int n5;
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (this.enc == 0) {
            this.embeddedEnc = 1;
            if (this.fontEnc == -1) {
                this.putFontEncoding(1);
            }
            if (!this.isCID) return;
            try {
                int n6 = n;
                if (n6 > nArray.length) {
                    n6 = nArray.length;
                }
                for (int i = 1; i < n6; ++i) {
                    if (nArray[i] >= 391) continue;
                    String string2 = bl ? Type1C.getString(byArray, nArray[i], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[i], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putMappedChar(nArray[i], StandardFonts.getUnicodeName(string2));
                }
                return;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) return;
                LogWriter.writeLog("Exception: " + exception.getMessage());
                return;
            }
        }
        if (this.enc == 1) {
            this.embeddedEnc = 3;
            if (this.fontEnc != -1) return;
            this.putFontEncoding(3);
            return;
        }
        this.top = this.enc;
        int n7 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
        if ((n7 & 0x7F) == 0) {
            n5 = bl ? 1 + (byArray[this.top++] & 0xFF) : 1 + (fontData.getByte(this.top++) & 0xFF);
            if (n5 > n) {
                n5 = n;
            }
            for (n4 = 1; n4 < n5; ++n4) {
                if (bl) {
                    n3 = byArray[this.top++] & 0xFF;
                    string = Type1C.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                } else {
                    n3 = fontData.getByte(this.top++) & 0xFF;
                    string = Type1C.getString(fontData, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                }
                this.putChar(n3, string);
            }
        } else if ((n7 & 0x7F) == 1) {
            n5 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
            n4 = 1;
            for (n2 = 0; n2 < n5; ++n2) {
                int n8;
                if (bl) {
                    n3 = byArray[this.top++] & 0xFF;
                    n8 = byArray[this.top++] & 0xFF;
                } else {
                    n3 = fontData.getByte(this.top++) & 0xFF;
                    n8 = fontData.getByte(this.top++) & 0xFF;
                }
                for (int i = 0; i <= n8 && n4 < n; ++i) {
                    string = bl ? Type1C.getString(byArray, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[n4], this.stringIdx, this.stringStart, this.stringOffSize);
                    this.putChar(n3, string);
                    ++n4;
                    ++n3;
                }
            }
        }
        if ((n7 & 0x80) == 0) return;
        n5 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = bl ? byArray[this.top++] & 0xFF : fontData.getByte(this.top++) & 0xFF;
            n2 = bl ? Type1C.getWord(byArray, this.top, 2) : Type1C.getWord(fontData, this.top, 2);
            this.top += 2;
            string = bl ? Type1C.getString(byArray, n2, this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, n2, this.stringIdx, this.stringStart, this.stringOffSize);
            this.putChar(n3, string);
        }
    }

    private void readSubrs(byte[] byArray, FontData fontData, int n) throws Exception {
        int n2;
        boolean bl = byArray != null;
        byte by = bl ? byArray[this.top + 2] : fontData.getByte(this.top + 2);
        this.top += 3;
        int n3 = this.top;
        int n4 = this.top + (n + 1) * by - 1;
        int n5 = this.top + n * by;
        this.top = bl ? (n5 < byArray.length ? n4 + Type1C.getWord(byArray, n5, (int)by) : byArray.length - 1) : (n5 < byArray.length ? n4 + Type1C.getWord(fontData, n5, (int)by) : fontData.length() - 1);
        int[] nArray = new int[n + 2];
        int n6 = n3;
        for (n2 = 0; n2 < n + 1; ++n2) {
            if (bl) {
                if (n6 + by < byArray.length) {
                    nArray[n2] = n4 + Type1C.getWord(byArray, n6, (int)by);
                }
            } else if (n6 + by < fontData.length()) {
                nArray[n2] = n4 + Type1C.getWord(fontData, n6, (int)by);
            }
            n6 += by;
        }
        nArray[n + 1] = this.top;
        this.glyphs.setLocalBias(Type1C.calculateSubroutineBias(n));
        n2 = nArray[0];
        for (int i = 1; i < n + 1; ++i) {
            int n7;
            if (n2 == 0 || nArray[i] > byArray.length || nArray[i] < 0 || nArray[i] == 0) continue;
            FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
            for (n7 = n2; n7 < nArray[i]; ++n7) {
                if (bl || n7 >= fontData.length()) continue;
                fastByteArrayOutputStream.write(fontData.getByte(n7));
            }
            if (bl) {
                n7 = nArray[i] - n2;
                if (n7 > 0) {
                    byte[] byArray2 = new byte[n7];
                    System.arraycopy(byArray, n2, byArray2, 0, n7);
                    this.glyphs.setCharString("subrs" + (i - 1), byArray2, i);
                }
            } else {
                this.glyphs.setCharString("subrs" + (i - 1), fastByteArrayOutputStream.toByteArray(), i);
            }
            n2 = nArray[i];
        }
    }

    private void readGlyphs(byte[] byArray, FontData fontData, int n, int[] nArray) throws Exception {
        int n2;
        boolean bl = byArray != null;
        byte by = bl ? byArray[this.top + 2] : fontData.getByte(this.top + 2);
        this.top += 3;
        int n3 = this.top;
        int n4 = this.top + (n + 1) * by - 1;
        this.top = bl ? n4 + Type1C.getWord(byArray, this.top + n * by, (int)by) : n4 + Type1C.getWord(fontData, this.top + n * by, (int)by);
        int[] nArray2 = new int[n + 2];
        int n5 = n3;
        for (n2 = 0; n2 < n + 1; ++n2) {
            nArray2[n2] = bl ? n4 + Type1C.getWord(byArray, n5, (int)by) : n4 + Type1C.getWord(fontData, n5, (int)by);
            n5 += by;
        }
        nArray2[n + 1] = this.top;
        n2 = nArray2[0];
        for (int i = 1; i < n + 1; ++i) {
            byte[] byArray2 = new byte[nArray2[i] - n2];
            for (int j = n2; j < nArray2[i]; ++j) {
                byArray2[j - n2] = bl ? byArray[j] : fontData.getByte(j);
            }
            String string = this.isCID ? String.valueOf(nArray[i - 1]) : (bl ? Type1C.getString(byArray, nArray[i - 1], this.stringIdx, this.stringStart, this.stringOffSize) : Type1C.getString(fontData, nArray[i - 1], this.stringIdx, this.stringStart, this.stringOffSize));
            this.glyphs.setCharString(string, byArray2, i);
            n2 = nArray2[i];
            if (!this.trackIndices) continue;
            this.glyphs.setIndexForCharString(i, string);
        }
    }

    private static int calculateSubroutineBias(int n) {
        int n2 = n < 1240 ? 107 : (n < 33900 ? 1131 : 32768);
        return n2;
    }

    private void readGlobalSubRoutines(byte[] byArray, FontData fontData) throws Exception {
        int n;
        int n2;
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (bl) {
            n2 = byArray[this.top + 2] & 0xFF;
            n = Type1C.getWord(byArray, this.top, 2);
        } else {
            n2 = fontData.getByte(this.top + 2) & 0xFF;
            n = Type1C.getWord(fontData, this.top, 2);
        }
        this.top += 3;
        if (n > 0) {
            int n3;
            int n4 = this.top;
            int n5 = this.top + (n + 1) * n2 - 1;
            this.top = bl ? n5 + Type1C.getWord(byArray, this.top + n * n2, n2) : n5 + Type1C.getWord(fontData, this.top + n * n2, n2);
            int[] nArray = new int[n + 2];
            int n6 = n4;
            for (n3 = 0; n3 < n + 1; ++n3) {
                nArray[n3] = bl ? n5 + Type1C.getWord(byArray, n6, n2) : n5 + Type1C.getWord(fontData, n6, n2);
                n6 += n2;
            }
            nArray[n + 1] = this.top;
            this.glyphs.setGlobalBias(Type1C.calculateSubroutineBias(n));
            n3 = nArray[0];
            for (int i = 1; i < n + 1; ++i) {
                FastByteArrayOutputStream fastByteArrayOutputStream = new FastByteArrayOutputStream();
                for (int j = n3; j < nArray[i]; ++j) {
                    if (bl) {
                        fastByteArrayOutputStream.write(byArray[j]);
                        continue;
                    }
                    fastByteArrayOutputStream.write(fontData.getByte(j));
                }
                this.glyphs.setCharString("global" + (i - 1), fastByteArrayOutputStream.toByteArray(), i);
                n3 = nArray[i];
            }
        }
    }

    private void decodeDictionary(byte[] byArray, FontData fontData, int n, int n2, String[] stringArray) {
        boolean bl = false;
        boolean bl2 = byArray != null;
        int n3 = n;
        int n4 = 0;
        double[] dArray = new double[48];
        while (n3 < n2) {
            int n5 = bl2 ? byArray[n3] & 0xFF : fontData.getByte(n3) & 0xFF;
            if (n5 <= 27 || n5 == 31) {
                int n6 = n5;
                ++n3;
                if (n6 == 12) {
                    n6 = bl2 ? byArray[n3] & 0xFF : fontData.getByte(n3) & 0xFF;
                    ++n3;
                    bl = this.handle2ByteOperand(stringArray, bl, n6, dArray);
                } else {
                    this.handle1ByteOperand(n, stringArray, n6, dArray);
                }
                n4 = 0;
                continue;
            }
            n3 = bl2 ? T1GlyphNumber.getNumber(byArray, n3, dArray, n4, this.is1C()) : T1GlyphNumber.getNumber(fontData, n3, dArray, n4, this.is1C());
            ++n4;
        }
        if (!bl) {
            this.FDSelect = -1;
        }
    }

    private void handle1ByteOperand(int n, String[] stringArray, int n2, double[] dArray) {
        switch (n2) {
            case 2: {
                int n3 = (int)dArray[0];
                if (n3 > 390) {
                    n3 -= 390;
                }
                this.embeddedFontName = stringArray[n3];
                break;
            }
            case 3: {
                break;
            }
            case 5: {
                for (int i = 0; i < 4; ++i) {
                    this.FontBBox[i] = (float)dArray[i];
                }
                break;
            }
            case 15: {
                this.charset = (int)dArray[0];
                break;
            }
            case 16: {
                this.enc = (int)dArray[0];
                break;
            }
            case 17: {
                this.charstrings = (int)dArray[0];
                break;
            }
            case 18: {
                if (!this.glyphs.is1C()) break;
                int n4 = this.currentFD;
                if (n4 == -1) {
                    n4 = 0;
                }
                this.privateDictOffset[n4] = (int)dArray[1];
                this.privateDictLength[n4] = (int)dArray[0];
                break;
            }
            case 19: {
                int n5 = this.currentFD;
                if (n5 == -1) {
                    n5 = 0;
                }
                this.subrs[n5] = n + (int)dArray[0];
                break;
            }
            case 20: {
                int n6 = this.currentFD;
                if (n6 == -1) {
                    n6 = 0;
                }
                this.defaultWidthX[n6] = (int)dArray[0];
                if (!(this.glyphs instanceof T1Glyphs)) break;
                ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
                break;
            }
            case 21: {
                int n7 = this.currentFD;
                if (n7 == -1) {
                    n7 = 0;
                }
                this.nominalWidthX[n7] = (int)dArray[0];
                if (!(this.glyphs instanceof T1Glyphs)) break;
                ((T1Glyphs)this.glyphs).setWidthValues(this.defaultWidthX, this.nominalWidthX);
            }
        }
    }

    private boolean handle2ByteOperand(String[] stringArray, boolean bl, int n, double[] dArray) {
        if (n == 36 || n == 37 || n == 7 || this.FDSelect == -1) {
            switch (n) {
                case 0: {
                    int n2 = (int)dArray[0];
                    if (n2 > 390) {
                        n2 -= 390;
                    }
                    this.copyright = stringArray[n2];
                    break;
                }
                case 2: {
                    this.italicAngle = (int)dArray[0];
                    break;
                }
                case 6: {
                    if (!(dArray[0] > 0.0)) break;
                    this.blueValues = new int[6];
                    for (int i = 0; i < this.blueValues.length; ++i) {
                        this.blueValues[i] = (int)dArray[i];
                    }
                    break;
                }
                case 7: {
                    if (!this.hasFontMatrix) {
                        System.arraycopy(dArray, 0, this.FontMatrix, 0, 6);
                    }
                    this.hasFontMatrix = true;
                    break;
                }
                case 8: {
                    this.familyBlues = new int[6];
                    for (int i = 0; i < this.familyBlues.length; ++i) {
                        this.familyBlues[i] = (int)dArray[i];
                    }
                    break;
                }
                case 9: {
                    if (!(dArray[0] > 0.0)) break;
                    this.familyOtherBlues = new int[6];
                    for (int i = 0; i < this.familyOtherBlues.length; ++i) {
                        this.familyOtherBlues[i] = (int)dArray[i];
                    }
                    break;
                }
                case 10: {
                    this.stdHW = (int)dArray[0];
                    break;
                }
                case 11: {
                    this.stdVW = (int)dArray[0];
                    break;
                }
                case 21: {
                    break;
                }
                case 22: {
                    break;
                }
                case 30: {
                    this.ros = (int)dArray[0];
                    this.isCID = true;
                    break;
                }
                case 31: {
                    this.CIDFontVersion = (int)dArray[0];
                    break;
                }
                case 32: {
                    this.CIDFontRevision = (int)dArray[0];
                    break;
                }
                case 33: {
                    this.CIDFontType = (int)dArray[0];
                    break;
                }
                case 34: {
                    this.CIDcount = (int)dArray[0];
                    break;
                }
                case 35: {
                    this.UIDBase = (int)dArray[0];
                    break;
                }
                case 36: {
                    this.FDArray = (int)dArray[0];
                    break;
                }
                case 37: {
                    this.FDSelect = (int)dArray[0];
                    bl = true;
                    break;
                }
            }
        }
        return bl;
    }

    private String[] readStringIndex(byte[] byArray, FontData fontData, int n, int n2, int n3) {
        int n4;
        int n5;
        boolean bl;
        boolean bl2 = bl = byArray != null;
        if (bl) {
            this.top = n + Type1C.getWord(byArray, this.top + n3 * n2, n2);
            n5 = Type1C.getWord(byArray, this.top, 2);
            this.stringOffSize = byArray[this.top + 2];
        } else {
            this.top = n + Type1C.getWord(fontData, this.top + n3 * n2, n2);
            n5 = Type1C.getWord(fontData, this.top, 2);
            this.stringOffSize = fontData.getByte(this.top + 2);
        }
        this.top += 3;
        this.stringIdx = this.top;
        this.stringStart = this.top + (n5 + 1) * this.stringOffSize - 1;
        this.top = bl ? this.stringStart + Type1C.getWord(byArray, this.top + n5 * this.stringOffSize, this.stringOffSize) : this.stringStart + Type1C.getWord(fontData, this.top + n5 * this.stringOffSize, this.stringOffSize);
        int[] nArray = new int[n5 + 2];
        String[] stringArray = new String[n5 + 2];
        int n6 = this.stringIdx;
        for (n4 = 0; n4 < n5 + 1; ++n4) {
            nArray[n4] = bl ? Type1C.getWord(byArray, n6, this.stringOffSize) : Type1C.getWord(fontData, n6, this.stringOffSize);
            n6 += this.stringOffSize;
        }
        nArray[n5 + 1] = this.top - this.stringStart;
        n4 = 0;
        for (int i = 0; i < n5 + 1; ++i) {
            StringBuilder stringBuilder = new StringBuilder(nArray[i] - n4);
            for (int j = n4; j < nArray[i]; ++j) {
                if (bl) {
                    stringBuilder.append((char)byArray[this.stringStart + j]);
                    continue;
                }
                stringBuilder.append((char)fontData.getByte(this.stringStart + j));
            }
            stringArray[i] = stringBuilder.toString();
            n4 = nArray[i];
        }
        return stringArray;
    }

    private static String getString(FontData fontData, int n, int n2, int n3, int n4) {
        String string;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + Type1C.getWord(fontData, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + Type1C.getWord(fontData, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(fontData.getBytes(n5, n7));
        }
        return string;
    }

    private static String getString(byte[] byArray, int n, int n2, int n3, int n4) {
        String string;
        if (n < 391) {
            string = type1CStdStrings[n];
        } else {
            int n5 = n3 + Type1C.getWord(byArray, n2 + (n -= 391) * n4, n4);
            int n6 = n3 + Type1C.getWord(byArray, n2 + (n + 1) * n4, n4);
            int n7 = n6 - n5;
            if (n7 > 255) {
                n7 = 255;
            }
            string = new String(byArray, n5, n7);
        }
        return string;
    }

    private int[] readCharset(int n, int n2, FontData fontData, byte[] byArray) {
        int[] nArray;
        block7: {
            int n3;
            int n4;
            boolean bl;
            block12: {
                block11: {
                    block10: {
                        block9: {
                            block8: {
                                block6: {
                                    boolean bl2 = bl = byArray != null;
                                    if (!this.isCID || n <= 8000) break block6;
                                    nArray = new int[n2];
                                    nArray[0] = 0;
                                    for (int i = 1; i < n2; ++i) {
                                        nArray[i] = i;
                                    }
                                    break block7;
                                }
                                if (n != 0) break block8;
                                nArray = ISOAdobeCharset;
                                break block7;
                            }
                            if (n != 1) break block9;
                            nArray = ExpertCharset;
                            break block7;
                        }
                        if (n != 2) break block10;
                        nArray = ExpertSubCharset;
                        break block7;
                    }
                    nArray = new int[n2 + 1];
                    nArray[0] = 0;
                    n4 = n;
                    n3 = bl ? byArray[n4++] & 0xFF : fontData.getByte(n4++) & 0xFF;
                    if (n3 != 0) break block11;
                    for (int i = 1; i < n2; ++i) {
                        nArray[i] = bl ? Type1C.getWord(byArray, n4, 2) : Type1C.getWord(fontData, n4, 2);
                        n4 += 2;
                    }
                    break block7;
                }
                if (n3 != 1) break block12;
                int n5 = 1;
                while (n5 < n2) {
                    int n6 = bl ? Type1C.getWord(byArray, n4, 2) : Type1C.getWord(fontData, n4, 2);
                    n4 += 2;
                    int n7 = bl ? byArray[n4++] & 0xFF : fontData.getByte(n4++) & 0xFF;
                    for (int i = 0; i <= n7; ++i) {
                        nArray[n5++] = n6++;
                    }
                }
                break block7;
            }
            if (n3 != 2) break block7;
            int n8 = 1;
            while (n8 < n2) {
                int n9 = bl ? Type1C.getWord(byArray, n4, 2) : Type1C.getWord(fontData, n4, 2);
                int n10 = bl ? Type1C.getWord(byArray, n4, 2) : Type1C.getWord(fontData, n4 += 2, 2);
                n4 += 2;
                for (int i = 0; i <= n10; ++i) {
                    nArray[n8++] = n9++;
                }
            }
        }
        return nArray;
    }

    private static int getWord(FontData fontData, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (fontData.getByte(n + i) & 0xFF);
        }
        return n3;
    }

    private static int getWord(byte[] byArray, int n, int n2) {
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 = (n3 << 8) + (byArray[n + i] & 0xFF);
        }
        return n3;
    }

    @Override
    public Rectangle getBoundingBox() {
        if (this.BBox == null) {
            this.BBox = this.isFontEmbedded ? new Rectangle((int)this.FontBBox[0], (int)this.FontBBox[1], (int)(this.FontBBox[2] - this.FontBBox[0]), (int)(this.FontBBox[3] - this.FontBBox[1])) : super.getBoundingBox();
        }
        return this.BBox;
    }

    public int[] getFDSelect() {
        return this.fdSelect;
    }

    public int[] getRosArray() {
        return this.rosArray;
    }

    public static byte[] getOperatorBytes(int n) {
        byte[] byArray = null;
        if (n <= 30 && n >= 0) {
            byArray = new byte[]{(byte)n};
            return byArray;
        }
        if (n >= 3072 && n <= 3110) {
            byArray = Type1C.setNextInt16(n);
            return byArray;
        }
        return byArray;
    }

    static final byte[] setNextInt16(int n) {
        byte[] byArray = new byte[2];
        for (int i = 0; i < 2; ++i) {
            byArray[i] = (byte)(n >> 8 * (1 - i) & 0xFF);
        }
        return byArray;
    }

    public Object getKeyValue(int n) {
        switch (n) {
            case 4: {
                return 388;
            }
            case 3074: {
                return this.italicAngle;
            }
            case 3079: {
                return this.FontMatrix;
            }
            case 5: {
                return this.FontBBox;
            }
            case 16: {
                return this.enc;
            }
            case 20: {
                return this.defaultWidthX[0];
            }
            case 21: {
                return this.nominalWidthX[0];
            }
            case 6: {
                return this.blueValues;
            }
            case 7: {
                return this.otherBlues;
            }
            case 8: {
                return this.familyBlues;
            }
            case 9: {
                return this.familyOtherBlues;
            }
            case 10: {
                return this.stdHW;
            }
            case 11: {
                return this.stdVW;
            }
            case 19: {
                return this.subrs;
            }
            case 3102: {
                return this.ros;
            }
            case 3106: {
                return this.CIDcount;
            }
            case 3104: {
                return this.CIDFontRevision;
            }
            case 3103: {
                return this.CIDFontVersion;
            }
            case 3105: {
                return this.CIDFontType;
            }
            case 3108: {
                return this.FDArray;
            }
            case 3109: {
                return this.FDSelect;
            }
        }
        throw new RuntimeException("Key is unknown or value is not yet assigned " + n);
    }
}

