/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts;

import java.util.Map;
import org.jpedal.exception.PdfException;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.fonts.glyph.T3Glyph;
import org.jpedal.fonts.glyph.T3Glyphs;
import org.jpedal.fonts.glyph.T3Size;
import org.jpedal.io.ObjectStore;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.PdfKeyPairsIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.T3StreamDecoder;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;

public class Type3
extends PdfFont {
    private final GraphicsState currentGraphicsState = new GraphicsState();
    private final boolean isPrinting;

    public Type3(PdfObjectReader pdfObjectReader, boolean bl) {
        this.glyphs = new T3Glyphs();
        this.isPrinting = bl;
        this.init(pdfObjectReader);
    }

    @Override
    public final void createFont(PdfObject pdfObject, String string, boolean bl, ObjectStore objectStore, Map map) throws Exception {
        this.fontTypes = 1228944679;
        this.init(string, bl);
        PdfObject pdfObject2 = pdfObject.getDictionary(-1044665361);
        this.setBoundsAndMatrix(pdfObject);
        this.setName(pdfObject);
        this.setEncoding(pdfObject, pdfObject2);
        this.readWidths(pdfObject, false);
        this.readEmbeddedFont(pdfObject, objectStore);
        if (bl) {
            this.setFont(this.getBaseFontName(), 1);
        }
    }

    private void readEmbeddedFont(PdfObject pdfObject, ObjectStore objectStore) {
        PdfObject pdfObject2 = pdfObject.getDictionary(2054190454);
        if (pdfObject2 != null) {
            T3StreamDecoder t3StreamDecoder;
            block14: {
                t3StreamDecoder = new T3StreamDecoder(this.currentPdfFile, true, this.isPrinting);
                t3StreamDecoder.setParameters(false, true, 7, 0, false, false);
                t3StreamDecoder.setObjectValue(-8, objectStore);
                PdfObject pdfObject3 = pdfObject.getDictionary(2004251818);
                if (pdfObject3 != null) {
                    try {
                        t3StreamDecoder.readResources(pdfObject3, false);
                    }
                    catch (PdfException pdfException) {
                        if (!LogWriter.isOutput()) break block14;
                        LogWriter.writeLog("Exception: " + pdfException.getMessage());
                    }
                }
            }
            PdfKeyPairsIterator pdfKeyPairsIterator = pdfObject2.getKeyPairsIterator();
            while (pdfKeyPairsIterator.hasMorePairs()) {
                block15: {
                    String string = pdfKeyPairsIterator.getNextKeyAsString();
                    PdfObject pdfObject4 = pdfKeyPairsIterator.getNextValueAsDictionary();
                    Object var13_13 = null;
                    if (this.diffLookup != null) {
                        String string2 = StandardFonts.convertNumberToGlyph(string, this.containsHexNumbers, this.allNumbers);
                        var13_13 = this.diffLookup.get(string2);
                    }
                    if (pdfObject4 != null && this.renderPage && !string.equals(".notdef") && !string.equals(".")) {
                        T3Display t3Display = new T3Display(0, false, 20, objectStore);
                        t3Display.setHiResImageForDisplayMode(true);
                        t3Display.setType3Glyph(string);
                        try {
                            int n;
                            t3StreamDecoder.setRenderer(t3Display);
                            t3StreamDecoder.setDefaultColors(this.currentGraphicsState.getNonstrokeColor(), this.currentGraphicsState.getNonstrokeColor());
                            int n2 = 1;
                            double[] dArray = pdfObject.getDoubleArray(-2105119560);
                            if (dArray != null && dArray[0] == 1.0 && (dArray[3] == 1.0 || dArray[3] == -1.0)) {
                                n2 = 10;
                            }
                            GraphicsState graphicsState = new GraphicsState(0, 0);
                            graphicsState.CTM = new float[][]{{n2, 0.0f, 0.0f}, {0.0f, n2, 0.0f}, {0.0f, 0.0f, 1.0f}};
                            T3Size t3Size = t3StreamDecoder.decodePageContent(pdfObject4, graphicsState);
                            int n3 = t3Size.x;
                            int n4 = t3Size.y;
                            if (n3 == 0 && n4 != 0) {
                                n3 = t3Size.y;
                                n4 = t3Size.x;
                            }
                            T3Glyph t3Glyph = new T3Glyph(t3Display, n3, n4, t3StreamDecoder.ignoreColors);
                            t3Glyph.setScaling(1.0f / (float)n2);
                            int n5 = -1;
                            if (var13_13 != null) {
                                n = var13_13;
                                if (pdfKeyPairsIterator.isNextKeyANumber()) {
                                    n5 = pdfKeyPairsIterator.getNextKeyAsNumber();
                                }
                            } else {
                                n = pdfKeyPairsIterator.getNextKeyAsNumber();
                            }
                            this.glyphs.setT3Glyph(n, n5, t3Glyph);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace(System.out);
                            if (!LogWriter.isOutput()) break block15;
                            LogWriter.writeLog("Exception " + exception + " is Type3 font code");
                        }
                    }
                }
                pdfKeyPairsIterator.nextPair();
            }
            this.isFontEmbedded = true;
        }
    }
}

