/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.util.HashMap;
import java.util.Map;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Table;
import org.jpedal.utils.LogWriter;

public class Post
extends Table {
    private final Map translateToID = new HashMap();
    private final String[] macEncoding = new String[]{".notdef", ".null", "nonmarkingreturn", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "summation", "product", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nonbreakingspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "apple", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idotaccent", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dcroat"};

    public Post(FontFile2 fontFile2) {
        int n = fontFile2.selectTable(8);
        if (n == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No Post table found");
            }
        } else {
            int n2 = (int)(10.0f * fontFile2.getFixed());
            fontFile2.getFixed();
            fontFile2.getFWord();
            fontFile2.getFWord();
            fontFile2.getNextUint16();
            fontFile2.getNextUint16();
            fontFile2.getNextUint32();
            fontFile2.getNextUint32();
            fontFile2.getNextUint32();
            fontFile2.getNextUint32();
            if (n2 != 30) {
                for (int i = 0; i < 258; ++i) {
                    this.translateToID.put(this.macEncoding[i], i);
                }
            }
            switch (n2) {
                case 20: {
                    int n3;
                    int n4 = fontFile2.getNextUint16();
                    int[] nArray = new int[n4];
                    int n5 = 0;
                    for (int i = 0; i < n4; ++i) {
                        nArray[i] = fontFile2.getNextUint16();
                        if (nArray[i] <= 257 || nArray[i] >= 32768) continue;
                        ++n5;
                    }
                    String[] stringArray = new String[n5];
                    for (n3 = 0; n3 < n5; ++n3) {
                        stringArray[n3] = fontFile2.getString();
                    }
                    for (n3 = 0; n3 < n4; ++n3) {
                        if (nArray[n3] <= 257 || nArray[n3] >= 32768 || nArray[n3] - 258 >= n5) continue;
                        this.translateToID.put(stringArray[nArray[n3] - 258], n3);
                    }
                    break;
                }
                case 25: {
                    int n6 = fontFile2.getNextUint16();
                    int[] nArray = new int[n6];
                    for (int i = 0; i < n6; ++i) {
                        nArray[i] = fontFile2.getNextint8();
                        this.translateToID.put(this.macEncoding[nArray[i] + i], nArray[i]);
                    }
                    break;
                }
            }
        }
    }

    public Post() {
    }

    public int convertGlyphToCharacterCode(String string) {
        Integer n = (Integer)this.translateToID.get(string);
        if (n == null) {
            return 0;
        }
        return n;
    }
}

