/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt;

import java.io.Serializable;
import java.util.Map;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.MarkerGlyph;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.fonts.objects.FontData;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.CFF;
import org.jpedal.fonts.tt.CMAP;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Glyf;
import org.jpedal.fonts.tt.Head;
import org.jpedal.fonts.tt.Hhea;
import org.jpedal.fonts.tt.Hmtx;
import org.jpedal.fonts.tt.Loca;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.Name;
import org.jpedal.fonts.tt.Post;
import org.jpedal.fonts.tt.TTGlyph;
import org.jpedal.fonts.tt.TTGlyphFX;
import org.jpedal.fonts.tt.Table;
import org.jpedal.fonts.tt.hinting.TTVM;
import org.jpedal.utils.LogWriter;

public class TTGlyphs
extends PdfJavaGlyphs {
    protected boolean hasGIDtoCID;
    protected int[] CIDToGIDMap;
    float[] FontBBox = new float[]{0.0f, 0.0f, 1000.0f, 1000.0f};
    boolean isCorrupted;
    private CMAP currentCMAP;
    private Post currentPost;
    private Glyf currentGlyf;
    private Hmtx currentHmtx;
    private Hhea currentHhea;
    private Head currentHead;
    private FontFile2 fontTable;
    private Loca currentLoca;
    private TTVM vm;
    private CFF currentCFF;
    int type = 1217103210;
    private int unitsPerEm;
    private boolean hasCFF;
    private boolean isCID;

    @Override
    public PdfGlyph getEmbeddedGlyph(GlyphFactory glyphFactory, String string, float[][] fArray, int n, String string2, float f, String string3) {
        PdfGlyph pdfGlyph;
        int n2 = n;
        if (this.hasGIDtoCID && this.isIdentity()) {
            n = this.CIDToGIDMap[n];
        }
        if (fArray != null && this.lastTrm[0][0] != fArray[0][0] | this.lastTrm[1][0] != fArray[1][0] | this.lastTrm[0][1] != fArray[0][1] | this.lastTrm[1][1] != fArray[1][1]) {
            this.lastTrm = fArray;
            this.flush();
        }
        if ((pdfGlyph = this.getEmbeddedCachedShape(n2)) == null) {
            block10: {
                int n3 = n;
                if (!(this.isCID && this.isIdentity() || this.currentCMAP == null)) {
                    n3 = this.currentCMAP.convertIndexToCharacterCode(string, n);
                }
                if (n3 < 1) {
                    n3 = this.currentPost.convertGlyphToCharacterCode(string);
                }
                try {
                    if (this.hasCFF) {
                        pdfGlyph = this.currentCFF.getCFFGlyph(glyphFactory, string, fArray, n3, string2, f, string3);
                        if (pdfGlyph != null) {
                            pdfGlyph.setWidth(this.getUnscaledWidth(string, n, false));
                        }
                    } else {
                        pdfGlyph = this.getTTGlyph(n3, string, n, string2, glyphFactory);
                    }
                }
                catch (Exception exception) {
                    pdfGlyph = null;
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
            this.setEmbeddedCachedShape(n2, pdfGlyph);
        }
        return pdfGlyph;
    }

    private PdfGlyph getTTGlyph(int n, String string, int n2, String string2, GlyphFactory glyphFactory) {
        if (this.isCorrupted) {
            n = n2;
        }
        PdfGlyph pdfGlyph = null;
        try {
            BaseTTGlyph.debug = false;
            if (n != -1) {
                int n3 = this.currentGlyf.getCharString(n);
                if (n3 != -1) {
                    pdfGlyph = glyphFactory.useFX() ? (TTGlyph.useHinting ? new TTGlyphFX(this.currentGlyf, this.fontTable, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f, this.vm) : new TTGlyphFX(this.currentGlyf, this.fontTable, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f, this.baseFontName)) : (TTGlyph.useHinting ? new TTGlyph(this.currentGlyf, this.fontTable, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f, this.vm) : new TTGlyph(this.currentGlyf, this.fontTable, this.currentHmtx, n, (float)this.unitsPerEm / 1000.0f, this.baseFontName));
                    if (BaseTTGlyph.debug) {
                        System.out.println(">>" + n3 + ' ' + n2 + ' ' + string2 + ' ' + this.baseFontName);
                    }
                } else if (!glyphFactory.useFX() && (" ".equals(string) || " ".equals(string2))) {
                    pdfGlyph = new MarkerGlyph(0.0f, 0.0f, 0.0f, 0.0f, this.baseFontName);
                    pdfGlyph.setGlyphNumber(n + 1);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
        return pdfGlyph;
    }

    @Override
    public void setEncodingToUse(boolean bl, int n, boolean bl2) {
        if (this.currentCMAP != null) {
            if (this.isCorrupted) {
                this.currentCMAP.setEncodingToUse(bl, n, bl2);
            } else {
                this.currentCMAP.setEncodingToUse(bl, n, bl2);
            }
        }
    }

    @Override
    public int getConvertedGlyph(int n) {
        if (this.currentCMAP == null) {
            return n;
        }
        return this.currentCMAP.convertIndexToCharacterCode(null, n);
    }

    @Override
    public Map getCharStrings() {
        if (this.currentCMAP != null) {
            return this.currentCMAP.buildCharStringTable();
        }
        return this.currentGlyf.buildCharStringTable();
    }

    @Override
    public float getTTWidth(String string, int n, String string2, boolean bl) {
        float f;
        block4: {
            int n2 = n;
            f = 0.0f;
            try {
                if (!bl) {
                    n2 = this.currentCMAP.convertIndexToCharacterCode(string, n);
                }
                if (n2 < 1) {
                    n2 = this.currentPost.convertGlyphToCharacterCode(string);
                }
                f = this.currentHmtx.getWidth(n2);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Attempting to read width " + exception);
            }
        }
        return f;
    }

    private float getUnscaledWidth(String string, int n, boolean bl) {
        float f;
        block4: {
            int n2 = n;
            f = 0.0f;
            try {
                if (!bl) {
                    n2 = this.currentCMAP.convertIndexToCharacterCode(string, n);
                }
                if (n2 < 1) {
                    n2 = this.currentPost.convertGlyphToCharacterCode(string);
                }
                f = this.currentHmtx.getUnscaledWidth(n2);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block4;
                LogWriter.writeLog("Attempting to read width " + exception);
            }
        }
        return f;
    }

    @Override
    public void setGIDtoCID(int[] nArray) {
        this.hasGIDtoCID = true;
        this.CIDToGIDMap = nArray;
    }

    public static String[] readFontNames(FontData fontData, int n) {
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n2 = fontFile2.getFontCount();
        String[] stringArray = new String[n2];
        for (int i = 0; i < n2; ++i) {
            String string;
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            if (n == 2) {
                string = name.getString(Name.POSTSCRIPT_NAME);
            } else if (n == 3) {
                string = name.getString(Name.FONT_FAMILY_NAME);
            } else if (n == 4) {
                string = name.getString(Name.FULL_FONT_NAME);
            } else {
                throw new RuntimeException("Unsupported mode " + n + ". Unable to resolve font names");
            }
            stringArray[i] = string == null ? null : string.toLowerCase();
        }
        if (fontData != null) {
            fontData.close();
        }
        return stringArray;
    }

    public static void addStringValues(FontData fontData, Map map) {
        FontFile2 fontFile2 = new FontFile2(fontData);
        int n = fontFile2.getFontCount();
        for (int i = 0; i < n; ++i) {
            fontFile2.setSelectedFontIndex(i);
            Name name = new Name(fontFile2);
            Map map2 = name.getStrings();
            if (map2 == null) continue;
            for (Object k : map2.keySet()) {
                Integer n2 = (Integer)k;
                int n3 = n2;
                if (n3 >= Name.stringNames.length) continue;
                map.put(Name.stringNames[n2], map2.get(n2));
            }
        }
        if (fontData != null) {
            fontData.close();
        }
    }

    @Override
    public int readEmbeddedFont(boolean bl, byte[] byArray, FontData fontData) {
        Serializable serializable;
        this.isCID = bl;
        FontFile2 fontFile2 = byArray != null ? new FontFile2(byArray) : new FontFile2(fontData);
        if (FontMappings.fontSubstitutionFontID == null) {
            fontFile2.setPointer(0);
        } else {
            serializable = (Integer)FontMappings.fontSubstitutionFontID.get(this.fontName.toLowerCase());
            if (serializable != null) {
                fontFile2.setPointer((Integer)serializable);
            } else {
                fontFile2.setPointer(0);
            }
        }
        this.currentHead = new Head(fontFile2);
        this.currentPost = new Post(fontFile2);
        serializable = new Maxp(fontFile2);
        this.glyphCount = ((Maxp)serializable).getGlyphCount();
        this.currentLoca = new Loca(fontFile2, this.glyphCount, this.currentHead.getIndexToLocFormat());
        this.isCorrupted = this.currentLoca.isCorrupted();
        this.currentGlyf = new Glyf(fontFile2, this.glyphCount, this.currentLoca.getIndices());
        this.currentCFF = new CFF(fontFile2, this.isCID);
        this.hasCFF = this.currentCFF.hasCFFData();
        if (this.hasCFF) {
            this.type = 6;
        }
        if (TTGlyph.useHinting) {
            this.vm = new TTVM(fontFile2, (Maxp)serializable);
        }
        this.currentHhea = new Hhea(fontFile2);
        this.FontBBox = this.currentHead.getFontBBox();
        this.currentHmtx = new Hmtx(fontFile2, this.glyphCount, this.currentHhea.getNumberOfHMetrics(), (int)this.FontBBox[3]);
        int n = fontFile2.selectTable(2);
        if (n != 0) {
            this.currentCMAP = new CMAP(fontFile2, n);
        }
        this.unitsPerEm = this.currentHead.getUnitsPerEm();
        this.fontTable = new FontFile2(this.currentGlyf.getTableData(), true);
        if (fontData != null) {
            fontData.close();
        }
        return this.type;
    }

    @Override
    public float[] getFontBoundingBox() {
        return this.FontBBox;
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public boolean isCorrupted() {
        return this.isCorrupted;
    }

    @Override
    public void setCorrupted(boolean bl) {
        this.isCorrupted = bl;
    }

    @Override
    public Table getTable(int n) {
        Table table;
        switch (n) {
            case 3: {
                table = this.currentLoca;
                break;
            }
            case 2: {
                table = this.currentCMAP;
                break;
            }
            case 5: {
                table = this.currentHhea;
                break;
            }
            case 6: {
                table = this.currentHmtx;
                break;
            }
            case 0: {
                table = this.currentHead;
                break;
            }
            default: {
                throw new RuntimeException("table not yet added to getTable)");
            }
        }
        return table;
    }
}

