/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.fonts.tt.hinting;

import java.io.Serializable;
import java.util.HashMap;
import org.jpedal.fonts.tt.BaseTTGlyph;
import org.jpedal.fonts.tt.FontFile2;
import org.jpedal.fonts.tt.Maxp;
import org.jpedal.fonts.tt.hinting.Cvt;
import org.jpedal.fonts.tt.hinting.TTGraphicsState;
import org.jpedal.utils.LogWriter;

public class TTVM
implements Serializable {
    protected static final int TWILIGHT_ZONE = 0;
    protected static final int GLYPH_ZONE = 1;
    protected static final int ORIGINAL = 2;
    private boolean printOut;
    private final int[] preProgram;
    private final int[] fontProgram;
    private boolean fontProgramRun;
    private boolean scalerRun;
    private double ptSize;
    private double ppem;
    private double scaler;
    private final int[][] x;
    private final int[][] y;
    private final boolean[][] curve;
    private final boolean[][] contour;
    private boolean[][][] touched;
    final Maxp maxp;
    private boolean useDefaultGS;
    private Stack stack = new Stack();
    private final Cvt cvt;
    private final TTGraphicsState graphicsState;
    private final int[] storage;
    private final HashMap<Integer, int[]> functions;
    private final HashMap<Integer, int[]> instructions;
    private static final int SVTCAy = 0;
    private static final int SVTCAx = 1;
    private static final int SPVTCAy = 2;
    private static final int SPVTCAx = 3;
    private static final int SFVTCAy = 4;
    private static final int SFVTCAx = 5;
    private static final int SPVTL0 = 6;
    private static final int SPVTL1 = 7;
    private static final int SFVTL0 = 8;
    private static final int SFVTL1 = 9;
    private static final int SPVFS = 10;
    private static final int SFVFS = 11;
    private static final int GPV = 12;
    private static final int GFV = 13;
    private static final int SFVTPV = 14;
    private static final int ISECT = 15;
    private static final int SRP0 = 16;
    private static final int SRP1 = 17;
    private static final int SRP2 = 18;
    private static final int SZP0 = 19;
    private static final int SZP1 = 20;
    private static final int SZP2 = 21;
    private static final int SZPS = 22;
    private static final int SLOOP = 23;
    private static final int RTG = 24;
    private static final int RTHG = 25;
    private static final int SMD = 26;
    private static final int ELSE = 27;
    private static final int JMPR = 28;
    private static final int SCVTCI = 29;
    private static final int SSWCI = 30;
    private static final int SSW = 31;
    private static final int DUP = 32;
    private static final int POP = 33;
    private static final int CLEAR = 34;
    private static final int SWAP = 35;
    private static final int DEPTH = 36;
    private static final int CINDEX = 37;
    private static final int MINDEX = 38;
    private static final int ALIGNPTS = 39;
    private static final int UTP = 41;
    private static final int LOOPCALL = 42;
    private static final int CALL = 43;
    private static final int FDEF = 44;
    private static final int ENDF = 45;
    private static final int MDAP0 = 46;
    private static final int MDAP1 = 47;
    private static final int IUPy = 48;
    private static final int IUPx = 49;
    private static final int SHP0 = 50;
    private static final int SHP1 = 51;
    private static final int SHC0 = 52;
    private static final int SHC1 = 53;
    private static final int SHZ0 = 54;
    private static final int SHZ1 = 55;
    private static final int SHPIX = 56;
    private static final int IP = 57;
    private static final int MSIRP0 = 58;
    private static final int MSIRP1 = 59;
    private static final int ALIGNRP = 60;
    private static final int RTDG = 61;
    private static final int MIAP0 = 62;
    private static final int MIAP1 = 63;
    private static final int NPUSHB = 64;
    private static final int NPUSHW = 65;
    private static final int WS = 66;
    private static final int RS = 67;
    private static final int WCVTP = 68;
    private static final int RCVT = 69;
    private static final int GC0 = 70;
    private static final int GC1 = 71;
    private static final int SCFS = 72;
    private static final int MD0 = 73;
    private static final int MD1 = 74;
    private static final int MPPEM = 75;
    private static final int MPS = 76;
    private static final int FLIPON = 77;
    private static final int FLIPOFF = 78;
    private static final int DEBUG = 79;
    private static final int LT = 80;
    private static final int LTEQ = 81;
    private static final int GT = 82;
    private static final int GTEQ = 83;
    private static final int EQ = 84;
    private static final int NEQ = 85;
    private static final int ODD = 86;
    private static final int EVEN = 87;
    private static final int IF = 88;
    private static final int EIF = 89;
    private static final int AND = 90;
    private static final int OR = 91;
    private static final int NOT = 92;
    private static final int DELTAP1 = 93;
    private static final int SDB = 94;
    private static final int SDS = 95;
    private static final int ADD = 96;
    private static final int SUB = 97;
    private static final int DIV = 98;
    private static final int MUL = 99;
    private static final int ABS = 100;
    private static final int NEG = 101;
    private static final int FLOOR = 102;
    private static final int CEILING = 103;
    private static final int ROUND00 = 104;
    private static final int ROUND01 = 105;
    private static final int ROUND10 = 106;
    private static final int ROUND11 = 107;
    private static final int NROUND00 = 108;
    private static final int NROUND01 = 109;
    private static final int NROUND10 = 110;
    private static final int NROUND11 = 111;
    private static final int WCVTF = 112;
    private static final int DELTAP2 = 113;
    private static final int DELTAP3 = 114;
    private static final int DELTAC1 = 115;
    private static final int DELTAC2 = 116;
    private static final int DELTAC3 = 117;
    private static final int SROUND = 118;
    private static final int S45ROUND = 119;
    private static final int JROT = 120;
    private static final int JROF = 121;
    private static final int ROFF = 122;
    private static final int RUTG = 124;
    private static final int RDTG = 125;
    private static final int SANGW = 126;
    private static final int AA = 127;
    private static final int FLIPPT = 128;
    private static final int FLIPRGON = 129;
    private static final int FLIPRGOFF = 130;
    private static final int SCANCTRL = 133;
    private static final int SDPVTL0 = 134;
    private static final int SDPVTL1 = 135;
    private static final int GETINFO = 136;
    private static final int IDEF = 137;
    private static final int ROLL = 138;
    private static final int MAX = 139;
    private static final int MIN = 140;
    private static final int SCANTYPE = 141;
    private static final int INSTCTRL = 142;
    private static final int PUSHB = 176;
    private static final int PUSHW = 184;
    private static final int MDRP = 192;
    private static final int MIRP = 224;
    private static final int paramRESETRP0 = 16;
    private static final int paramUSEMINDIST = 8;
    private static final int paramROUND = 4;

    public TTVM(FontFile2 fontFile2, Maxp maxp) {
        this.cvt = new Cvt(fontFile2);
        this.graphicsState = new TTGraphicsState();
        this.preProgram = TTVM.readProgramTable(fontFile2, 14);
        this.fontProgram = TTVM.readProgramTable(fontFile2, 10);
        this.storage = new int[maxp.getMaxStorage()];
        this.functions = new HashMap();
        this.instructions = new HashMap();
        this.maxp = maxp;
        int n = maxp.getMaxPoints();
        this.x = new int[4][n];
        this.y = new int[4][n];
        this.curve = new boolean[2][n];
        this.contour = new boolean[2][n];
        this.touched = new boolean[4][n][2];
        this.x[0] = new int[maxp.getMaxTwilightPoints()];
        this.y[0] = new int[maxp.getMaxTwilightPoints()];
    }

    public void setScaleVars(double d, double d2, double d3) {
        this.scalerRun = false;
        this.ppem = (int)(d2 + 0.5);
        this.ptSize = d3;
        if (!this.fontProgramRun) {
            this.execute(this.fontProgram, this.graphicsState);
            this.fontProgramRun = true;
        }
        if (d != this.scaler) {
            this.scaler = d;
            this.cvt.scale(d);
            this.execute(this.preProgram, this.graphicsState);
            this.scalerRun = true;
        }
    }

    public void processGlyph(int[] nArray, int[] nArray2, int[] nArray3, boolean[] blArray, boolean[] blArray2) {
        TTGraphicsState tTGraphicsState;
        this.x[1] = nArray2;
        this.x[3] = new int[nArray2.length];
        System.arraycopy(this.x[1], 0, this.x[3], 0, this.x[1].length);
        this.y[1] = nArray3;
        this.y[3] = new int[nArray3.length];
        System.arraycopy(this.y[1], 0, this.y[3], 0, this.y[1].length);
        this.curve[1] = blArray;
        this.contour[1] = blArray2;
        int n = this.maxp.getMaxTwilightPoints();
        if (nArray2.length > n) {
            n = nArray2.length;
        }
        this.touched = new boolean[4][n][2];
        this.stack = new Stack();
        if (this.useDefaultGS) {
            tTGraphicsState = new TTGraphicsState();
        } else {
            try {
                tTGraphicsState = (TTGraphicsState)this.graphicsState.clone();
                tTGraphicsState.resetForGlyph();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                if (LogWriter.isOutput()) {
                    LogWriter.writeLog("Exception: " + cloneNotSupportedException.getMessage());
                }
                cloneNotSupportedException.printStackTrace(System.out);
                tTGraphicsState = new TTGraphicsState();
            }
        }
        if (tTGraphicsState.instructControl != 0) {
            return;
        }
        this.execute(nArray, tTGraphicsState);
    }

    private void execute(int[] nArray, TTGraphicsState tTGraphicsState) {
        if (nArray == null) {
            return;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (this.printOut) {
                System.out.print(i + "\t");
            }
            i = this.process(nArray[i], i, nArray, tTGraphicsState);
            if (!BaseTTGlyph.redecodePage) continue;
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int process(int n, int n2, int[] nArray, TTGraphicsState tTGraphicsState) {
        int n3 = 0;
        if (n >= 176 && n <= 191) {
            n3 = n % 8;
            n -= n3;
            ++n3;
        }
        try {
            switch (n) {
                case 0: {
                    tTGraphicsState.freedomVector = 16384;
                    tTGraphicsState.projectionVector = 16384;
                    tTGraphicsState.dualProjectionVector = 16384;
                    return n2;
                }
                case 1: {
                    tTGraphicsState.freedomVector = 0x40000000;
                    tTGraphicsState.projectionVector = 0x40000000;
                    tTGraphicsState.dualProjectionVector = 0x40000000;
                    return n2;
                }
                case 2: {
                    tTGraphicsState.projectionVector = 16384;
                    tTGraphicsState.dualProjectionVector = 16384;
                    return n2;
                }
                case 3: {
                    tTGraphicsState.projectionVector = 0x40000000;
                    tTGraphicsState.dualProjectionVector = 0x40000000;
                    return n2;
                }
                case 4: {
                    tTGraphicsState.freedomVector = 16384;
                    return n2;
                }
                case 5: {
                    tTGraphicsState.freedomVector = 0x40000000;
                    return n2;
                }
                case 6: {
                    int n4 = this.stack.pop();
                    int n5 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n5] - this.x[tTGraphicsState.zp1][n4]);
                    double d2 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n5] - this.y[tTGraphicsState.zp1][n4]);
                    double d3 = Math.sqrt(d * d + d2 * d2);
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d3), TTVM.storeDoubleAsF2Dot14(d2 /= d3));
                    return n2;
                }
                case 7: {
                    int n6 = this.stack.pop();
                    int n7 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n7] - this.x[tTGraphicsState.zp1][n6]);
                    double d4 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n7] - this.y[tTGraphicsState.zp1][n6]);
                    double d5 = Math.sqrt(d * d + d4 * d4);
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(d4 /= d5)), TTVM.storeDoubleAsF2Dot14(d /= d5));
                    return n2;
                }
                case 8: {
                    int n8 = this.stack.pop();
                    int n9 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp1][n9] - this.x[tTGraphicsState.zp2][n8]);
                    double d6 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp1][n9] - this.y[tTGraphicsState.zp2][n8]);
                    double d7 = Math.sqrt(d * d + d6 * d6);
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d7), TTVM.storeDoubleAsF2Dot14(d6 /= d7));
                    return n2;
                }
                case 9: {
                    int n10 = this.stack.pop();
                    int n11 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp1][n11] - this.x[tTGraphicsState.zp2][n10]);
                    double d8 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp1][n11] - this.y[tTGraphicsState.zp2][n10]);
                    double d9 = Math.sqrt(d * d + d8 * d8);
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(-(d8 /= d9)), TTVM.storeDoubleAsF2Dot14(d /= d9));
                    return n2;
                }
                case 10: {
                    int n12 = this.stack.pop();
                    int n13 = this.stack.pop();
                    tTGraphicsState.dualProjectionVector = tTGraphicsState.projectionVector = TTGraphicsState.createVector(n13, n12);
                    return n2;
                }
                case 11: {
                    int n14 = this.stack.pop();
                    int n15 = this.stack.pop();
                    tTGraphicsState.freedomVector = TTGraphicsState.createVector(n15, n14);
                    return n2;
                }
                case 12: {
                    int[] nArray2 = TTGraphicsState.getVectorComponents(tTGraphicsState.projectionVector);
                    this.stack.push(nArray2[0]);
                    this.stack.push(nArray2[1]);
                    return n2;
                }
                case 13: {
                    int[] nArray3 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    this.stack.push(nArray3[0]);
                    this.stack.push(nArray3[1]);
                    return n2;
                }
                case 14: {
                    tTGraphicsState.freedomVector = tTGraphicsState.projectionVector;
                    return n2;
                }
                case 15: {
                    double d;
                    int n16;
                    int n17;
                    int n18 = this.stack.pop();
                    int n19 = this.stack.pop();
                    int n20 = this.stack.pop();
                    int n21 = this.stack.pop();
                    int n22 = this.x[tTGraphicsState.zp1][n21];
                    int n23 = this.y[tTGraphicsState.zp1][n21];
                    int n24 = this.x[tTGraphicsState.zp1][n20] - n22;
                    int n25 = this.y[tTGraphicsState.zp1][n20] - n23;
                    int n26 = this.x[tTGraphicsState.zp0][n19];
                    int n27 = this.y[tTGraphicsState.zp0][n19];
                    int n28 = this.x[tTGraphicsState.zp0][n18] - n26;
                    int n29 = this.y[tTGraphicsState.zp0][n18] - n27;
                    if (n24 == 0 && n28 == 0) {
                        n17 = n22 + n26 / 2;
                        n16 = (n23 + n27 + (n23 + n25) + (n27 + n29)) / 4;
                    } else if (n24 == 0) {
                        d = TTVM.getDoubleFromF26Dot6(n29) / TTVM.getDoubleFromF26Dot6(n28);
                        double d10 = TTVM.getDoubleFromF26Dot6(n27) - d * TTVM.getDoubleFromF26Dot6(n26);
                        n17 = n22;
                        n16 = TTVM.storeDoubleAsF26Dot6(d * TTVM.getDoubleFromF26Dot6(n22) + d10);
                    } else if (n28 == 0) {
                        d = TTVM.getDoubleFromF26Dot6(n25) / TTVM.getDoubleFromF26Dot6(n24);
                        double d11 = TTVM.getDoubleFromF26Dot6(n23) - d * TTVM.getDoubleFromF26Dot6(n22);
                        n17 = n26;
                        n16 = TTVM.storeDoubleAsF26Dot6(d * TTVM.getDoubleFromF26Dot6(n26) + d11);
                    } else {
                        d = TTVM.getDoubleFromF26Dot6(n25) / TTVM.getDoubleFromF26Dot6(n24);
                        double d12 = TTVM.getDoubleFromF26Dot6(n23) - d * TTVM.getDoubleFromF26Dot6(n22);
                        double d13 = TTVM.getDoubleFromF26Dot6(n29) / TTVM.getDoubleFromF26Dot6(n28);
                        double d14 = TTVM.getDoubleFromF26Dot6(n27) - d13 * TTVM.getDoubleFromF26Dot6(n26);
                        if (d == d13) {
                            n17 = (n22 + n26 + (n22 + n24) + (n26 + n28)) / 4;
                            n16 = (n23 + n27 + (n23 + n25) + (n27 + n29)) / 4;
                        } else {
                            double d15 = (d14 - d12) / (d - d13);
                            n17 = TTVM.storeDoubleAsF26Dot6(d15);
                            n16 = TTVM.storeDoubleAsF26Dot6(d * d15 + d12);
                        }
                    }
                    int n30 = this.stack.pop();
                    this.x[tTGraphicsState.zp2][n30] = n17;
                    this.y[tTGraphicsState.zp2][n30] = n16;
                    return n2;
                }
                case 16: {
                    tTGraphicsState.rp0 = this.stack.pop();
                    return n2;
                }
                case 17: {
                    tTGraphicsState.rp1 = this.stack.pop();
                    return n2;
                }
                case 18: {
                    tTGraphicsState.rp2 = this.stack.pop();
                    return n2;
                }
                case 19: {
                    int n31;
                    tTGraphicsState.zp0 = n31 = this.stack.pop();
                    return n2;
                }
                case 20: {
                    int n32;
                    tTGraphicsState.zp1 = n32 = this.stack.pop();
                    return n2;
                }
                case 21: {
                    int n33;
                    tTGraphicsState.zp2 = n33 = this.stack.pop();
                    return n2;
                }
                case 22: {
                    int n34;
                    tTGraphicsState.zp0 = n34 = this.stack.pop();
                    tTGraphicsState.zp1 = n34;
                    tTGraphicsState.zp2 = n34;
                    return n2;
                }
                case 23: {
                    tTGraphicsState.loop = this.stack.pop();
                    return n2;
                }
                case 24: {
                    tTGraphicsState.roundState = 72;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 25: {
                    tTGraphicsState.roundState = 104;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 26: {
                    tTGraphicsState.minimumDistance = this.stack.pop();
                    return n2;
                }
                case 27: {
                    int n35 = 0;
                    int n36 = 0;
                    do {
                        if (n35 == 89 && n36 != 0) {
                            --n36;
                        }
                        if ((n35 = nArray[++n2]) == 88) {
                            ++n36;
                        }
                        if (n35 == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n35 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n35 >= 176 && n35 <= 183) {
                            n2 += n35 + 1 - 176;
                            continue;
                        }
                        if (n35 < 184 || n35 > 191) continue;
                        n2 += (n35 + 1 - 184) * 2;
                    } while (n35 != 89 || n36 != 0);
                    return n2;
                }
                case 28: {
                    int n37 = this.stack.pop();
                    n2 = n2 + n37 - 1;
                    if (n2 >= 0) return n2;
                    throw new RuntimeException("Jumped back further than the start of the instruction.");
                }
                case 29: {
                    tTGraphicsState.controlValueTableCutIn = this.stack.pop();
                    return n2;
                }
                case 30: {
                    tTGraphicsState.singleWidthCutIn = this.stack.pop();
                    return n2;
                }
                case 31: {
                    tTGraphicsState.singleWidthValue = this.stack.pop();
                    return n2;
                }
                case 32: {
                    int n38 = this.stack.pop();
                    this.stack.push(n38);
                    this.stack.push(n38);
                    return n2;
                }
                case 33: {
                    this.stack.pop();
                    return n2;
                }
                case 34: {
                    this.stack = new Stack();
                    return n2;
                }
                case 35: {
                    int n39 = this.stack.pop();
                    int n40 = this.stack.pop();
                    this.stack.push(n39);
                    this.stack.push(n40);
                    return n2;
                }
                case 36: {
                    this.stack.push(this.stack.size());
                    return n2;
                }
                case 37: {
                    int n41 = this.stack.pop();
                    int n42 = this.stack.elementAt(n41);
                    this.stack.push(n42);
                    return n2;
                }
                case 38: {
                    int n43 = this.stack.pop();
                    int n44 = this.stack.remove(n43);
                    this.stack.push(n44);
                    return n2;
                }
                case 39: {
                    int n45 = this.stack.pop();
                    int n46 = this.stack.pop();
                    int n47 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n45], this.y[tTGraphicsState.zp1][n45]);
                    int n48 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n46], this.y[tTGraphicsState.zp0][n46]);
                    int n49 = (n47 + n48) / 2;
                    int[] nArray4 = tTGraphicsState.getFVMoveforPVDistance(n49 - n47);
                    int[] nArray5 = this.x[tTGraphicsState.zp1];
                    int n50 = n45;
                    nArray5[n50] = nArray5[n50] + nArray4[0];
                    int[] nArray6 = this.y[tTGraphicsState.zp1];
                    int n51 = n45;
                    nArray6[n51] = nArray6[n51] + nArray4[1];
                    int[] nArray7 = this.x[tTGraphicsState.zp0];
                    int n52 = n46;
                    nArray7[n52] = nArray7[n52] - nArray4[0];
                    int[] nArray8 = this.y[tTGraphicsState.zp0];
                    int n53 = n46;
                    nArray8[n53] = nArray8[n53] - nArray4[1];
                    int[] nArray9 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray9[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n45][0] = true;
                        this.touched[tTGraphicsState.zp0][n46][0] = true;
                    }
                    if (nArray9[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp1][n45][1] = true;
                    this.touched[tTGraphicsState.zp0][n46][1] = true;
                    return n2;
                }
                case 41: {
                    int n54 = this.stack.pop();
                    if (tTGraphicsState.freedomVector == 0x40000000) {
                        this.touched[tTGraphicsState.zp0][n54][0] = false;
                        return n2;
                    }
                    if (tTGraphicsState.freedomVector == 16384) {
                        this.touched[tTGraphicsState.zp0][n54][1] = false;
                        return n2;
                    }
                    this.touched[tTGraphicsState.zp0][n54][0] = false;
                    this.touched[tTGraphicsState.zp0][n54][1] = false;
                    return n2;
                }
                case 42: {
                    int n55 = this.stack.pop();
                    int n56 = this.stack.pop();
                    int[] nArray10 = this.functions.get(n55);
                    for (int i = 0; i < n56; ++i) {
                        this.execute(nArray10, tTGraphicsState);
                    }
                    if (!this.printOut) return n2;
                    System.out.println("LOOPCALL finished");
                    return n2;
                }
                case 43: {
                    int n57 = this.stack.pop();
                    int[] nArray11 = this.functions.get(n57);
                    this.execute(nArray11, tTGraphicsState);
                    if (!this.printOut) return n2;
                    System.out.println("CALL finished");
                    return n2;
                }
                case 44: {
                    int n58;
                    int n59 = this.stack.pop();
                    int n60 = n2;
                    do {
                        if ((n58 = nArray[++n2]) == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n58 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n58 >= 176 && n58 <= 183) {
                            n2 += n58 + 1 - 176;
                            continue;
                        }
                        if (n58 < 184 || n58 > 191) continue;
                        n2 += (n58 + 1 - 184) * 2;
                    } while (n58 != 45);
                    int n61 = n2 - n60 - 1;
                    n2 = n60;
                    int[] nArray12 = new int[n61];
                    for (int i = 0; i < n61; ++i) {
                        nArray12[i] = nArray[++n2];
                    }
                    this.functions.put(n59, nArray12);
                    ++n2;
                    return n2;
                }
                case 45: {
                    return n2;
                }
                case 46: {
                    int n62;
                    tTGraphicsState.rp0 = n62 = this.stack.pop();
                    tTGraphicsState.rp1 = n62;
                    if (tTGraphicsState.freedomVector == 0x40000000) {
                        this.touched[tTGraphicsState.zp0][n62][0] = true;
                        return n2;
                    }
                    if (tTGraphicsState.freedomVector == 16384) {
                        this.touched[tTGraphicsState.zp0][n62][1] = true;
                        return n2;
                    }
                    this.touched[tTGraphicsState.zp0][n62][0] = true;
                    this.touched[tTGraphicsState.zp0][n62][1] = true;
                    return n2;
                }
                case 47: {
                    int n63;
                    tTGraphicsState.rp0 = n63 = this.stack.pop();
                    tTGraphicsState.rp1 = n63;
                    int n64 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n63], this.y[tTGraphicsState.zp0][n63]);
                    n64 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n64))) - n64;
                    int[] nArray13 = tTGraphicsState.getFVMoveforPVDistance(n64);
                    int[] nArray14 = this.x[tTGraphicsState.zp0];
                    int n65 = n63;
                    nArray14[n65] = nArray14[n65] + nArray13[0];
                    int[] nArray15 = this.y[tTGraphicsState.zp0];
                    int n66 = n63;
                    nArray15[n66] = nArray15[n66] + nArray13[1];
                    int[] nArray16 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray16[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n63][0] = true;
                    }
                    if (nArray16[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp0][n63][1] = true;
                    return n2;
                }
                case 48: {
                    this.interpolateUntouchedPoints(48);
                    return n2;
                }
                case 49: {
                    this.interpolateUntouchedPoints(49);
                    return n2;
                }
                case 50: {
                    int n67;
                    for (int i = 0; i < tTGraphicsState.loop && (n67 = this.stack.pop()) <= this.x[tTGraphicsState.zp2].length && tTGraphicsState.rp2 <= this.x[tTGraphicsState.zp1].length; ++i) {
                        int n68 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n69 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n70 = n68 - n69;
                        int[] nArray17 = tTGraphicsState.getFVMoveforPVDistance(n70);
                        int[] nArray18 = this.x[tTGraphicsState.zp2];
                        int n71 = n67;
                        nArray18[n71] = nArray18[n71] + nArray17[0];
                        int[] nArray19 = this.y[tTGraphicsState.zp2];
                        int n72 = n67;
                        nArray19[n72] = nArray19[n72] + nArray17[1];
                        int[] nArray20 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray20[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n67][0] = true;
                        }
                        if (nArray20[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n67][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 51: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n73 = this.stack.pop();
                        int n74 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n75 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n76 = n74 - n75;
                        int[] nArray21 = tTGraphicsState.getFVMoveforPVDistance(n76);
                        int[] nArray22 = this.x[tTGraphicsState.zp2];
                        int n77 = n73;
                        nArray22[n77] = nArray22[n77] + nArray21[0];
                        int[] nArray23 = this.y[tTGraphicsState.zp2];
                        int n78 = n73;
                        nArray23[n78] = nArray23[n78] + nArray21[1];
                        if (nArray21[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n73][0] = true;
                        }
                        if (nArray21[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n73][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 52: {
                    int n79;
                    int n80 = this.stack.pop();
                    int[] nArray24 = new int[this.contour[1].length];
                    int[] nArray25 = new int[this.contour[1].length];
                    int n81 = 0;
                    int n82 = 0;
                    nArray25[0] = 0;
                    for (n79 = 0; n79 < this.contour[1].length; ++n79) {
                        if (!this.contour[1][n79]) continue;
                        nArray25[n81 + 1] = n79 + 1;
                        nArray24[n81] = n79 + 1 - n82;
                        n82 = n79 + 1;
                        ++n81;
                    }
                    n79 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n83 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n84 = n79 - n83;
                    int[] nArray26 = tTGraphicsState.getFVMoveforPVDistance(n84);
                    int n85 = nArray25[n80];
                    while (n85 < nArray25[n80] + nArray24[n80]) {
                        if (tTGraphicsState.zp1 == tTGraphicsState.zp2 || n85 != tTGraphicsState.rp2) {
                            int[] nArray27 = this.x[tTGraphicsState.zp2];
                            int n86 = n85;
                            nArray27[n86] = nArray27[n86] + nArray26[0];
                            int[] nArray28 = this.y[tTGraphicsState.zp2];
                            int n87 = n85;
                            nArray28[n87] = nArray28[n87] + nArray26[1];
                        }
                        ++n85;
                    }
                    return n2;
                }
                case 53: {
                    int n88;
                    int n89 = this.stack.pop();
                    int[] nArray29 = new int[this.contour[1].length];
                    int[] nArray30 = new int[this.contour[1].length];
                    int n90 = 0;
                    int n91 = 0;
                    nArray30[0] = 0;
                    for (n88 = 0; n88 < this.contour[1].length; ++n88) {
                        if (!this.contour[1][n88]) continue;
                        nArray30[n90 + 1] = n88 + 1;
                        nArray29[n90] = n88 + 1 - n91;
                        n91 = n88 + 1;
                        ++n90;
                    }
                    n88 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n92 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n93 = n88 - n92;
                    int[] nArray31 = tTGraphicsState.getFVMoveforPVDistance(n93);
                    int n94 = nArray30[n89];
                    while (n94 < nArray30[n89] + nArray29[n89]) {
                        if (tTGraphicsState.zp2 != tTGraphicsState.zp0 || n94 != tTGraphicsState.rp1) {
                            int[] nArray32 = this.x[tTGraphicsState.zp2];
                            int n95 = n94;
                            nArray32[n95] = nArray32[n95] + nArray31[0];
                            int[] nArray33 = this.y[tTGraphicsState.zp2];
                            int n96 = n94;
                            nArray33[n96] = nArray33[n96] + nArray31[1];
                        }
                        ++n94;
                    }
                    return n2;
                }
                case 54: {
                    int n97 = this.stack.pop();
                    int n98 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n99 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]);
                    int n100 = n98 - n99;
                    int[] nArray34 = tTGraphicsState.getFVMoveforPVDistance(n100);
                    int n101 = 0;
                    while (n101 < this.x[n97].length) {
                        if (n97 != tTGraphicsState.zp1 || n101 != tTGraphicsState.rp2) {
                            int[] nArray35 = this.x[n97];
                            int n102 = n101;
                            nArray35[n102] = nArray35[n102] + nArray34[0];
                            int[] nArray36 = this.y[n97];
                            int n103 = n101;
                            nArray36[n103] = nArray36[n103] + nArray34[1];
                        }
                        ++n101;
                    }
                    return n2;
                }
                case 55: {
                    int n104 = this.stack.pop();
                    int n105 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n106 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                    int n107 = n105 - n106;
                    int[] nArray37 = tTGraphicsState.getFVMoveforPVDistance(n107);
                    int n108 = 0;
                    while (n108 < this.x[n104].length) {
                        if (n104 != tTGraphicsState.zp0 || n108 != tTGraphicsState.rp1) {
                            int[] nArray38 = this.x[n104];
                            int n109 = n108;
                            nArray38[n109] = nArray38[n109] + nArray37[0];
                            int[] nArray39 = this.y[n104];
                            int n110 = n108;
                            nArray39[n110] = nArray39[n110] + nArray37[1];
                        }
                        ++n108;
                    }
                    return n2;
                }
                case 56: {
                    int n111 = this.stack.pop();
                    int[] nArray40 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n112 = this.stack.pop();
                        int[] nArray41 = this.x[tTGraphicsState.zp2];
                        int n113 = n112;
                        nArray41[n113] = (int)((double)nArray41[n113] + (double)n111 * TTVM.getDoubleFromF2Dot14(nArray40[0]) / 64.0);
                        int[] nArray42 = this.y[tTGraphicsState.zp2];
                        int n114 = n112;
                        nArray42[n114] = (int)((double)nArray42[n114] + (double)n111 * TTVM.getDoubleFromF2Dot14(nArray40[1]) / 64.0);
                        if (nArray40[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n112][0] = true;
                        }
                        if (nArray40[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n112][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 57: {
                    int n115;
                    for (int i = 0; i < tTGraphicsState.loop && (n115 = this.stack.pop()) >= 0 && n115 <= this.x[tTGraphicsState.zp2].length && tTGraphicsState.rp1 <= this.x[tTGraphicsState.zp0].length && tTGraphicsState.rp2 <= this.x[tTGraphicsState.zp1].length; ++i) {
                        int n116;
                        int n117 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        if (n117 == (n116 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[2 + tTGraphicsState.zp1][tTGraphicsState.rp2]))) continue;
                        int n118 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp2][n115], this.y[2 + tTGraphicsState.zp2][n115]);
                        double d = (double)(n118 - n117) / (double)(n116 - n117);
                        int n119 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp1], this.y[tTGraphicsState.zp0][tTGraphicsState.rp1]);
                        int n120 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][tTGraphicsState.rp2], this.y[tTGraphicsState.zp1][tTGraphicsState.rp2]);
                        int n121 = (int)(d * (double)(n120 - n119) + (double)n119 + 0.5) - n118;
                        int[] nArray43 = tTGraphicsState.getFVMoveforPVDistance(n121);
                        int[] nArray44 = this.x[tTGraphicsState.zp2];
                        int n122 = n115;
                        nArray44[n122] = nArray44[n122] + nArray43[0];
                        int[] nArray45 = this.y[tTGraphicsState.zp2];
                        int n123 = n115;
                        nArray45[n123] = nArray45[n123] + nArray43[1];
                        int[] nArray46 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray46[0] != 0) {
                            this.touched[tTGraphicsState.zp2][n115][0] = true;
                        }
                        if (nArray46[1] == 0) continue;
                        this.touched[tTGraphicsState.zp2][n115][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 58: {
                    int n124 = this.stack.pop();
                    int n125 = this.stack.pop();
                    int[] nArray47 = tTGraphicsState.getFVMoveforPVDistance(n124 - (TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n125], this.y[tTGraphicsState.zp1][n125]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0])));
                    int[] nArray48 = this.x[tTGraphicsState.zp1];
                    int n126 = n125;
                    nArray48[n126] = nArray48[n126] + nArray47[0];
                    int[] nArray49 = this.y[tTGraphicsState.zp1];
                    int n127 = n125;
                    nArray49[n127] = nArray49[n127] + nArray47[1];
                    int[] nArray50 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray50[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n125][0] = true;
                    }
                    if (nArray50[1] != 0) {
                        this.touched[tTGraphicsState.zp1][n125][1] = true;
                    }
                    tTGraphicsState.rp1 = tTGraphicsState.rp0;
                    tTGraphicsState.rp2 = n125;
                    return n2;
                }
                case 59: {
                    int n128 = this.stack.pop();
                    int n129 = this.stack.pop();
                    int[] nArray51 = tTGraphicsState.getFVMoveforPVDistance(n128 - (TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n129], this.y[tTGraphicsState.zp1][n129]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0])));
                    int[] nArray52 = this.x[tTGraphicsState.zp1];
                    int n130 = n129;
                    nArray52[n130] = nArray52[n130] + nArray51[0];
                    int[] nArray53 = this.y[tTGraphicsState.zp1];
                    int n131 = n129;
                    nArray53[n131] = nArray53[n131] + nArray51[1];
                    int[] nArray54 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray54[0] != 0) {
                        this.touched[tTGraphicsState.zp1][n129][0] = true;
                    }
                    if (nArray54[1] != 0) {
                        this.touched[tTGraphicsState.zp1][n129][1] = true;
                    }
                    tTGraphicsState.rp1 = tTGraphicsState.rp0;
                    tTGraphicsState.rp2 = n129;
                    tTGraphicsState.rp0 = n129;
                    return n2;
                }
                case 60: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n132 = this.stack.pop();
                        int n133 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        int n134 = n133 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n132], this.y[tTGraphicsState.zp1][n132]);
                        int[] nArray55 = tTGraphicsState.getFVMoveforPVDistance(n134);
                        int[] nArray56 = this.x[tTGraphicsState.zp1];
                        int n135 = n132;
                        nArray56[n135] = nArray56[n135] + nArray55[0];
                        int[] nArray57 = this.y[tTGraphicsState.zp1];
                        int n136 = n132;
                        nArray57[n136] = nArray57[n136] + nArray55[1];
                        int[] nArray58 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray58[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n132][0] = true;
                        }
                        if (nArray58[1] == 0) continue;
                        this.touched[tTGraphicsState.zp1][n132][1] = true;
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 61: {
                    tTGraphicsState.roundState = 8;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 62: {
                    int n137 = this.stack.pop();
                    int n138 = this.stack.pop();
                    int n139 = this.cvt.get(n137);
                    int n140 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n138], this.y[tTGraphicsState.zp0][n138]);
                    int n141 = n139 - n140;
                    int[] nArray59 = tTGraphicsState.getFVMoveforPVDistance(n141);
                    int[] nArray60 = this.x[tTGraphicsState.zp0];
                    int n142 = n138;
                    nArray60[n142] = nArray60[n142] + nArray59[0];
                    int[] nArray61 = this.y[tTGraphicsState.zp0];
                    int n143 = n138;
                    nArray61[n143] = nArray61[n143] + nArray59[1];
                    int[] nArray62 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray62[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n138][0] = true;
                    }
                    if (nArray62[1] != 0) {
                        this.touched[tTGraphicsState.zp0][n138][1] = true;
                    }
                    tTGraphicsState.rp0 = tTGraphicsState.rp1 = n138;
                    return n2;
                }
                case 63: {
                    int n144 = this.stack.pop();
                    int n145 = this.stack.pop();
                    int n146 = this.cvt.get(n144);
                    int n147 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n145], this.y[tTGraphicsState.zp0][n145]);
                    int n148 = n146 - n147;
                    if (Math.abs(n148) > tTGraphicsState.controlValueTableCutIn) {
                        n146 = n147;
                    }
                    n146 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n146)));
                    n148 = n146 - n147;
                    int[] nArray63 = tTGraphicsState.getFVMoveforPVDistance(n148);
                    int[] nArray64 = this.x[tTGraphicsState.zp0];
                    int n149 = n145;
                    nArray64[n149] = nArray64[n149] + nArray63[0];
                    int[] nArray65 = this.y[tTGraphicsState.zp0];
                    int n150 = n145;
                    nArray65[n150] = nArray65[n150] + nArray63[1];
                    int[] nArray66 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray66[0] != 0) {
                        this.touched[tTGraphicsState.zp0][n145][0] = true;
                    }
                    if (nArray66[1] != 0) {
                        this.touched[tTGraphicsState.zp0][n145][1] = true;
                    }
                    tTGraphicsState.rp0 = tTGraphicsState.rp1 = n145;
                    return n2;
                }
                case 64: {
                    ++n2;
                    return this.readFromIS(nArray[n2], false, n2, nArray);
                }
                case 65: {
                    ++n2;
                    return this.readFromIS(nArray[n2], true, n2, nArray);
                }
                case 66: {
                    int n151 = this.stack.pop();
                    int n152 = this.stack.pop();
                    this.storage[n152] = n151;
                    return n2;
                }
                case 67: {
                    int n153 = this.stack.pop();
                    this.stack.push(this.storage[n153]);
                    return n2;
                }
                case 68: {
                    int n154 = this.stack.pop();
                    int n155 = this.stack.pop();
                    this.cvt.putInPixels(n155, n154);
                    return n2;
                }
                case 69: {
                    int n156 = this.stack.pop();
                    this.stack.push(this.cvt.get(n156));
                    return n2;
                }
                case 70: {
                    int n157 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp2][n157], this.y[tTGraphicsState.zp2][n157]));
                    return n2;
                }
                case 71: {
                    int n158 = this.stack.pop();
                    this.stack.push(TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp2][n158], this.y[2 + tTGraphicsState.zp2][n158]));
                    return n2;
                }
                case 72: {
                    int n159 = this.stack.pop();
                    int n160 = this.stack.pop();
                    int n161 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp2][n160], this.y[tTGraphicsState.zp2][n160]);
                    int n162 = n159 - n161;
                    int[] nArray67 = tTGraphicsState.getFVMoveforPVDistance(n162);
                    int[] nArray68 = this.x[tTGraphicsState.zp2];
                    int n163 = n160;
                    nArray68[n163] = nArray68[n163] + nArray67[0];
                    int[] nArray69 = this.y[tTGraphicsState.zp2];
                    int n164 = n160;
                    nArray69[n164] = nArray69[n164] + nArray67[1];
                    int[] nArray70 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                    if (nArray70[0] != 0) {
                        this.touched[tTGraphicsState.zp2][n160][0] = true;
                    }
                    if (nArray70[1] == 0) return n2;
                    this.touched[tTGraphicsState.zp2][n160][1] = true;
                    return n2;
                }
                case 73: {
                    int n165 = this.stack.pop();
                    int n166 = this.stack.pop();
                    int n167 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n166], this.y[tTGraphicsState.zp1][n166]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][n165], this.y[tTGraphicsState.zp0][n165]);
                    this.stack.push(n167);
                    return n2;
                }
                case 74: {
                    int n168 = this.stack.pop();
                    int n169 = this.stack.pop();
                    int n170 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n169], this.y[2 + tTGraphicsState.zp1][n169]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][n168], this.y[2 + tTGraphicsState.zp0][n168]);
                    this.stack.push(n170);
                    return n2;
                }
                case 75: {
                    int n171 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, (int)(this.ppem * 64.0), (int)(this.ppem * 64.0)) / 64;
                    if (n171 < 0) {
                        n171 = -n171;
                    }
                    this.stack.push(n171);
                    return n2;
                }
                case 76: {
                    this.stack.push((int)(this.ptSize * 64.0));
                    return n2;
                }
                case 77: {
                    tTGraphicsState.autoFlip = true;
                    return n2;
                }
                case 78: {
                    tTGraphicsState.autoFlip = false;
                    return n2;
                }
                case 79: {
                    this.stack.pop();
                    return n2;
                }
                case 80: {
                    int n172 = this.stack.pop();
                    int n173 = this.stack.pop();
                    if (n173 < n172) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 81: {
                    int n174 = this.stack.pop();
                    int n175 = this.stack.pop();
                    if (n175 <= n174) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 82: {
                    int n176 = this.stack.pop();
                    int n177 = this.stack.pop();
                    if (n177 > n176) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 83: {
                    int n178 = this.stack.pop();
                    int n179 = this.stack.pop();
                    if (n179 >= n178) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 84: {
                    int n180 = this.stack.pop();
                    int n181 = this.stack.pop();
                    if (n181 == n180) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 85: {
                    int n182 = this.stack.pop();
                    int n183 = this.stack.pop();
                    if (n183 != n182) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 86: {
                    int n184 = this.stack.pop();
                    n184 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n184)));
                    n184 = (n184 >> 6) % 2;
                    this.stack.push(n184);
                    return n2;
                }
                case 87: {
                    int n185 = this.stack.pop();
                    n185 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n185)));
                    n185 = ((n185 >> 6) + 1) % 2;
                    this.stack.push(n185);
                    return n2;
                }
                case 88: {
                    boolean bl = this.stack.pop() != 0;
                    if (bl) return n2;
                    int n186 = 0;
                    int n187 = 0;
                    do {
                        if (n186 == 89 && n187 != 0) {
                            --n187;
                        }
                        if ((n186 = nArray[++n2]) == 88) {
                            ++n187;
                        }
                        if (n186 == 64) {
                            ++n2;
                            n2 += nArray[n2];
                            continue;
                        }
                        if (n186 == 65) {
                            ++n2;
                            n2 += nArray[n2] * 2;
                            continue;
                        }
                        if (n186 >= 176 && n186 <= 183) {
                            n2 += n186 + 1 - 176;
                            continue;
                        }
                        if (n186 < 184 || n186 > 191) continue;
                        n2 += (n186 + 1 - 184) * 2;
                    } while (n186 != 27 && n186 != 89 || n187 != 0);
                    return n2;
                }
                case 89: {
                    return n2;
                }
                case 90: {
                    boolean bl;
                    boolean bl2 = this.stack.pop() != 0;
                    boolean bl3 = bl = this.stack.pop() != 0;
                    if (bl && bl2) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 91: {
                    boolean bl;
                    boolean bl4 = this.stack.pop() != 0;
                    boolean bl5 = bl = this.stack.pop() != 0;
                    if (bl || bl4) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 92: {
                    boolean bl;
                    boolean bl6 = bl = this.stack.pop() != 0;
                    if (!bl) {
                        this.stack.push(1);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 93: {
                    int n188 = this.stack.pop();
                    int n189 = 0;
                    while (n189 < n188) {
                        int n190 = this.stack.pop();
                        int n191 = this.stack.pop();
                        int n192 = tTGraphicsState.deltaBase + (n191 >> 4);
                        if ((double)n192 == this.ppem) {
                            int n193 = (n191 & 0xF) - 7;
                            if (n193 <= 0) {
                                --n193;
                            }
                            int n194 = TTVM.storeDoubleAsF26Dot6((double)n193 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray71 = tTGraphicsState.getFVMoveforPVDistance(n194);
                            int[] nArray72 = this.x[tTGraphicsState.zp0];
                            int n195 = n190;
                            nArray72[n195] = nArray72[n195] + nArray71[0];
                            int[] nArray73 = this.y[tTGraphicsState.zp0];
                            int n196 = n190;
                            nArray73[n196] = nArray73[n196] + nArray71[1];
                            int[] nArray74 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray74[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n190][0] = true;
                            }
                            if (nArray74[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n190][1] = true;
                            }
                        }
                        ++n189;
                    }
                    return n2;
                }
                case 94: {
                    tTGraphicsState.deltaBase = this.stack.pop();
                    return n2;
                }
                case 95: {
                    tTGraphicsState.deltaShift = this.stack.pop();
                    return n2;
                }
                case 96: {
                    this.stack.push(this.stack.pop() + this.stack.pop());
                    return n2;
                }
                case 97: {
                    int n197 = this.stack.pop();
                    int n198 = this.stack.pop();
                    this.stack.push(n198 - n197);
                    return n2;
                }
                case 98: {
                    int n199 = this.stack.pop();
                    int n200 = this.stack.pop();
                    if (n199 != 0) {
                        this.stack.push(n200 * 64 / n199);
                        return n2;
                    }
                    this.stack.push(0);
                    return n2;
                }
                case 99: {
                    int n201 = this.stack.pop();
                    int n202 = this.stack.pop();
                    this.stack.push(n201 * n202 / 64);
                    return n2;
                }
                case 100: {
                    int n203 = this.stack.pop();
                    if (n203 < 0) {
                        n203 = -n203;
                    }
                    this.stack.push(n203);
                    return n2;
                }
                case 101: {
                    this.stack.push(-this.stack.pop());
                    return n2;
                }
                case 102: {
                    this.stack.push(this.stack.pop() >> 6 << 6);
                    return n2;
                }
                case 103: {
                    int n204 = this.stack.pop();
                    if ((n204 & 0x3F) != 0) {
                        n204 = (n204 >> 6) + 1 << 6;
                    }
                    this.stack.push(n204);
                    return n2;
                }
                case 104: {
                    int n205 = this.stack.pop();
                    n205 = TTVM.engineCompensation(n205, 0);
                    double d = TTVM.getDoubleFromF26Dot6(n205);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 105: {
                    int n206 = this.stack.pop();
                    n206 = TTVM.engineCompensation(n206, 1);
                    double d = TTVM.getDoubleFromF26Dot6(n206);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 106: {
                    int n207 = this.stack.pop();
                    n207 = TTVM.engineCompensation(n207, 2);
                    double d = TTVM.getDoubleFromF26Dot6(n207);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 107: {
                    int n208 = this.stack.pop();
                    n208 = TTVM.engineCompensation(n208, 3);
                    double d = TTVM.getDoubleFromF26Dot6(n208);
                    this.stack.push(TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(d)));
                    return n2;
                }
                case 108: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 0));
                    return n2;
                }
                case 109: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 1));
                    return n2;
                }
                case 110: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 2));
                    return n2;
                }
                case 111: {
                    this.stack.push(TTVM.engineCompensation(this.stack.pop(), 3));
                    return n2;
                }
                case 112: {
                    int n209 = this.stack.pop();
                    int n210 = this.stack.pop();
                    this.cvt.putInFUnits(n210, n209);
                    return n2;
                }
                case 113: {
                    int n211 = this.stack.pop();
                    int n212 = 0;
                    while (n212 < n211) {
                        int n213 = this.stack.pop();
                        int n214 = this.stack.pop();
                        int n215 = tTGraphicsState.deltaBase + 16 + (n214 >> 4);
                        if ((double)n215 == this.ppem) {
                            int n216 = (n214 & 0xF) - 7;
                            if (n216 <= 0) {
                                --n216;
                            }
                            int n217 = TTVM.storeDoubleAsF26Dot6((double)n216 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray75 = tTGraphicsState.getFVMoveforPVDistance(n217);
                            int[] nArray76 = this.x[tTGraphicsState.zp0];
                            int n218 = n213;
                            nArray76[n218] = nArray76[n218] + nArray75[0];
                            int[] nArray77 = this.y[tTGraphicsState.zp0];
                            int n219 = n213;
                            nArray77[n219] = nArray77[n219] + nArray75[1];
                            int[] nArray78 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray78[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n213][0] = true;
                            }
                            if (nArray78[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n213][1] = true;
                            }
                        }
                        ++n212;
                    }
                    return n2;
                }
                case 114: {
                    int n220 = this.stack.pop();
                    int n221 = 0;
                    while (n221 < n220) {
                        int n222 = this.stack.pop();
                        int n223 = this.stack.pop();
                        int n224 = tTGraphicsState.deltaBase + 32 + (n223 >> 4);
                        if ((double)n224 == this.ppem) {
                            int n225 = (n223 & 0xF) - 7;
                            if (n225 <= 0) {
                                --n225;
                            }
                            int n226 = TTVM.storeDoubleAsF26Dot6((double)n225 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int[] nArray79 = tTGraphicsState.getFVMoveforPVDistance(n226);
                            int[] nArray80 = this.x[tTGraphicsState.zp0];
                            int n227 = n222;
                            nArray80[n227] = nArray80[n227] + nArray79[0];
                            int[] nArray81 = this.y[tTGraphicsState.zp0];
                            int n228 = n222;
                            nArray81[n228] = nArray81[n228] + nArray79[1];
                            int[] nArray82 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                            if (nArray82[0] != 0) {
                                this.touched[tTGraphicsState.zp0][n222][0] = true;
                            }
                            if (nArray82[1] != 0) {
                                this.touched[tTGraphicsState.zp0][n222][1] = true;
                            }
                        }
                        ++n221;
                    }
                    return n2;
                }
                case 115: {
                    int n229 = this.stack.pop();
                    int n230 = 0;
                    while (n230 < n229) {
                        int n231 = this.stack.pop();
                        int n232 = this.stack.pop();
                        int n233 = tTGraphicsState.deltaBase + (n232 >> 4);
                        if ((double)n233 == this.ppem) {
                            int n234 = (n232 & 0xF) - 7;
                            if (n234 <= 0) {
                                --n234;
                            }
                            int n235 = TTVM.storeDoubleAsF26Dot6((double)n234 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n236 = this.cvt.get(n231);
                            this.cvt.putInPixels(n231, n236 += n235);
                        }
                        ++n230;
                    }
                    return n2;
                }
                case 116: {
                    int n237 = this.stack.pop();
                    int n238 = 0;
                    while (n238 < n237) {
                        int n239 = this.stack.pop();
                        int n240 = this.stack.pop();
                        int n241 = tTGraphicsState.deltaBase + 16 + (n240 >> 4);
                        if ((double)n241 == this.ppem) {
                            int n242 = (n240 & 0xF) - 7;
                            if (n242 <= 0) {
                                --n242;
                            }
                            int n243 = TTVM.storeDoubleAsF26Dot6((double)n242 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n244 = this.cvt.get(n239);
                            this.cvt.putInPixels(n239, n244 += n243);
                        }
                        ++n238;
                    }
                    return n2;
                }
                case 117: {
                    int n245 = this.stack.pop();
                    int n246 = 0;
                    while (n246 < n245) {
                        int n247 = this.stack.pop();
                        int n248 = this.stack.pop();
                        int n249 = tTGraphicsState.deltaBase + 32 + (n248 >> 4);
                        if ((double)n249 == this.ppem) {
                            int n250 = (n248 & 0xF) - 7;
                            if (n250 <= 0) {
                                --n250;
                            }
                            int n251 = TTVM.storeDoubleAsF26Dot6((double)n250 * (1.0 / Math.pow(2.0, tTGraphicsState.deltaShift)));
                            int n252 = this.cvt.get(n247);
                            this.cvt.putInPixels(n247, n252 += n251);
                        }
                        ++n246;
                    }
                    return n2;
                }
                case 118: {
                    tTGraphicsState.roundState = this.stack.pop();
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 119: {
                    tTGraphicsState.roundState = this.stack.pop();
                    tTGraphicsState.gridPeriod = 0.7071067811865476;
                    return n2;
                }
                case 120: {
                    boolean bl = this.stack.pop() != 0;
                    int n253 = this.stack.pop();
                    if (!bl) return n2;
                    return n2 + n253 - 1;
                }
                case 121: {
                    boolean bl = this.stack.pop() != 0;
                    int n254 = this.stack.pop();
                    if (bl) return n2;
                    return n2 + n254 - 1;
                }
                case 122: {
                    tTGraphicsState.roundState = -1;
                    return n2;
                }
                case 124: {
                    tTGraphicsState.roundState = 64;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 125: {
                    tTGraphicsState.roundState = 68;
                    tTGraphicsState.gridPeriod = 1.0;
                    return n2;
                }
                case 126: {
                    this.stack.pop();
                    return n2;
                }
                case 127: {
                    this.stack.pop();
                    return n2;
                }
                case 128: {
                    for (int i = 0; i < tTGraphicsState.loop; ++i) {
                        int n255 = this.stack.pop();
                        this.curve[tTGraphicsState.zp0][n255] = !this.curve[tTGraphicsState.zp0][n255];
                    }
                    tTGraphicsState.loop = 1;
                    return n2;
                }
                case 129: {
                    int n256;
                    int n257 = this.stack.pop();
                    int n258 = n256 = this.stack.pop();
                    while (n258 <= n257) {
                        this.curve[tTGraphicsState.zp0][n258] = true;
                        ++n258;
                    }
                    return n2;
                }
                case 130: {
                    int n259;
                    int n260 = this.stack.pop();
                    int n261 = n259 = this.stack.pop();
                    while (n261 <= n260) {
                        this.curve[tTGraphicsState.zp0][n261] = false;
                        ++n261;
                    }
                    return n2;
                }
                case 133: {
                    this.stack.pop();
                    return n2;
                }
                case 134: {
                    int n262 = this.stack.pop();
                    int n263 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n262] - this.x[tTGraphicsState.zp1][n263]);
                    double d16 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n262] - this.y[tTGraphicsState.zp1][n263]);
                    double d17 = TTVM.getDoubleFromF26Dot6(this.x[2 + tTGraphicsState.zp2][n262] - this.x[2 + tTGraphicsState.zp1][n263]);
                    double d18 = TTVM.getDoubleFromF26Dot6(this.y[2 + tTGraphicsState.zp2][n262] - this.y[2 + tTGraphicsState.zp1][n263]);
                    double d19 = Math.sqrt(d * d + d16 * d16);
                    double d20 = Math.sqrt(d17 * d17 + d18 * d18);
                    tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d /= d19), TTVM.storeDoubleAsF2Dot14(d16 /= d19));
                    tTGraphicsState.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d17 /= d20), TTVM.storeDoubleAsF2Dot14(d18 /= d20));
                    return n2;
                }
                case 135: {
                    int n264 = this.stack.pop();
                    int n265 = this.stack.pop();
                    double d = TTVM.getDoubleFromF26Dot6(this.x[tTGraphicsState.zp2][n264] - this.x[tTGraphicsState.zp1][n265]);
                    double d21 = TTVM.getDoubleFromF26Dot6(this.y[tTGraphicsState.zp2][n264] - this.y[tTGraphicsState.zp1][n265]);
                    double d22 = TTVM.getDoubleFromF26Dot6(this.x[2 + tTGraphicsState.zp2][n264] - this.x[2 + tTGraphicsState.zp1][n265]);
                    double d23 = TTVM.getDoubleFromF26Dot6(this.y[2 + tTGraphicsState.zp2][n264] - this.y[2 + tTGraphicsState.zp1][n265]);
                    double d24 = Math.sqrt(d * d + d21 * d21);
                    double d25 = Math.sqrt(d22 * d22 + d23 * d23);
                    tTGraphicsState.projectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d21 /= d24), TTVM.storeDoubleAsF2Dot14(-(d /= d24)));
                    tTGraphicsState.dualProjectionVector = TTGraphicsState.createVector(TTVM.storeDoubleAsF2Dot14(d23 /= d25), TTVM.storeDoubleAsF2Dot14(-(d22 /= d25)));
                    return n2;
                }
                case 136: {
                    int n266 = this.stack.pop();
                    int n267 = 0;
                    if ((n266 & 1) == 1) {
                        n267 += 3;
                    }
                    this.stack.push(n267);
                    return n2;
                }
                case 137: {
                    int n268;
                    int n269 = this.stack.pop();
                    int n270 = n2;
                    while ((n268 = nArray[++n2]) != 45) {
                    }
                    int n271 = n2 - n270 - 1;
                    n2 = n270;
                    int[] nArray83 = new int[n271];
                    for (int i = 0; i < n271; ++i) {
                        nArray83[i] = nArray[++n2];
                    }
                    this.instructions.put(n269, nArray83);
                    ++n2;
                    return n2;
                }
                case 138: {
                    int n272 = this.stack.pop();
                    int n273 = this.stack.pop();
                    int n274 = this.stack.pop();
                    this.stack.push(n273);
                    this.stack.push(n272);
                    this.stack.push(n274);
                    return n2;
                }
                case 139: {
                    int n275 = this.stack.pop();
                    int n276 = this.stack.pop();
                    if (n275 > n276) {
                        this.stack.push(n275);
                        return n2;
                    }
                    this.stack.push(n276);
                    return n2;
                }
                case 140: {
                    int n277 = this.stack.pop();
                    int n278 = this.stack.pop();
                    if (n277 < n278) {
                        this.stack.push(n277);
                        return n2;
                    }
                    this.stack.push(n278);
                    return n2;
                }
                case 141: {
                    this.stack.pop();
                    return n2;
                }
                case 142: {
                    int n279 = this.stack.pop();
                    int n280 = this.stack.pop();
                    if (n279 == 1) {
                        tTGraphicsState.instructControl = n280;
                        return n2;
                    }
                    if (n279 != 2) return n2;
                    this.useDefaultGS = n280 == 2;
                    return n2;
                }
                case 176: {
                    if (!this.printOut) return this.readFromIS(n3, false, n2, nArray);
                    System.out.println("PUSHB1    - Push bytes from IS to stack");
                    return this.readFromIS(n3, false, n2, nArray);
                }
                case 184: {
                    if (!this.printOut) return this.readFromIS(n3, true, n2, nArray);
                    System.out.println("PUSHW1    - Push words from IS to stack");
                    return this.readFromIS(n3, true, n2, nArray);
                }
                default: {
                    if (n >= 192 && n < 224) {
                        int n281 = n - 192;
                        if (this.printOut) {
                            System.out.println("MDRP      - Move direct relative point (" + Integer.toBinaryString(n281) + ')');
                        }
                        boolean bl = false;
                        boolean bl7 = false;
                        boolean bl8 = false;
                        if ((n281 & 0x10) == 16) {
                            bl = true;
                        }
                        if ((n281 & 8) == 8) {
                            bl7 = true;
                        }
                        if ((n281 & 4) == 4) {
                            bl8 = true;
                        }
                        int n282 = n281 & 3;
                        int n283 = this.stack.pop();
                        int n284 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n283], this.y[2 + tTGraphicsState.zp1][n283]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        if (Math.abs(n284) < tTGraphicsState.singleWidthCutIn) {
                            n284 = n284 > 0 ? tTGraphicsState.singleWidthValue : -tTGraphicsState.singleWidthValue;
                        }
                        n284 = TTVM.engineCompensation(n284, n282);
                        if (bl8) {
                            n284 = TTVM.storeDoubleAsF26Dot6(tTGraphicsState.round(TTVM.getDoubleFromF26Dot6(n284)));
                        }
                        if (bl7 && Math.abs(n284) < tTGraphicsState.minimumDistance) {
                            n284 = n284 < 0 ? -tTGraphicsState.minimumDistance : tTGraphicsState.minimumDistance;
                        }
                        int n285 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]) + n284;
                        int n286 = n285 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n283], this.y[tTGraphicsState.zp1][n283]);
                        int[] nArray84 = tTGraphicsState.getFVMoveforPVDistance(n286);
                        int[] nArray85 = this.x[tTGraphicsState.zp1];
                        int n287 = n283;
                        nArray85[n287] = nArray85[n287] + nArray84[0];
                        int[] nArray86 = this.y[tTGraphicsState.zp1];
                        int n288 = n283;
                        nArray86[n288] = nArray86[n288] + nArray84[1];
                        int[] nArray87 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray87[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n283][0] = true;
                        }
                        if (nArray87[1] != 0) {
                            this.touched[tTGraphicsState.zp1][n283][1] = true;
                        }
                        tTGraphicsState.rp1 = tTGraphicsState.rp0;
                        tTGraphicsState.rp2 = n283;
                        if (!bl) return n2;
                        tTGraphicsState.rp0 = n283;
                        return n2;
                    }
                    if (n >= 224 && n <= 255) {
                        int n289 = n - 224;
                        if (this.printOut) {
                            System.out.println("MIRP      - Move Indirect Relative Point(" + Integer.toBinaryString(n289) + ')');
                        }
                        boolean bl = false;
                        boolean bl9 = false;
                        boolean bl10 = false;
                        if ((n289 & 0x10) == 16) {
                            bl = true;
                        }
                        if ((n289 & 8) == 8) {
                            bl9 = true;
                        }
                        if ((n289 & 4) == 4) {
                            bl10 = true;
                        }
                        int n290 = n289 & 3;
                        int n291 = this.cvt.get(this.stack.pop());
                        int n292 = this.stack.pop();
                        int n293 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp1][n292], this.y[2 + tTGraphicsState.zp1][n292]) - TTGraphicsState.getCoordsOnVector(tTGraphicsState.dualProjectionVector, this.x[2 + tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[2 + tTGraphicsState.zp0][tTGraphicsState.rp0]);
                        if (Math.abs(n293 - tTGraphicsState.singleWidthValue) < tTGraphicsState.singleWidthCutIn) {
                            n293 = tTGraphicsState.singleWidthValue;
                        }
                        if (bl10) {
                            if (tTGraphicsState.autoFlip && (n293 < 0 && n291 > 0 || n293 > 0 && n291 < 0)) {
                                n291 = -n291;
                            }
                            if (Math.abs(n293 - n291) < tTGraphicsState.controlValueTableCutIn) {
                                n293 = n291;
                            }
                        }
                        n293 = TTVM.engineCompensation(n293, n290);
                        if (bl10) {
                            n293 = tTGraphicsState.round(n293);
                        }
                        if (bl9 && Math.abs(n293) < tTGraphicsState.minimumDistance) {
                            n293 = n293 > 0 ? tTGraphicsState.minimumDistance : -tTGraphicsState.minimumDistance;
                        }
                        int n294 = TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp0][tTGraphicsState.rp0], this.y[tTGraphicsState.zp0][tTGraphicsState.rp0]) + n293;
                        int n295 = n294 - TTGraphicsState.getCoordsOnVector(tTGraphicsState.projectionVector, this.x[tTGraphicsState.zp1][n292], this.y[tTGraphicsState.zp1][n292]);
                        int[] nArray88 = tTGraphicsState.getFVMoveforPVDistance(n295);
                        int[] nArray89 = this.x[tTGraphicsState.zp1];
                        int n296 = n292;
                        nArray89[n296] = nArray89[n296] + nArray88[0];
                        int[] nArray90 = this.y[tTGraphicsState.zp1];
                        int n297 = n292;
                        nArray90[n297] = nArray90[n297] + nArray88[1];
                        int[] nArray91 = TTGraphicsState.getVectorComponents(tTGraphicsState.freedomVector);
                        if (nArray91[0] != 0) {
                            this.touched[tTGraphicsState.zp1][n292][0] = true;
                        }
                        if (nArray91[1] != 0) {
                            this.touched[tTGraphicsState.zp1][n292][1] = true;
                        }
                        tTGraphicsState.rp1 = tTGraphicsState.rp0;
                        tTGraphicsState.rp2 = n292;
                        if (!bl) return n2;
                        tTGraphicsState.rp0 = n292;
                        return n2;
                    }
                    if (!this.instructions.containsKey(n)) return n2;
                    if (this.printOut) {
                        System.out.println("I 0x" + Integer.toHexString(n) + "    - Custom Instruction");
                    }
                    this.execute(this.instructions.get(n), tTGraphicsState);
                    if (!this.printOut) return n2;
                    System.out.println("I 0x" + Integer.toHexString(n) + " finished");
                }
            }
            return n2;
        }
        catch (Exception exception) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
            BaseTTGlyph.useHinting = false;
            BaseTTGlyph.redecodePage = true;
        }
        return n2;
    }

    private void interpolateUntouchedPoints(int n) {
        int n2;
        int n3;
        int[] nArray;
        int[] nArray2;
        boolean[] blArray = new boolean[this.touched[1].length];
        if (n == 49) {
            nArray2 = this.x[1];
            nArray = this.x[3];
            for (n3 = 0; n3 < this.touched[1].length; ++n3) {
                blArray[n3] = this.touched[1][n3][0];
            }
        } else {
            nArray2 = this.y[1];
            nArray = this.y[3];
            for (n3 = 0; n3 < this.touched[1].length; ++n3) {
                blArray[n3] = this.touched[1][n3][1];
            }
        }
        for (n3 = 0; n3 < nArray2.length; n3 += n2) {
            int n4;
            int[] nArray3 = new int[nArray.length];
            int n5 = 0;
            n2 = 0;
            do {
                if (!blArray[n3 + n2]) continue;
                nArray3[n5] = n3 + n2;
                ++n5;
            } while (!this.contour[1][n3 + ++n2 - 1] && n3 + n2 < this.contour[1].length);
            if (n5 == 1) {
                n4 = nArray2[nArray3[0]] - nArray[nArray3[0]];
                for (int i = n3; i < n3 + n2; ++i) {
                    if (blArray[i]) continue;
                    int n6 = i;
                    nArray2[n6] = nArray2[n6] + n4;
                }
                continue;
            }
            if (n5 <= 1) continue;
            for (n4 = 0; n4 < n5; ++n4) {
                if (n4 + 1 >= n5) {
                    TTVM.interpolateRange(nArray3[n4] + 1, n3 + n2 - 1, nArray3[n4], nArray3[0], nArray2, nArray);
                    TTVM.interpolateRange(n3, nArray3[0] - 1, nArray3[n4], nArray3[0], nArray2, nArray);
                    continue;
                }
                TTVM.interpolateRange(nArray3[n4] + 1, nArray3[n4 + 1] - 1, nArray3[n4], nArray3[n4 + 1], nArray2, nArray);
            }
        }
    }

    private static void interpolateRange(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        int n5;
        int n6;
        if (nArray2[n4] < nArray2[n3]) {
            n6 = n4;
            n5 = n3;
        } else {
            n6 = n3;
            n5 = n4;
        }
        for (int i = n; i <= n2; ++i) {
            if (nArray2[i] < nArray2[n6]) {
                int n7 = i;
                nArray[n7] = nArray[n7] + (nArray[n6] - nArray2[n6]);
                continue;
            }
            if (nArray2[i] > nArray2[n5]) {
                int n8 = i;
                nArray[n8] = nArray[n8] + (nArray[n5] - nArray2[n5]);
                continue;
            }
            double d = (double)(nArray2[i] - nArray2[n6]) / (double)(nArray2[n5] - nArray2[n6]);
            nArray[i] = nArray[n6] + (int)(d * (double)(nArray[n5] - nArray[n6]));
        }
    }

    private static int engineCompensation(int n, int n2) {
        return n;
    }

    private int readFromIS(int n, boolean bl, int n2, int[] nArray) {
        for (int i = 0; i < n; ++i) {
            int n3;
            ++n2;
            if (!bl) {
                n3 = nArray[n2];
            } else {
                int n4 = nArray[n2];
                int n5 = nArray[++n2];
                n3 = TTVM.getIntFrom2Uint8(n4, n5);
            }
            this.stack.push(n3);
        }
        return n2;
    }

    protected static int getIntFrom2Uint8(int n, int n2) {
        return (n << 8) + n2 + (n >> 7 & 1) * -65536;
    }

    protected static double getDoubleFromF26Dot6(int n) {
        return (double)n / 64.0;
    }

    protected static double getDoubleFromF2Dot14(int n) {
        return (double)n / 16384.0;
    }

    protected static int storeDoubleAsF26Dot6(double d) {
        return (int)(d * 64.0 + 0.5);
    }

    protected static int storeDoubleAsF2Dot14(double d) {
        return (int)(d * 16384.0 + 0.5);
    }

    private static int[] readProgramTable(FontFile2 fontFile2, int n) {
        int[] nArray = new int[]{};
        int n2 = fontFile2.selectTable(n);
        if (n2 == 0) {
            if (LogWriter.isOutput()) {
                LogWriter.writeLog("No program table found: " + n);
            }
        } else {
            int n3 = fontFile2.getOffset(n);
            nArray = new int[n3];
            for (int i = 0; i < n3; ++i) {
                nArray[i] = fontFile2.getNextUint8();
            }
        }
        return nArray;
    }

    private static class Stack
    implements Serializable {
        private int pointer;
        private int[] stack = new int[10];

        Stack() {
        }

        public void push(int n) {
            if (this.pointer >= this.stack.length) {
                int[] nArray = new int[(int)((double)this.stack.length * 1.5)];
                System.arraycopy(this.stack, 0, nArray, 0, this.stack.length);
                this.stack = nArray;
            }
            this.stack[this.pointer] = n;
            ++this.pointer;
        }

        public int pop() {
            --this.pointer;
            if (this.pointer >= 0) {
                return this.stack[this.pointer];
            }
            throw new RuntimeException("Popped an empty stack!");
        }

        public int size() {
            return this.pointer;
        }

        public int elementAt(int n) {
            return this.stack[this.pointer - n];
        }

        public int remove(int n) {
            int n2 = this.pointer - n;
            int n3 = this.stack[n2];
            int[] nArray = new int[this.stack.length];
            System.arraycopy(this.stack, 0, nArray, 0, n2);
            System.arraycopy(this.stack, n2 + 1, nArray, n2, this.stack.length - n2 - 1);
            this.stack = nArray;
            --this.pointer;
            return n3;
        }
    }
}

