/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.util.HashMap;
import org.jpedal.io.ObjectDecoder;
import org.jpedal.io.PdfFileReader;
import org.jpedal.objects.Javascript;
import org.jpedal.objects.raw.NamesObject;
import org.jpedal.objects.raw.PdfArrayIterator;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.StringUtils;

public class NameLookup
extends HashMap {
    private final PdfFileReader objectReader;

    public NameLookup(PdfFileReader pdfFileReader) {
        this.objectReader = pdfFileReader;
    }

    public void readNames(PdfObject pdfObject, Javascript javascript, boolean bl) {
        ObjectDecoder objectDecoder = new ObjectDecoder(this.objectReader);
        objectDecoder.checkResolved(pdfObject);
        int[] nArray = new int[]{893600855, -2006286978, 1195921064};
        int n = nArray.length;
        if (bl) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            PdfArrayIterator pdfArrayIterator;
            int n2;
            PdfObject pdfObject2 = bl ? pdfObject : pdfObject.getDictionary(nArray[i]);
            if (pdfObject2 == null) continue;
            byte[][] byArray = pdfObject2.getKeyArray(456733763);
            if (byArray != null && (n2 = byArray.length) > 0) {
                for (byte[] byArray2 : byArray) {
                    String string = new String(byArray2);
                    NamesObject namesObject = new NamesObject(string);
                    namesObject.ignoreRecursion(false);
                    this.objectReader.readObject(namesObject);
                    this.readNames(namesObject, javascript, true);
                }
            }
            if ((pdfArrayIterator = pdfObject2.getMixedArray(826094945)) == null || pdfArrayIterator.getTokenCount() <= 0) continue;
            block6: while (pdfArrayIterator.hasMoreTokens()) {
                String string = pdfArrayIterator.getNextValueAsString(true);
                if (!pdfArrayIterator.hasMoreTokens()) continue;
                String string2 = pdfArrayIterator.getNextValueAsString(true);
                switch (nArray[i]) {
                    case -2006286978: {
                        NameLookup.setJavaScriptName(string2, objectDecoder, javascript, string);
                        continue block6;
                    }
                    case 1195921064: {
                        this.setXFAImage(string2, objectDecoder, string);
                        continue block6;
                    }
                }
                this.put(string, string2);
            }
        }
    }

    private void setXFAImage(String string, ObjectDecoder objectDecoder, String string2) {
        XObject xObject = new XObject(string);
        xObject.decompressStreamWhenRead();
        byte[] byArray = StringUtils.toBytes(string);
        if (byArray[0] == 60) {
            xObject.setStatus(2);
        } else {
            xObject.setStatus(1);
        }
        if (string.contains(" ") || string.contains("<")) {
            xObject.setUnresolvedData(byArray, 979194486);
            objectDecoder.checkResolved(xObject);
            byte[] byArray2 = this.objectReader.readStream(xObject, true, true, false, false, false, null);
            this.put(string2, byArray2);
        }
    }

    static void setJavaScriptName(String string, ObjectDecoder objectDecoder, Javascript javascript, String string2) {
        String string3;
        NamesObject namesObject = new NamesObject(string);
        byte[] byArray = StringUtils.toBytes(string);
        if (byArray[0] == 60) {
            namesObject.setStatus(2);
        } else {
            namesObject.setStatus(1);
        }
        if (string.contains(" ") || string.contains("<")) {
            namesObject.setUnresolvedData(byArray, 6691);
            objectDecoder.checkResolved(namesObject);
            PdfObject pdfObject = ((PdfObject)namesObject).getDictionary(6691);
            string3 = pdfObject != null ? new String(pdfObject.getDecodedStream()) : ((PdfObject)namesObject).getTextStreamValue(6691);
        } else {
            string3 = string;
        }
        if (string3 != null) {
            javascript.setCode(string2, string3);
        }
    }
}

