/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io;

import java.io.Serializable;
import org.jpedal.io.DecryptionFactory;
import org.jpedal.io.ObjectUtils;
import org.jpedal.io.PdfFileReader;
import org.jpedal.io.PdfObjectFactory;
import org.jpedal.io.types.Array;
import org.jpedal.io.types.BooleanValue;
import org.jpedal.io.types.Dictionary;
import org.jpedal.io.types.FloatValue;
import org.jpedal.io.types.Form;
import org.jpedal.io.types.General;
import org.jpedal.io.types.Name;
import org.jpedal.io.types.NumberValue;
import org.jpedal.io.types.Stream;
import org.jpedal.io.types.StringValue;
import org.jpedal.io.types.TextStream;
import org.jpedal.objects.raw.ObjectFactory;
import org.jpedal.objects.raw.PdfDictionary;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.utils.NumberUtils;
import org.jpedal.utils.StringUtils;

public class ObjectDecoder
implements Serializable {
    public PdfFileReader objectReader;
    public DecryptionFactory decryption;
    private Object PDFkey;
    static final byte[] endPattern = new byte[]{101, 110, 100, 111, 98, 106};
    public static final boolean debugFastCode = false;
    private int pdfKeyType;
    private int PDFkeyInt;
    public static String padding = "";
    boolean isInlineImage;
    private int endPt = -1;

    public ObjectDecoder(PdfFileReader pdfFileReader) {
        this.init(pdfFileReader);
    }

    private void init(PdfFileReader pdfFileReader) {
        this.objectReader = pdfFileReader;
        this.decryption = pdfFileReader.getDecryptionObject();
    }

    public int readDictionaryAsObject(PdfObject pdfObject, int n, byte[] byArray) {
        if (this.endPt == -1) {
            this.endPt = byArray.length;
        }
        int n2 = byArray.length;
        n = this.readObjectDataValues(pdfObject, n, byArray, n2);
        if (!pdfObject.ignoreStream() && pdfObject.getGeneralType(-1) != 6420) {
            Stream.readStreamData(pdfObject, n, byArray, n2, this.objectReader);
        }
        if (pdfObject.getObjectType() == 373244477) {
            Form.setFieldNames(pdfObject, this.objectReader);
        }
        return n;
    }

    private int readObjectDataValues(PdfObject pdfObject, int n, byte[] byArray, int n2) {
        int n3 = 0;
        if (this.isInlineImage) {
            n3 = 1;
        }
        while (true) {
            if (n < n2 && byArray[n] == 37) {
                n = ObjectDecoder.stripComment(n2, n, byArray);
            }
            if (n >= n2 || this.endPt != -1 && n >= this.endPt || byArray[n] == 101 && byArray[n + 1] == 110 && byArray[n + 2] == 100 && byArray[n + 3] == 111 || byArray[n] == 115 && byArray[n + 1] == 116 && byArray[n + 2] == 114 && byArray[n + 3] == 101 && byArray[n + 4] == 97 && byArray[n + 5] == 109) break;
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                ++n;
                ++n3;
            } else if (byArray[n] == 62 && n + 1 != n2 && byArray[n + 1] == 62 && byArray[n - 1] != 62) {
                ++n;
                if (--n3 == 0) {
                    break;
                }
            } else if (byArray[n] == 47 && (byArray[n + 1] == 47 || byArray[n + 1] == 32)) {
                ++n;
            } else if (byArray[n] == 47) {
                int n4;
                int n5 = ++n;
                if ((n += (n4 = Dictionary.findDictionaryEnd(n, byArray, n2))) == n2) break;
                boolean bl = false;
                if (pdfObject.getID() == 1184787) {
                    bl = Dictionary.isStringPair(n, byArray, bl);
                }
                int n6 = pdfObject.getObjectType();
                boolean bl2 = this.isMapObject(pdfObject, n, byArray, n2, n5, n4, bl, n6);
                if (byArray[n] == 47 || byArray[n] == 40 || byArray[n] == 91 && byArray[n + 1] != 93) {
                    --n;
                }
                if (this.pdfKeyType == -1) {
                    n = ObjectUtils.handleUnknownType(n, byArray, n2);
                }
                if (this.PDFkeyInt != -1 && this.pdfKeyType != -1) {
                    n = this.setValue(pdfObject, n, byArray, n2, bl2);
                }
            } else if (byArray[n] == 91 && n3 == 0 && pdfObject.getObjectType() == 1485011327) {
                Array array = new Array(this.objectReader, n, byArray.length, 18, null, 826094945);
                array.readArray(false, byArray, pdfObject, 339034948);
            }
            ++n;
        }
        return n;
    }

    private boolean isMapObject(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, boolean bl, int n5) {
        boolean bl2;
        if (n5 == 487790868 && (pdfObject.getID() == 893350012 || pdfObject.getID() == 1184787 && bl || pdfObject.getID() == 17 && byArray[n - 2] == 47)) {
            this.pdfKeyType = 30;
            this.PDFkey = PdfDictionary.getKey(n3, n4, byArray);
            this.PDFkeyInt = 487790868;
            bl2 = true;
        } else {
            bl2 = false;
            this.PDFkey = null;
            this.getKeyType(pdfObject, n, byArray, n2, n4, n3, n5);
        }
        return bl2;
    }

    private void getKeyType(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, int n4, int n5) {
        int n6;
        this.PDFkeyInt = PdfDictionary.getIntKey(n4, n3, byArray);
        if (this.PDFkeyInt == 895578984 && (n5 == 7451 || n5 == 373244477 || n5 == 2004845231 || n5 == 1111442775)) {
            this.PDFkeyInt = 25;
        }
        if (this.isInlineImage) {
            this.PDFkeyInt = PdfObjectFactory.getInlineID(this.PDFkeyInt);
        }
        int n7 = pdfObject.getID();
        if (n5 == 2004251818 && (this.PDFkeyInt == 2087749783 || this.PDFkeyInt == -1938465939 || this.PDFkeyInt == 878474856 || this.PDFkeyInt == 979194486 || this.PDFkeyInt == 373243460 || this.PDFkeyInt == 1146450818)) {
            this.pdfKeyType = 2;
        } else if (n5 == 1485011327 && this.PDFkeyInt == 20) {
            this.PDFkeyInt = 339034948;
            this.pdfKeyType = 18;
        } else if ((n5 == 373244477 || n5 == 7451) && this.PDFkeyInt == 20) {
            if (n7 == 4384 || n7 == 4369) {
                this.pdfKeyType = 40;
            } else if (n7 == 2570558) {
                this.pdfKeyType = 25;
            } else {
                this.PDFkeyInt = 339034948;
                this.pdfKeyType = 18;
            }
        } else {
            this.pdfKeyType = !(n5 != 373244477 && n5 != 7451 || n7 != 4384 && n7 != 4369 || this.PDFkeyInt != 17) ? 40 : (this.PDFkeyInt == 1110717793 && n5 == -1567847737 ? 22 : (this.PDFkeyInt == 506543413 && n5 == -1567847737 ? 25 : ((n5 == 2087749783 || n5 == 1518239089) && this.PDFkeyInt == 30 ? 7 : (this.PDFkeyInt == 826096968 && n5 == 2087749783 && pdfObject.getParameterConstant(2087749783) == 391471749 ? 7 : (n7 == 2570558 && pdfObject.getObjectType() == 373244477 && (this.PDFkeyInt == 32 || this.PDFkeyInt == 31) ? 25 : (this.isInlineImage && this.PDFkeyInt == 2087749783 ? 1 : PdfDictionary.getKeyType(this.PDFkeyInt, n5)))))));
        }
        if (n7 == 878474856 && this.PDFkeyInt == 1518239089) {
            n6 = n;
            while (byArray[n6] >= 48 && byArray[n6] < 58 || byArray[n6] == 32) {
                ++n6;
            }
            if (byArray[n6] == 91) {
                this.pdfKeyType = 14;
            }
        }
        if (this.pdfKeyType == -1 && n7 == 1448698499) {
            this.pdfKeyType = Dictionary.getPairedValues(pdfObject, n, byArray, this.pdfKeyType, n2, n3, n4);
        } else if ((n7 == 30 || n7 == 20 || n7 == 34) && pdfObject.getParentID() == 4384 && pdfObject.getObjectType() == 373244477 && byArray[n] != 91) {
            n6 = n;
            while (byArray[n6] >= 48 && byArray[n6] < 58 || byArray[n6] == 32) {
                ++n6;
            }
            if (!(byArray[n4] == 76 && byArray[n4 + 1] == 101 && byArray[n4 + 2] == 110 && byArray[n4 + 3] == 103 && byArray[n4 + 4] == 116 && byArray[n4 + 5] == 104 || byArray[n4] == 79 && byArray[n4 + 1] == 110 || byArray[n4] == 79 && byArray[n4 + 1] == 102 && byArray[n4 + 2] == 102 || byArray[n6] != 82)) {
                this.pdfKeyType = Dictionary.getPairedValues(pdfObject, n, byArray, this.pdfKeyType, n2, n3, n4);
            }
        }
        if (this.PDFkeyInt == 1888135062) {
            this.pdfKeyType = ObjectDecoder.setTypeForDecodeParams(n, byArray, n2, this.pdfKeyType);
        }
    }

    private int setValue(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl) {
        boolean bl2 = pdfObject.ignoreRecursion();
        if (this.pdfKeyType == 5 && pdfObject.isDataExternal()) {
            this.pdfKeyType = 1;
        }
        switch (this.pdfKeyType) {
            case 25: {
                n = TextStream.setTextStreamValue(pdfObject, n, byArray, bl2, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 35: {
                n = Name.setNameTreeValue(pdfObject, n, byArray, n2, bl2, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 2: {
                n = Dictionary.setDictionaryValue(pdfObject, n, byArray, n2, bl2, this.objectReader, this.PDFkeyInt);
                break;
            }
            case 20: {
                Array array = new Array(this.objectReader, n, this.endPt, 20);
                n = array.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 12: {
                Array array = new Array(this.objectReader, n, this.endPt, 12);
                n = array.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 14: {
                Array array = new Array(this.objectReader, n, this.endPt, 14);
                n = array.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 18: {
                Array array = new Array(this.objectReader, n, this.endPt, 18);
                n = array.readArray(bl2, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 22: {
                Array array = new Array(this.objectReader, n, this.endPt, 22);
                n = array.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 16: {
                Array array = new Array(this.objectReader, n, this.endPt, 16);
                n = array.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 9: {
                Array array = new Array(this.objectReader, n, this.endPt, 9);
                n = array.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 10: {
                Array array = new Array(this.objectReader, n, this.endPt, 10);
                n = array.readArray(false, byArray, pdfObject, this.PDFkeyInt);
                break;
            }
            case 30: {
                n = Name.setNameStringValue(pdfObject, n, byArray, bl, this.PDFkey, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 8: {
                n = BooleanValue.set(pdfObject, n, byArray, this.PDFkeyInt);
                break;
            }
            case 3: {
                n = StringValue.setStringConstantValue(pdfObject, n, byArray, this.PDFkeyInt);
                break;
            }
            case 4: {
                n = StringValue.setStringKeyValue(pdfObject, n, byArray, this.PDFkeyInt);
                break;
            }
            case 6: {
                ++n;
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47) {
                    ++n;
                }
                n = NumberValue.setNumberValue(pdfObject, n, byArray, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 7: {
                n = FloatValue.setFloatValue(pdfObject, n, byArray, n2, this.PDFkeyInt, this.objectReader);
                break;
            }
            case 5: {
                n = this.setUnreadDictionaryValue(pdfObject, n, byArray);
                break;
            }
            case 40: {
                if (byArray.length - 5 > 0 && byArray[n + 1] == 110 && byArray[n + 2] == 117 && byArray[n + 3] == 108 && byArray[n + 4] == 108) {
                    n += 5;
                    break;
                }
                n = this.setVariousValue(pdfObject, n, byArray, n2, this.PDFkeyInt, bl, bl2, this.objectReader);
                break;
            }
            case 1: {
                n = this.setDictionaryValue(pdfObject, n, byArray, bl2);
            }
        }
        return n;
    }

    static int stripComment(int n, int n2, byte[] byArray) {
        while (n2 < n && byArray[n2] != 10 && byArray[n2] != 13) {
            ++n2;
        }
        while (n2 < n && (byArray[n2] == 9 || byArray[n2] == 10 || byArray[n2] == 13 || byArray[n2] == 32 || byArray[n2] == 60)) {
            ++n2;
        }
        return n2;
    }

    int setVariousValue(PdfObject pdfObject, int n, byte[] byArray, int n2, int n3, boolean bl, boolean bl2, PdfFileReader pdfFileReader) {
        if (byArray[n] != 60) {
            ++n;
        }
        if (byArray[n] == 47) {
            n = Name.setNameStringValue(pdfObject, n, byArray, bl, this.PDFkey, n3, pdfFileReader);
        } else if (byArray[n] == 102 && byArray[n + 1] == 97 && byArray[n + 2] == 108 && byArray[n + 3] == 115 && byArray[n + 4] == 101) {
            pdfObject.setBoolean(n3, false);
            n += 4;
        } else if (byArray[n] == 116 && byArray[n + 1] == 114 && byArray[n + 2] == 117 && byArray[n + 3] == 101) {
            pdfObject.setBoolean(n3, true);
            n += 3;
        } else {
            n = byArray[n] == 40 || byArray[n] == 60 && byArray[n - 1] != 60 && byArray[n + 1] != 60 ? TextStream.readTextStream(pdfObject, n, byArray, n3, bl2, pdfFileReader) : (byArray[n] == 91 ? ObjectDecoder.setArray(pdfObject, n, byArray, n3, bl2, pdfFileReader, this.endPt) : (byArray[n] == 60 && byArray[n + 1] == 60 ? Dictionary.readDictionary(pdfObject, n, byArray, n3, bl2, pdfFileReader, this.isInlineImage) : General.readGeneral(pdfObject, n, byArray, n2, n3, bl, bl2, pdfFileReader, this.PDFkey, this.endPt)));
        }
        return n;
    }

    static int setArray(PdfObject pdfObject, int n, byte[] byArray, int n2, boolean bl, PdfFileReader pdfFileReader, int n3) {
        if (n2 == 2627089) {
            Array array = new Array(pdfFileReader, n, n3, 18);
            n = array.readArray(bl, byArray, pdfObject, n2);
        } else if (n2 == 27) {
            Array array = new Array(pdfFileReader, n, n3, 20);
            n = array.readArray(bl, byArray, pdfObject, n2);
        } else if (n2 == 19) {
            Array array = new Array(pdfFileReader, n, n3, 10);
            n = array.readArray(bl, byArray, pdfObject, n2);
        } else if (n2 == 521344835) {
            Array array = new Array(pdfFileReader, n, n3, 14);
            n = array.readArray(bl, byArray, pdfObject, n2);
        } else {
            Array array = new Array(pdfFileReader, n, n3, 20);
            n = array.readArray(bl, byArray, pdfObject, n2);
        }
        return n;
    }

    static int setTypeForDecodeParams(int n, byte[] byArray, int n2, int n3) {
        int n4;
        for (n4 = n; n4 < n2 && (byArray[n4] == 32 || byArray[n4] == 9 || byArray[n4] == 13 || byArray[n4] == 10); ++n4) {
        }
        if (byArray[n4] != 60) {
            while (n4 < n2 && (byArray[n4] == 32 || byArray[n4] == 9 || byArray[n4] == 13 || byArray[n4] == 10 || byArray[n4] == 91)) {
                ++n4;
            }
            if (byArray[n4] == 60 || byArray[n4] >= 48 && byArray[n4] <= 57) {
                n3 = 22;
            }
        }
        return n3;
    }

    private int setDictionaryValue(PdfObject pdfObject, int n, byte[] byArray, boolean bl) {
        boolean bl2;
        int n2 = n;
        int n3 = n;
        while (byArray[n3] == 10 || byArray[n3] == 32 || byArray[n3] == 9) {
            ++n3;
        }
        if (byArray[n3] == 110 && byArray[n3 + 1] == 117 && byArray[n3 + 2] == 108 && byArray[n3 + 3] == 108) {
            n = n3 + 4;
            return n;
        }
        if (byArray[n3] == 91 && byArray[n3 + 1] == 93) {
            n = n3;
            return n;
        }
        if (byArray[n] != 60 && byArray[n + 1] != 60) {
            n2 += 2;
        }
        boolean bl3 = true;
        boolean bl4 = bl2 = byArray[n2 - 1] == 47;
        while (bl3) {
            if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                int n4 = 1;
                ++n2;
                while (n4 > 0) {
                    if (byArray[n2] == 60 && byArray[n2 + 1] == 60) {
                        ++n4;
                        n2 += 2;
                        continue;
                    }
                    if (byArray[n2 - 1] == 62 && byArray[n2] == 62) {
                        if (--n4 <= 0) continue;
                        n2 += 2;
                        continue;
                    }
                    if (byArray[n2] == 40) {
                        ++n2;
                        while (byArray[n2] != 41 || ObjectUtils.isEscaped(byArray, n2)) {
                            ++n2;
                        }
                        continue;
                    }
                    ++n2;
                }
                bl3 = false;
                continue;
            }
            if (byArray[n2] == 82) {
                bl3 = false;
                continue;
            }
            if (bl2 && (byArray[n2] == 32 || byArray[n2] == 13 || byArray[n2] == 10 || byArray[n2] == 9)) {
                bl3 = false;
                continue;
            }
            if (byArray[n2] == 47) {
                bl3 = false;
                --n2;
                continue;
            }
            if (byArray[n2] == 62 && byArray[n2 + 1] == 62) {
                bl3 = false;
                --n2;
                continue;
            }
            ++n2;
        }
        Dictionary.readDictionary(pdfObject, n, byArray, this.PDFkeyInt, bl, this.objectReader, this.isInlineImage);
        return n2;
    }

    private int setUnreadDictionaryValue(PdfObject pdfObject, int n, byte[] byArray) {
        byte[] byArray2;
        int n2;
        if (byArray[n] != 60) {
            ++n;
        }
        while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 9) {
            ++n;
        }
        int n3 = n;
        PdfObject pdfObject2 = ObjectFactory.createObject(this.PDFkeyInt, pdfObject.getObjectRefAsString(), pdfObject.getObjectType(), pdfObject.getID());
        pdfObject2.setID(this.PDFkeyInt);
        if (byArray[n] != 110 || byArray[n + 1] != 117 || byArray[n + 2] != 108 || byArray[n + 3] != 108) {
            pdfObject.setDictionary(this.PDFkeyInt, pdfObject2);
        }
        int n4 = 2;
        if (byArray[n] == 47) {
            while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32 || byArray[n] == 47 || byArray[n] == 60) {
                ++n;
            }
            int n5 = n;
            int n6 = 0;
            while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                ++n;
                ++n6;
            }
            --n;
            n2 = pdfObject2.setConstant(this.PDFkeyInt, n5, n6, byArray);
            if (n2 == -1 || this.isInlineImage) {
                byArray2 = new byte[n6];
                System.arraycopy(byArray, n5, byArray2, 0, n6);
                String string = new String(byArray2);
                pdfObject2.setGeneralStringValue(string);
            }
            n4 = 0;
        } else if (byArray[n] != 101 || byArray[n + 1] != 110 || byArray[n + 2] != 100 || byArray[n + 3] != 111 || byArray[n + 4] != 98) {
            while (byArray[n] == 91 && this.PDFkeyInt != 2087749783 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                ++n;
            }
            if (byArray[n] == 60 && byArray[n + 1] == 60) {
                n += 2;
                n2 = 1;
                while (n2 > 0) {
                    if (byArray[n] == 60 && byArray[n + 1] == 60) {
                        n += 2;
                        ++n2;
                        continue;
                    }
                    if (byArray[n] == 40) {
                        ++n;
                        while (byArray[n] != 41 || ObjectUtils.isEscaped(byArray, n)) {
                            ++n;
                        }
                        continue;
                    }
                    if (byArray[n] == 62 && n + 1 == byArray.length) {
                        n2 = 0;
                        continue;
                    }
                    if (byArray[n] == 62 && byArray[n + 1] == 62) {
                        n += 2;
                        --n2;
                        continue;
                    }
                    ++n;
                }
            } else if (byArray[n] == 91) {
                ++n;
                n2 = 1;
                while (n2 > 0) {
                    if (byArray[n] == 40) {
                        ++n;
                        while (byArray[n] != 41 || ObjectUtils.isEscaped(byArray, n)) {
                            ++n;
                        }
                    } else if (byArray[n] == 91) {
                        ++n2;
                    } else if (byArray[n] == 93) {
                        --n2;
                    }
                    ++n;
                }
                --n;
            } else if (byArray[n] == 110 && byArray[n + 1] == 117 && byArray[n + 2] == 108 && byArray[n + 3] == 108) {
                n += 4;
            } else {
                n4 = 1;
                while ((byArray[n] != 82 || byArray[n - 1] == 101) && ++n != byArray.length) {
                }
                if (++n >= byArray.length) {
                    n = byArray.length - 1;
                }
            }
        }
        pdfObject2.setStatus(n4);
        if (n4 != 0) {
            n2 = n - n3;
            byArray2 = new byte[n2];
            System.arraycopy(byArray, n3, byArray2, 0, n2);
            if (byArray2[n2 - 1] == 82) {
                for (int i = 0; i < n2; ++i) {
                    if (byArray2[i] != 10 && byArray2[i] != 13) continue;
                    byArray2[i] = 32;
                }
            }
            pdfObject2.setUnresolvedData(byArray2, this.PDFkeyInt);
        }
        if (byArray[n] == 47 || byArray[n] == 62) {
            --n;
        }
        return n;
    }

    public static int handleValue(PdfObject pdfObject, int n, int n2, int n3, int n4, int n5, byte[] byArray, PdfFileReader pdfFileReader) {
        int n6 = byArray.length;
        if (byArray[n3] == 47) {
            int n7 = ++n3;
            int n8 = 0;
            while (n3 < n6 && byArray[n3] != 10 && byArray[n3] != 13 && byArray[n3] != 32 && byArray[n3] != 47 && byArray[n3] != 60 && byArray[n3] != 62) {
                ++n3;
                ++n8;
            }
            --n;
            if (n2 == -1) {
                pdfObject.setConstant(n2, n7, n8, byArray);
            } else {
                PdfObject pdfObject2 = ObjectFactory.createObject(n2, null, pdfObject.getObjectType(), pdfObject.getID());
                pdfObject2.setID(n2);
                pdfObject2.setConstant(n2, n7, n8, byArray);
                pdfObject.setDictionary(n2, pdfObject2);
                if (pdfObject.isDataExternal()) {
                    pdfObject2.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(pdfObject2, pdfFileReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
            }
        } else {
            PdfObject pdfObject3;
            if (n2 == -1) {
                pdfObject3 = pdfObject;
            } else {
                pdfObject3 = ObjectFactory.createObject(n2, n4, n5, pdfObject.getObjectType());
                pdfObject3.setID(n2);
                pdfObject3.setInCompressedStream(pdfObject.isInCompressedStream());
                if (pdfObject.isDataExternal()) {
                    pdfObject3.isDataExternal(true);
                    if (!ObjectDecoder.resolveFully(pdfObject3, pdfFileReader)) {
                        pdfObject.setFullyResolved(false);
                    }
                }
                if (n2 != 2004251818) {
                    pdfObject3.ignoreRecursion(pdfObject.ignoreRecursion());
                }
            }
            ObjectDecoder objectDecoder = new ObjectDecoder(pdfFileReader);
            objectDecoder.readDictionaryAsObject(pdfObject3, n3, byArray);
            if (n2 != -1) {
                pdfObject.setDictionary(n2, pdfObject3);
            }
        }
        return n;
    }

    public static synchronized boolean resolveFully(PdfObject pdfObject, PdfFileReader pdfFileReader) {
        boolean bl;
        boolean bl2 = bl = pdfObject != null;
        if (bl) {
            byte[] byArray = pdfObject.getStatus() == 0 ? StringUtils.toBytes(pdfObject.getObjectRefAsString()) : pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (byArray[0] != 101 && byArray[1] != 110 && byArray[2] != 100 && byArray[3] != 111 && byArray[4] != 98) {
                int n = 0;
                while (byArray[n] == 91 || byArray[n] == 32 || byArray[n] == 13 || byArray[n] == 10) {
                    ++n;
                }
                int n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                int n3 = NumberUtils.parseInt(n2, n, byArray);
                while (byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 32) {
                    ++n;
                }
                n2 = n;
                while (byArray[n] != 10 && byArray[n] != 13 && byArray[n] != 32 && byArray[n] != 47 && byArray[n] != 60 && byArray[n] != 62) {
                    ++n;
                }
                int n4 = NumberUtils.parseInt(n2, n, byArray);
                if (byArray[byArray.length - 1] == 82) {
                    bl = ObjectDecoder.resolveFullyChildren(pdfObject, bl, byArray, n3, n4, pdfFileReader);
                }
                if (bl) {
                    pdfObject.ignoreRecursion(false);
                    ObjectDecoder objectDecoder = new ObjectDecoder(pdfFileReader);
                    objectDecoder.readDictionaryAsObject(pdfObject, n, byArray);
                }
            }
        }
        return bl;
    }

    static boolean resolveFullyChildren(PdfObject pdfObject, boolean bl, byte[] byArray, int n, int n2, PdfFileReader pdfFileReader) {
        pdfObject.setRef(new String(byArray));
        pdfObject.isDataExternal(true);
        byte[] byArray2 = pdfFileReader.readObjectAsByteArray(pdfObject, pdfFileReader.isCompressed(n, n2), n, n2);
        if (byArray2 == null) {
            pdfObject.setFullyResolved(false);
            bl = false;
        } else {
            pdfObject.setStatus(2);
            pdfObject.setUnresolvedData(byArray2, 2004845231);
            pdfObject.isDataExternal(true);
            if (!ObjectDecoder.resolveFully(pdfObject, pdfFileReader)) {
                pdfObject.setFullyResolved(false);
            }
        }
        return bl;
    }

    public void checkResolved(PdfObject pdfObject) {
        if (pdfObject != null && pdfObject.getStatus() != 0) {
            byte[] byArray = pdfObject.getUnresolvedData();
            pdfObject.setStatus(0);
            if (!(byArray[0] == 101 && byArray[1] == 110 && byArray[2] == 100 && byArray[3] == 111 && byArray[4] == 98 || byArray[0] == 110 && byArray[1] == 117 && byArray[2] == 108 && byArray[3] == 108)) {
                String string = pdfObject.getObjectRefAsString();
                if (byArray[0] == 91) {
                    int n;
                    int n2 = 0;
                    int n3 = byArray.length;
                    for (n = 0; n < n3; ++n) {
                        if (byArray[n] < 48 || byArray[n] > 57) continue;
                        n2 = n;
                        n = n3;
                    }
                    n = n2;
                    while (byArray[n] >= 48 && byArray[n] <= 57 || byArray[n] == 32 || byArray[n] == 10 || byArray[n] == 13 || byArray[n] == 9) {
                        ++n;
                    }
                    if (byArray[n] == 82) {
                        pdfObject.setRef(new String(byArray, n2, n3 - n2));
                    }
                } else if (byArray[byArray.length - 1] == 82) {
                    string = new String(byArray);
                    pdfObject.setRef(string);
                }
                Dictionary.readDictionaryFromRefOrDirect(-1, pdfObject, string, 0, byArray, -1, this.objectReader);
            }
        }
    }

    public void setEndPt(int n) {
        this.endPt = n;
    }
}

