/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.io.filter;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;
import org.jpedal.io.filter.BaseFilter;
import org.jpedal.io.filter.PdfFilter;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.sun.LZWDecoder;
import org.jpedal.sun.LZWDecoder2;
import org.jpedal.sun.TIFFLZWDecoder;

public class LZW
extends BaseFilter
implements PdfFilter {
    private int predictor = 1;
    private int EarlyChange = 1;
    private int colors = 1;
    private int bitsPerComponent = 8;
    private int rows;
    private int columns;

    public LZW(PdfObject pdfObject, int n, int n2) {
        super(pdfObject);
        this.rows = n2;
        this.columns = n;
        if (pdfObject != null) {
            int n3;
            int n4;
            int n5 = pdfObject.getInt(-1344207655);
            if (n5 != -1) {
                this.bitsPerComponent = n5;
            }
            if ((n4 = pdfObject.getInt(1010783618)) != -1) {
                this.colors = n4;
            }
            if ((n3 = pdfObject.getInt(1162902911)) != -1) {
                this.columns = n3;
            }
            this.EarlyChange = pdfObject.getInt(1838971823);
            this.predictor = pdfObject.getInt(1970893723);
            int n6 = pdfObject.getInt(574572355);
            if (n6 != -1) {
                this.rows = n6;
            }
        }
    }

    @Override
    public byte[] decode(byte[] byArray) throws Exception {
        if (this.rows * this.columns == 1) {
            if (byArray != null) {
                byte[] byArray2 = new byte[8 * this.rows * (this.columns + 7 >> 3)];
                TIFFLZWDecoder tIFFLZWDecoder = new TIFFLZWDecoder();
                tIFFLZWDecoder.decode(byArray, byArray2);
                return this.applyPredictor(this.predictor, byArray2, this.colors, 8, this.columns);
            }
        } else {
            if (byArray != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                LZWDecoder lZWDecoder = new LZWDecoder();
                lZWDecoder.decode(byArray, byteArrayOutputStream, this.EarlyChange == 1);
                byteArrayOutputStream.close();
                byArray = byteArrayOutputStream.toByteArray();
            }
            byArray = this.applyPredictor(this.predictor, byArray, this.colors, this.bitsPerComponent, this.columns);
        }
        return byArray;
    }

    public void decode(BufferedInputStream bufferedInputStream, BufferedOutputStream bufferedOutputStream, String string, Map map) throws Exception {
        if (this.rows * this.columns != 1) {
            if (bufferedInputStream != null) {
                LZWDecoder2 lZWDecoder2 = new LZWDecoder2();
                lZWDecoder2.decode(null, bufferedOutputStream, bufferedInputStream);
            }
            if (this.predictor != 1 && this.predictor != 10) {
                bufferedOutputStream.flush();
                bufferedOutputStream.close();
                if (string != null) {
                    this.setupCachedObjectForDecoding(string);
                }
            }
            this.applyPredictor(this.predictor, null, this.colors, this.bitsPerComponent, this.columns);
        }
    }
}

