/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.jbig2.segment.region.halftone;

import java.io.IOException;
import org.jpedal.jbig2.JBIG2Exception;
import org.jpedal.jbig2.decoders.JBIG2StreamDecoder;
import org.jpedal.jbig2.image.JBIG2Bitmap;
import org.jpedal.jbig2.segment.Segment;
import org.jpedal.jbig2.segment.pageinformation.PageInformationSegment;
import org.jpedal.jbig2.segment.pattern.PatternDictionarySegment;
import org.jpedal.jbig2.segment.region.RegionSegment;
import org.jpedal.jbig2.segment.region.halftone.HalftoneRegionFlags;
import org.jpedal.jbig2.util.BinaryOperation;

public class HalftoneRegionSegment
extends RegionSegment {
    private final HalftoneRegionFlags halftoneRegionFlags = new HalftoneRegionFlags();
    private final boolean inlineImage;

    public HalftoneRegionSegment(JBIG2StreamDecoder jBIG2StreamDecoder, boolean bl) {
        super(jBIG2StreamDecoder);
        this.inlineImage = bl;
    }

    @Override
    public void readSegment() throws IOException, JBIG2Exception {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Segment segment;
        super.readSegment();
        this.readHalftoneRegionFlags();
        short[] sArray = new short[4];
        this.decoder.readByte(sArray);
        int n6 = BinaryOperation.getInt32(sArray);
        sArray = new short[4];
        this.decoder.readByte(sArray);
        int n7 = BinaryOperation.getInt32(sArray);
        sArray = new short[4];
        this.decoder.readByte(sArray);
        int n8 = BinaryOperation.getInt32(sArray);
        sArray = new short[4];
        this.decoder.readByte(sArray);
        int n9 = BinaryOperation.getInt32(sArray);
        sArray = new short[2];
        this.decoder.readByte(sArray);
        int n10 = BinaryOperation.getInt16(sArray);
        sArray = new short[2];
        this.decoder.readByte(sArray);
        int n11 = BinaryOperation.getInt16(sArray);
        int[] nArray = this.segmentHeader.getReferredToSegments();
        if (nArray.length != 1) {
            System.out.println("Error in halftone Segment. referredToSegments should == 1.");
        }
        if ((segment = this.decoder.findSegment(nArray[0])).getSegmentHeader().getSegmentType() != 16) {
            // empty if block
        }
        PatternDictionarySegment patternDictionarySegment = (PatternDictionarySegment)segment;
        int n12 = 0;
        for (n5 = 1; n5 < patternDictionarySegment.getSize(); n5 <<= 1) {
            ++n12;
        }
        JBIG2Bitmap jBIG2Bitmap = patternDictionarySegment.getBitmaps()[0];
        int n13 = jBIG2Bitmap.getWidth();
        int n14 = jBIG2Bitmap.getHeight();
        boolean bl = this.halftoneRegionFlags.getFlagValue("H_MMR") != 0;
        int n15 = this.halftoneRegionFlags.getFlagValue("H_TEMPLATE");
        if (!bl) {
            this.arithmeticDecoder.resetGenericStats(n15, null);
            this.arithmeticDecoder.start();
        }
        int n16 = this.halftoneRegionFlags.getFlagValue("H_DEF_PIXEL");
        jBIG2Bitmap = new JBIG2Bitmap(this.regionBitmapWidth, this.regionBitmapHeight, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
        jBIG2Bitmap.clear(n16);
        boolean bl2 = this.halftoneRegionFlags.getFlagValue("H_ENABLE_SKIP") != 0;
        JBIG2Bitmap jBIG2Bitmap2 = null;
        if (bl2) {
            jBIG2Bitmap2 = new JBIG2Bitmap(n6, n7, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            jBIG2Bitmap2.clear(0);
            for (int i = 0; i < n7; ++i) {
                for (int j = 0; j < n6; ++j) {
                    int n17 = n8 + i * n11 + j * n10;
                    int n18 = n9 + i * n10 - j * n11;
                    if (n17 + n13 >> 8 > 0 && n17 >> 8 < this.regionBitmapWidth && n18 + n14 >> 8 > 0 && n18 >> 8 < this.regionBitmapHeight) continue;
                    jBIG2Bitmap2.setPixel(i, j, 1);
                }
            }
            jBIG2Bitmap2.getDataWriter().clearResources();
        }
        int[] nArray2 = new int[n6 * n7];
        short[] sArray2 = new short[4];
        short[] sArray3 = new short[4];
        sArray2[0] = (short)(n15 <= 1 ? 3 : 2);
        sArray3[0] = -1;
        sArray2[1] = -3;
        sArray3[1] = -1;
        sArray2[2] = 2;
        sArray3[2] = -2;
        sArray2[3] = -2;
        sArray3[3] = -2;
        for (n4 = n12 - 1; n4 >= 0; --n4) {
            JBIG2Bitmap jBIG2Bitmap3 = new JBIG2Bitmap(n6, n7, this.arithmeticDecoder, this.huffmanDecoder, this.mmrDecoder, this.decoder);
            if (bl) {
                jBIG2Bitmap3.readBitmapWithMMR(-1);
            } else {
                jBIG2Bitmap3.readBitmap(n15, false, bl2, jBIG2Bitmap2, sArray2, sArray3);
            }
            n5 = 0;
            for (n3 = 0; n3 < n7; ++n3) {
                for (n2 = 0; n2 < n6; ++n2) {
                    n = jBIG2Bitmap3.getPixel(n2, n3) ^ nArray2[n5] & 1;
                    nArray2[n5] = nArray2[n5] << 1 | n;
                    ++n5;
                }
            }
            jBIG2Bitmap3.getDataWriter().clearResources();
        }
        n4 = this.halftoneRegionFlags.getFlagValue("H_COMB_OP");
        n5 = 0;
        for (n3 = 0; n3 < n7; ++n3) {
            n2 = n8 + n3 * n11;
            n = n9 + n3 * n10;
            for (int i = 0; i < n6; ++i) {
                if (!bl2 || jBIG2Bitmap2.getPixel(n3, i) != 1) {
                    JBIG2Bitmap jBIG2Bitmap4 = patternDictionarySegment.getBitmaps()[nArray2[n5]];
                    jBIG2Bitmap.combine(jBIG2Bitmap4, n2 >> 8, n >> 8, n4);
                }
                n2 += n10;
                n -= n11;
                ++n5;
            }
        }
        if (this.inlineImage) {
            PageInformationSegment pageInformationSegment = this.decoder.findPageSegment(this.segmentHeader.getPageAssociation());
            JBIG2Bitmap jBIG2Bitmap5 = pageInformationSegment.getPageBitmap();
            n = this.regionFlags.getFlagValue("EXTERNAL_COMBINATION_OPERATOR");
            jBIG2Bitmap5.combine(jBIG2Bitmap, this.regionBitmapXLocation, this.regionBitmapYLocation, n);
            jBIG2Bitmap.getDataWriter().clearResources();
        } else {
            jBIG2Bitmap.setBitmapNumber(this.getSegmentHeader().getSegmentNumber());
            this.decoder.appendBitmap(jBIG2Bitmap);
        }
    }

    private void readHalftoneRegionFlags() {
        short s = this.decoder.readByte();
        this.halftoneRegionFlags.setFlags(s);
    }

    @Override
    public JBIG2Bitmap[] getBitmaps() {
        return null;
    }
}

