/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects;

import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.javascript.DefaultParser;
import org.jpedal.objects.javascript.ExpressionEngine;
import org.jpedal.objects.javascript.GenericParser;
import org.jpedal.objects.javascript.RhinoParser;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.repositories.Vector_String;

public class Javascript {
    private ExpressionEngine jsParser;
    private static boolean useNewJSParser;
    private static boolean disableJavascript;
    private final Map javascriptCommands;
    private final Map javascriptTypesUsed;
    private final Map linkedjavascriptCommands;
    private final Map javascriptNamesObjects;

    public Javascript(ExpressionEngine expressionEngine, AcroRenderer acroRenderer, Object object) {
        block10: {
            this.javascriptCommands = new HashMap();
            this.javascriptTypesUsed = new HashMap();
            this.linkedjavascriptCommands = new HashMap();
            this.javascriptNamesObjects = new HashMap();
            if (disableJavascript) {
                return;
            }
            if (System.getProperty("org.jpedal.newJS") != null) {
                useNewJSParser = true;
            }
            if (expressionEngine != null) {
                this.jsParser = expressionEngine;
            } else {
                try {
                    if (!useNewJSParser) {
                        InputStream inputStream = DefaultParser.class.getClassLoader().getResourceAsStream("org/mozilla/javascript/Context.class");
                        this.jsParser = inputStream != null ? new RhinoParser(this) : new DefaultParser();
                    } else {
                        GenericParser genericParser = new GenericParser(this);
                        this.jsParser = genericParser;
                        genericParser.setupPDFObjects(this);
                    }
                }
                catch (Error error) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Error: " + error.getMessage());
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception: " + exception.getMessage());
                }
            }
        }
        this.jsParser.setAcroRenderer(acroRenderer);
    }

    public void executeAction(String string) {
        if (disableJavascript) {
            return;
        }
        this.jsParser.executeFunctions(string, null);
    }

    public int execute(FormObject formObject, int n, int n2, char c) {
        String string;
        Vector_String vector_String;
        int n3 = this.executeCommand(formObject, n, n2, c);
        boolean bl = false;
        if (n2 == 6 && (n != 4866 || n == 4866 && (n3 == 0 || n3 == 3))) {
            bl = true;
        }
        if (bl && (vector_String = (Vector_String)this.linkedjavascriptCommands.get(string = formObject.getTextStreamValue(36))) != null) {
            String[] stringArray;
            vector_String.trim();
            for (String string2 : stringArray = vector_String.get()) {
                if (string2.equals(string) && n != 4866) continue;
            }
        }
        return n3;
    }

    public Object getJavascriptCommand(String string, int n) {
        return this.javascriptCommands.get(string + '-' + n);
    }

    private int executeCommand(FormObject formObject, int n, int n2, char c) {
        int n3 = 0;
        if (disableJavascript) {
            return n3;
        }
        if (formObject == null) {
            return n3;
        }
        Object v = this.javascriptCommands.get(formObject.getObjectRefAsString() + '-' + n);
        if (v == null) {
            v = this.javascriptCommands.get(formObject.getTextStreamValue(36) + '-' + n);
        }
        if (v == null) {
            return 0;
        }
        if (n3 != 2) {
            n3 = this.jsParser.execute(formObject, n, v, n2, c);
        }
        return n3;
    }

    public void setCode(String string, String string2) {
        if (disableJavascript) {
            return;
        }
        this.javascriptNamesObjects.put(string, string2);
        this.jsParser.addCode(string2);
    }

    public String getJavaScript(String string) {
        String string2;
        if (string == null) {
            Collection collection = this.javascriptNamesObjects.values();
            Iterator iterator = collection.iterator();
            StringBuilder stringBuilder = new StringBuilder();
            while (iterator.hasNext()) {
                stringBuilder.append(iterator.next());
            }
            string2 = stringBuilder.toString();
        } else {
            string2 = (String)this.javascriptNamesObjects.get(string);
        }
        return string2;
    }

    public void closeFile() {
        this.javascriptTypesUsed.clear();
        this.javascriptCommands.clear();
        this.linkedjavascriptCommands.clear();
        if (disableJavascript) {
            return;
        }
        this.jsParser.closeFile();
    }

    public void storeJavascript(String string, String string2, int n) {
        this.javascriptCommands.put(string + '-' + n, string2);
        this.javascriptTypesUsed.put(n, "x");
        if (n == 4866) {
            int n2 = 0;
            while (true) {
                int n3 = string2.indexOf("\\\"", n2);
                while ((n2 = string2.indexOf(34, n2)) != -1 && n3 != -1 && n2 - 1 <= n3) {
                }
                if (n2 == -1) break;
                int n4 = ++n2;
                n3 = string2.indexOf("\\\"", n2);
                while ((n2 = string2.indexOf(34, n2)) != -1 && n3 != -1 && n2 - 1 <= n3) {
                }
                if (n2 == -1) break;
                String string3 = string2.substring(n4, n2);
                if (string3 != null) {
                    Vector_String vector_String = (Vector_String)this.linkedjavascriptCommands.get(string3);
                    if (vector_String == null) {
                        vector_String = new Vector_String();
                        vector_String.addElement(string);
                    } else if (!vector_String.contains(string)) {
                        vector_String.addElement(string);
                    }
                    this.linkedjavascriptCommands.put(string3, vector_String);
                }
                ++n2;
            }
        }
    }

    public void dispose() {
        if (disableJavascript) {
            return;
        }
        this.jsParser.dispose();
    }

    public static void disableJavascript() {
        disableJavascript = true;
    }
}

