/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.acroforms.overridingImplementations;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.Icon;
import javax.swing.SwingConstants;
import org.jpedal.io.PdfObjectReader;
import org.jpedal.objects.acroforms.GUIData;
import org.jpedal.objects.acroforms.overridingImplementations.CustomImageIcon;
import org.jpedal.objects.raw.FormObject;
import org.jpedal.objects.raw.FormStream;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.objects.raw.XObject;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.StringUtils;

public class ReadOnlyTextIcon
extends CustomImageIcon
implements Icon,
SwingConstants {
    private boolean currentlyPrinting;
    private int printMultiplier = 1;
    private int alignment = -1;
    private static final long serialVersionUID = 8946195842453749725L;
    private BufferedImage rootImage;
    private BufferedImage finalImage;
    private PdfObject fakeObj;
    private boolean textChanged;
    private String preFontStream = "";
    private String betweenFontAndTextStream = "";
    private String afterTextStream = "";
    private String text = "";
    private String fontName = "";
    private String fontSize = "12";
    private String fontCommand = "";
    private String fullCommandString;
    private final PdfObjectReader currentpdffile;
    private int subtype = -1;
    private final PdfObject resources;
    private final PdfObject form;

    public ReadOnlyTextIcon(PdfObject pdfObject, int n, PdfObjectReader pdfObjectReader, PdfObject pdfObject2) {
        super(n);
        this.form = pdfObject;
        this.currentpdffile = pdfObjectReader;
        this.resources = pdfObject2;
    }

    @Override
    public Image getImage() {
        this.checkAndCreateimage();
        BufferedImage bufferedImage = this.finalImage;
        return bufferedImage;
    }

    public BufferedImage drawToBufferedImage() {
        BufferedImage bufferedImage = new BufferedImage(this.getIconWidth(), this.getIconHeight(), 2);
        Graphics graphics = bufferedImage.getGraphics();
        this.paintIcon(null, graphics, 0, 0);
        graphics.dispose();
        return bufferedImage;
    }

    @Override
    public synchronized void paintIcon(Component component, Graphics graphics, int n, int n2) {
        BufferedImage bufferedImage = (BufferedImage)this.getImage();
        if (bufferedImage == null) {
            return;
        }
        if (component != null && component.isEnabled()) {
            graphics.setColor(component.getBackground());
        } else {
            graphics.setColor(Color.gray);
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (this.iconWidth > 0 && this.iconHeight > 0) {
            int n3;
            int n4 = this.iconWidth;
            int n5 = this.iconHeight;
            if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                n4 = this.iconHeight;
                n5 = this.iconWidth;
            }
            if (this.currentpdffile != null) {
                float f;
                float f2 = (float)n4 / (float)bufferedImage.getWidth(null);
                if (f2 < (f = (float)n5 / (float)bufferedImage.getHeight(null))) {
                    n4 = (int)(f2 * (float)bufferedImage.getWidth(null));
                    n5 = (int)(f2 * (float)bufferedImage.getHeight(null));
                } else {
                    n4 = (int)(f * (float)bufferedImage.getWidth(null));
                    n5 = (int)(f * (float)bufferedImage.getHeight(null));
                }
            }
            int n6 = 0;
            int n7 = 0;
            if (this.currentpdffile != null) {
                if (this.displaySingle && (this.iconRotation == 270 || this.iconRotation == 90)) {
                    n6 = (this.iconHeight - n4) / 2;
                    n7 = (this.iconWidth - n5) / 2;
                } else {
                    n6 = (this.iconWidth - n4) / 2;
                    n7 = (this.iconHeight - n5) / 2;
                }
            }
            if (this.alignment == 2) {
                n6 = 0;
            }
            if ((n3 = this.displaySingle ? ReadOnlyTextIcon.validateRotationValue(this.pageRotate - this.iconRotation) : this.pageRotate) == 270) {
                graphics2D.rotate(-1.5707963267948966);
                graphics2D.translate(-n4, 0);
                graphics2D.drawImage(bufferedImage, -n6, n7, n4, n5, null);
            } else if (n3 == 90) {
                graphics2D.rotate(1.5707963267948966);
                graphics2D.translate(0, -n5);
                graphics2D.drawImage(bufferedImage, n6, -n7, n4, n5, null);
            } else if (n3 == 180) {
                graphics2D.rotate(Math.PI);
                graphics2D.translate(-n4, -n5);
                graphics2D.drawImage(bufferedImage, -n6, -n7, n4, n5, null);
            } else {
                graphics2D.drawImage(bufferedImage, n6, n7, n4, n5, null);
            }
        } else {
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        }
        graphics2D.translate(-n, -n2);
    }

    private void checkAndCreateimage() {
        if (this.currentpdffile == null) {
            return;
        }
        int n = this.iconWidth;
        int n2 = this.iconHeight;
        if (this.currentlyPrinting) {
            n = this.iconWidth * this.printMultiplier;
            n2 = this.iconHeight * this.printMultiplier;
        }
        if (this.textChanged || this.rootImage == null || n > this.rootImage.getWidth(null) || n2 > this.rootImage.getHeight(null) || (float)n < (float)this.rootImage.getWidth(null) / MAXSCALEFACTOR || (float)n2 < (float)this.rootImage.getHeight(null) / MAXSCALEFACTOR) {
            this.rootImage = FormStream.decode(this.form, this.currentpdffile, this.fakeObj, this.subtype, n, n2, 0, 1.0f);
            this.finalImage = FormStream.rotate(this.rootImage, this.iconRotation);
            this.textChanged = false;
        }
    }

    public void setText(String string) {
        block31: {
            int n;
            Object object;
            if (string == null) {
                string = "";
            }
            if (string.equals(this.text)) {
                return;
            }
            this.textChanged = true;
            this.text = string;
            PdfObject pdfObject = new PdfObject("1 10 X");
            do {
                pdfObject.setDecodedStream(StringUtils.toBytes(this.afterTextStream));
                object = FormStream.decipherTextFromAP(this.currentpdffile, pdfObject);
                if (object == null || !this.text.contains((CharSequence)object)) break;
                n = this.afterTextStream.indexOf(" Tj", this.afterTextStream.indexOf((String)object)) + 3;
                this.afterTextStream = this.afterTextStream.substring(n);
            } while (!this.afterTextStream.isEmpty());
            try {
                Object object2;
                int n2;
                int n3;
                if (this.text.contains("\n")) {
                    object = new StringTokenizer(this.text, "\n", false);
                    n3 = 2;
                    n2 = ((FormObject)this.form).getBoundingRectangle().height;
                    object2 = " " + n3 + ' ' + n2 + " Td ";
                    this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + (String)object2;
                    int n4 = 0;
                    while (((StringTokenizer)object).hasMoreTokens()) {
                        String string2 = ((StringTokenizer)object).nextToken();
                        FontMetrics fontMetrics = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                        Rectangle2D rectangle2D = fontMetrics.getStringBounds(string2, null);
                        if (((FormObject)this.form).getAlignment() != -1) {
                            switch (((FormObject)this.form).getAlignment()) {
                                case 2: {
                                    n3 = 0;
                                    break;
                                }
                                case 0: {
                                    n3 = (int)((double)((FormObject)this.form).getBoundingRectangle().width - rectangle2D.getWidth()) / 2;
                                    n3 -= n4;
                                    break;
                                }
                                case 4: {
                                    n3 = (int)((double)((FormObject)this.form).getBoundingRectangle().width - rectangle2D.getWidth());
                                    n3 -= n4;
                                }
                            }
                        }
                        n2 = (int)(-(rectangle2D.getHeight() + 2.0));
                        object2 = " " + n3 + ' ' + n2 + " Td ";
                        this.fullCommandString = this.fullCommandString + (String)object2 + '(' + string2 + ")Tj ";
                        n4 += n3;
                    }
                    this.fullCommandString = this.fullCommandString + this.afterTextStream;
                } else {
                    int n5 = 2;
                    n = (int)((float)((FormObject)this.form).getBoundingRectangle().height - Float.parseFloat(this.fontSize)) / 2;
                    if (n < 2) {
                        n = 2;
                    }
                    if (((FormObject)this.form).getAlignment() != 2) {
                        object2 = new Canvas().getFontMetrics(new Font(this.fontName, 0, (int)Float.parseFloat(this.fontSize)));
                        Rectangle2D rectangle2D = ((FontMetrics)object2).getStringBounds(this.text, null);
                        switch (((FormObject)this.form).getAlignment()) {
                            case 0: {
                                n5 = (int)((double)((FormObject)this.form).getBoundingRectangle().width - rectangle2D.getWidth()) / 2;
                                break;
                            }
                            case 4: {
                                n5 = (int)((double)((FormObject)this.form).getBoundingRectangle().width - rectangle2D.getWidth()) - 2;
                            }
                        }
                    }
                    object2 = n5 + " " + n + " Td ";
                    this.fullCommandString = this.preFontStream + this.fontName + this.fontSize + this.fontCommand + this.betweenFontAndTextStream + (String)object2 + '(' + this.text + ")Tj " + this.afterTextStream;
                }
                Color color = null;
                if (this.form.getDictionary(7451) != null) {
                    PdfObject pdfObject2 = this.form.getDictionary(7451);
                    object2 = pdfObject2.getFloatArray(4631);
                    if (object2 != null) {
                        n3 = 0;
                        for (n2 = 0; n2 != ((Object)object2).length; ++n2) {
                            if (!(object2[n2] > 1.0f)) continue;
                            n3 = 1;
                            break;
                        }
                        if (n3 != 0) {
                            for (n2 = 0; n2 != ((Object)object2).length; ++n2) {
                                if (!(object2[n2] > 1.0f)) continue;
                                Object object3 = object2;
                                int n6 = n2;
                                object3[n6] = object3[n6] / 255.0f;
                            }
                        }
                    }
                    if (object2 != null && ((Object)object2).length > 0) {
                        switch (((Object)object2).length) {
                            case 1: {
                                color = new Color((float)object2[0], (float)object2[0], (float)object2[0], 1.0f);
                                break;
                            }
                            case 3: {
                                color = new Color((float)object2[0], (float)object2[1], (float)object2[2], 1.0f);
                                break;
                            }
                        }
                    }
                }
                if (color != null) {
                    this.fullCommandString = color.getRed() + " " + color.getGreen() + ' ' + color.getBlue() + " rg 0 0 " + (((FormObject)this.form).getBoundingRectangle().width - 3) + ' ' + (((FormObject)this.form).getBoundingRectangle().height - 3) + " re f " + this.fullCommandString;
                }
                this.fakeObj.setDecodedStream(this.fullCommandString.getBytes("Cp1252"));
            }
            catch (IOException iOException) {
                if (!LogWriter.isOutput()) break block31;
                LogWriter.writeLog("Exception: " + iOException.getMessage());
            }
        }
    }

    public boolean decipherAppObject(FormObject formObject) {
        Rectangle rectangle;
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Object object;
        String string = "";
        PdfObject pdfObject = formObject.getDictionary(4384).getDictionary(30);
        if (pdfObject != null && (object = pdfObject.getDecodedStream()) != null) {
            n5 = -1;
            int n6 = -1;
            n4 = -1;
            n3 = ((byte[])object).length;
            for (n2 = 0; n2 < n3 - 1; ++n2) {
                if ((char)object[n2] != 'T' || (char)object[n2 + 1] != 'f' || n2 + 2 < n3 && object[n2 + 2] != 10 && object[n2 + 2] != 13 && object[n2 + 2] != 32) continue;
                n6 = n2 + 2;
                break;
            }
            if (n6 == -1) {
                n5 = 0;
                n6 = 0;
            } else {
                for (n2 = n6 - 3; n2 > n5; --n2) {
                    if (object[n2] != 47) continue;
                    n5 = n2;
                    break;
                }
            }
            for (n2 = n6; n2 < n3 - 1; ++n2) {
                if ((char)object[n2] != 'T' || (char)object[n2 + 1] != 'j' || n2 + 2 < n3 && object[n2 + 2] != 10 && object[n2 + 2] != 13 && object[n2 + 2] != 32) continue;
                n4 = n2 + 2;
                break;
            }
            if (n4 == -1) {
                n = n6;
                n4 = n6;
            } else {
                n = n6;
                n2 = 0;
                boolean bl = false;
                for (int i = n4 - 3; i > n; --i) {
                    if (object[i] == 32 || object[i] == 10 || object[i] == 13) {
                        if (!bl || n2 != 0) continue;
                        n = i + 1;
                        break;
                    }
                    if (object[i] == 41) {
                        ++n2;
                        continue;
                    }
                    if (object[i] == 40) {
                        if (--n2 != 0 || !bl) continue;
                        n = i;
                        break;
                    }
                    bl = true;
                }
            }
            for (n2 = n6; n2 < n; ++n2) {
                if (object[n2] == 32 || object[n2] == 10 || object[n2] == 13 || object[n2] > 47 && object[n2] < 58) continue;
                if (object[n2] == 103 && n2 + 1 < n && (object[n2 + 1] == 32 || object[n2 + 1] == 10 || object[n2 + 1] == 13)) {
                    n6 = n2 + 1;
                    break;
                }
                if (object[n2] != 114 || n2 + 2 >= n || object[n2 + 1] != 103 || object[n2 + 2] != 32 && object[n2 + 2] != 10 && object[n2 + 2] != 13) break;
                n6 = n2 + 2;
                break;
            }
            if (n4 != n6) {
                if (n6 == 0) {
                    this.preFontStream = new String((byte[])object, 0, n);
                    this.betweenFontAndTextStream = " ";
                } else {
                    this.preFontStream = new String((byte[])object, 0, n5);
                    string = new String((byte[])object, n5, n6 - n5);
                    this.betweenFontAndTextStream = new String((byte[])object, n6, n - n6);
                }
                this.text = new String((byte[])object, n, n4 - 3 - n);
                this.afterTextStream = new String((byte[])object, n4, ((Object)object).length - n4);
            } else if (n6 == 0) {
                this.preFontStream = new String((byte[])object);
            } else {
                this.preFontStream = new String((byte[])object, 0, n5);
                string = new String((byte[])object, n5, n6 - n5);
                this.betweenFontAndTextStream = new String((byte[])object, n6, ((Object)object).length - n6);
            }
        }
        object = formObject.getTextStreamValue(5137);
        this.fakeObj = new XObject(formObject.getObjectRefAsString());
        if (object == null || ((String)object).isEmpty()) {
            if (!string.isEmpty()) {
                formObject.setTextStreamValue(5137, StringUtils.toBytes(string));
                FormStream.decodeFontCommandObj(string, formObject);
            }
            return false;
        }
        if (string.isEmpty()) {
            n5 = ((String)object).indexOf(47);
            if (n5 < 0) {
                n5 = 0;
            }
            string = ((String)object).substring(n5).trim();
        } else {
            String string2 = ((String)object).substring(0, ((String)object).indexOf(32));
            String string3 = string.substring(string.indexOf(32), string.length());
            string = string2 + string3;
            string = string.trim();
        }
        if (this.resources != null) {
            this.fakeObj.setDictionary(2004251818, this.resources);
        }
        if ((rectangle = formObject.getBoundingRectangle()) != null) {
            this.fakeObj.setFloatArray(303185736, new float[]{rectangle.width, 0.0f, 0.0f, rectangle.height, 0.0f, 0.0f});
        }
        this.subtype = -1;
        if (this.preFontStream.isEmpty() || !this.preFontStream.contains("BT")) {
            this.preFontStream = "BT 0 0 0 RG 1 TFS ";
            this.betweenFontAndTextStream = " 1 0 0 1 0 0 Tm ";
            this.afterTextStream = "";
        }
        int n7 = string.indexOf(32);
        n = -1;
        n4 = 0;
        for (n3 = n7; n3 < string.length(); ++n3) {
            n2 = string.charAt(n3);
            if (n2 == 32 || n2 == 10 || n2 == 13) {
                if (n4 == 0) continue;
                n = n3;
                break;
            }
            n4 = 1;
        }
        float f = 12.0f;
        if (n != -1) {
            this.fontName = string.substring(0, n7);
            this.fontCommand = string.substring(n);
            f = Float.parseFloat(string.substring(n7, n));
        }
        if (this.fontName.isEmpty()) {
            Font font = formObject.getTextFont();
            this.fontName = '/' + font.getFontName();
            this.fontCommand = "Tf ";
        }
        if (f == 0.0f || f == -1.0f) {
            f = GUIData.calculateFontSize(rectangle.height, rectangle.width, false, this.text);
        }
        this.fontSize = " " + f + ' ';
        return true;
    }

    public void setAlignment(int n) {
        this.alignment = n;
    }

    public void setPrinting(boolean bl, int n) {
        this.currentlyPrinting = bl;
        this.printMultiplier = n;
        this.checkAndCreateimage();
    }

    public PdfObject getFakeObject() {
        return this.fakeObj;
    }
}

