/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.objects.javascript.jsobjects;

import java.util.HashMap;
import java.util.List;
import org.jpedal.objects.acroforms.AcroRenderer;
import org.jpedal.objects.acroforms.ReturnValues;
import org.jpedal.objects.javascript.jsobjects.JSField;
import org.jpedal.objects.raw.FormObject;

public class JSDoc {
    private AcroRenderer acroRenderer;
    private HashMap<String, JSField> nameTofields = new HashMap();
    private HashMap<String, JSField> refTofields = new HashMap();

    public void setAcroRenderer(AcroRenderer acroRenderer) {
        this.acroRenderer = acroRenderer;
        if (acroRenderer != null) {
            this.loadFormObjects();
        }
    }

    public void loadFormObjects() {
        if (this.acroRenderer == null) {
            throw new RuntimeException("No acrorender object set for Doc object.");
        }
        List list = this.acroRenderer.getCompData().getFormComponents(null, ReturnValues.FORMOBJECTS_FROM_REF, -1);
        for (FormObject formObject : list) {
            JSField jSField = new JSField(formObject);
            this.refTofields.put(formObject.getObjectRefAsString(), jSField);
            this.nameTofields.put(formObject.getTextStreamValue(36), jSField);
        }
    }

    public JSField getField(String string) {
        if (this.nameTofields.size() <= 0) {
            this.loadFormObjects();
        }
        if (this.nameTofields.containsKey(string)) {
            return this.nameTofields.get(string);
        }
        return null;
    }

    public JSField getFieldByRef(String string) {
        if (this.refTofields.size() <= 0) {
            this.loadFormObjects();
        }
        if (this.refTofields.containsKey(string)) {
            return this.refTofields.get(string);
        }
        return null;
    }

    public void flush() {
        this.nameTofields = new HashMap();
        this.refTofields = new HashMap();
    }

    public FormObject[] getFormObjects() {
        FormObject[] formObjectArray = new FormObject[this.refTofields.size()];
        int n = 0;
        for (String string : this.refTofields.keySet()) {
            formObjectArray[n] = this.refTofields.get((Object)string).target;
            ++n;
        }
        return formObjectArray;
    }
}

