/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser;

import org.jpedal.exception.PdfException;
import org.jpedal.external.FontHandler;
import org.jpedal.fonts.FontMappings;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.StandardFonts;
import org.jpedal.objects.GraphicsState;
import org.jpedal.objects.raw.FontObject;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.PdfFontFactory;
import org.jpedal.parser.PdfObjectCache;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.utils.LogWriter;

public class FontResolver {
    public static PdfFont resolveFont(GraphicsState graphicsState, PdfStreamDecoder pdfStreamDecoder, String string, PdfFontFactory pdfFontFactory, PdfObjectCache pdfObjectCache) {
        PdfFont pdfFont;
        String string2 = string;
        if (graphicsState != null && pdfObjectCache.resolvedFonts.get("t-" + string) != null) {
            string2 = string + ':' + graphicsState.nonstrokeColorSpace.getColor().getRGB();
        }
        if ((pdfFont = (PdfFont)pdfObjectCache.resolvedFonts.get(string2)) == null) {
            block11: {
                PdfObject pdfObject = (PdfObject)pdfObjectCache.unresolvedFonts.get(string);
                if (pdfObject == null) {
                    pdfObjectCache.directFonts.remove(string);
                }
                if (pdfStreamDecoder.parserOptions.isFlattenedForm() && pdfObject == null) {
                    pdfObject = new FontObject("1 0 R");
                    string = FontResolver.resolveFlattenedFont(string, pdfObject);
                }
                if (pdfObject != null) {
                    pdfStreamDecoder.currentPdfFile.checkResolved(pdfObject);
                    try {
                        DynamicVectorRenderer dynamicVectorRenderer = pdfStreamDecoder.current;
                        boolean bl = false;
                        boolean bl2 = dynamicVectorRenderer.isHTMLorSVG();
                        if (bl2 && !dynamicVectorRenderer.getBooleanValue(46)) {
                            bl = true;
                        }
                        pdfFont = pdfFontFactory.createFont(bl, pdfObject, string, pdfStreamDecoder.objectStoreStreamRef, pdfStreamDecoder.parserOptions.isRenderPage(), pdfStreamDecoder.errorTracker, pdfStreamDecoder.isPrinting);
                        FontHandler fontHandler = dynamicVectorRenderer.getFontHandler();
                        if (fontHandler != null) {
                            fontHandler.processFont(bl2, pdfFont, dynamicVectorRenderer, pdfObject, pdfStreamDecoder.currentPdfFile);
                        }
                    }
                    catch (PdfException pdfException) {
                        if (!LogWriter.isOutput()) break block11;
                        LogWriter.writeLog("Exception: " + pdfException.getMessage());
                    }
                }
            }
            if (pdfFont != null && !pdfStreamDecoder.parserOptions.isFlattenedForm()) {
                pdfStreamDecoder.cache.resolvedFonts.put(string2, pdfFont);
                if (pdfFont.getFontType() == 1228944679) {
                    pdfStreamDecoder.cache.resolvedFonts.put("t-" + string, "T3");
                }
            }
        }
        return pdfFont;
    }

    private static String resolveFlattenedFont(String string, PdfObject pdfObject) {
        String string2 = StandardFonts.expandName(string.replace(",", "-"));
        if (FontMappings.fontSubstitutionAliasTable.get(string2) == null && FontMappings.fontSubstitutionTable != null && FontMappings.fontSubstitutionTable.get(string2) == null) {
            String string3 = string2.toLowerCase();
            string2 = string3.contains("bold") ? "Arial-Bold" : (string3.contains("italic") ? "Arial-Italic" : "Arial");
        }
        pdfObject.setName((Object)678461817, string2);
        pdfObject.setName((Object)879786873, string2);
        pdfObject.setConstant(1147962727, 1217103210);
        string = StandardFonts.expandName(string2);
        return string;
    }
}

