/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.parser.fx;

import java.awt.image.BufferedImage;
import java.util.concurrent.CountDownLatch;
import javafx.application.Platform;
import javafx.beans.property.SimpleObjectProperty;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.Group;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.SnapshotResult;
import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.transform.Transform;
import javafx.util.Callback;
import org.jpedal.exception.PdfException;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.raw.PdfObject;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.parser.PDFtoImageConvertor;
import org.jpedal.parser.PdfStreamDecoder;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.FXDisplay;
import org.jpedal.render.FXDisplayForRasterizing;

public class PDFtoImageConvertorFX
extends PDFtoImageConvertor {
    public PDFtoImageConvertorFX(float f, DecoderOptions decoderOptions) {
        super(f, decoderOptions);
        this.isFX = true;
    }

    @Override
    public DynamicVectorRenderer getDisplay(int n, ObjectStore objectStore) {
        this.imageDisplay = new FXDisplayForRasterizing(n, true, 5000, objectStore);
        return this.imageDisplay;
    }

    @Override
    public BufferedImage pageToImage(boolean bl, final PdfStreamDecoder pdfStreamDecoder, final float f, final PdfObject pdfObject) throws PdfException {
        final SimpleObjectProperty simpleObjectProperty = new SimpleObjectProperty();
        final CountDownLatch countDownLatch = new CountDownLatch(1);
        if (Platform.isFxApplicationThread()) {
            this.snapshot(pdfStreamDecoder, f, pdfObject, null, (SimpleObjectProperty<BufferedImage>)simpleObjectProperty);
        } else {
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    PDFtoImageConvertorFX.this.snapshot(pdfStreamDecoder, f, pdfObject, countDownLatch, (SimpleObjectProperty<BufferedImage>)simpleObjectProperty);
                }
            });
        }
        try {
            if (!Platform.isFxApplicationThread()) {
                countDownLatch.await();
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        return (BufferedImage)simpleObjectProperty.get();
    }

    private void snapshot(PdfStreamDecoder pdfStreamDecoder, float f, PdfObject pdfObject, final CountDownLatch countDownLatch, final SimpleObjectProperty<BufferedImage> simpleObjectProperty) {
        try {
            pdfStreamDecoder.setObjectValue(-7, null);
            pdfStreamDecoder.decodePageContent(pdfObject);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        Group group = ((FXDisplay)this.imageDisplay).getFXPane();
        group.getTransforms().add((Object)Transform.affine((double)(1.0f * f), (double)0.0, (double)0.0, (double)(-1.0f * f), (double)this.crx, (double)((float)this.h + this.cry)));
        Scene scene = new Scene((Parent)group, (double)this.w, (double)this.h);
        scene.setFill((Paint)Color.rgb((int)255, (int)255, (int)255, (double)1.0));
        if (countDownLatch != null) {
            scene.snapshot((Callback)new Callback<SnapshotResult, Void>(){

                public Void call(SnapshotResult snapshotResult) {
                    simpleObjectProperty.set((Object)SwingFXUtils.fromFXImage((Image)snapshotResult.getImage(), null));
                    countDownLatch.countDown();
                    return null;
                }
            }, null);
        } else {
            simpleObjectProperty.set((Object)SwingFXUtils.fromFXImage((Image)scene.snapshot(null), null));
        }
    }
}

