/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import com.idrsolutions.pdf.color.blends.BlendMode;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.PathIterator;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.examples.handlers.DefaultImageHelper;
import org.jpedal.exception.PdfException;
import org.jpedal.external.ColorHandler;
import org.jpedal.external.FontHandler;
import org.jpedal.external.ImageHandler;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.io.ColorSpaceConvertor;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.T3ImageUtils;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public abstract class BaseDisplay
implements DynamicVectorRenderer {
    private boolean isRenderingToImage;
    protected Vector_Int objectType;
    protected static final int defaultSize = 5000;
    protected int type;
    boolean isType3Font;
    private boolean saveImageData = true;
    protected boolean addBackground = true;
    protected Vector_Rectangle_Int areas;
    protected ObjectStore objectStoreRef;
    protected int currentItem = -1;
    protected static int itemToRender = -1;
    protected static int endItem = -1;
    protected int pageRotation;
    Area lastClip;
    boolean hasClips;
    int blendMode = 1111314299;
    boolean colorsLocked;
    Graphics2D g2;
    boolean optimisedTurnCode = true;
    public boolean useHiResImageForDisplay;
    boolean extraRot;
    String rawKey;
    PdfPaint fillCol;
    PdfPaint strokeCol;
    public int rawPageNumber;
    int xx;
    int yy;
    public static boolean invertHighlight;
    boolean isPrinting;
    ImageHandler customImageHandler;
    ColorHandler customColorHandler;
    double cropX;
    double cropH;
    float scaling = 1.0f;
    float lastScaling;
    protected Vector_Object pageObjects;
    protected final Map imageIDtoName = new HashMap(10);
    protected boolean needsHorizontalInvert;
    protected boolean needsVerticalInvert;
    int w;
    int h;
    protected Color backgroundColor = Color.WHITE;
    protected static Color textColor;
    protected static int colorThresholdToReplace;
    protected boolean changeLineArtAndText;
    public static RenderingHints userHints;
    private DynamicVectorRenderer.Mode mode = DynamicVectorRenderer.Mode.PDF;

    @Override
    public void setInset(int n, int n2) {
        this.xx = n;
        this.yy = n2;
    }

    @Override
    public void setG2(Graphics2D graphics2D) {
        this.g2 = graphics2D;
        if (userHints != null) {
            this.g2.setRenderingHints(userHints);
        }
    }

    @Override
    public void init(int n, int n2, int n3, Color color) {
        this.w = n;
        this.h = n2;
        this.pageRotation = n3;
        this.backgroundColor = color;
    }

    @Override
    public void paintBackground(Shape shape) {
        if (this.addBackground && this.g2 != null) {
            this.g2.setColor(this.backgroundColor);
            if (shape == null) {
                this.g2.fill(new Rectangle(this.xx, this.yy, (int)((float)this.w * this.scaling), (int)((float)this.h * this.scaling)));
            } else {
                this.g2.fill(shape);
            }
        }
    }

    protected static boolean checkColorThreshold(int n) {
        int n2 = n & 0xFF;
        int n3 = n >> 8 & 0xFF;
        int n4 = n >> 16 & 0xFF;
        return n2 <= colorThresholdToReplace && n3 <= colorThresholdToReplace && n4 <= colorThresholdToReplace;
    }

    void renderEmbeddedText(int n, Object object, int n2, AffineTransform affineTransform, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f, float f2, int n3) {
        float f3 = 0.0f;
        if (n == 1 && (double)n3 >= 1.0) {
            f3 = this.scaling;
        }
        PdfGlyph pdfGlyph = (PdfGlyph)object;
        AffineTransform affineTransform2 = this.g2.getTransform();
        double[] dArray = new double[6];
        affineTransform2.getMatrix(dArray);
        if (pdfGlyph != null) {
            Color color;
            Stroke stroke = this.g2.getStroke();
            if (n3 != 0 || n == 3) {
                float f4 = (float)n3 * (float)this.g2.getTransform().getScaleX();
                if (f4 < 0.0f) {
                    f4 = -f4;
                }
                if (n != 3) {
                    // empty if block
                }
                if (!this.isPrinting) {
                    // empty if block
                }
                this.g2.setStroke(new BasicStroke(f4 += 32.0f - (float)this.g2.getTransform().getScaleX()));
            }
            this.g2.transform(affineTransform);
            Composite composite = this.g2.getComposite();
            if ((n & 2) == 2) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint2.getRGB())) {
                    pdfPaint2 = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, (float)affineTransform.getTranslateX(), (float)affineTransform.getTranslateY());
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(pdfPaint2);
                }
                this.renderComposite(f2);
                if (rectangle != null) {
                    if (invertHighlight) {
                        color = this.g2.getColor();
                        this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                    } else if (DecoderOptions.backgroundColor != null) {
                        this.g2.setColor(DecoderOptions.backgroundColor);
                    }
                }
                if (n2 == 6 && !pdfGlyph.ignoreColors()) {
                    pdfGlyph.setT3Colors(pdfPaint, pdfPaint2, false);
                }
                pdfGlyph.render(2, this.g2, this.scaling, false);
                this.g2.setComposite(composite);
            }
            if (n == 1) {
                pdfGlyph.setStrokedOnly(true);
            }
            if (!(DecoderOptions.isRunningOnMac && this.isPrinting && n == 3 || (n & 1) != 1)) {
                block32: {
                    if (pdfPaint != null) {
                        if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint.getRGB())) {
                            pdfPaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                        }
                        pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    if (this.customColorHandler != null) {
                        this.customColorHandler.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
                    } else if (DecoderOptions.Helper != null) {
                        DecoderOptions.Helper.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
                    } else {
                        this.g2.setPaint(pdfPaint);
                    }
                    this.renderComposite(f);
                    if (rectangle != null) {
                        if (invertHighlight) {
                            color = this.g2.getColor();
                            this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                        } else if (DecoderOptions.backgroundColor != null) {
                            this.g2.setColor(DecoderOptions.backgroundColor);
                        }
                    }
                    try {
                        pdfGlyph.render(1, this.g2, f3, false);
                    }
                    catch (Exception exception) {
                        if (!LogWriter.isOutput()) break block32;
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                }
                this.g2.setComposite(composite);
            }
            this.g2.setTransform(affineTransform2);
            if (n3 != 0) {
                this.g2.setStroke(stroke);
            }
        }
    }

    void renderShape(Shape shape, int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Object object, float f, float f2) {
        System.out.println("renderShape in base display should never be called");
    }

    void renderShape(Shape shape, int n, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, Shape shape2, float f, float f2) {
        boolean bl = false;
        Shape shape3 = this.g2.getClip();
        Composite composite = this.g2.getComposite();
        if (n == 2 || n == 3) {
            block22: {
                if (pdfPaint2 != null) {
                    if (pdfPaint2.getRGB() != -1 && this.changeLineArtAndText && textColor != null && !pdfPaint2.isPattern() && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint2.getRGB())) {
                        pdfPaint2 = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                    }
                    pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                }
                if (this.customColorHandler != null) {
                    this.customColorHandler.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                } else if (DecoderOptions.Helper != null) {
                    DecoderOptions.Helper.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                } else {
                    this.g2.setPaint(pdfPaint2);
                }
                this.renderComposite(f2);
                try {
                    double d = shape2.getBounds2D().getWidth();
                    double d2 = shape2.getBounds2D().getHeight();
                    if ((d2 == 0.0 || d == 0.0) && ((BasicStroke)this.g2.getStroke()).getLineWidth() <= 1.0f) {
                        this.g2.fillRect(shape2.getBounds().x, shape2.getBounds().y, shape2.getBounds().width, shape2.getBounds().height);
                    } else {
                        this.g2.fill(shape2);
                    }
                }
                catch (Exception exception) {
                    if (!LogWriter.isOutput()) break block22;
                    LogWriter.writeLog("Exception " + exception + " filling shape");
                }
            }
            this.g2.setComposite(composite);
        }
        if (n == 1 || n == 3) {
            Stroke stroke2 = this.g2.getStroke();
            if (shape2.getBounds2D().getWidth() < 1.0 && ((BasicStroke)stroke).getLineWidth() > 10.0f) {
                this.g2.setStroke(new BasicStroke(1.0f));
            } else {
                this.g2.setStroke(stroke);
            }
            if (this.changeLineArtAndText && textColor != null && !pdfPaint.isPattern() && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint.getRGB())) {
                pdfPaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
            }
            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint);
            }
            this.renderComposite(f);
            if (!this.isPrinting && shape3 != null && shape3.getBounds2D().getWidth() % 1.0 > (double)0.65f && shape3.getBounds2D().getHeight() % 1.0 > (double)0.1f && shape2.getBounds().getWidth() == shape3.getBounds().getWidth()) {
                this.g2.setClip(BaseDisplay.convertPDFClipToJavaClip(new Area(shape3)));
                bl = true;
            }
            if (!this.isPrinting && shape3 != null && (shape3.getBounds2D().getHeight() < 1.0 || shape3.getBounds2D().getWidth() < 1.0)) {
                this.g2.setClip(shape);
                bl = true;
            }
            this.g2.draw(shape2);
            this.g2.setStroke(stroke2);
            this.g2.setComposite(composite);
        }
        if (bl) {
            this.g2.setClip(shape3);
        }
    }

    void renderImage(AffineTransform affineTransform, BufferedImage object, float f, GraphicsState graphicsState, float f2, float f3, int n) {
        Object object2;
        AffineTransform affineTransform2;
        block53: {
            Object object3;
            boolean bl;
            boolean bl2 = bl = graphicsState != null;
            if (object == null || this.g2 == null) {
                return;
            }
            int n2 = ((BufferedImage)object).getWidth();
            int n3 = ((BufferedImage)object).getHeight();
            AffineTransform affineTransform3 = new AffineTransform();
            boolean bl3 = false;
            float[][] fArray = new float[3][3];
            if (graphicsState != null) {
                fArray = graphicsState.CTM;
            }
            if (fArray[0][0] < 0.0f && fArray[1][1] < 0.0f && fArray[1][0] > -2.0f && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][1] < 10.0f) {
                fArray[0][1] = 0.0f;
                fArray[1][0] = 0.0f;
            }
            affineTransform2 = this.g2.getTransform();
            boolean bl4 = false;
            float f4 = 0.0f;
            float f5 = 0.0f;
            if (bl || this.useHiResImageForDisplay) {
                if (bl) {
                    affineTransform3 = null;
                    if ((n & 1) != 1) {
                        if (!this.optimisedTurnCode) {
                            object = RenderUtils.invertImage((BufferedImage)object);
                        } else if (fArray[0][1] < 0.0f && fArray[1][0] > 0.0f && fArray[0][0] * fArray[1][1] == 0.0f) {
                            affineTransform3 = new AffineTransform(fArray[0][0] / (float)n2, fArray[0][1] / (float)n2, -fArray[1][0] / (float)n3, fArray[1][1] / (float)n3, fArray[2][0] + fArray[1][0], fArray[2][1]);
                        } else if (fArray[0][1] != 0.0f || fArray[1][0] != 0.0f) {
                            object2 = new float[][]{{1.0f / (float)n2, 0.0f, 0.0f}, {0.0f, -1.0f / (float)n3, 0.0f}, {0.0f, 1.0f / (float)n3, 1.0f}};
                            object3 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            object2 = Matrix.multiply((float[][])object2, (float[][])object3);
                            affineTransform3 = new AffineTransform((float)object2[0][0], (float)object2[0][1], (float)object2[1][0], (float)object2[1][1], (float)object2[2][0], (float)object2[2][1]);
                            f4 = ((BufferedImage)object).getHeight() > 1 ? fArray[2][0] - (float)((BufferedImage)object).getHeight() * object2[1][0] : fArray[2][0];
                            f5 = fArray[2][1];
                            f5 += fArray[1][1];
                        } else if (fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f) {
                            object2 = new float[][]{{-1.0f / (float)n2, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n3, 0.0f}, {1.0f / (float)n2, 0.0f, 1.0f}};
                            object3 = new float[][]{{fArray[0][0], fArray[0][1], 0.0f}, {fArray[1][0], fArray[1][1], 0.0f}, {0.0f, 0.0f, 1.0f}};
                            object2 = Matrix.multiply((float[][])object2, (float[][])object3);
                            affineTransform3 = new AffineTransform((float)object2[0][0], (float)object2[1][0], (float)object2[0][1], (float)object2[1][1], (float)object2[2][0], (float)object2[2][1]);
                            f4 = fArray[2][0] - (float)((BufferedImage)object).getHeight() * object2[0][1];
                            f5 = fArray[2][1];
                        } else if (fArray[1][1] != 0.0f) {
                            bl4 = true;
                        }
                    }
                    if (affineTransform3 == null) {
                        affineTransform3 = new AffineTransform(fArray[0][0] / (float)n2, fArray[0][1] / (float)n2, fArray[1][0] / (float)n3, fArray[1][1] / (float)n3, fArray[2][0], fArray[2][1]);
                    }
                } else {
                    affineTransform3 = affineTransform;
                    bl4 = (n & 4) == 4;
                }
                bl3 = true;
            }
            object2 = this.g2.getComposite();
            this.renderComposite(f);
            if (this.isType3Font && this.fillCol != null && (object = T3ImageUtils.handleType3Image((BufferedImage)object, this.fillCol)) == null) {
                return;
            }
            if (bl || this.useHiResImageForDisplay) {
                try {
                    double d;
                    Object object4;
                    if (this.optimisedTurnCode && bl4 && (n & 1) != 1) {
                        object3 = new double[6];
                        affineTransform3.getMatrix((double[])object3);
                        f4 = (float)(object3[4] + object3[1] * (double)((BufferedImage)object).getWidth());
                        f5 = (float)(object3[5] + (double)((BufferedImage)object).getHeight() * object3[3]);
                        if (object3[0] > 0.0 && object3[1] > 0.0 && object3[2] > 0.0 && object3[3] < 0.0) {
                            object3[2] = -object3[2];
                        }
                        object3[3] = -object3[3];
                        object3[4] = 0.0;
                        object3[5] = 0.0;
                        affineTransform3 = new AffineTransform((double[])object3);
                    }
                    boolean bl5 = this.customImageHandler != null;
                    this.g2.translate(f4, f5);
                    if (bl5) {
                        bl5 = this.customImageHandler.drawImageOnscreen((BufferedImage)object, n, affineTransform3, null, this.g2, bl, this.objectStoreRef, this.isPrinting);
                    }
                    if (bl5) {
                        this.g2.setComposite((Composite)object2);
                        return;
                    }
                    if (this.customColorHandler != null) {
                        object4 = this.customColorHandler.processImage((BufferedImage)object, this.rawPageNumber, this.isPrinting);
                        if (object4 != null) {
                            object = object4;
                        }
                    } else if (DecoderOptions.Helper != null && (object4 = DecoderOptions.Helper.processImage((BufferedImage)object, this.rawPageNumber, this.isPrinting)) != null) {
                        object = object4;
                    }
                    object4 = this.g2.getClip();
                    boolean bl6 = false;
                    if (object4 != null) {
                        boolean bl7;
                        double d2 = this.g2.getClip().getBounds2D().getY();
                        double d3 = this.g2.getClip().getBounds2D().getHeight();
                        double d4 = (double)((BufferedImage)object).getHeight() - d3;
                        if (d4 < 0.0) {
                            d4 = -d4;
                        }
                        if (d4 > 0.0 && d4 < 1.0 && d2 < 0.0 && ((BufferedImage)object).getHeight() > 1 && ((BufferedImage)object).getHeight() < 10 && (bl7 = BaseDisplay.isSimpleOutline(this.g2.getClip()))) {
                            d = this.g2.getClip().getBounds2D().getX();
                            double d5 = this.g2.getClip().getBounds2D().getWidth();
                            this.g2.setClip(new Rectangle((int)d, (int)d2, (int)d5, (int)d3));
                            bl6 = false;
                        }
                    }
                    AffineTransform affineTransform4 = this.g2.getTransform();
                    double d6 = affineTransform4.getScaleX();
                    double d7 = affineTransform4.getScaleX();
                    double d8 = affineTransform3.getScaleX();
                    d = affineTransform3.getScaleY();
                    if (((BufferedImage)object).getType() != 0 && d6 == 0.0 && d7 == 0.0 && d8 > 0.0 && d < 0.0) {
                        d6 = affineTransform4.getShearX();
                        d7 = affineTransform4.getShearY();
                        d8 = Math.abs(d8);
                        d = Math.abs(d);
                        if (d6 > 0.0 && d7 > 0.0) {
                            int n4 = Math.abs((int)((double)((BufferedImage)object).getWidth() * d8 * d6));
                            int n5 = Math.abs((int)((double)((BufferedImage)object).getHeight() * d * d7));
                            if (n4 > 0 && n5 > 0 && n4 > ((BufferedImage)object).getWidth() && n5 > ((BufferedImage)object).getHeight()) {
                                BufferedImage bufferedImage = new BufferedImage(n4, n5, ((BufferedImage)object).getType());
                                Graphics2D graphics2D = bufferedImage.createGraphics();
                                graphics2D.setRenderingHints(this.g2.getRenderingHints());
                                graphics2D.drawImage((Image)object, AffineTransform.getScaleInstance(d6 * d8, d7 * d), null);
                                affineTransform3.scale(1.0 / d8, -(1.0 / d));
                                affineTransform4.scale(1.0 / d6, -(1.0 / d7));
                                this.g2.setTransform(affineTransform4);
                                object = bufferedImage;
                            }
                        }
                    }
                    this.g2.drawImage((Image)object, affineTransform3, null);
                    if (bl6) {
                        this.g2.setClip((Shape)object4);
                    }
                    break block53;
                }
                catch (Exception exception) {
                    if (LogWriter.isOutput()) {
                        LogWriter.writeLog("Exception: " + exception.getMessage());
                    }
                    break block53;
                }
            }
            try {
                if (bl3) {
                    object3 = new AffineTransformOp(affineTransform3, ColorSpaces.hints);
                    object = ((AffineTransformOp)object3).filter((BufferedImage)object, null);
                }
                this.g2.translate(f2, f3);
                if (this.optimisedTurnCode && (n & 4) == 4) {
                    float[] fArray2 = new float[]{1.0f, 0.0f, 0.0f, -1.0f, 0.0f, ((BufferedImage)object).getHeight()};
                    if (this.pageRotation == 0) {
                        object3 = new AffineTransform(fArray2);
                    } else if (this.pageRotation == 90) {
                        object3 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object3).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object3).rotate(1.5707963267948966, 0.0, 0.0);
                        }
                        ((AffineTransform)object3).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        AffineTransform affineTransform5 = new AffineTransform(fArray2);
                        ((AffineTransform)object3).concatenate(affineTransform5);
                    } else if (this.pageRotation == 180) {
                        object3 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object3).rotate(Math.PI, 0.0, 0.0);
                        }
                        ((AffineTransform)object3).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        AffineTransform affineTransform6 = new AffineTransform(fArray2);
                        ((AffineTransform)object3).concatenate(affineTransform6);
                    } else {
                        object3 = new AffineTransform();
                        if (this.extraRot) {
                            ((AffineTransform)object3).rotate(Math.PI, 0.0, 0.0);
                        } else {
                            ((AffineTransform)object3).rotate(4.71238898038469, 0.0, 0.0);
                        }
                        ((AffineTransform)object3).translate(-((BufferedImage)object).getWidth(), -((BufferedImage)object).getHeight());
                        fArray2 = new float[]{-1.0f, 0.0f, 0.0f, 1.0f, ((BufferedImage)object).getWidth(), 0.0f};
                        AffineTransform affineTransform7 = new AffineTransform(fArray2);
                        ((AffineTransform)object3).concatenate(affineTransform7);
                    }
                    this.g2.drawImage((Image)object, (AffineTransform)object3, null);
                } else {
                    this.g2.drawImage((Image)object, 0, 0, null);
                }
                this.g2.translate(-f2, -f3);
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block53;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.g2.setTransform(affineTransform2);
        this.g2.setComposite((Composite)object2);
    }

    public static boolean isSimpleOutline(Shape shape) {
        int n;
        PathIterator pathIterator = shape.getPathIterator(null);
        for (n = 0; !pathIterator.isDone() && n < 6; ++n) {
            pathIterator.next();
        }
        return n < 6;
    }

    final void renderText(float f, float f2, int n, Area area, Rectangle rectangle, PdfPaint pdfPaint, PdfPaint pdfPaint2, float f3, float f4) {
        Color color;
        Paint paint = this.g2.getPaint();
        Composite composite = this.g2.getComposite();
        if ((n & 2) == 2) {
            if (pdfPaint2 != null) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint2.getRGB())) {
                    pdfPaint2 = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint2);
            }
            this.renderComposite(f4);
            if (rectangle != null) {
                if (invertHighlight) {
                    color = this.g2.getColor();
                    this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            this.g2.fill(area);
            this.g2.setComposite(composite);
        }
        if ((n & 1) == 1) {
            float f5;
            if (pdfPaint != null) {
                if (textColor != null && (itemToRender == -1 || endItem == -1 || itemToRender <= endItem) && BaseDisplay.checkColorThreshold(pdfPaint.getRGB())) {
                    pdfPaint = new PdfColor(textColor.getRed(), textColor.getGreen(), textColor.getBlue());
                }
                pdfPaint.setScaling(this.cropX + (double)f, this.cropH + (double)f2, this.scaling, f, f2);
            }
            if (this.customColorHandler != null) {
                this.customColorHandler.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
            } else if (DecoderOptions.Helper != null) {
                DecoderOptions.Helper.setPaint(this.g2, pdfPaint, this.rawPageNumber, this.isPrinting);
            } else {
                this.g2.setPaint(pdfPaint);
            }
            this.renderComposite(f3);
            if (rectangle != null) {
                if (invertHighlight) {
                    color = this.g2.getColor();
                    this.g2.setColor(new Color(255 - color.getRed(), 255 - color.getGreen(), 255 - color.getBlue()));
                } else if (DecoderOptions.backgroundColor != null) {
                    this.g2.setColor(DecoderOptions.backgroundColor);
                }
            }
            if ((f5 = (float)(1.0 / this.g2.getTransform().getScaleX())) < 0.0f) {
                f5 = -f5;
            }
            this.g2.setStroke(new BasicStroke(f5));
            if (f5 < 0.1f) {
                this.g2.draw(area);
            } else {
                this.g2.fill(area);
            }
            this.g2.setComposite(composite);
        }
        this.g2.setPaint(paint);
    }

    @Override
    public ObjectStore getObjectStore() {
        return this.objectStoreRef;
    }

    @Override
    public void setHiResImageForDisplayMode(boolean bl) {
        this.useHiResImageForDisplay = bl;
    }

    @Override
    public void setScalingValues(double d, double d2, float f) {
        this.cropX = d;
        this.cropH = d2;
        this.scaling = f;
    }

    @Override
    public void setCustomImageHandler(ImageHandler imageHandler) {
        this.customImageHandler = imageHandler;
    }

    @Override
    public void setCustomColorHandler(ColorHandler colorHandler) {
        this.customColorHandler = colorHandler;
    }

    @Override
    public void resetOnColorspaceChange() {
    }

    @Override
    public void drawFontBounds(Rectangle rectangle) {
    }

    @Override
    public void drawAffine(double[] dArray) {
    }

    @Override
    public void drawFontSize(int n) {
    }

    @Override
    public void setLineWidth(int n) {
    }

    @Override
    public void stopClearOnNextRepaint(boolean bl) {
    }

    @Override
    public boolean hasObjectsBehind(float[][] fArray) {
        int n;
        boolean bl = false;
        int n2 = (int)fArray[2][0];
        int n3 = (int)fArray[2][1];
        int n4 = (int)fArray[0][0];
        if (n4 == 0) {
            n4 = (int)fArray[0][1];
        }
        if ((n = (int)fArray[1][1]) == 0) {
            n = (int)fArray[1][0];
        }
        if (n < 0) {
            n3 += n;
        }
        if (n4 < 0) {
            n2 += n4;
            n4 = n2 - n4;
        }
        if (this.areas == null) {
            return true;
        }
        int[][] nArray = this.areas.get();
        int n5 = nArray.length;
        for (int i = 0; i < n5; ++i) {
            boolean bl2;
            if (nArray[i] == null) continue;
            int n6 = nArray[i][0];
            int n7 = nArray[i][1];
            int n8 = nArray[i][2];
            int n9 = nArray[i][3];
            boolean bl3 = BaseDisplay.valueInRange(n2, n6, n6 + n8) || BaseDisplay.valueInRange(n6, n2, n2 + n4);
            boolean bl4 = bl2 = bl3 && BaseDisplay.valueInRange(n3, n7, n7 + n9) || BaseDisplay.valueInRange(n7, n3, n3 + n);
            if (!bl3 || !bl2) continue;
            i = n5;
            bl = true;
        }
        return bl;
    }

    private static boolean valueInRange(int n, int n2, int n3) {
        return n >= n2 && n <= n3;
    }

    @Override
    public void flagDecodingFinished() {
    }

    @Override
    public void flagImageDeleted(int n) {
    }

    @Override
    public void setOCR(boolean bl) {
    }

    @Override
    public byte[] serializeToByteArray(Set set) throws IOException {
        return new byte[0];
    }

    @Override
    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
    }

    @Override
    public Rectangle getArea(int n) {
        return null;
    }

    @Override
    public int[] getAreaAsArray(int n) {
        return this.areas.elementAt(n);
    }

    @Override
    public int isInsideImage(int n, int n2) {
        int n3 = -1;
        int[][] nArray = this.areas.get();
        int[] nArray2 = null;
        int n4 = nArray.length;
        if (this.objectType != null) {
            int[] nArray3 = this.objectType.get();
            for (int i = 0; i < n4; ++i) {
                if (nArray[i] == null || !RenderUtils.rectangleContains(nArray[i], n, n2) || nArray3[i] != 3) continue;
                if (nArray2 != null) {
                    int n5 = nArray[i][3] * nArray[i][2];
                    void var9_9 = nArray2[3] * nArray2[2];
                    if (n5 < var9_9) {
                        nArray2 = nArray[i];
                    }
                    n3 = i;
                    continue;
                }
                nArray2 = nArray[i];
                n3 = i;
            }
        }
        return n3;
    }

    @Override
    public void saveImage(int n, String string, String string2) {
        block10: {
            BufferedImage bufferedImage;
            String string3 = (String)this.imageIDtoName.get(n);
            if (this.useHiResImageForDisplay) {
                bufferedImage = this.objectStoreRef.loadStoredImage(string3);
                if (bufferedImage == null) {
                    bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
                }
            } else {
                bufferedImage = (BufferedImage)this.pageObjects.elementAt(n);
            }
            if (bufferedImage != null) {
                if (!this.optimisedTurnCode) {
                    bufferedImage = RenderUtils.invertImage(bufferedImage);
                }
                if (bufferedImage.getType() == 0 || string2.equals("jpg") && bufferedImage.getType() == 2) {
                    bufferedImage = ColorSpaceConvertor.convertToRGB(bufferedImage);
                }
                if (this.needsHorizontalInvert) {
                    bufferedImage = RenderUtils.invertImageBeforeSave(bufferedImage, true);
                }
                if (this.needsVerticalInvert) {
                    bufferedImage = RenderUtils.invertImageBeforeSave(bufferedImage, false);
                }
                try {
                    DefaultImageHelper.write(bufferedImage, string2, string);
                }
                catch (IOException iOException) {
                    if (!LogWriter.isOutput()) break block10;
                    LogWriter.writeLog("Exception in writing image " + iOException);
                }
            }
        }
    }

    protected void showMessageDialog(String string) {
    }

    @Override
    public int getType() {
        return this.type;
    }

    @Override
    public int getObjectUnderneath(int n, int n2) {
        int n3 = -1;
        int[][] nArray = this.areas.get();
        int n4 = nArray.length;
        if (this.objectType != null) {
            int[] nArray2 = this.objectType.get();
            boolean bl = true;
            for (int i = n4 - 1; i > -1; --i) {
                if (nArray[i] == null || !RenderUtils.rectangleContains(nArray[i], n, n2) || nArray2[i] == 2 || nArray2[i] == 7) continue;
                bl = false;
                n3 = nArray2[i];
                i = -1;
            }
            if (bl) {
                return -1;
            }
        }
        return n3;
    }

    @Override
    public void setneedsVerticalInvert(boolean bl) {
        this.needsVerticalInvert = bl;
    }

    @Override
    public void setneedsHorizontalInvert(boolean bl) {
        this.needsHorizontalInvert = bl;
    }

    @Override
    public void stopG2HintSetting(boolean bl) {
    }

    @Override
    public void setPrintPage(int n) {
    }

    @Override
    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
    }

    @Override
    public void drawCustom(Object object) {
    }

    @Override
    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, double[] dArray, String string, PdfFont pdfFont, float f) {
    }

    @Override
    public void paint(Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle) {
    }

    @Override
    public void setMessageFrame(Container container) {
    }

    @Override
    public void dispose() {
    }

    @Override
    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        return -1;
    }

    @Override
    public void drawFillColor(PdfPaint pdfPaint) {
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
    }

    @Override
    public void flushAdditionalObjOnPage() {
    }

    @Override
    public void setOptimsePainting(boolean bl) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
    }

    @Override
    public Rectangle getOccupiedArea() {
        return null;
    }

    @Override
    public void setGraphicsState(int n, float f, int n2) {
    }

    @Override
    public void drawStrokeColor(Paint paint) {
    }

    @Override
    public void drawTR(int n) {
    }

    @Override
    public void drawStroke(Stroke stroke) {
    }

    @Override
    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
    }

    @Override
    public void writeCustom(int n, Object object) {
    }

    @Override
    public void flagCommand(int n, int n2) {
    }

    @Override
    public void setValue(int n, int n2) {
        switch (n) {
            case 1: {
                this.backgroundColor = new Color(n2);
                break;
            }
            case 2: {
                textColor = new Color(n2);
                break;
            }
            case 3: {
                this.changeLineArtAndText = n2 > 0;
                break;
            }
            case 4: {
                colorThresholdToReplace = n2;
            }
        }
    }

    @Override
    public int getValue(int n) {
        return -1;
    }

    @Override
    public BufferedImage getSingleImagePattern() {
        return null;
    }

    @Override
    public boolean isScalingControlledByUser() {
        return false;
    }

    @Override
    public boolean avoidDownSamplingImage() {
        return false;
    }

    @Override
    public boolean getBooleanValue(int n) {
        return false;
    }

    @Override
    public float getScaling() {
        return this.scaling;
    }

    @Override
    public void saveAdvanceWidth(String string, String string2, int n) {
    }

    public static int isRectangle(Shape shape) {
        int n;
        PathIterator pathIterator = shape.getPathIterator(null);
        for (n = 0; !pathIterator.isDone() && n < 8; ++n) {
            pathIterator.next();
        }
        return n;
    }

    @Override
    public void setMode(DynamicVectorRenderer.Mode mode) {
        this.mode = mode;
    }

    @Override
    public DynamicVectorRenderer.Mode getMode() {
        return this.mode;
    }

    @Override
    public Object getObjectValue(int n) {
        return null;
    }

    @Override
    public void drawShape(Object object, GraphicsState graphicsState, int n) {
        System.out.println("drawShape in BaseDisplay Should never be called");
    }

    @Override
    public void eliminateHiddenText(Shape shape, GraphicsState graphicsState, int n, boolean bl) {
    }

    private void renderComposite(float f) {
        if (this.blendMode == 1111314299 || this.blendMode == 1987215544) {
            if (f != 1.0f) {
                this.g2.setComposite(AlphaComposite.getInstance(3, f));
            }
        } else {
            BlendMode blendMode = new BlendMode(this.blendMode, f);
            this.g2.setComposite(blendMode);
        }
    }

    @Override
    public boolean isHTMLorSVG() {
        return false;
    }

    @Override
    public void saveImageData(boolean bl) {
        this.saveImageData = bl;
    }

    @Override
    public boolean saveImageData() {
        return this.saveImageData;
    }

    public boolean isRenderingToImage() {
        return this.isRenderingToImage;
    }

    @Override
    public void setIsRenderingToImage(boolean bl) {
        this.isRenderingToImage = bl;
    }

    public static Area convertPDFClipToJavaClip(Area area) {
        if (area != null) {
            double d = (area.getBounds2D().getWidth() + 2.0) / area.getBounds2D().getWidth();
            double d2 = (area.getBounds2D().getHeight() + 2.0) / area.getBounds2D().getHeight();
            double d3 = area.getBounds2D().getX();
            double d4 = area.getBounds2D().getY();
            Area area2 = (Area)area.clone();
            area2.transform(AffineTransform.getTranslateInstance(-d3, -d4));
            area2.transform(AffineTransform.getScaleInstance(d, d2));
            area2.transform(AffineTransform.getTranslateInstance(d3 - 1.0, d4 - 1.0));
            return area2;
        }
        return area;
    }

    @Override
    public FontHandler getFontHandler() {
        return null;
    }

    static {
        colorThresholdToReplace = 255;
    }
}

