/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.render;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javafx.geometry.Bounds;
import javafx.scene.shape.Path;
import javax.swing.JOptionPane;
import org.jpedal.color.ColorSpaces;
import org.jpedal.color.PdfColor;
import org.jpedal.color.PdfPaint;
import org.jpedal.exception.PdfException;
import org.jpedal.external.JPedalCustomDrawObject;
import org.jpedal.fonts.PdfFont;
import org.jpedal.fonts.glyph.GlyphFactory;
import org.jpedal.fonts.glyph.PdfGlyph;
import org.jpedal.fonts.glyph.PdfGlyphs;
import org.jpedal.fonts.glyph.PdfJavaGlyphs;
import org.jpedal.io.ObjectStore;
import org.jpedal.objects.GraphicsState;
import org.jpedal.parser.DecoderOptions;
import org.jpedal.render.BaseDisplay;
import org.jpedal.render.DynamicVectorRenderer;
import org.jpedal.render.GUIDisplay;
import org.jpedal.render.RenderUtils;
import org.jpedal.render.T3Display;
import org.jpedal.utils.LogWriter;
import org.jpedal.utils.Matrix;
import org.jpedal.utils.Messages;
import org.jpedal.utils.repositories.Vector_Double;
import org.jpedal.utils.repositories.Vector_Float;
import org.jpedal.utils.repositories.Vector_Int;
import org.jpedal.utils.repositories.Vector_Object;
import org.jpedal.utils.repositories.Vector_Rectangle;
import org.jpedal.utils.repositories.Vector_Shape;
import org.jpedal.utils.repositories.generic.Vector_Rectangle_Int;

public class SwingDisplay
extends GUIDisplay {
    boolean ignoreHighlight;
    float lastStrokeOpacity;
    float lastFillOpacity;
    private boolean noRepaint;
    private int lastItemPainted;
    private boolean optimsePainting;
    private int pageX1;
    private int pageX2;
    private int pageY1;
    private int pageY2;
    private boolean highlightsNeedToBeGenerated;
    private BufferedImage singleImage;
    private int imageCount;
    private static final RenderingHints hints = new RenderingHints(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
    private static final boolean newHighlight = true;
    private final Map cachedWidths;
    private final Map cachedHeights;
    private Map fonts;
    private Set<String> fontsUsed;
    protected GlyphFactory factory;
    private PdfGlyphs glyphs;
    private Map imageID;
    private Map storedImageValues;
    private int[] textHighlightsX;
    private int[] textHighlightsWidth;
    private int[] textHighlightsHeight;
    boolean stopG2setting;
    float[] x_coord;
    float[] y_coord;
    private Map largeImages;
    private Vector_Object text_color;
    private Vector_Object stroke_color;
    private Vector_Object fill_color;
    private Vector_Object stroke;
    Vector_Int shapeType;
    private Vector_Rectangle fontBounds;
    private Vector_Double af1;
    private Vector_Double af2;
    private Vector_Double af3;
    private Vector_Double af4;
    private Vector_Int imageOptions;
    private Vector_Int TRvalues;
    private Vector_Int fs;
    private Vector_Int lw;
    private Vector_Shape clips;
    private Vector_Object javaObjects;
    private Vector_Int textFillType;
    private Vector_Float opacity;
    private Vector_Int BMvalues;
    int lastFillTextCol;
    int lastFillCol;
    int lastStrokeCol;
    Stroke lastStroke;
    private double[] lastAf;
    private int lastTR;
    private int lastFS;
    private int lastLW;
    boolean resetTextColors;
    boolean fillSet;
    boolean strokeSet;
    private boolean needsHighlights;
    private int paintThreadCount;
    private int paintThreadID;
    private boolean[] drawnHighlights;
    private boolean hasOCR;
    protected int type;
    private boolean renderFailed;
    private Container frame;
    private static boolean userAlerted;
    private Rectangle[] objectAreas;

    public SwingDisplay() {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.currentItem = 0;
    }

    void setupArrays(int n) {
        this.x_coord = new float[n];
        this.y_coord = new float[n];
        this.text_color = new Vector_Object(n);
        this.textFillType = new Vector_Int(n);
        this.stroke_color = new Vector_Object(n);
        this.fill_color = new Vector_Object(n);
        this.stroke = new Vector_Object(n);
        this.pageObjects = new Vector_Object(n);
        this.javaObjects = new Vector_Object(n);
        this.shapeType = new Vector_Int(n);
        this.areas = new Vector_Rectangle_Int(n);
        this.af1 = new Vector_Double(n);
        this.af2 = new Vector_Double(n);
        this.af3 = new Vector_Double(n);
        this.af4 = new Vector_Double(n);
        this.fontBounds = new Vector_Rectangle(n);
        this.clips = new Vector_Shape(n);
        this.objectType = new Vector_Int(n);
        this.opacity = new Vector_Float(n);
        this.currentItem = 0;
    }

    public SwingDisplay(int n, boolean bl, int n2, ObjectStore objectStore) {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.rawPageNumber = n;
        this.objectStoreRef = objectStore;
        this.addBackground = bl;
        this.setupArrays(n2);
    }

    public SwingDisplay(int n, ObjectStore objectStore, boolean bl) {
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
        this.lastItemPainted = -1;
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.cachedWidths = new HashMap(10);
        this.cachedHeights = new HashMap(10);
        this.fonts = new HashMap(50);
        this.fontsUsed = new HashSet<String>(50);
        this.imageID = new HashMap(10);
        this.storedImageValues = new HashMap(10);
        this.largeImages = new WeakHashMap(10);
        this.lastAf = new double[4];
        this.lastTR = 2;
        this.lastFS = -1;
        this.lastLW = -1;
        this.resetTextColors = true;
        this.needsHighlights = true;
        this.type = 1;
        this.rawPageNumber = n;
        this.objectStoreRef = objectStore;
        this.isPrinting = bl;
        this.setupArrays(5000);
    }

    @Override
    public void setOptimsePainting(boolean bl) {
        this.optimsePainting = bl;
        this.lastItemPainted = -1;
    }

    private void renderHighlight(Rectangle rectangle, Graphics2D graphics2D) {
        if (rectangle != null && !this.ignoreHighlight) {
            Shape shape = graphics2D.getClip();
            graphics2D.setClip(null);
            Composite composite = graphics2D.getComposite();
            Paint paint = graphics2D.getPaint();
            graphics2D.setComposite(AlphaComposite.getInstance(3, DecoderOptions.highlightComposite));
            if (invertHighlight) {
                graphics2D.setColor(Color.WHITE);
                graphics2D.setXORMode(Color.BLACK);
            } else {
                graphics2D.setPaint(DecoderOptions.highlightColor);
            }
            graphics2D.fill(rectangle);
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
            this.needsHighlights = false;
            graphics2D.setClip(shape);
        }
    }

    @Override
    public void stopG2HintSetting(boolean bl) {
        this.stopG2setting = bl;
    }

    @Override
    public void flush() {
        this.singleImage = null;
        this.imageCount = 0;
        this.lastFS = -1;
        this.objectAreas = null;
        if (this.shapeType != null) {
            this.shapeType.clear();
            this.pageObjects.clear();
            this.objectType.clear();
            this.javaObjects.clear();
            this.areas.clear();
            this.clips.clear();
            this.x_coord = new float[5000];
            this.y_coord = new float[5000];
            this.textFillType.clear();
            this.text_color.clear();
            this.fill_color.clear();
            this.stroke_color.clear();
            this.stroke.clear();
            if (this.TRvalues != null) {
                this.TRvalues = null;
            }
            if (this.imageOptions != null) {
                this.imageOptions = null;
            }
            if (this.fs != null) {
                this.fs = null;
            }
            if (this.lw != null) {
                this.lw = null;
            }
            this.af1.clear();
            this.af2.clear();
            this.af3.clear();
            this.af4.clear();
            this.fontBounds.clear();
            if (this.opacity != null) {
                this.opacity.clear();
            }
            if (this.BMvalues != null) {
                this.BMvalues.clear();
            }
            this.lastStrokeOpacity = -1.0f;
            this.lastFillOpacity = -1.0f;
            if (this.isPrinting) {
                this.largeImages.clear();
            }
            endItem = -1;
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.currentItem = 0;
        this.fillSet = false;
        this.strokeSet = false;
        this.fonts.clear();
        this.fontsUsed.clear();
        this.imageID.clear();
        this.pageX1 = 9999;
        this.pageX2 = -9999;
        this.pageY1 = -9999;
        this.pageY2 = 9999;
        this.lastScaling = 0.0f;
    }

    @Override
    public void dispose() {
        this.singleImage = null;
        this.shapeType = null;
        this.pageObjects = null;
        this.objectType = null;
        this.areas = null;
        this.clips = null;
        this.x_coord = null;
        this.y_coord = null;
        this.textFillType = null;
        this.text_color = null;
        this.fill_color = null;
        this.stroke_color = null;
        this.stroke = null;
        this.TRvalues = null;
        this.imageOptions = null;
        this.fs = null;
        this.lw = null;
        this.af1 = null;
        this.af2 = null;
        this.af3 = null;
        this.af4 = null;
        this.fontBounds = null;
        this.opacity = null;
        this.BMvalues = null;
        this.largeImages = null;
        this.lastClip = null;
        this.lastStroke = null;
        this.lastAf = null;
        this.fonts = null;
        this.fontsUsed = null;
        this.imageID = null;
        this.storedImageValues = null;
    }

    @Override
    public void paint(Rectangle[] rectangleArray, AffineTransform affineTransform, Rectangle rectangle) {
        int n;
        Shape shape;
        Vector_Rectangle vector_Rectangle = null;
        HashSet<String> hashSet = null;
        if (this.hasOCR) {
            vector_Rectangle = new Vector_Rectangle(4000);
            hashSet = new HashSet<String>(10);
        }
        int n2 = ++this.paintThreadID;
        ++this.paintThreadCount;
        if (rectangleArray != null) {
            this.drawnHighlights = new boolean[rectangleArray.length];
            for (int i = 0; i != this.drawnHighlights.length; ++i) {
                this.drawnHighlights[i] = false;
            }
        }
        if (this.paintThreadCount > 1) {
            block108: {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {
                    if (!LogWriter.isOutput()) break block108;
                    LogWriter.writeLog("Exception: " + interruptedException.getMessage());
                }
            }
            if (n2 != this.paintThreadID) {
                --this.paintThreadCount;
                return;
            }
        }
        float f = 0.0f;
        float f2 = 0.0f;
        float f3 = 0.0f;
        float f4 = 0.0f;
        Rectangle rectangle2 = null;
        int[] nArray = this.objectType.get();
        int[] nArray2 = this.textFillType.get();
        int n3 = this.currentItem;
        Area[] areaArray = this.clips.get();
        double[] dArray = this.af1.get();
        int[] nArray3 = null;
        if (this.fs != null) {
            nArray3 = this.fs.get();
        }
        int[] nArray4 = null;
        if (this.lw != null) {
            nArray4 = this.lw.get();
        }
        double[] dArray2 = this.af2.get();
        double[] dArray3 = this.af3.get();
        double[] dArray4 = this.af4.get();
        Object[] objectArray = this.text_color.get();
        Object[] objectArray2 = this.fill_color.get();
        Object[] objectArray3 = this.stroke_color.get();
        Object[] objectArray4 = this.pageObjects.get();
        Object[] objectArray5 = this.javaObjects.get();
        Object[] objectArray6 = this.stroke.get();
        int[] nArray5 = this.shapeType.get();
        float[] fArray = null;
        if (this.opacity != null) {
            fArray = this.opacity.get();
        }
        int[] nArray6 = null;
        if (this.BMvalues != null) {
            nArray6 = this.BMvalues.get();
        }
        int[] nArray7 = null;
        if (this.TRvalues != null) {
            nArray7 = this.TRvalues.get();
        }
        int[][] nArray8 = null;
        if (this.areas != null) {
            nArray8 = this.areas.get();
        }
        int[] nArray9 = null;
        if (this.imageOptions != null) {
            nArray9 = this.imageOptions.get();
        }
        boolean bl = false;
        Shape shape2 = null;
        if (this.g2 != null) {
            shape = this.g2.getClip();
            if (shape != null) {
                rectangle2 = shape.getBounds();
            }
            shape2 = this.g2.getClip();
        }
        shape = null;
        boolean bl2 = false;
        if (this.noRepaint) {
            this.noRepaint = false;
        } else if (this.lastItemPainted == -1) {
            this.paintBackground(rectangle2);
        }
        AffineTransform affineTransform2 = null;
        if (this.g2 != null) {
            affineTransform2 = this.g2.getTransform();
            if (affineTransform != null) {
                this.g2.transform(affineTransform);
                shape2 = this.g2.getClip();
            }
        }
        int n4 = 2;
        int n5 = 0;
        float f5 = 1.0f;
        float f6 = 1.0f;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = -1;
        int n10 = 0;
        int n11 = -1;
        int n12 = 0;
        int n13 = 0;
        int n14 = 0;
        int n15 = 0;
        int n16 = 0;
        int n17 = 0;
        int n18 = 0;
        int n19 = 0;
        PdfPaint pdfPaint = null;
        PdfPaint pdfPaint2 = null;
        PdfPaint pdfPaint3 = null;
        PdfPaint pdfPaint4 = null;
        Stroke stroke = null;
        if (this.colorsLocked) {
            pdfPaint4 = this.strokeCol;
            pdfPaint3 = this.fillCol;
        }
        if (this.highlightsNeedToBeGenerated) {
            // empty if block
        }
        block38: for (n = 0; n < n3; ++n) {
            int n20;
            itemToRender = n;
            int n21 = nArray[n];
            if (n21 == 27) continue;
            Rectangle rectangle3 = null;
            if (n2 != this.paintThreadID) {
                --this.paintThreadCount;
                return;
            }
            if (n21 <= 0) continue;
            float f7 = this.x_coord[n];
            float f8 = this.y_coord[n];
            Object object = objectArray4[n];
            if (n21 == 29) {
                n21 = 3;
                n20 = (Integer)object;
                object = objectArray4[n20];
            } else {
                n20 = -1;
            }
            if (rectangle3 == null) {
                rectangle3 = this.getObjectArea(dArray, nArray3, dArray2, dArray3, dArray4, objectArray4, nArray8, n21, f7, f8, n9, n11, n);
            }
            boolean bl3 = false;
            if (rectangle3 != null && n21 < 7 && rectangle != null && !rectangle.intersects(rectangle3) && rectangle3.width > 0) {
                bl3 = true;
            }
            if (bl3 || this.lastItemPainted != -1 && n < this.lastItemPainted) {
                switch (n21) {
                    case 2: {
                        ++n8;
                        break;
                    }
                    case 3: {
                        ++n6;
                        break;
                    }
                    case 29: {
                        ++n6;
                        break;
                    }
                    case 7: {
                        ++n7;
                        break;
                    }
                    case 21: {
                        ++n9;
                        break;
                    }
                    case 22: {
                        ++n10;
                        break;
                    }
                    case 10: {
                        ++n12;
                        break;
                    }
                    case 11: {
                        ++n14;
                        break;
                    }
                    case 12: {
                        ++n15;
                        break;
                    }
                    case 14: {
                        ++n13;
                        break;
                    }
                    case 15: {
                        ++n16;
                    }
                }
                continue;
            }
            if (!bl && !this.stopG2setting && this.g2 != null) {
                if (userHints != null) {
                    this.g2.setRenderingHints(userHints);
                } else {
                    this.g2.setRenderingHints(hints);
                }
                bl = true;
            }
            if (n4 == 4) {
                this.needsHighlights = true;
            }
            Rectangle rectangle4 = null;
            switch (n21) {
                case 2: {
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    this.paintShape(nArray5[n8], shape2, object, f5, f6, pdfPaint3, pdfPaint4, stroke, n);
                    ++n8;
                    continue block38;
                }
                case 1: {
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    this.paintText(rectangleArray, vector_Rectangle, hashSet, dArray, dArray2, dArray3, dArray4, (Area)object, n4, f5, f6, f7, f8, n11, pdfPaint, pdfPaint2, rectangle3, rectangle4);
                    continue block38;
                }
                case 4: {
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    this.paintTrueType(rectangleArray, vector_Rectangle, hashSet, dArray, dArray2, dArray3, dArray4, object, n4, n5, f5, f6, f7, f8, n11, pdfPaint, pdfPaint2, rectangle3, rectangle4);
                    continue block38;
                }
                case 5: {
                    Object object2;
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n11], dArray2[n11], dArray3[n11], dArray4[n11], (double)f7, (double)f8);
                    if (!invertHighlight) {
                        rectangle4 = this.setHighlightForGlyph(rectangle3, rectangleArray);
                    }
                    if (this.hasOCR && rectangle4 != null && hashSet.contains(object2 = rectangle4.x + " " + rectangle4.y)) {
                        hashSet.add((String)object2);
                        vector_Rectangle.addElement(rectangle4);
                    }
                    this.renderEmbeddedText(n4, object, 5, affineTransform3, rectangle4, pdfPaint, pdfPaint2, f6, f5, n5);
                    continue block38;
                }
                case 6: {
                    Object object2;
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    AffineTransform affineTransform3 = new AffineTransform(dArray[n11], dArray2[n11], dArray3[n11], dArray4[n11], (double)f7, (double)f8);
                    if (!invertHighlight) {
                        rectangle4 = this.setHighlightForGlyph(rectangle3, rectangleArray);
                    }
                    if (this.hasOCR && rectangle4 != null && hashSet.contains(object2 = rectangle4.x + " " + rectangle4.y)) {
                        hashSet.add((String)object2);
                        vector_Rectangle.addElement(rectangle4);
                    }
                    this.renderEmbeddedText(n4, object, 6, affineTransform3, rectangle4, pdfPaint, pdfPaint2, f6, f5, n5);
                    continue block38;
                }
                case 3: {
                    if (bl2) {
                        RenderUtils.renderClip((Area)shape, rectangle2, shape2, this.g2);
                        bl2 = false;
                    }
                    this.renderImage(dArray, dArray2, dArray3, dArray4, objectArray4, nArray9, object, f5, f7, f8, n6, n11, n20, n);
                    ++n6;
                    continue block38;
                }
                case 7: {
                    shape = areaArray[n7];
                    bl2 = true;
                    ++n7;
                    continue block38;
                }
                case 9: {
                    ++n11;
                    continue block38;
                }
                case 21: {
                    ++n9;
                    continue block38;
                }
                case 22: {
                    n5 = nArray4[n10];
                    ++n10;
                    continue block38;
                }
                case 10: {
                    int n22 = nArray2[n12];
                    if (n22 == 1) {
                        pdfPaint = (PdfPaint)objectArray[n12];
                    } else {
                        pdfPaint2 = (PdfPaint)objectArray[n12];
                    }
                    ++n12;
                    continue block38;
                }
                case 11: {
                    if (!this.colorsLocked) {
                        pdfPaint3 = (PdfPaint)objectArray2[n14];
                    }
                    ++n14;
                    continue block38;
                }
                case 12: {
                    if (!this.colorsLocked && (pdfPaint4 = (PdfPaint)objectArray3[n15]) != null) {
                        pdfPaint4.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                    }
                    ++n15;
                    continue block38;
                }
                case 14: {
                    stroke = (Stroke)objectArray6[n13];
                    ++n13;
                    continue block38;
                }
                case 15: {
                    n4 = nArray7[n16];
                    ++n16;
                    continue block38;
                }
                case 17: {
                    f6 = fArray[n17];
                    ++n17;
                    continue block38;
                }
                case 31: {
                    this.blendMode = nArray6[n18];
                    ++n18;
                    continue block38;
                }
                case 18: {
                    f5 = fArray[n17];
                    ++n17;
                    continue block38;
                }
                case 16: {
                    Object object2 = this.g2.getClip();
                    this.g2.setClip(shape2);
                    AffineTransform affineTransform4 = this.g2.getTransform();
                    String string = (String)object;
                    double[] dArray5 = new double[6];
                    this.g2.getTransform().getMatrix(dArray5);
                    if (super.getMode() != DynamicVectorRenderer.Mode.XFA) {
                        if (dArray5[2] != 0.0) {
                            dArray5[2] = -dArray5[2];
                        }
                        if (dArray5[3] != 0.0) {
                            dArray5[3] = -dArray5[3];
                        }
                    }
                    this.g2.setTransform(new AffineTransform(dArray5));
                    Font font = (Font)objectArray5[n19];
                    this.g2.setFont(font);
                    if ((n4 & 2) == 2) {
                        if (pdfPaint2 != null) {
                            pdfPaint2.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                        } else if (DecoderOptions.Helper != null) {
                            DecoderOptions.Helper.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(pdfPaint2);
                        }
                    }
                    if ((n4 & 1) == 1) {
                        if (pdfPaint != null) {
                            pdfPaint.setScaling(this.cropX, this.cropH, this.scaling, 0.0f, 0.0f);
                        }
                        if (this.customColorHandler != null) {
                            this.customColorHandler.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                        } else if (DecoderOptions.Helper != null) {
                            DecoderOptions.Helper.setPaint(this.g2, pdfPaint2, this.rawPageNumber, this.isPrinting);
                        } else {
                            this.g2.setPaint(pdfPaint2);
                        }
                    }
                    this.g2.drawString(string, f7, f8);
                    this.g2.setTransform(affineTransform4);
                    this.g2.setClip((Shape)object2);
                    ++n19;
                    continue block38;
                }
                case 23: {
                    Shape shape3 = this.g2.getClip();
                    this.g2.setClip(shape2);
                    AffineTransform affineTransform5 = this.g2.getTransform();
                    JPedalCustomDrawObject jPedalCustomDrawObject = (JPedalCustomDrawObject)object;
                    if (this.isPrinting) {
                        jPedalCustomDrawObject.print(this.g2, this.rawPageNumber);
                    } else {
                        jPedalCustomDrawObject.paint(this.g2);
                    }
                    this.g2.setTransform(affineTransform5);
                    this.g2.setClip(shape3);
                }
            }
        }
        itemToRender = -1;
        if (rectangleArray != null) {
            for (n = 0; n != rectangleArray.length; ++n) {
                this.renderHighlight(rectangleArray[n], this.g2);
            }
        }
        if (this.needsHighlights && rectangleArray != null) {
            for (n = 0; n != rectangleArray.length; ++n) {
                this.ignoreHighlight = false;
                this.renderHighlight(rectangleArray[n], this.g2);
            }
        }
        if (vector_Rectangle != null) {
            SwingDisplay.paintOCRHighlights(vector_Rectangle, this.g2);
        }
        if (this.g2 != null) {
            this.g2.setClip(shape2);
            this.g2.setTransform(affineTransform2);
        }
        if (this.frame != null && this.renderFailed && !userAlerted) {
            userAlerted = true;
            if (DecoderOptions.showErrorMessages) {
                String string = Messages.getMessage("PdfViewer.ImageDisplayError") + Messages.getMessage("PdfViewer.ImageDisplayError1") + Messages.getMessage("PdfViewer.ImageDisplayError2") + Messages.getMessage("PdfViewer.ImageDisplayError3") + Messages.getMessage("PdfViewer.ImageDisplayError4") + Messages.getMessage("PdfViewer.ImageDisplayError5") + Messages.getMessage("PdfViewer.ImageDisplayError6") + Messages.getMessage("PdfViewer.ImageDisplayError7");
                JOptionPane.showMessageDialog(this.frame, string);
                this.frame.invalidate();
                this.frame.repaint();
            }
        }
        --this.paintThreadCount;
        this.lastItemPainted = this.optimsePainting ? n3 : -1;
        this.lastScaling = this.scaling;
    }

    private void paintTrueType(Rectangle[] rectangleArray, Vector_Rectangle vector_Rectangle, Set<String> set, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Object object, int n, int n2, float f, float f2, float f3, float f4, int n3, PdfPaint pdfPaint, PdfPaint pdfPaint2, Rectangle rectangle, Rectangle rectangle2) {
        if (n3 != -1) {
            String string;
            AffineTransform affineTransform = new AffineTransform(dArray[n3], dArray2[n3], dArray3[n3], dArray4[n3], (double)f3, (double)f4);
            if (!invertHighlight) {
                rectangle2 = this.setHighlightForGlyph(rectangle, rectangleArray);
            }
            if (this.hasOCR && rectangle2 != null && set.contains(string = rectangle2.x + " " + rectangle2.y)) {
                set.add(string);
                vector_Rectangle.addElement(rectangle2);
            }
            this.renderEmbeddedText(n, object, 4, affineTransform, rectangle2, pdfPaint, pdfPaint2, f2, f, n2);
        }
    }

    private void paintShape(int n, Shape shape, Object object, float f, float f2, PdfPaint pdfPaint, PdfPaint pdfPaint2, Stroke stroke, int n2) {
        Shape shape2 = null;
        if (endItem != -1 && endItem < n2) {
            shape2 = this.g2.getClip();
            this.g2.setClip(shape);
        }
        if (this.isSwing) {
            this.renderShape(shape, n, pdfPaint2, pdfPaint, stroke, (Shape)object, f2, f);
        } else {
            this.renderShape(shape, n, pdfPaint2, pdfPaint, stroke, object, f2, f);
        }
        if (endItem != -1 && endItem < n2) {
            this.g2.setClip(shape2);
        }
    }

    private void paintText(Rectangle[] rectangleArray, Vector_Rectangle vector_Rectangle, Set<String> set, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Area area, int n, float f, float f2, float f3, float f4, int n2, PdfPaint pdfPaint, PdfPaint pdfPaint2, Rectangle rectangle, Rectangle rectangle2) {
        Object object;
        if (!invertHighlight) {
            rectangle2 = this.setHighlightForGlyph(rectangle, rectangleArray);
        }
        if (this.hasOCR && rectangle2 != null && set.contains(object = rectangle2.x + " " + rectangle2.y)) {
            set.add((String)object);
            vector_Rectangle.addElement(rectangle2);
        }
        object = this.g2.getTransform();
        if (n2 != -1) {
            this.g2.transform(new AffineTransform(dArray[n2], dArray2[n2], -dArray3[n2], -dArray4[n2], (double)f3, (double)f4));
            this.renderText(f3, f4, n, area, rectangle2, pdfPaint, pdfPaint2, f2, f);
            this.g2.setTransform((AffineTransform)object);
        }
    }

    static void paintOCRHighlights(Vector_Rectangle vector_Rectangle, Graphics2D graphics2D) {
        Rectangle[] rectangleArray = vector_Rectangle.get();
        Composite composite = graphics2D.getComposite();
        Paint paint = graphics2D.getPaint();
        for (int i = 0; i != rectangleArray.length; ++i) {
            if (rectangleArray[i] != null) {
                graphics2D.setComposite(AlphaComposite.getInstance(3, DecoderOptions.highlightComposite));
                graphics2D.setPaint(DecoderOptions.highlightColor);
                graphics2D.fill(rectangleArray[i]);
            }
            graphics2D.setComposite(composite);
            graphics2D.setPaint(paint);
        }
    }

    private Rectangle getObjectArea(double[] dArray, int[] nArray, double[] dArray2, double[] dArray3, double[] dArray4, Object[] objectArray, int[][] nArray2, int n, float f, float f2, int n2, int n3, int n4) {
        int n5;
        Rectangle rectangle = null;
        if (this.objectAreas == null || this.objectAreas.length != nArray2.length) {
            this.objectAreas = new Rectangle[nArray2.length];
            for (n5 = 0; n5 < this.objectAreas.length; ++n5) {
                if (this.objectAreas[n5] == null) continue;
                this.objectAreas[n5] = new Rectangle(nArray2[n5][0], nArray2[n5][1], nArray2[n5][2], nArray2[n5][3]);
            }
        }
        if (dArray != null && n == 3) {
            if (this.objectAreas != null) {
                rectangle = this.objectAreas[n4];
            }
        } else if (dArray != null && n == 2) {
            if (this.isSwing) {
                rectangle = ((Shape)objectArray[n4]).getBounds();
            } else {
                Bounds bounds = ((Path)objectArray[n4]).getBoundsInLocal();
                rectangle = new Rectangle((int)bounds.getMinX(), (int)bounds.getMinY(), (int)bounds.getWidth(), (int)bounds.getHeight());
            }
        } else if (n == 1 && n3 > -1) {
            rectangle = RenderUtils.getAreaForGlyph(new float[][]{{(float)dArray[n3], (float)dArray2[n3], 0.0f}, {(float)dArray3[n3], (float)dArray4[n3], 0.0f}, {f, f2, 1.0f}});
        } else if (n2 != -1 && dArray != null) {
            n5 = nArray[n2];
            rectangle = n5 < 0 ? new Rectangle((int)f + n5, (int)f2, -n5, -n5) : new Rectangle((int)f, (int)f2, n5, n5);
        }
        return rectangle;
    }

    private void renderImage(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4, Object[] objectArray, int[] nArray, Object object, float f, float f2, float f3, int n, int n2, int n3, int n4) {
        int n5 = 0;
        if (nArray != null) {
            n5 = nArray[n];
        }
        int n6 = 1;
        int n7 = 0;
        int n8 = 0;
        int n9 = 1;
        String string = Integer.toString(this.rawPageNumber) + Integer.toString(n);
        if (this.useHiResImageForDisplay && !this.isType3Font && this.objectStoreRef.isRawImageDataSaved(string)) {
            float f4 = this.scaling;
            if (this.useHiResImageForDisplay && this.scaling < 1.0f) {
                f4 = 1.0f;
            }
            int n10 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pX);
            int n11 = (int)((float)n10 * f4);
            int n12 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_pY);
            n8 = (int)((float)n12 * f4);
            n7 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_WIDTH);
            int n13 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_HEIGHT);
            byte[] byArray = (byte[])this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_MASKCOL);
            int n14 = (Integer)this.objectStoreRef.getRawImageDataParameter(string, ObjectStore.IMAGE_COLORSPACE);
            BufferedImage bufferedImage = null;
            if (n11 > 0) {
                int n15;
                int n16;
                int n17;
                int n18 = n7;
                int n19 = n8 << 2;
                int n20 = n11 << 2;
                for (n17 = n13; n18 > n20 && n17 > n19; n18 >>= 1, n17 >>= 1) {
                    n6 <<= 1;
                }
                int n21 = n7 / n11;
                if (n21 < 1) {
                    n21 = 1;
                }
                if ((n16 = n13 / n8) < 1) {
                    n16 = 1;
                }
                if ((n6 = n21) > n16) {
                    n6 = n16;
                }
                int n22 = n7;
                int n23 = n8 << 2;
                int n24 = n11 << 2;
                for (int i = n13; n22 > n24 && i > n23; n22 >>= 1, i >>= 1) {
                    n9 <<= 1;
                }
                int n25 = n7 / n10;
                if (n25 < 1) {
                    n25 = 1;
                }
                if ((n15 = n13 / n12) < 1) {
                    n15 = 1;
                }
                if ((n9 = n25) > n15) {
                    n9 = n15;
                }
                if ((this.scaling > 1.0f || this.lastScaling > 1.0f) && n6 >= 1 && this.lastScaling != this.scaling) {
                    n18 = n7 / n6;
                    n17 = n13 / n6;
                    bufferedImage = this.resampleImageData(n6, n7, n13, byArray, n18, n17, string, n14);
                }
            }
            if (bufferedImage != null) {
                if (this.singleImage != null) {
                    this.singleImage = bufferedImage;
                }
                objectArray[n4] = bufferedImage;
                object = bufferedImage;
            }
        }
        if (this.useHiResImageForDisplay) {
            double d = 1.0;
            if (n6 >= 1 && this.scaling > 1.0f && n7 > 0) {
                d = (float)n6 / (float)n9;
            }
            AffineTransform affineTransform = new AffineTransform(dArray[n2] * d, dArray2[n2] * d, dArray3[n2] * d, dArray4[n2] * d, (double)f2, (double)f3);
            BufferedImage bufferedImage = null;
            if (object != null) {
                bufferedImage = (BufferedImage)object;
            }
            if (object == null) {
                bufferedImage = this.reloadCachedImage(n3, n4, bufferedImage);
            }
            if (bufferedImage != null) {
                this.renderImage(affineTransform, bufferedImage, f, null, f2, f3, n5);
            }
        } else {
            AffineTransform affineTransform = this.g2.getTransform();
            this.extraRot = false;
            if (n8 > 0) {
                double d;
                double[] dArray5 = new double[6];
                this.g2.getTransform().getMatrix(dArray5);
                dArray5[0] = d = (double)((float)n8 / (float)((BufferedImage)object).getHeight());
                dArray5[1] = 0.0;
                dArray5[2] = 0.0;
                dArray5[3] = -d;
                this.g2.scale(1.0f / this.scaling, 1.0f / this.scaling);
                this.g2.setTransform(new AffineTransform(dArray5));
            } else {
                this.extraRot = true;
            }
            this.renderImage(null, (BufferedImage)object, f, null, f2, f3, n5);
            this.g2.setTransform(affineTransform);
        }
    }

    private BufferedImage resampleImageData(int n, int n2, int n3, byte[] byArray, int n4, int n5, String string, int n6) {
        int n7;
        int n8;
        byte[] byArray2 = this.objectStoreRef.getRawImageData(string);
        byte[] byArray3 = null;
        if (byArray != null && n6 != 1785221209) {
            byArray3 = byArray;
        }
        int n9 = n4 * n5;
        if (byArray3 != null) {
            n9 *= 3;
        }
        byte[] byArray4 = new byte[n9];
        int[] nArray = new int[]{1, 2, 4, 8, 16, 32, 64, 128};
        int n10 = n2 + 7 >> 3;
        int n11 = 0;
        for (int i = 0; i < n5; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n12;
                n8 = 0;
                int n13 = 0;
                int n14 = n;
                n7 = n;
                int n15 = n2 - j;
                int n16 = n3 - i;
                if (n14 > n15) {
                    n14 = n15;
                }
                if (n7 > n16) {
                    n7 = n16;
                }
                for (n12 = 0; n12 < n7; ++n12) {
                    for (int k = 0; k < n14; ++k) {
                        int n17 = (n12 + i * n) * n10 + (j * n + k >> 3);
                        int n18 = n17 < byArray2.length ? byArray2[n17] : -1;
                        int n19 = n18 & nArray[7 - (j * n + k & 7)];
                        if (n19 != 0) {
                            ++n8;
                        }
                        ++n13;
                    }
                }
                if (n13 > 0) {
                    if (byArray3 == null) {
                        byArray4[j + n4 * i] = (byte)(255 * n8 / n13);
                        continue;
                    }
                    for (n12 = 0; n12 < 3; ++n12) {
                        byArray4[n11] = (float)(n8 / n13) < 0.5f ? (int)(byArray[n12] & 0xFF) : -1;
                        ++n11;
                    }
                    continue;
                }
                if (byArray3 == null) {
                    byArray4[j + n4 * i] = -1;
                    continue;
                }
                for (n12 = 0; n12 < 3; ++n12) {
                    byArray4[n11] = -1;
                    ++n11;
                }
            }
        }
        n8 = 10;
        DataBufferByte dataBufferByte = new DataBufferByte(byArray4, byArray4.length);
        int[] nArray2 = new int[]{0};
        n7 = 1;
        if (byArray == null && n2 * n3 * 3 == byArray2.length) {
            n8 = 1;
            nArray2 = new int[]{0, 1, 2};
            n7 = 3;
        }
        BufferedImage bufferedImage = new BufferedImage(n4, n5, n8);
        WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n4, n5, n4 * n7, n7, nArray2, null);
        bufferedImage.setData(writableRaster);
        return bufferedImage;
    }

    private BufferedImage reloadCachedImage(int n, int n2, BufferedImage bufferedImage) {
        block8: {
            try {
                BufferedImage bufferedImage2 = this.singleImage != null ? this.singleImage.getSubimage(0, 0, this.singleImage.getWidth(), this.singleImage.getHeight()) : (this.rawKey == null ? this.largeImages.get("HIRES_" + n2) : this.largeImages.get("HIRES_" + n2 + '_' + this.rawKey));
                if (bufferedImage2 == null) {
                    int n3 = n2;
                    if (n != -1) {
                        n3 = n;
                    }
                    if ((bufferedImage2 = this.rawKey == null ? this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + n3) : this.objectStoreRef.loadStoredImage(this.rawPageNumber + "_HIRES_" + n3 + '_' + this.rawKey)) == null) {
                        this.renderFailed = true;
                    }
                    if (!this.isPrinting) {
                        if (this.rawKey == null) {
                            this.largeImages.put("HIRES_" + n2, bufferedImage2);
                        } else {
                            this.largeImages.put("HIRES_" + n2, bufferedImage2 + "_" + this.rawKey);
                        }
                    }
                }
                bufferedImage = bufferedImage2;
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block8;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        return bufferedImage;
    }

    @Override
    public void setMessageFrame(Container container) {
        this.frame = container;
    }

    private Rectangle setHighlightForGlyph(Rectangle rectangle, Rectangle[] rectangleArray) {
        if (rectangleArray == null || this.textHighlightsX == null) {
            return null;
        }
        this.ignoreHighlight = false;
        for (int i = 0; i != rectangleArray.length; ++i) {
            if (rectangleArray[i] == null || rectangle == null || !rectangleArray[i].intersects(rectangle)) continue;
            Rectangle rectangle2 = rectangleArray[i].intersection(rectangle);
            float f = rectangle2.width * rectangle2.height;
            float f2 = (float)(rectangle.width * rectangle.height) / 4.0f;
            if (!(rectangleArray[i].contains(rectangle.x, rectangle.y) && f > f2) && !(f > (float)(rectangle.width * rectangle.height) / 1.667f)) continue;
            if (!this.drawnHighlights[i]) {
                this.ignoreHighlight = false;
                this.drawnHighlights[i] = true;
                return rectangleArray[i];
            }
            this.ignoreHighlight = true;
            return rectangleArray[i];
        }
        return null;
    }

    @Override
    public void drawText(float[][] fArray, String string, GraphicsState graphicsState, float f, float f2, Font font) {
        int n;
        PdfPaint pdfPaint;
        int n2;
        double[] dArray;
        if (fArray != null && (this.lastAf[0] != (dArray = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3])) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (((n2 = graphicsState.getTextRenderType()) & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n) {
                    this.lastFillTextCol = n;
                    this.drawColor(pdfPaint, 2);
                }
            }
        }
        if ((n2 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n) {
                    this.lastStrokeCol = n;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.pageObjects.addElement(string);
        this.javaObjects.addElement(font);
        this.objectType.addElement(16);
        n = font.getSize();
        int[] nArray = new int[]{(int)f, (int)f2, n, n};
        if (n > 100) {
            this.areas.addElement(nArray);
        } else {
            this.areas.addElement(null);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        ++this.currentItem;
        this.resetTextColors = false;
    }

    @Override
    public int drawImage(int n, BufferedImage bufferedImage, GraphicsState graphicsState, boolean bl, String string, int n2, int n3) {
        Object object;
        int n4;
        int n5;
        boolean bl2;
        if (n3 != -1) {
            return this.redrawImage(n, graphicsState, string, n3);
        }
        this.rawPageNumber = n;
        float[][] fArray = graphicsState.CTM;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        double[] dArray = new double[6];
        boolean bl3 = bufferedImage.getWidth() < 100 && bufferedImage.getHeight() < 100 || bufferedImage.getHeight() == 1;
        String string2 = this.rawKey == null ? n + "_" + (this.currentItem + 1) : this.rawKey + '_' + (this.currentItem + 1);
        if (this.imageOptions == null) {
            this.imageOptions = new Vector_Int(5000);
            this.imageOptions.setCheckpoint();
        }
        boolean bl4 = bl2 = n2 == 0 && fArray[0][0] < 0.0f && fArray[0][1] > 0.0f && fArray[1][0] < 0.0f && fArray[1][1] < 0.0f && this.pageRotation == 0 && this.type == 1;
        if (!bl && bufferedImage.getHeight() > 1 && (n2 & 1) != 1) {
            int n6 = n5 = this.optimisedTurnCode && fArray[0][0] * fArray[0][1] == 0.0f && fArray[1][1] * fArray[1][0] == 0.0f && !RenderUtils.isRotated(fArray) ? 1 : 0;
            if (this.optimisedTurnCode && n5 == 0 && fArray[0][0] > 0.0f && fArray[1][1] < 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f && Math.abs(fArray[0][0]) > Math.abs(fArray[0][1]) && Math.abs(fArray[1][1]) > Math.abs(fArray[1][0])) {
                n5 = 1;
            }
            if (!(this.optimisedTurnCode && n5 != 0 || this.pageRotation == 90 || this.pageRotation == 270 || this.type != 3 && !bl2)) {
                bufferedImage = RenderUtils.invertImage(bufferedImage);
            }
            if (n5 != 0) {
                n2 += 4;
            }
        }
        this.imageOptions.addElement(n2);
        if (this.useHiResImageForDisplay) {
            Object object2;
            Object object3;
            Object object4;
            int n7;
            if (!bl || this.cachedWidths.get(string2) == null) {
                n5 = bufferedImage.getWidth();
                n7 = bufferedImage.getHeight();
            } else {
                n5 = (Integer)this.cachedWidths.get(string2);
                n7 = (Integer)this.cachedHeights.get(string2);
            }
            n4 = RenderUtils.isRotated(fArray);
            if (n4 != 0) {
                if ((n2 & 2) != 2) {
                    object4 = new AffineTransform();
                    ((AffineTransform)object4).rotate(1.5707963267948966, n5 / 2, n7 / 2);
                    ((AffineTransform)object4).translate(-((double)n7 - ((AffineTransform)object4).getTranslateX()), -((AffineTransform)object4).getTranslateY());
                    object3 = new double[6];
                    ((AffineTransform)object4).getMatrix((double[])object3);
                    if (object3[4] < 1.0) {
                        object3[4] = 1.0;
                        object4 = new AffineTransform((double[])object3);
                    }
                    object2 = new AffineTransformOp((AffineTransform)object4, 2);
                    if (bufferedImage != null) {
                        if (bufferedImage.getHeight() > 1 && bufferedImage.getWidth() > 1) {
                            bufferedImage = ((AffineTransformOp)object2).filter(bufferedImage, null);
                        }
                        if (RenderUtils.isInverted(fArray) && (n2 & 2) != 2) {
                            object = new AffineTransform();
                            ((AffineTransform)object).scale(-1.0, 1.0);
                            ((AffineTransform)object).translate(-bufferedImage.getWidth(), 0.0);
                            AffineTransformOp affineTransformOp = new AffineTransformOp((AffineTransform)object, ColorSpaces.hints);
                            if (bufferedImage.getType() == 12) {
                                BufferedImage bufferedImage2 = bufferedImage;
                                bufferedImage = new BufferedImage(bufferedImage2.getWidth(), bufferedImage2.getHeight(), bufferedImage2.getType());
                                affineTransformOp.filter(bufferedImage2, bufferedImage);
                            } else {
                                bufferedImage = affineTransformOp.filter(bufferedImage, null);
                            }
                        }
                    }
                    object = new float[][]{{0.0f, 1.0f / (float)n7, 0.0f}, {1.0f / (float)n5, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    fArray = Matrix.multiply((float[][])object, fArray);
                } else {
                    object4 = new float[][]{{0.0f, 1.0f / (float)n5, 0.0f}, {1.0f / (float)n7, 0.0f, 0.0f}, {0.0f, 0.0f, 1.0f}};
                    fArray = Matrix.multiply((float[][])object4, fArray);
                }
            } else {
                if (n2 == 0 && fArray[0][0] < 0.0f && fArray[0][1] > 0.0f && fArray[1][0] > 0.0f && fArray[1][1] > 0.0f) {
                    object4 = new AffineTransform();
                    ((AffineTransform)object4).scale(1.0, -1.0);
                    ((AffineTransform)object4).translate(0.0, -bufferedImage.getHeight());
                    object3 = new AffineTransformOp((AffineTransform)object4, ColorSpaces.hints);
                    if (bufferedImage.getType() == 12) {
                        object2 = bufferedImage;
                        bufferedImage = new BufferedImage(((BufferedImage)object2).getWidth(), ((BufferedImage)object2).getHeight(), ((BufferedImage)object2).getType());
                        ((AffineTransformOp)object3).filter((BufferedImage)object2, bufferedImage);
                    } else {
                        bufferedImage = ((AffineTransformOp)object3).filter(bufferedImage, null);
                    }
                }
                object4 = new float[][]{{1.0f / (float)n5, 0.0f, 0.0f}, {0.0f, 1.0f / (float)n7, 0.0f}, {0.0f, 0.0f, 1.0f}};
                fArray = Matrix.multiply((float[][])object4, fArray);
            }
            object4 = new AffineTransform(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], 0.0f, 0.0f);
            ((AffineTransform)object4).getMatrix(dArray);
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
            if (!bl && !bl3) {
                if (!this.isPrinting) {
                    if (this.rawKey == null) {
                        this.largeImages.put("HIRES_" + this.currentItem, bufferedImage);
                    } else {
                        this.largeImages.put("HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage);
                    }
                    if (this.imageCount == 0) {
                        this.singleImage = bufferedImage.getSubimage(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight());
                        ++this.imageCount;
                    } else {
                        this.singleImage = null;
                    }
                }
                if (this.rawKey == null) {
                    this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem, bufferedImage, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + this.currentItem);
                } else {
                    this.objectStoreRef.saveStoredImage(n + "_HIRES_" + this.currentItem + '_' + this.rawKey, bufferedImage, false, false, "tif");
                    this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + this.currentItem + '_' + this.rawKey);
                }
                string2 = this.rawKey == null ? n + "_" + this.currentItem : this.rawKey + '_' + this.currentItem;
                this.cachedWidths.put(string2, n5);
                this.cachedHeights.put(string2, n7);
            }
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(3);
        float f3 = 1.0f;
        float f4 = 1.0f;
        if (this.useHiResImageForDisplay) {
            if (!bl) {
                f3 = bufferedImage.getWidth();
                f4 = bufferedImage.getHeight();
            } else {
                f3 = ((Integer)this.cachedWidths.get(string2)).intValue();
                f4 = ((Integer)this.cachedHeights.get(string2)).intValue();
            }
        }
        if (fArray[0][0] > 0.0f && (double)fArray[0][0] < 0.05 && fArray[0][1] != 0.0f && fArray[1][0] != 0.0f && fArray[1][1] != 0.0f) {
            this.areas.addElement(null);
        } else {
            this.w = (int)(fArray[0][0] * f3);
            if (this.w == 0) {
                this.w = (int)(fArray[0][1] * f3);
            }
            this.h = (int)(fArray[1][1] * f4);
            if (this.h == 0) {
                this.h = (int)(fArray[1][0] * f4);
            }
            if (!this.useHiResImageForDisplay && fArray[1][0] < 0.0f && fArray[0][1] > 0.0f && fArray[0][0] == 0.0f && fArray[1][1] == 0.0f) {
                n4 = this.w;
                this.w = -this.h;
                this.h = n4;
            }
            if (this.h < 0 && !this.useHiResImageForDisplay) {
                this.h = -this.h;
            }
            n4 = (int)graphicsState.x;
            int n8 = (int)graphicsState.y;
            int n9 = this.w;
            int n10 = this.h;
            if (n10 < 0) {
                n8 += n10;
                n10 = -n10;
            }
            if (n10 == 0) {
                n10 = 1;
            }
            object = new int[]{n4, n8, n9, n10};
            this.areas.addElement((int[])object);
            this.checkWidth((int[])object);
        }
        if (this.useHiResImageForDisplay && !bl3) {
            this.pageObjects.addElement(null);
        } else {
            this.pageObjects.addElement(bufferedImage);
        }
        this.imageID.put(string, this.currentItem);
        this.storedImageValues.put("imageOptions-" + this.currentItem, n2);
        this.storedImageValues.put("imageAff-" + this.currentItem, dArray);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private int redrawImage(int n, GraphicsState graphicsState, String string, int n2) {
        Object[] objectArray;
        this.rawPageNumber = n;
        float f = graphicsState.x;
        float f2 = graphicsState.y;
        this.imageOptions.addElement((Integer)this.storedImageValues.get("imageOptions-" + n2));
        if (this.useHiResImageForDisplay) {
            objectArray = (double[])this.storedImageValues.get("imageAff-" + n2);
            this.drawAffine((double[])objectArray);
            this.lastAf[0] = objectArray[0];
            this.lastAf[1] = objectArray[1];
            this.lastAf[2] = objectArray[2];
            this.lastAf[3] = objectArray[3];
            if (this.rawKey == null && this.imageIDtoName.containsKey(n2)) {
                this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + n2);
            } else {
                this.imageIDtoName.put(this.currentItem, n + "_HIRES_" + n2 + '_' + this.rawKey);
            }
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = f;
        this.y_coord[this.currentItem] = f2;
        this.objectType.addElement(29);
        objectArray = this.areas.elementAt(n2);
        int[] nArray = null;
        if (objectArray != null) {
            nArray = new int[]{(int)f, (int)f2, (int)objectArray[2], (int)objectArray[3]};
        }
        this.areas.addElement(nArray);
        if (objectArray != null) {
            this.checkWidth(nArray);
        }
        this.pageObjects.addElement(n2);
        this.imageID.put(string, n2);
        ++this.currentItem;
        return this.currentItem - 1;
    }

    private void checkWidth(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1];
        int n3 = n2 + nArray[3];
        int n4 = n + nArray[2];
        if (n < this.pageX1) {
            this.pageX1 = n;
        }
        if (n4 > this.pageX2) {
            this.pageX2 = n4;
        }
        if (n3 > this.pageY1) {
            this.pageY1 = n3;
        }
        if (n2 < this.pageY2) {
            this.pageY2 = n2;
        }
    }

    @Override
    public Rectangle getOccupiedArea() {
        return new Rectangle(this.pageX1, this.pageY1, this.pageX2 - this.pageX1, this.pageY1 - this.pageY2);
    }

    @Override
    public void drawShape(Shape shape, GraphicsState graphicsState, int n) {
        int n2;
        PdfPaint pdfPaint;
        int n3 = graphicsState.getFillType();
        if (shape.getBounds().getWidth() == 1.0 && shape.getBounds().getHeight() == 1.0 && graphicsState.getLineWidth() < 1.0f) {
            shape = new Rectangle(shape.getBounds().x, shape.getBounds().y, 1, 1);
        }
        if (n3 == 2 || n3 == 3) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint == null) {
                pdfPaint = new PdfColor(0, 0, 0);
            }
            if (pdfPaint.isPattern()) {
                this.drawFillColor(pdfPaint);
                this.fillSet = true;
            } else {
                n2 = pdfPaint.getRGB();
                if (!this.fillSet || this.lastFillCol != n2) {
                    this.lastFillCol = n2;
                    this.drawFillColor(pdfPaint);
                    this.fillSet = true;
                }
            }
        }
        if (n3 == 1 || n3 == 3) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint instanceof Color) {
                n2 = pdfPaint.getRGB();
                if (!this.strokeSet || this.lastStrokeCol != n2) {
                    this.lastStrokeCol = n2;
                    this.drawStrokeColor(pdfPaint);
                    this.strokeSet = true;
                }
            } else {
                this.drawStrokeColor(pdfPaint);
                this.strokeSet = true;
            }
        }
        Stroke stroke = graphicsState.getStroke();
        if (this.lastStroke == null || !this.lastStroke.equals(stroke)) {
            if (((BasicStroke)stroke).getLineWidth() < 1.0f && !(this instanceof T3Display)) {
                stroke = new BasicStroke(1.0f);
            }
            this.lastStroke = stroke;
            this.drawStroke(stroke);
        }
        this.pageObjects.addElement(shape);
        this.objectType.addElement(2);
        int[] nArray = new int[]{shape.getBounds().x, shape.getBounds().y, shape.getBounds().width, shape.getBounds().height};
        this.areas.addElement(nArray);
        this.checkWidth(nArray);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = graphicsState.x;
        this.y_coord[this.currentItem] = graphicsState.y;
        this.shapeType.addElement(n3);
        ++this.currentItem;
        this.resetTextColors = true;
    }

    private void drawColor(PdfPaint pdfPaint, int n) {
        this.areas.addElement(null);
        this.pageObjects.addElement(null);
        this.objectType.addElement(10);
        this.textFillType.addElement(n);
        this.text_color.addElement(pdfPaint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
    }

    @Override
    public void resetOnColorspaceChange() {
        this.fillSet = false;
        this.strokeSet = false;
    }

    @Override
    public void drawFillColor(PdfPaint pdfPaint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(11);
        this.areas.addElement(null);
        this.fill_color.addElement(pdfPaint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.lastFillCol = pdfPaint.getRGB();
    }

    @Override
    public void setGraphicsState(int n, float f, int n2) {
        if (n2 != 1111314299 || this.BMvalues != null) {
            if (this.BMvalues == null) {
                this.BMvalues = new Vector_Int(5000);
                this.BMvalues.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            this.objectType.addElement(31);
            this.BMvalues.addElement(n2);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
        if (n == 1) {
            if (this.lastFillOpacity == f) {
                return;
            }
            this.lastFillOpacity = f;
        }
        if (n == 2) {
            if (this.lastStrokeOpacity == f) {
                return;
            }
            this.lastStrokeOpacity = f;
        }
        if (f != 1.0f || this.opacity != null) {
            if (this.opacity == null) {
                this.opacity = new Vector_Float(5000);
                this.opacity.setCheckpoint();
            }
            this.pageObjects.addElement(null);
            this.areas.addElement(null);
            if (n == 1) {
                this.objectType.addElement(17);
            } else {
                this.objectType.addElement(18);
            }
            this.opacity.addElement(f);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawAdditionalObjectsOverPage(int[] nArray, Color[] colorArray, Object[] objectArray) throws PdfException {
        if (objectArray == null) {
            return;
        }
        if (endItem == -1) {
            endItem = this.currentItem;
            this.objectType.setCheckpoint();
            this.shapeType.setCheckpoint();
            this.pageObjects.setCheckpoint();
            this.areas.setCheckpoint();
            this.clips.setCheckpoint();
            this.textFillType.setCheckpoint();
            this.text_color.setCheckpoint();
            this.fill_color.setCheckpoint();
            this.stroke_color.setCheckpoint();
            this.stroke.setCheckpoint();
            if (this.imageOptions == null) {
                this.imageOptions = new Vector_Int(5000);
            }
            this.imageOptions.setCheckpoint();
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
            }
            this.TRvalues.setCheckpoint();
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
            }
            this.fs.setCheckpoint();
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
            }
            this.lw.setCheckpoint();
            this.af1.setCheckpoint();
            this.af2.setCheckpoint();
            this.af3.setCheckpoint();
            this.af4.setCheckpoint();
            this.fontBounds.setCheckpoint();
            if (this.opacity != null) {
                this.opacity.setCheckpoint();
            }
            if (this.BMvalues != null) {
                this.BMvalues.setCheckpoint();
            }
        }
        this.drawUserContent(nArray, objectArray, colorArray);
    }

    @Override
    public void flushAdditionalObjOnPage() {
        if (endItem != -1) {
            this.currentItem = endItem;
        }
        endItem = -1;
        this.objectType.resetToCheckpoint();
        this.shapeType.resetToCheckpoint();
        this.pageObjects.resetToCheckpoint();
        this.areas.resetToCheckpoint();
        this.clips.resetToCheckpoint();
        this.textFillType.resetToCheckpoint();
        this.text_color.resetToCheckpoint();
        this.fill_color.resetToCheckpoint();
        this.stroke_color.resetToCheckpoint();
        this.stroke.resetToCheckpoint();
        if (this.imageOptions != null) {
            this.imageOptions.resetToCheckpoint();
        }
        if (this.TRvalues != null) {
            this.TRvalues.resetToCheckpoint();
        }
        if (this.fs != null) {
            this.fs.resetToCheckpoint();
        }
        if (this.lw != null) {
            this.lw.resetToCheckpoint();
        }
        this.af1.resetToCheckpoint();
        this.af2.resetToCheckpoint();
        this.af3.resetToCheckpoint();
        this.af4.resetToCheckpoint();
        this.fontBounds.resetToCheckpoint();
        if (this.opacity != null) {
            this.opacity.resetToCheckpoint();
        }
        if (this.BMvalues != null) {
            this.BMvalues.resetToCheckpoint();
        }
        this.lastFillTextCol = 0;
        this.lastFillCol = 0;
        this.lastStrokeCol = 0;
        this.lastClip = null;
        this.hasClips = false;
        this.lastStroke = null;
        this.lastAf = new double[4];
        this.fillSet = false;
        this.strokeSet = false;
        this.lastStrokeOpacity = -1.0f;
        this.lastFillOpacity = -1.0f;
    }

    @Override
    public void drawStrokeColor(Paint paint) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(12);
        this.areas.addElement(null);
        this.stroke_color.addElement(paint);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
        this.strokeSet = false;
        this.fillSet = false;
        this.resetTextColors = true;
    }

    @Override
    public void drawCustom(Object object) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(23);
        this.areas.addElement(null);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawTR(int n) {
        if (n != this.lastTR) {
            if (this.TRvalues == null) {
                this.TRvalues = new Vector_Int(5000);
                this.TRvalues.setCheckpoint();
            }
            this.lastTR = n;
            this.pageObjects.addElement(null);
            this.objectType.addElement(15);
            this.areas.addElement(null);
            this.TRvalues.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
        }
    }

    @Override
    public void drawStroke(Stroke stroke) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(14);
        this.areas.addElement(null);
        this.stroke.addElement(stroke);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawClip(GraphicsState graphicsState, Shape shape, boolean bl) {
        boolean bl2 = false;
        Area area = graphicsState.getClippingShape();
        if (!bl || !this.hasClips || this.lastClip != null || area != null) {
            if (!bl || this.lastClip == null || area == null) {
                bl2 = true;
            } else {
                Rectangle rectangle = area.getBounds();
                Rectangle rectangle2 = this.lastClip.getBounds();
                if (rectangle.x != rectangle2.x || rectangle.y != rectangle2.y || rectangle.width != rectangle2.width || rectangle.height != rectangle2.height) {
                    bl2 = true;
                }
            }
        }
        if (bl2) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(7);
            this.areas.addElement(null);
            this.lastClip = area;
            if (area == null) {
                this.clips.addElement(null);
            } else {
                this.clips.addElement(BaseDisplay.convertPDFClipToJavaClip(area));
            }
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = graphicsState.x;
            this.y_coord[this.currentItem] = graphicsState.y;
            ++this.currentItem;
            this.hasClips = true;
        }
    }

    @Override
    public void drawEmbeddedText(float[][] fArray, int n, PdfGlyph pdfGlyph, Object object, int n2, GraphicsState graphicsState, double[] dArray, String string, PdfFont pdfFont, float f) {
        int n3;
        PdfPaint pdfPaint;
        int n4 = graphicsState.getTextRenderType();
        if ((n4 & 2) == 2) {
            pdfPaint = graphicsState.getNonstrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 2);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastFillTextCol != n3) {
                    this.lastFillTextCol = n3;
                    this.drawColor(pdfPaint, 2);
                    this.resetTextColors = false;
                }
            }
        }
        if ((n4 & 1) == 1) {
            pdfPaint = graphicsState.getStrokeColor();
            if (pdfPaint.isPattern()) {
                this.drawColor(pdfPaint, 1);
                this.resetTextColors = true;
            } else {
                n3 = pdfPaint.getRGB();
                if (this.resetTextColors || this.lastStrokeCol != n3) {
                    this.resetTextColors = false;
                    this.lastStrokeCol = n3;
                    this.drawColor(pdfPaint, 1);
                }
            }
        }
        this.setLineWidth((int)graphicsState.getLineWidth());
        this.drawFontSize(n);
        if (object != null) {
            double[] dArray2;
            if (fArray != null && (this.lastAf[0] != (dArray2 = new double[]{fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]})[0] || this.lastAf[1] != dArray2[1] || this.lastAf[2] != dArray2[2] || this.lastAf[3] != dArray2[3])) {
                this.drawAffine(dArray2);
                this.lastAf[0] = dArray2[0];
                this.lastAf[1] = dArray2[1];
                this.lastAf[2] = dArray2[2];
                this.lastAf[3] = dArray2[3];
            }
            if (!(object instanceof Area)) {
                n2 = -n2;
            }
        } else if (this.lastAf[0] != dArray[0] || this.lastAf[1] != dArray[1] || this.lastAf[2] != dArray[2] || this.lastAf[3] != dArray[3]) {
            this.drawAffine(dArray);
            this.lastAf[0] = dArray[0];
            this.lastAf[1] = dArray[1];
            this.lastAf[2] = dArray[2];
            this.lastAf[3] = dArray[3];
        }
        if (pdfGlyph == null) {
            this.pageObjects.addElement(object);
        } else {
            this.pageObjects.addElement(pdfGlyph);
        }
        this.objectType.addElement(n2);
        if (n2 < 0) {
            this.areas.addElement(null);
        } else if (object != null) {
            int[] nArray = new int[]{(int)fArray[2][0], (int)fArray[2][1], n, n};
            this.areas.addElement(nArray);
            this.checkWidth(nArray);
        } else {
            int n5 = n;
            if (n5 < 0) {
                n5 = -n5;
            }
            int[] nArray = new int[]{(int)fArray[2][0], (int)fArray[2][1], n5, n5};
            this.areas.addElement(nArray);
            this.checkWidth(nArray);
        }
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = fArray[2][0];
        this.y_coord[this.currentItem] = fArray[2][1];
        ++this.currentItem;
    }

    @Override
    public void drawFontBounds(Rectangle rectangle) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(24);
        this.areas.addElement(null);
        this.fontBounds.addElement(rectangle);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = 0.0f;
        this.y_coord[this.currentItem] = 0.0f;
        ++this.currentItem;
    }

    @Override
    public void drawAffine(double[] dArray) {
        this.pageObjects.addElement(null);
        this.objectType.addElement(9);
        this.areas.addElement(null);
        this.af1.addElement(dArray[0]);
        this.af2.addElement(dArray[1]);
        this.af3.addElement(dArray[2]);
        this.af4.addElement(dArray[3]);
        this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
        this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
        this.x_coord[this.currentItem] = (float)dArray[4];
        this.y_coord[this.currentItem] = (float)dArray[5];
        ++this.currentItem;
    }

    @Override
    public void drawFontSize(int n) {
        int n2 = n;
        if (n2 < 0) {
            n2 = -n2;
        }
        if (n2 != this.lastFS) {
            this.pageObjects.addElement(null);
            this.objectType.addElement(21);
            this.areas.addElement(null);
            if (this.fs == null) {
                this.fs = new Vector_Int(5000);
                this.fs.setCheckpoint();
            }
            this.fs.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastFS = n2;
        }
    }

    @Override
    public void setLineWidth(int n) {
        if (n != this.lastLW) {
            this.areas.addElement(null);
            this.pageObjects.addElement(null);
            this.objectType.addElement(22);
            if (this.lw == null) {
                this.lw = new Vector_Int(5000);
                this.lw.setCheckpoint();
            }
            this.lw.addElement(n);
            this.x_coord = RenderUtils.checkSize(this.x_coord, this.currentItem);
            this.y_coord = RenderUtils.checkSize(this.y_coord, this.currentItem);
            this.x_coord[this.currentItem] = 0.0f;
            this.y_coord[this.currentItem] = 0.0f;
            ++this.currentItem;
            this.lastLW = n;
        }
    }

    public SwingDisplay(byte[] byArray, Map map) {
        block5: {
            this.lastStrokeOpacity = -1.0f;
            this.lastFillOpacity = -1.0f;
            this.lastItemPainted = -1;
            this.pageX1 = 9999;
            this.pageX2 = -9999;
            this.pageY1 = -9999;
            this.pageY2 = 9999;
            this.cachedWidths = new HashMap(10);
            this.cachedHeights = new HashMap(10);
            this.fonts = new HashMap(50);
            this.fontsUsed = new HashSet<String>(50);
            this.imageID = new HashMap(10);
            this.storedImageValues = new HashMap(10);
            this.largeImages = new WeakHashMap(10);
            this.lastAf = new double[4];
            this.lastTR = 2;
            this.lastFS = -1;
            this.lastLW = -1;
            this.resetTextColors = true;
            this.needsHighlights = true;
            this.type = 1;
            try {
                Object object;
                int n;
                this.fonts = map;
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n2 = byteArrayInputStream.read();
                if (n2 != 1) {
                    throw new PdfException("Unknown version in serialised object " + n2);
                }
                int n3 = byteArrayInputStream.read();
                this.useHiResImageForDisplay = n3 == 1;
                this.rawPageNumber = byteArrayInputStream.read();
                this.x_coord = (float[])RenderUtils.restoreFromStream(byteArrayInputStream);
                this.y_coord = (float[])RenderUtils.restoreFromStream(byteArrayInputStream);
                this.text_color = (Vector_Object)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.textFillType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.stroke_color = new Vector_Object();
                this.stroke_color.restoreFromStream(byteArrayInputStream);
                this.fill_color = new Vector_Object();
                this.fill_color.restoreFromStream(byteArrayInputStream);
                this.stroke = new Vector_Object();
                this.stroke.restoreFromStream(byteArrayInputStream);
                this.pageObjects = new Vector_Object();
                this.pageObjects.restoreFromStream(byteArrayInputStream);
                this.javaObjects = (Vector_Object)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.shapeType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.af1 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.af2 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.af3 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.af4 = (Vector_Double)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.fontBounds = new Vector_Rectangle();
                this.fontBounds.restoreFromStream(byteArrayInputStream);
                this.clips = new Vector_Shape();
                this.clips.restoreFromStream(byteArrayInputStream);
                this.objectType = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.opacity = (Vector_Float)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.BMvalues = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.imageOptions = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.TRvalues = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.fs = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                this.lw = (Vector_Int)RenderUtils.restoreFromStream(byteArrayInputStream);
                int n4 = (Integer)RenderUtils.restoreFromStream(byteArrayInputStream);
                for (n = 0; n < n4; ++n) {
                    Object object2 = RenderUtils.restoreFromStream(byteArrayInputStream);
                    object = RenderUtils.restoreFromStream(byteArrayInputStream);
                    map.put(object2, object);
                }
                n = (Integer)RenderUtils.restoreFromStream(byteArrayInputStream);
                for (int i = 0; i < n; ++i) {
                    object = RenderUtils.restoreFromStream(byteArrayInputStream);
                    PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)map.get(object);
                    pdfJavaGlyphs.setDisplayValues((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
                    pdfJavaGlyphs.setCharGlyphs((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
                    pdfJavaGlyphs.setEmbeddedEncs((Map)RenderUtils.restoreFromStream(byteArrayInputStream));
                }
                byteArrayInputStream.close();
            }
            catch (Exception exception) {
                if (!LogWriter.isOutput()) break block5;
                LogWriter.writeLog("Exception: " + exception.getMessage());
            }
        }
        this.currentItem = this.pageObjects.get().length;
    }

    @Override
    public void stopClearOnNextRepaint(boolean bl) {
        this.noRepaint = bl;
    }

    @Override
    public byte[] serializeToByteArray(Set set) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(1);
        if (this.useHiResImageForDisplay) {
            byteArrayOutputStream.write(1);
        } else {
            byteArrayOutputStream.write(0);
        }
        byteArrayOutputStream.write(this.rawPageNumber);
        this.text_color.trim();
        this.stroke_color.trim();
        this.fill_color.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.stroke.trim();
        this.pageObjects.trim();
        this.javaObjects.trim();
        this.shapeType.trim();
        this.af1.trim();
        this.af2.trim();
        this.af3.trim();
        this.af4.trim();
        this.fontBounds.trim();
        this.clips.trim();
        this.objectType.trim();
        if (this.opacity != null) {
            this.opacity.trim();
        }
        if (this.BMvalues != null) {
            this.BMvalues.trim();
        }
        if (this.imageOptions != null) {
            this.imageOptions.trim();
        }
        if (this.TRvalues != null) {
            this.TRvalues.trim();
        }
        if (this.fs != null) {
            this.fs.trim();
        }
        if (this.lw != null) {
            this.lw.trim();
        }
        RenderUtils.writeToStream(byteArrayOutputStream, this.x_coord);
        RenderUtils.writeToStream(byteArrayOutputStream, this.y_coord);
        RenderUtils.writeToStream(byteArrayOutputStream, this.text_color);
        RenderUtils.writeToStream(byteArrayOutputStream, this.textFillType);
        this.stroke_color.writeToStream(byteArrayOutputStream);
        this.fill_color.writeToStream(byteArrayOutputStream);
        this.stroke.writeToStream(byteArrayOutputStream);
        this.pageObjects.writeToStream(byteArrayOutputStream);
        RenderUtils.writeToStream(byteArrayOutputStream, this.javaObjects);
        RenderUtils.writeToStream(byteArrayOutputStream, this.shapeType);
        RenderUtils.writeToStream(byteArrayOutputStream, this.af1);
        RenderUtils.writeToStream(byteArrayOutputStream, this.af2);
        RenderUtils.writeToStream(byteArrayOutputStream, this.af3);
        RenderUtils.writeToStream(byteArrayOutputStream, this.af4);
        this.fontBounds.writeToStream(byteArrayOutputStream);
        this.clips.writeToStream(byteArrayOutputStream);
        RenderUtils.writeToStream(byteArrayOutputStream, this.objectType);
        RenderUtils.writeToStream(byteArrayOutputStream, this.opacity);
        RenderUtils.writeToStream(byteArrayOutputStream, this.BMvalues);
        RenderUtils.writeToStream(byteArrayOutputStream, this.imageOptions);
        RenderUtils.writeToStream(byteArrayOutputStream, this.TRvalues);
        RenderUtils.writeToStream(byteArrayOutputStream, this.fs);
        RenderUtils.writeToStream(byteArrayOutputStream, this.lw);
        int n = 0;
        int n2 = 0;
        HashSet<String> hashSet = new HashSet<String>(10);
        HashSet<String> hashSet2 = new HashSet<String>(10);
        for (String string : this.fontsUsed) {
            if (!set.contains(string)) {
                ++n;
                hashSet2.add(string);
                continue;
            }
            ++n2;
            hashSet.add(string);
        }
        RenderUtils.writeToStream(byteArrayOutputStream, n);
        for (String string : hashSet2) {
            RenderUtils.writeToStream(byteArrayOutputStream, string);
            RenderUtils.writeToStream(byteArrayOutputStream, this.fonts.get(string));
            set.add(string);
        }
        RenderUtils.writeToStream(byteArrayOutputStream, n2);
        for (String string : hashSet) {
            RenderUtils.writeToStream(byteArrayOutputStream, string);
            PdfJavaGlyphs pdfJavaGlyphs = (PdfJavaGlyphs)this.fonts.get(string);
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getDisplayValues());
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getCharGlyphs());
            RenderUtils.writeToStream(byteArrayOutputStream, pdfJavaGlyphs.getEmbeddedEncs());
        }
        byteArrayOutputStream.close();
        this.fontsUsed.clear();
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public void checkFontSaved(Object object, String string, PdfFont pdfFont) {
        this.pageObjects.addElement(object);
        this.objectType.addElement(200);
        this.areas.addElement(null);
        ++this.currentItem;
        if (this.fontsUsed.contains(string) || pdfFont.isFontSubsetted()) {
            this.fonts.put(string, pdfFont.getGlyphData());
            this.fontsUsed.add(string);
        }
    }

    @Override
    public Rectangle getArea(int n) {
        return new Rectangle(this.areas.elementAt(n)[0], this.areas.elementAt(n)[1], this.areas.elementAt(n)[2], this.areas.elementAt(n)[3]);
    }

    @Override
    public void flagDecodingFinished() {
        this.highlightsNeedToBeGenerated = true;
    }

    private void generateHighlights(Graphics2D graphics2D, int n, int[] nArray, Object[] objectArray, float f, float f2, float f3, float f4, int[] nArray2, Rectangle[] rectangleArray) {
        this.highlightsNeedToBeGenerated = false;
        int[] nArray3 = new int[n];
        int n2 = -1;
        int n3 = 0;
        float[] fArray = new float[n];
        float[] fArray2 = new float[n];
        float[] fArray3 = new float[n];
        float[] fArray4 = new float[n];
        boolean[] blArray = new boolean[n];
        int[] nArray4 = new int[n];
        float[] fArray5 = new float[n];
        this.textHighlightsX = new int[n];
        int[] nArray5 = new int[n];
        this.textHighlightsWidth = new int[n];
        this.textHighlightsHeight = new int[n];
        int n4 = 0;
        int n5 = 1000;
        int n6 = 1000;
        int n7 = 1;
        int n8 = 1;
        double[] dArray = new double[6];
        graphics2D.getTransform().getMatrix(dArray);
        int n9 = 0;
        if (dArray[1] < 0.0 && dArray[2] < 0.0) {
            n9 = 270;
        }
        for (int i = 0; i < n; ++i) {
            this.type = nArray[i];
            if (this.type <= 0) continue;
            float f5 = this.x_coord[i];
            float f6 = this.y_coord[i];
            if (n8 < 0) {
                f5 += (float)n8;
            }
            Object object = objectArray[i];
            if (this.type == 24) {
                Rectangle rectangle = rectangleArray[n3];
                n5 = rectangle.height;
                n4 = rectangle.y;
                n6 = rectangle.width;
                ++n3;
                continue;
            }
            if (this.type == 21) {
                if ((n8 = nArray2[++n2]) < 0) {
                    n7 = -n8;
                    continue;
                }
                n7 = n8;
                continue;
            }
            if (this.type != 4 && this.type != 5 && this.type != 1) continue;
            if (this.type == 4 || this.type == 5) {
                PdfGlyph pdfGlyph = (PdfGlyph)object;
                float f7 = (float)n7 / 1000.0f;
                this.textHighlightsX[i] = pdfGlyph.getFontBB(1);
                nArray5[i] = n4;
                this.textHighlightsWidth[i] = pdfGlyph.getFontBB(3);
                this.textHighlightsHeight[i] = n5;
                blArray[i] = true;
                if (n9 == 90) {
                    fArray2[i] = -((float)nArray5[i] * f7) + f5;
                    fArray3[i] = (float)this.textHighlightsX[i] * f7 + f6;
                } else if (n9 == 270) {
                    fArray2[i] = (float)nArray5[i] * f7 + f5;
                    fArray3[i] = -((float)this.textHighlightsX[i] * f7 + f6);
                } else {
                    fArray2[i] = (float)nArray5[i] * f7 + f6;
                    fArray3[i] = (float)this.textHighlightsX[i] * f7 + f5;
                }
                fArray[i] = fArray2[i] + (float)this.textHighlightsHeight[i] * f7;
                fArray4[i] = fArray3[i] + (float)this.textHighlightsWidth[i] * f7;
                fArray5[i] = 10.0f;
                nArray4[i] = n7;
            } else {
                float f8 = 1000.0f / (float)n7;
                this.textHighlightsX[i] = (int)f5;
                nArray5[i] = (int)(f6 + (float)n4 / f8);
                this.textHighlightsWidth[i] = (int)((float)n6 / f8);
                this.textHighlightsHeight[i] = (int)((float)(n5 - n4) / f8);
                if (n9 == 90) {
                    fArray2[i] = -nArray5[i];
                    fArray3[i] = this.textHighlightsX[i];
                } else if (n9 == 270) {
                    fArray2[i] = nArray5[i];
                    fArray3[i] = -this.textHighlightsX[i];
                } else {
                    fArray2[i] = nArray5[i];
                    fArray3[i] = this.textHighlightsX[i];
                }
                fArray[i] = fArray2[i] + (float)this.textHighlightsHeight[i];
                fArray4[i] = fArray3[i] + (float)this.textHighlightsWidth[i];
                fArray5[i] = ((Area)object).getBounds().width;
                nArray4[i] = n7;
            }
            nArray3[i] = i;
        }
        for (int i = 0; i < n - 1; ++i) {
            int n10 = nArray3[i];
            if (n10 == -31) {
                System.out.println("*" + n10 + " = " + " left=" + fArray3[n10] + " bottom=" + fArray2[n10] + " right=" + fArray4[n10] + " top=" + fArray[n10]);
            }
            for (int j = i + 1; j < n; ++j) {
                boolean bl;
                int n11;
                int n12 = nArray3[j];
                if (blArray[n12] != blArray[n10] || fArray5[n12] < 1.0f) continue;
                if (n10 == -31) {
                    System.out.println("compare with=" + n12 + " left=" + fArray3[n12] + " right=" + fArray4[n12] + ' ' + (fArray3[n12] > fArray3[n10] && fArray3[n12] < fArray4[n10]));
                }
                if (!(fArray3[n12] > fArray3[n10] && fArray3[n12] < fArray4[n10]) && (!(fArray3[n12] > (fArray3[n10] + fArray4[n10]) / 2.0f) || !(fArray4[n10] < fArray4[n12]))) continue;
                int n13 = this.textHighlightsWidth[n10];
                int n14 = this.textHighlightsX[n10];
                if (blArray[n12]) {
                    float f9 = fArray3[n12] - fArray4[n10];
                    f9 = f9 > 0.0f ? (f9 += 0.5f) : (f9 += 0.5f);
                    n11 = (int)(f9 * 1000.0f / (float)nArray4[n10]);
                    if (this.textHighlightsX[n12] > 0) {
                        n11 += this.textHighlightsX[n12];
                    }
                } else {
                    n11 = (int)(fArray3[n12] - fArray4[n10]);
                }
                if (n10 == -31) {
                    System.out.println(fArray3[n12] - fArray4[n10] + " gap=" + n11 + ' ' + (fArray3[n12] - fArray4[n10]) * 1000.0f / (float)nArray4[n10] + " currentX=" + n14 + " scaling=" + this.scaling + ' ' + n6);
                }
                boolean bl2 = bl = n11 > 0 || n11 < 0 && fArray3[n10] < fArray3[n12] && fArray4[n10] > fArray3[n12] && fArray4[n10] < fArray4[n12] && fArray3[n10] < fArray4[n10] && (-n11 < nArray4[n10] && !blArray[n10] || -n11 < n6 && blArray[n10]);
                if (!(fArray2[n10] < fArray[n12]) || !(fArray2[n12] < fArray[n10]) || n11 <= 0 && !bl) continue;
                if (bl && (!blArray[n10] && n11 < nArray4[n10] && n13 + n11 < nArray4[n10] || blArray[n10] && n11 < n6)) {
                    if (n10 == -31) {
                        System.out.println(n12 + " = " + " left=" + fArray3[n12] + " bottom=" + fArray2[n12] + " right=" + fArray4[n12] + " top=" + fArray[n12]);
                    }
                    this.textHighlightsWidth[n10] = blArray[n10] ? (n11 > 0 ? n13 + n11 : n13 - n11) : (n11 > 0 ? n11 : n13 + n11);
                    if (n10 == -31) {
                        System.out.println("new=" + this.textHighlightsWidth[n10]);
                    }
                    j = n;
                    continue;
                }
                if (n11 <= n6) continue;
            }
        }
    }

    @Override
    public void setPrintPage(int n) {
        this.rawPageNumber = n;
    }

    @Override
    public void flagImageDeleted(int n) {
        this.objectType.setElementAt(27, n);
    }

    @Override
    public void setOCR(boolean bl) {
        this.hasOCR = bl;
    }

    @Override
    protected void showMessageDialog(String string) {
        JOptionPane.showMessageDialog(null, string);
    }

    static {
        hints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }
}

