/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils;

import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jpedal.utils.LogScanner;
import org.jpedal.utils.TimeNow;

public class LogWriter {
    public static LogScanner logScanner;
    public static boolean debug;
    public static String log_name;
    public static boolean testing;
    private static boolean verbose;
    private static final Set<String> filterValues;

    private static Set getFilterSet() {
        String string = System.getProperty("org.jpedal.inclusiveLogFilters");
        HashSet<String> hashSet = null;
        if (string != null) {
            hashSet = new HashSet<String>(Arrays.asList(string.toLowerCase().split("[,]")));
        }
        return hashSet;
    }

    public static final boolean isOutput() {
        return verbose || logScanner != null;
    }

    public static final void writeLog(String string) {
        if (filterValues != null && string != null) {
            boolean bl = false;
            for (String string2 : filterValues) {
                if (!string.toLowerCase().contains(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                return;
            }
        }
        if (logScanner != null) {
            logScanner.message(string);
        }
        if (verbose) {
            System.out.println(string);
        }
        if (log_name != null) {
            try {
                PrintWriter printWriter = new PrintWriter(new FileWriter(log_name, true));
                if (!testing) {
                    printWriter.println(TimeNow.getTimeNow() + ' ' + string);
                }
                printWriter.println(string);
                printWriter.flush();
                printWriter.close();
            }
            catch (Exception exception) {
                System.err.println("Exception " + exception + " attempting to write to log file " + log_name);
            }
        }
    }

    public static final void setupLogFile(String string) {
        if (string != null) {
            if (string.indexOf(118) != -1) {
                verbose = true;
                LogWriter.writeLog("Verbose on");
            } else {
                verbose = false;
            }
        }
        if (!testing) {
            LogWriter.writeLog("Software version - 6.4.28");
            LogWriter.writeLog("Software started - " + TimeNow.getTimeNow());
        }
        LogWriter.writeLog("=======================================================");
    }

    public static void writeFormLog(String string, boolean bl) {
        if (bl) {
            System.out.println("[forms] " + string);
        }
        LogWriter.writeLog("[forms] " + string);
    }

    static {
        filterValues = LogWriter.getFilterSet();
    }
}

