/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal.utils.repositories;

import java.io.Serializable;

public class Vector_Float
implements Serializable {
    int increment_size = 1000;
    protected int current_item;
    int max_size = 250;
    private float[] items = new float[this.max_size];
    private int checkPoint = -1;

    public Vector_Float() {
    }

    public Vector_Float(int n) {
        this.max_size = n;
        this.items = new float[this.max_size];
    }

    protected static int incrementSize(int n) {
        n = n < 8000 ? (n *= 4) : (n < 16000 ? (n *= 2) : (n += 2000));
        return n;
    }

    public final float[] get() {
        return this.items;
    }

    public final void addElement(float f) {
        if (this.current_item >= this.max_size) {
            this.checkSize(this.current_item);
        }
        this.items[this.current_item] = f;
        ++this.current_item;
    }

    public final float elementAt(int n) {
        if (n >= this.max_size) {
            return 0.0f;
        }
        return this.items[n];
    }

    public final void clear() {
        if (this.current_item > 0) {
            for (int i = 0; i < this.current_item; ++i) {
                this.items[i] = 0.0f;
            }
        } else {
            for (int i = 0; i < this.max_size; ++i) {
                this.items[i] = 0.0f;
            }
        }
        this.current_item = 0;
    }

    public final void reuse() {
        this.current_item = 0;
    }

    private void checkSize(int n) {
        int n2 = this.max_size;
        this.max_size += this.increment_size;
        if (this.max_size <= n) {
            this.max_size = n + this.increment_size + 2;
        }
        float[] fArray = this.items;
        this.items = new float[this.max_size];
        System.arraycopy(fArray, 0, this.items, 0, n2);
        this.increment_size = Vector_Float.incrementSize(this.increment_size);
    }

    public void trim() {
        float[] fArray = new float[this.current_item];
        System.arraycopy(this.items, 0, fArray, 0, this.current_item);
        this.items = fArray;
        this.max_size = this.current_item;
    }

    public void resetToCheckpoint() {
        if (this.checkPoint != -1) {
            this.current_item = this.checkPoint;
        }
        this.checkPoint = -1;
    }

    public void setCheckpoint() {
        if (this.checkPoint == -1 && this.current_item >= 0) {
            this.checkPoint = this.current_item;
        }
    }
}

