/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.l10n.Messages;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.tasks.Notifications;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticAfs;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticController;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticParameters;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticUdidsVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileProductStatisticVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.product.ProductFXHandler;
import com.gridnine.xtrip.client.fx.standard.helpers.AppConfigHelper;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.BookingFileProductStatisticsHelper;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.converters.StatisticGeneralProductFXHelper;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.additionalservice.AdditionalServiceProduct;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.profile.CalculatedStatisticType;
import com.gridnine.xtrip.common.model.profile.CostCode;
import com.gridnine.xtrip.common.model.profile.CostCodeProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class BookingFileProductStatisticParametersControllerInterceptor
extends ControllerInterceptor<BookingFileProductStatisticVM, BookingFileProductStatisticController> {
    protected Class<BookingFileProductStatisticController> getControllerClass() {
        return BookingFileProductStatisticController.class;
    }

    protected void onCreate(BookingFileProductStatisticController controller) {
        if (AppConfigHelper.isIbeEnabled()) {
            this.unhideAll(controller);
            this.hide(controller, (Class)((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().getValue(), (EntityReference<Organization>)((EntityReference)((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).clientProperty().getValue()));
        } else {
            this.hideAll(controller);
        }
    }

    protected void beforeReadData(BookingFileProductStatisticController controller, BookingFileProductStatisticVM model) {
        if (!controller.isReadonly()) {
            ProductFXHandler handler = ProductFXHandler.forProductClass((Class)model.getProductType());
            StatisticGeneralProductFXHelper.updateRelatedCostCodes(handler.isMultiTraveller(), controller.getData().getTravellersIbe(), controller.getData().getProfileCostCodeProperties(), controller.getData().getProfileCostCodes(), model.getStatistic().getUdids());
        }
    }

    protected void validateData(BookingFileProductStatisticController controller, List<Message> messages) {
        Collection statisticUdidsVMS = ((TableWidget)controller.getView().getStatisticNode().getUdidsCard().getContent()).getRowsData();
        List clientCostCodeProperties = controller.getData().getProfileCostCodeProperties();
        BookingFileProductStatisticParametersControllerInterceptor.validateStatisticalData(statisticUdidsVMS, clientCostCodeProperties, controller.getData().getProfileCostCodes(), controller.getData().getProductType(), controller.getData().getSystemNumber(), messages);
    }

    protected void afterReadData(BookingFileProductStatisticController controller, BookingFileProductStatisticVM model) {
        TableWidget udidsWidget = (TableWidget)controller.getView().getStatisticNode().getUdidsCard().getContent();
        ProductFXHandler handler = ProductFXHandler.forProductClass((Class)model.getProductType());
        if (handler != null && handler.isMultiTraveller()) {
            BookingFileProductStatisticsHelper.updateMultiTravellerUdidsTable((TableWidget<BookingFileProductStatisticUdidsVM>)udidsWidget, model);
        } else {
            BookingFileProductStatisticsHelper.updateSingleTravellerUdidsTable((TableWidget<BookingFileProductStatisticUdidsVM>)((TableWidget)controller.getView().getStatisticNode().getUdidsCard().getContent()), model);
        }
        if (AppConfigHelper.isIbeEnabled()) {
            this.unhideAll(controller);
            this.hide(controller, (Class)((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode().productClassProperty().getValue(), (EntityReference<Organization>)((EntityReference)((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).clientProperty().getValue()));
        } else {
            this.hideAll(controller);
        }
    }

    private void hide(BookingFileProductStatisticController controller, Class productClass, EntityReference<Organization> orgRef) {
        if (orgRef == null) {
            this.hideAll(controller);
        } else {
            Notifications.get().submitTask(() -> {
                EntityContainer orgCtr = ((EntityService)RpcServiceManager.get().getService(EntityService.class)).load(ServiceInvocationContext.get(), orgRef);
                if (orgCtr == null) {
                    return;
                }
                Organization org = (Organization)orgCtr.getEntity();
                FxUtil.submitToFxThread(() -> {
                    if (productClass != null && org != null) {
                        this.hideParameters(controller, org, productClass);
                    } else {
                        this.hideAll(controller);
                    }
                });
            }, Messages.General_Data_loading);
        }
    }

    private void hideParameters(BookingFileProductStatisticController controller, Organization org, Class productClass) {
        Set calculatedStatisticSettings = org.getCalculatedStatisticSettings();
        BookingFileProductStatisticParameters panel = ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode();
        panel.getSalesDeepLimitCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.SALES_DEEPS) && panel.getSalesDeepsLimitNode().getValue() == null);
        panel.getViolationCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.TRAVEL_POLICY_VIOLATION) && panel.getViolationNode().getValue() == null);
        panel.getAuthorizationCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.TRAVEL_POLICY_AUTHORIZATION) && panel.getAuthorizationNode().getValue() == null);
        panel.getLimitCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.TRAVEL_POLICY_LIMIT) && panel.getLimitNode().getValue() == null);
        panel.getSalesDeepsLimitCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.TRAVEL_POLICY_SALES_DEEPS_LIMIT) && panel.getSalesDeepLimitNode().getValue() == null);
        panel.getFlightDurationCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.FLIGHT_DURATION) && panel.getFlightDurationNode().getValue() == null);
        panel.getMinPricePerRoomCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.MIN_PRICE_PER_ROOM) && panel.getMinPricePerRoomNode().getValue() == null);
        panel.getRackRatePriceCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.RACK_RATE_PRICE) && panel.getRackRatePriceNode().getValue() == null);
        panel.getMinPriceHotelCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.MIN_PRICE_HOTEL) && panel.getMinPriceHotelNode().getValue() == null);
        panel.getMinPriceRailwayCell().setHidden(!calculatedStatisticSettings.contains(CalculatedStatisticType.MIN_PRICE_RAILWAY) && panel.getMinPriceRailwayNode().getValue() == null);
        if (!(productClass.getName().equals(Product.class.getName()) || productClass.getName().equals(AdditionalServiceProduct.class.getName()) || productClass.getName().equals(ProductVoiding.class.getName()))) {
            panel.getFlightDurationCell().setHidden(true);
        }
        if (!productClass.getName().equals(HotelProduct.class.getName())) {
            panel.getMinPricePerRoomCell().setHidden(true);
            panel.getRackRatePriceCell().setHidden(true);
            panel.getMinPriceHotelCell().setHidden(true);
        }
        if (!(productClass.getName().equals(RailwayProduct.class.getName()) || productClass.getName().equals(Product.class.getName()) || productClass.getName().equals(AdditionalServiceProduct.class.getName()) || productClass.getName().equals(ProductVoiding.class.getName()) || productClass.getName().equals(HotelProduct.class.getName()))) {
            panel.getViolationCell().setHidden(true);
            panel.getAuthorizationCell().setHidden(true);
            panel.getLimitCell().setHidden(true);
            panel.getSalesDeepsLimitCell().setHidden(true);
        }
        if (!productClass.getName().equals(RailwayProduct.class.getName())) {
            panel.getMinPriceRailwayCell().setHidden(true);
        }
    }

    private void hideAll(BookingFileProductStatisticController controller) {
        BookingFileProductStatisticParameters panel = ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode();
        panel.getMinPricePerRoomCell().setHidden(true);
        panel.getFlightDurationCell().setHidden(true);
        panel.getSalesDeepLimitCell().setHidden(true);
        panel.getRackRatePriceCell().setHidden(true);
        panel.getViolationCell().setHidden(true);
        panel.getAuthorizationCell().setHidden(true);
        panel.getLimitCell().setHidden(true);
        panel.getSalesDeepsLimitCell().setHidden(true);
        panel.getMinPriceHotelCell().setHidden(true);
        panel.getMinPriceRailwayCell().setHidden(true);
    }

    private void unhideAll(BookingFileProductStatisticController controller) {
        BookingFileProductStatisticParameters panel = ((BookingFileProductStatisticAfs)controller.getView().getStatisticNode().getAfsCard().getContent()).getParametersNode();
        panel.getMinPricePerRoomCell().setHidden(false);
        panel.getFlightDurationCell().setHidden(false);
        panel.getSalesDeepLimitCell().setHidden(false);
        panel.getRackRatePriceCell().setHidden(false);
        panel.getViolationCell().setHidden(false);
        panel.getAuthorizationCell().setHidden(false);
        panel.getLimitCell().setHidden(false);
        panel.getSalesDeepsLimitCell().setHidden(false);
        panel.getMinPriceHotelCell().setHidden(false);
        panel.getMinPriceRailwayCell().setHidden(false);
    }

    public static void validateStatisticalData(Collection<BookingFileProductStatisticUdidsVM> statisticUdidsVMS, List<CostCodeProperties> clientCostCodeProperties, List<CostCode> clientCostCodes, Class<? extends BaseProduct> productType, String systemNumber, List<Message> errors) {
        ProductFXHandler fxHandler = ProductFXHandler.forProductClass(productType);
        List shipmentCategoryProperties = clientCostCodeProperties.stream().filter(CostCodeProperties::isShipmentCategory).collect(Collectors.toList());
        List<BookingFileProductStatisticUdidsVM> udidsVMS = statisticUdidsVMS.stream().filter(item -> shipmentCategoryProperties.contains(item.getName())).collect(Collectors.toList());
        if (fxHandler != null && fxHandler.isMultiTraveller()) {
            Map<Traveller, List<BookingFileProductStatisticUdidsVM>> udidsMap = udidsVMS.stream().filter(item -> item.getTravellerIbe() != null).collect(Collectors.groupingBy(BookingFileProductStatisticUdidsVM::getTravellerIbe));
            for (Map.Entry<Traveller, List<BookingFileProductStatisticUdidsVM>> entry : udidsMap.entrySet()) {
                BookingFileProductStatisticParametersControllerInterceptor.validateStatisticUdidsVM(entry.getValue(), systemNumber, entry.getKey(), errors);
            }
        } else {
            BookingFileProductStatisticParametersControllerInterceptor.validateStatisticUdidsVM(udidsVMS, systemNumber, null, errors);
        }
        boolean isMultiTraveller = fxHandler != null && fxHandler.isMultiTraveller();
        statisticUdidsVMS.stream().filter(vm -> {
            CostCodeProperties ccp = clientCostCodeProperties.stream().filter(item -> MiscUtil.equals((Object)item, (Object)vm.getName())).findFirst().orElse(null);
            return ccp != null && ccp.isDependant();
        }).filter(vm -> clientCostCodes.stream().filter(cc -> cc.getRelatedCostCodeProperties().contains(vm.getName())).noneMatch(cc -> {
            BookingFileProductStatisticUdidsVM udidsVM = statisticUdidsVMS.stream().filter(item -> MiscUtil.equals((Object)item.getName(), (Object)cc.getCostCodeProperties()) && MiscUtil.equals((Object)vm.getTravellerIbe(), (Object)item.getTravellerIbe())).findFirst().orElse(null);
            return udidsVM != null && (TextUtil.equals((String)cc.getValue(), (String)udidsVM.getValue(), (boolean)false) || TextUtil.equals((String)cc.getEnglishValue(), (String)udidsVM.getValue(), (boolean)false) || TextUtil.equals((String)cc.getLocalValue(), (String)udidsVM.getValue(), (boolean)false));
        })).forEach(vm -> errors.add(isMultiTraveller ? MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.InvalidDependentTravellerCostCodeSelected, (Object[])new Object[]{systemNumber, vm.getTravellerIbe().getName(), vm.getName().getName()}) : MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.InvalidDependentCostCodeSelected, (Object[])new Object[]{systemNumber, vm.getName().getName()})));
    }

    private static void validateStatisticUdidsVM(List<BookingFileProductStatisticUdidsVM> statisticUdidsVMS, String systemNumber, Traveller traveller, List<Message> errors) {
        List properties = statisticUdidsVMS.stream().map(BookingFileProductStatisticUdidsVM::getName).collect(Collectors.toList());
        List repeatedProperties = properties.stream().filter(ccp -> Collections.frequency(properties, ccp) > 1).collect(Collectors.toList());
        if (!repeatedProperties.isEmpty()) {
            String costCodePropertiesNames = repeatedProperties.stream().map(CostCodeProperties::getName).distinct().reduce((c1, c2) -> String.format("\"%s\", \"%s\"", c1, c2)).orElse("");
            if (traveller != null) {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.InvalidShipmentCategoryCostCodeAmountForTraveller, (Object[])new Object[]{systemNumber, TextUtil.nonBlank((String)traveller.getName()) ? traveller.getName() : traveller, costCodePropertiesNames}));
            } else {
                errors.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)com.gridnine.xtrip.client.fx.standard.l10n.Messages.InvalidShipmentCategoryCostCodeAmount, (Object[])new Object[]{systemNumber, costCodePropertiesNames}));
            }
        }
    }
}

