/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking;

import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.model.booking.BaseProductVM;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.bookingfile.BookingFileHandlerConfigurator;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.BookingFileProductStatisticParametersControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.BusProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.CarRentalProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.HotelProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.InsuranceTouristProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.RailwayMcoProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.RailwayProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.TaxiProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.TransferProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.UniversalProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.VisaProductStatisticControllerInterceptor;
import com.gridnine.xtrip.client.fx.statistic.entity.handlers.booking.converters.StatisticProductConverter;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.uidata.BaseProductUIData;
import com.gridnine.xtrip.common.model.booking.uidata.BookingFileUIData;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.List;
import java.util.function.BiConsumer;

public class BookingFileStatisticConfigurator
implements BookingFileHandlerConfigurator {
    public void configureController(List<BiConsumer<DataTransferPackage<BookingFile, BookingFileUIData>, BookingFileSpaceVM>> toVM, List<BiConsumer<BookingFileSpaceVM, DataTransferPackage<BookingFile, BookingFileUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new BookingFileProductStatisticParametersControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new BusProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new CarRentalProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new HotelProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new InsuranceTouristProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new RailwayMcoProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new RailwayProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new TaxiProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new TransferProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new UniversalProductStatisticControllerInterceptor());
        ControllersRegistry.register((ControllerInterceptor)new VisaProductStatisticControllerInterceptor());
        toVM.add((dtp, vm) -> {
            BookingFile model = (BookingFile)dtp.getContainer().getEntity();
            BookingFileUIData uiData = (BookingFileUIData)dtp.getSupplement();
            this.toVMProducts(vm.getProductsFull().getContent(), model, uiData);
        });
        fromVM.add((vm, dtp) -> {
            BookingFile model = (BookingFile)dtp.getContainer().getEntity();
            BookingFileUIData uiData = (BookingFileUIData)dtp.getSupplement();
            this.fromVMProducts(vm.getProductsFull().getContent(), model);
        });
    }

    private void toVMProducts(List<BaseProductVM> vms, BookingFile model, BookingFileUIData supplement) {
        model.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).forEach(baseProduct -> {
            BaseProductUIData productUiData = supplement.getProducts().stream().filter(data -> data.getRelatedProductUID().equals(baseProduct.getUid())).findFirst().orElse(null);
            StatisticProductConverter.forProduct(baseProduct).toVM((BaseProduct)baseProduct, (BaseProductVM)CollectionUtil.find((Iterable)vms, (String)baseProduct.getUid()), productUiData);
        });
    }

    private void fromVMProducts(List<BaseProductVM> vms, BookingFile model) {
        model.getReservations().stream().flatMap(reservation -> reservation.getProducts().stream()).forEach(baseProduct -> StatisticProductConverter.forProduct(baseProduct).fromVM((BaseProductVM)CollectionUtil.find((Iterable)vms, (String)baseProduct.getUid()), (BaseProduct)baseProduct));
    }
}

