/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.handlers;

import com.gridnine.xtrip.common.bus.helpers.BusProductHelper;
import com.gridnine.xtrip.common.bus.rules.BusTargets;
import com.gridnine.xtrip.common.l10n.model.L10nResourcesManager;
import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.BaseIdentity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BillingItem;
import com.gridnine.xtrip.common.model.booking.BlankType;
import com.gridnine.xtrip.common.model.booking.FinanceDocument;
import com.gridnine.xtrip.common.model.booking.FinanceDocumentType;
import com.gridnine.xtrip.common.model.booking.GeneralProductCommission;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.MCOFeesSource;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductCancellationDetails;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.ServiceLocationType;
import com.gridnine.xtrip.common.model.booking.ServiceType;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.TicketType;
import com.gridnine.xtrip.common.model.booking.TransportationType;
import com.gridnine.xtrip.common.model.booking.TravelSubject;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.ValidationMessage;
import com.gridnine.xtrip.common.model.booking.VatBasisType;
import com.gridnine.xtrip.common.model.booking.VatComponent;
import com.gridnine.xtrip.common.model.booking.VatDetalization;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.booking.bus.BusTax;
import com.gridnine.xtrip.common.model.booking.commission.ProductType;
import com.gridnine.xtrip.common.model.dict.Airline;
import com.gridnine.xtrip.common.model.dict.ContractType;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.MCOCategory;
import com.gridnine.xtrip.common.model.dict.PassengerStatus;
import com.gridnine.xtrip.common.model.dict.ProductCategory;
import com.gridnine.xtrip.common.model.finance.BillingItemIncludeMode;
import com.gridnine.xtrip.common.model.finance.UniversalDocumentStatus;
import com.gridnine.xtrip.common.model.finance.VatViewMode;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.FinanceDocumentsHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Branch;
import com.gridnine.xtrip.common.model.profile.FinanceDocumentsProperties;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.SalesPoint;
import com.gridnine.xtrip.common.model.system.Money;
import com.gridnine.xtrip.common.model.system.PaymentType;
import com.gridnine.xtrip.common.model.system.VatAmount;
import com.gridnine.xtrip.common.model.system.VatValue;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;
import com.gridnine.xtrip.common.util.CollectionUtil;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BusProductHandler
implements ProductHandler<BusProduct> {
    public Class<BusProduct> getProductClass() {
        return BusProduct.class;
    }

    public VatAmount calculateProductPrice(GeneralProductContractRelationData relation, BusProduct product) {
        return GeneralProductHelper.calculateProductPrice((GeneralProductContractRelationData)relation, (ProductHandler)this, (BaseProduct)product);
    }

    public VatAmount calculateProductPrice(BusProduct product, ContractType ctype) {
        for (GeneralProductContractRelationData data : this.getUnmodifiableContractRelations(product)) {
            if (GeneralProductHelper.getContractType((EntityReference)data.getDescription()) != ctype) continue;
            return this.calculateProductPrice(data, product);
        }
        return this.calculateProductPrice(null, product);
    }

    public String generateShortProductName(BusProduct product) {
        return BusProductHelper.getProductName(product);
    }

    public String generateProductName(BusProduct product) {
        return BusProductHelper.getProductName(product);
    }

    public List<String> getProductNumbers(BusProduct product) {
        ArrayList<String> res = new ArrayList<String>();
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            res.add(product.getSystemNumber());
        }
        return res;
    }

    public EntityReference<Person> findIssuingAgent(BusProduct product) {
        return product.getAgent();
    }

    public TravelSubject findTravelSubject(BusProduct product) {
        return TravelSubject.BUS;
    }

    public Date findIssueDate(BusProduct product) {
        return product.getIssueDate();
    }

    public Date findLocalIssueDate(BusProduct product) {
        return product.getLocalIssueDate();
    }

    public void setIssueDate(BusProduct product, Date issueDate) {
        product.setIssueDate(issueDate);
    }

    public boolean includeInFinanceDocuments(BusProduct product) {
        return product.getStatus() != ProductStatus.EXCHANGE && product.getStatus() != ProductStatus.VOID;
    }

    public Set<FinanceDocument> getAppropriateFinanceDocuments(Collection<BaseProduct> products, List<FinanceDocument> availableDocuments) throws Exception {
        Set prods = products.stream().filter(bp -> bp instanceof BusProduct).map(bp -> this.createFinanceCapableProduct((BusProduct)bp)).collect(Collectors.toSet());
        return GeneralProductHelper.getAppropriateFinanceDocuments(prods, availableDocuments);
    }

    public Collection<BillingItem> getBillingItems(List<BaseProduct> products, FinanceDocumentsProperties fdp, boolean noVat) throws Exception {
        List prods = products.stream().filter(bp -> bp instanceof BusProduct).map(bp -> this.createFinanceCapableProduct((BusProduct)bp)).collect(Collectors.toCollection(ArrayList::new));
        return GeneralProductHelper.getBillingItems((List)prods, (FinanceDocumentsProperties)fdp, (boolean)noVat);
    }

    public String getBillingItemName(BusProduct product, String relatedInvoiceNumber) {
        return this.createFinanceCapableProduct(product).getCommonPart();
    }

    public Collection<Traveller> getTravellers(BusProduct product) {
        return product.getTravellers();
    }

    public void replaceTraveller(BusProduct product, Traveller oldTraveller, Traveller newTraveller) {
        Collections.replaceAll(product.getTravellers(), oldTraveller, newTraveller);
        product.getFopDetalizations().values().stream().flatMap(detalization -> detalization.getComponents().stream()).forEach(component -> {
            if (oldTraveller.equals((Object)component.getTraveller())) {
                component.setTraveller(newTraveller);
            }
        });
        if (product.getStatisticalData() != null) {
            product.getStatisticalData().getTravellerCostCodes().stream().filter(tcc -> oldTraveller.equals((Object)tcc.getTraveller())).forEach(tcc -> tcc.setTraveller(newTraveller));
        }
    }

    public void setOrReplaceTraveller(BusProduct product, Traveller oldTraveller, Traveller newTraveller) {
        if (oldTraveller == null) {
            product.getTravellers().add(newTraveller);
        } else {
            this.replaceTraveller(product, oldTraveller, newTraveller);
        }
    }

    public void updateBillingItems(Collection<BillingItem> items, List<BusProduct> products) {
    }

    public EntityReference<SalesPoint> findSalesPoint(BusProduct product) {
        return product.getSalesPoint();
    }

    public ProductStatus getStatus(BusProduct product) {
        return product.getStatus();
    }

    public ProductStatus getBaseStatus(BusProduct product) {
        return product.getStatus();
    }

    public void setStatus(BusProduct product, ProductStatus productStatus) {
        product.setStatus(productStatus);
    }

    public ProductType getProductType(BusProduct product) {
        return ProductType.BUS;
    }

    public Set<ProductType> getAllProductTypes() {
        return Collections.unmodifiableSet(Stream.of(ProductType.BUS).collect(Collectors.toSet()));
    }

    public RuleTarget getCommissionRuleTarget() {
        return BusTargets.BUS_PRODUCT_COMMISSION;
    }

    public EntityReference<Organization> getBlankOwner(BusProduct product) {
        return product.getBlankOwner();
    }

    public EntityReference<Branch> getBranch(BusProduct product) {
        return null;
    }

    public boolean isCompleted(BusProduct product) {
        return product.isCompleted();
    }

    public void setCompleted(BusProduct product, boolean completed) {
        product.setCompleted(completed);
    }

    public boolean isChecked(BusProduct product) {
        return product.isChecked();
    }

    public void setChecked(BusProduct product, boolean checked) {
        product.setChecked(checked);
    }

    public List<MCOFeesSource> getMcoFeesSources(BusProduct product) {
        return new ArrayList<MCOFeesSource>();
    }

    public TransportationType getTransportationType(BusProduct product) {
        return null;
    }

    public ServiceLocationType getServiceLocationType(BusProduct product) {
        return null;
    }

    public Date findNearestTravelDate(Date momentOfTime, BusProduct product) {
        for (BusSegment seg : product.getSegments()) {
            if (momentOfTime.compareTo(seg.getDepartureDate()) > 0) continue;
            return seg.getDepartureDate();
        }
        return null;
    }

    public BusProduct getPreviousProduct(BusProduct product) {
        return product.getPreviousProduct();
    }

    public void setPreviousProduct(BusProduct product, BusProduct previousProduct) {
        product.setPreviousProduct(previousProduct);
    }

    public void setNextProduct(BusProduct product, BusProduct nextProduct) {
        product.setNextProduct(nextProduct);
    }

    public BusProduct getNextProduct(BusProduct product) {
        return product.getNextProduct();
    }

    public void addRelatedProduct(BusProduct product, BaseProduct relatedProduct) {
    }

    public List<BaseProduct> getRelatedProducts(BusProduct product) {
        return Collections.emptyList();
    }

    public ProductCategory getProductCategory(BusProduct product) {
        return null;
    }

    public MCOCategory getMCOCategory(BusProduct product) {
        return null;
    }

    public List<GeneralProductTax> getTaxes(BusProduct product) {
        return product.getTaxes().stream().map(BusProductHelper::toGeneralProductTax).collect(Collectors.toList());
    }

    public DictionaryReference<BlankType> getBlankType(BusProduct product) {
        return null;
    }

    public BigDecimal getEquivalentFare(BusProduct product) {
        return product.getEquivalentFare();
    }

    public BigDecimal getServiceFare(BusProduct product) {
        return null;
    }

    public BigDecimal getPenalty(BusProduct product) {
        return product.getPenalty();
    }

    public int getConjunction(BusProduct product) {
        return 0;
    }

    public String getRouteLine(BusProduct product) {
        return BusProductHelper.getRouteLine(product);
    }

    public String getLocalizedRouteLine(BusProduct product) {
        return BusProductHelper.getRouteLine(product);
    }

    public String getCodeRouteLine(BusProduct product) {
        if (product == null) {
            return null;
        }
        return BusProductHelper.getRouteLine(product);
    }

    public Date findFirstTravelDate(BusProduct product) {
        return BusProductHelper.getFirstDepartureDate(product);
    }

    public Date findLastTravelDate(BusProduct product) {
        return BusProductHelper.getLastArrivalDate(product);
    }

    public ProductCancellationDetails getCancellationDetails(BusProduct product) {
        return null;
    }

    public List<GeneralProductContractRelationData> getUnmodifiableContractRelations(BusProduct product) {
        return BusProductHelper.getContractRelations(product).stream().map(this::cloneRelationData).collect(Collectors.toCollection(ArrayList::new));
    }

    public SalesChain getSalesChain(BusProduct product) {
        return BusProductHelper.getSalesChain(product);
    }

    public void updateContractRelations(BusProduct product, List<GeneralProductContractRelationData> relations) {
        GeneralProductHelper.updateContractRelationsByReflection((BaseProduct)product, relations);
    }

    public TicketType getTicketType(BusProduct product) {
        return product.getTicketType();
    }

    public void setTicketType(BusProduct product, TicketType ticketType) {
        product.setTicketType(ticketType);
    }

    public String getPCC(BusProduct product) {
        return null;
    }

    public void updateProductFops(BusProduct product) {
        GeneralProductHelper.updateProductFops((BaseProduct)product);
    }

    public void setContractRulesApplied(BusProduct product, boolean value) {
        product.setContractRulesApplied(value);
    }

    public List<ValidationMessage> getValidationMessages(BusProduct product) {
        return product.getValidationMessages();
    }

    public EntityReference<Organization> getProvider(BusProduct product) {
        return null;
    }

    public PassengerStatus getPassengerStatus(BusProduct product) {
        return null;
    }

    public boolean isHoldable(BusProduct product) {
        return false;
    }

    public Date getUnholdDate(BusProduct product) {
        return null;
    }

    public String getValidatorNumber(BusProduct product) {
        return null;
    }

    public DictionaryReference<PassengerType> getPassengerType(BusProduct product) {
        return product.getPassengerType();
    }

    public StatisticalData getStatisticalData(BusProduct product) {
        return product.getStatisticalData();
    }

    public boolean isStatisticalDataAvailable(BusProduct product) {
        return true;
    }

    public void newStatisticalData(BusProduct product) {
        product.setStatisticalData(new StatisticalData());
    }

    public BigDecimal getAddCollect(BusProduct product) {
        return null;
    }

    private GeneralProductHelper.FinanceCapableProduct createFinanceCapableProduct(final BusProduct product) {
        return new GeneralProductHelper.FinanceCapableProduct(){

            public Date getIssueDate() {
                return BusProductHandler.this.findIssueDate(product);
            }

            public List<GeneralProductFop> getVendorFops() {
                return BusProductHelper.getVendorFops(product);
            }

            public List<GeneralProductFop> getSubagentFops() {
                return BusProductHelper.getSubagentFops(product, false);
            }

            public List<GeneralProductFop> getClientFops() {
                return BusProductHelper.getClientFops(product);
            }

            public ProductStatus getStatus() {
                return product.getStatus();
            }

            public List<GeneralProductCommission> getCommissions() {
                return GeneralProductHelper.getUnmodifiableCommissions((BaseProduct)product, (ContractType)ContractType.CLIENT);
            }

            public GeneralProductHelper.FinanceCapableProduct getPreviousProduct() {
                return product.getPreviousProduct() != null && product.getPreviousProduct().getStatus() == ProductStatus.SELL ? BusProductHandler.this.createFinanceCapableProduct(product.getPreviousProduct()) : null;
            }

            public VatAmount calculateProductPrice() {
                return BusProductHandler.this.calculateProductPrice(product, ContractType.CLIENT);
            }

            public boolean isHasVat() {
                return true;
            }

            public String getCommonPart() {
                if (product.getStatus() == ProductStatus.REFUND) {
                    return L10nResourcesManager.getStr((String)"CAR_RENTAL_PRODUCT_REFUND", (Object[])new Object[0]);
                }
                return L10nResourcesManager.getStr((String)"CAR_RENTAL_PRODUCT_INFO", (Object[])new Object[0]);
            }

            public BigDecimal getPenalty() {
                return null;
            }

            public String getProductUid() {
                return product.getUid();
            }

            public String getTicketNumber() {
                return product.getSystemNumber();
            }

            public Traveller getTraveller() {
                return (Traveller)product.getTravellers().get(0);
            }
        };
    }

    private GeneralProductContractRelationData cloneRelationData(GeneralProductContractRelationData source) {
        GeneralProductContractRelationData dest = new GeneralProductContractRelationData();
        dest.setUid(source.getUid());
        dest.setDescription(source.getDescription());
        try {
            XCloneModelHelper.copy((BaseEntity)source.getServiceData(), (BaseEntity)dest.getServiceData());
            XCloneModelHelper.copy((BaseEntity)source.getGeneralData(), (BaseEntity)dest.getGeneralData());
            dest.getCommissions().addAll(source.getCommissions());
            this.cloneFops(source, dest);
        }
        catch (Exception e) {
            throw new IllegalStateException("unable to clone entity ", e);
        }
        return dest;
    }

    private void cloneFops(GeneralProductContractRelationData item, GeneralProductContractRelationData generalData) throws Exception {
        for (GeneralProductFop fop : item.getFops()) {
            GeneralProductFop clonedFop = new GeneralProductFop();
            XCloneModelHelper.copy((BaseEntity)fop, (BaseEntity)clonedFop);
            generalData.getFops().add(clonedFop);
        }
    }

    public VatDetalization getVendorVatDetalization(BusProduct product) {
        VatDetalization result = new VatDetalization();
        List vatComponents = result.getComponents();
        GeneralProductHelper.addVatComponent((List)vatComponents, (BigDecimal)product.getEquivalentFare(), (VatValue)product.getEquivalentFareVatValue(), (VatBasisType)VatBasisType.FARE);
        GeneralProductHelper.addVatComponent((List)vatComponents, (BigDecimal)product.getPenalty(), (VatValue)product.getPenaltyVatValue(), (VatBasisType)VatBasisType.PENALTY);
        for (BusTax tax : product.getTaxes()) {
            if (tax.getEquivalentAmount() == null) continue;
            BusProductHandler.addVatTaxComponent(vatComponents, tax.getEquivalentAmount(), tax.getEquivalentVatValue(), tax.getUid());
        }
        result.setDetalized(true);
        return result;
    }

    private static void addVatTaxComponent(List<VatComponent> components, BigDecimal totalAmount, VatValue vatValue, String taxUid) {
        if (BigDecimal.ZERO.compareTo(MiscUtil.guarded((BigDecimal)totalAmount)) == 0 || vatValue == null) {
            return;
        }
        VatComponent component = new VatComponent();
        component.setBasis(totalAmount);
        if (vatValue.getRate() != null && vatValue.getAmount() != null) {
            component.setRate(vatValue.getRate());
            component.setSum(vatValue.getAmount());
        }
        component.getBasisTypes().add(VatBasisType.TAXES);
        component.getTaxesUids().add(taxUid);
        components.add(component);
    }

    public boolean isMultiTraveller() {
        return true;
    }

    public TravelSubject getDefaultTravelSubject() {
        return TravelSubject.BUS;
    }

    public BusProduct newInstance() {
        return new BusProduct();
    }

    public String getCarrierNumber(BusProduct product) {
        return null;
    }

    public void setAgent(BusProduct product, EntityReference<Person> agent) {
        product.setAgent(agent);
    }

    public void setComments(BusProduct product, String comments) {
        product.setComments(comments);
    }

    public void setAgency(BusProduct product, EntityReference<Organization> agency) {
        BusProductHelper.setAgency(product, agency);
    }

    public void setBlankOwner(BusProduct product, EntityReference<Organization> blankOwner) {
        product.setBlankOwner(blankOwner);
    }

    public void setBranch(BusProduct product, EntityReference<Branch> branch) {
    }

    public void setSupplier(BusProduct product, EntityReference<Organization> supplier) {
        BusProductHelper.setSupplier(product, supplier);
    }

    public void setSubagency(BusProduct product, EntityReference<Organization> subagency) {
        BusProductHelper.setSubagency(product, subagency);
    }

    public void setSalesPoint(BusProduct product, EntityReference<SalesPoint> salesPoint) {
        product.setSalesPoint(salesPoint);
    }

    public String getGdsCurrency(BusProduct product) {
        return product.getGdsCurrency();
    }

    public void changeFopsPaymentTypes(BusProduct product, PaymentType paymentType, ContractType contractType, boolean updateOnlyFeeFops) {
        ArrayList<GeneralProductFop> fops = new ArrayList<GeneralProductFop>();
        switch (contractType) {
            case VENDOR: {
                fops.addAll(BusProductHelper.getVendorFops(product));
                break;
            }
            case SUBAGENCY: {
                fops.addAll(BusProductHelper.getSubagentFops(product, false));
                break;
            }
            case CLIENT: {
                fops.addAll(BusProductHelper.getClientFops(product));
            }
        }
        GeneralProductHelper.changeFopsPaymentTypes(fops, (PaymentType)paymentType, (boolean)updateOnlyFeeFops);
    }

    public void changeFopsAgent(BusProduct product, EntityReference<Person> agent, ContractType contractType) {
        List<GeneralProductFop> fops = this.getFops(product, contractType);
        fops.forEach(fop -> fop.setAgent(agent));
    }

    public List<String> getFopsUids(BusProduct product, ContractType contractType) {
        return this.getFops(product, contractType).stream().map(BaseIdentity::getUid).collect(Collectors.toList());
    }

    private List<GeneralProductFop> getFops(BusProduct product, ContractType contractType) {
        switch (contractType) {
            case VENDOR: {
                return BusProductHelper.getVendorFops(product);
            }
            case SUBAGENCY: {
                return BusProductHelper.getSubagentFops(product, false);
            }
            case CLIENT: {
                return BusProductHelper.getClientFops(product);
            }
        }
        return Collections.emptyList();
    }

    public void setBlankType(BusProduct product, DictionaryReference<BlankType> blankType) {
    }

    public Money getBspCommissionValue(BusProduct product) {
        return null;
    }

    public Double getBspCommissionRate(BusProduct product) {
        return null;
    }

    public boolean removeProduct(BusProduct product) {
        return BusProductHelper.removeProduct(product);
    }

    public boolean removeRelatedProduct(BusProduct product, BaseProduct relatedProduct) {
        return BusProductHelper.removeRelatedProduct(product, relatedProduct);
    }

    public boolean isAppropriateBillingItem(BusProduct product, FinanceDocumentType type, UniversalDocumentStatus universalDocumentStatus, BillingItemIncludeMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem, List<com.gridnine.xtrip.common.model.finance.BillingItem> billingItems, List<com.gridnine.xtrip.common.model.finance.BillingItem> prepaymentBillingItems) {
        if ((type == FinanceDocumentType.INVOICE_FACTURA || type == FinanceDocumentType.UNIVERSAL_DOCUMENT && universalDocumentStatus == UniversalDocumentStatus.ONE) && Optional.ofNullable(billingItem.getAmount()).map(VatAmount::getVat).orElse(null) == null) {
            return false;
        }
        if (type == FinanceDocumentType.STANDARD_BILL) {
            return billingItem.getServiceType() == ServiceType.TICKET || billingItem.getServiceType() == ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.ACCEPTANCE_CERTIFICATE && mode == BillingItemIncludeMode.ALL_EXCEPT_TICKET) {
            return billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
        }
        if (type == FinanceDocumentType.INVOICE) {
            if (prepaymentBillingItems.isEmpty()) {
                return true;
            }
            ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem> remainingList = new ArrayList<com.gridnine.xtrip.common.model.finance.BillingItem>(billingItems);
            remainingList.removeIf(item -> CollectionUtil.contains((Collection)prepaymentBillingItems, (Object)item, FinanceDocumentsHelper::isSameBillingItems));
            if (remainingList.isEmpty()) {
                return false;
            }
            if (!CollectionUtil.containsAll(billingItems, prepaymentBillingItems, FinanceDocumentsHelper::isSameBillingItems)) {
                return true;
            }
            return CollectionUtil.contains(remainingList, (Object)billingItem, FinanceDocumentsHelper::isSameBillingItems);
        }
        return true;
    }

    public boolean isVatIncludeBillingItem(BusProduct product, VatViewMode mode, com.gridnine.xtrip.common.model.finance.BillingItem billingItem) {
        return mode == VatViewMode.ALWAYS || mode == VatViewMode.ALWAYS_EXCEPT_TICKET && billingItem.getServiceType() != ServiceType.TICKET && billingItem.getServiceType() != ServiceType.PENALTY;
    }

    public String getCities(BusProduct product, Locale locale) {
        return BusProductHelper.getLocations(product, locale);
    }

    public String getCountries(BusProduct product, Locale locale) {
        return BusProductHelper.getCountries(product, locale);
    }

    public Date getFirstStartDate(BusProduct product) {
        List dates = product.getSegments().stream().map(BusSegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastStartDate(BusProduct product) {
        List dates = product.getSegments().stream().map(BusSegment::getDepartureDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public Date getFirstEndDate(BusProduct product) {
        List dates = product.getSegments().stream().map(BusSegment::getArrivalDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(0) : null;
    }

    public Date getLastEndDate(BusProduct product) {
        List dates = product.getSegments().stream().map(BusSegment::getArrivalDate).collect(Collectors.toList());
        return dates.size() > 0 ? (Date)dates.get(dates.size() - 1) : null;
    }

    public String getDescriptionLine(BusProduct product) {
        return null;
    }

    public DictionaryReference<Airline> getCarrier(BusProduct product) {
        return null;
    }

    public boolean isContractRulesApplied(BusProduct product) {
        return product.isContractRulesApplied();
    }

    public boolean isSystemNumberDuplicateAllowed(BusProduct product) {
        return false;
    }

    public String getRfic(BusProduct product) {
        return null;
    }

    public String getRfisc(BusProduct product) {
        return null;
    }

    public String getTourCode(BusProduct product) {
        return null;
    }

    public boolean isDuplicate(BusProduct product) {
        return false;
    }
}

