/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.helpers;

import com.gridnine.xtrip.common.model.BaseEntity;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.XCloneModelHelper;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.GeneralProductContractRelationData;
import com.gridnine.xtrip.common.model.booking.GeneralProductFop;
import com.gridnine.xtrip.common.model.booking.GeneralProductTax;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.SalesChain;
import com.gridnine.xtrip.common.model.booking.StatisticalData;
import com.gridnine.xtrip.common.model.booking.Traveller;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.booking.bus.BusSegment;
import com.gridnine.xtrip.common.model.booking.bus.BusTax;
import com.gridnine.xtrip.common.model.booking.misc.ProductVoiding;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.handlers.ProductHandler;
import com.gridnine.xtrip.common.model.helpers.BookingHelper;
import com.gridnine.xtrip.common.model.helpers.DictHelper;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.PredefinedContractorType;
import com.gridnine.xtrip.common.util.MiscUtil;
import com.gridnine.xtrip.common.util.TextUtil;
import com.gridnine.xtrip.common.util.XCloneHelper;
import com.gridnine.xtrip.common.util.XCloneable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Consumer;

public final class BusProductHelper {
    private static final String NAME_SEPARATOR = " ";
    private static final String STATION_SEPARATOR = "-";
    private static final String ROUTE_SEPARATOR = " / ";
    private static final String UNKNOWN_STATION = "?";

    private BusProductHelper() {
    }

    public static EntityReference<Organization> getSupplier(BusProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)BusProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUPPLIER);
    }

    public static EntityReference<Organization> getAgency(BusProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)BusProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.AGENCY);
    }

    public static EntityReference<Organization> getSubagency(BusProduct product) {
        return GeneralProductHelper.getContractor((SalesChain)BusProductHelper.getSalesChain(product), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY);
    }

    public static SalesChain getSalesChain(BusProduct product) {
        return GeneralProductHelper.getSalesChainByReflection((BaseProduct)product);
    }

    public static List<GeneralProductContractRelationData> getContractRelations(BusProduct prod) {
        return GeneralProductHelper.getContractRelationsByReflection((BaseProduct)prod);
    }

    public static GeneralProductContractRelationData getClientContractRelation(BusProduct prod) {
        return GeneralProductHelper.getClientContractRelationByReflection((BaseProduct)prod);
    }

    public static Traveller getTraveller(BusProduct product) {
        return product.getTravellers().isEmpty() ? null : (Traveller)product.getTravellers().get(0);
    }

    public static String getProductName(BusProduct product) {
        StringBuilder sb = new StringBuilder();
        sb.append("\u0411\u0438\u043b\u0435\u0442 \u043d\u0430 \u0430\u0432\u0442\u043e\u0431\u0443\u0441");
        if (!TextUtil.isBlank((String)product.getSystemNumber())) {
            sb.append(NAME_SEPARATOR).append(product.getSystemNumber());
        }
        if (product.getStatus() != null) {
            sb.append(NAME_SEPARATOR).append(product.getStatus());
        }
        return sb.toString();
    }

    public static Date getFirstDepartureDate(BusProduct product) {
        if (product.getSegments().isEmpty()) {
            return null;
        }
        return ((BusSegment)product.getSegments().get(0)).getDepartureDate();
    }

    public static Date getLastArrivalDate(BusProduct product) {
        List segments = product.getSegments();
        if (segments.isEmpty()) {
            return null;
        }
        return ((BusSegment)segments.get(segments.size() - 1)).getArrivalDate();
    }

    public static String getRouteLine(BusProduct product) {
        StringBuilder sb = new StringBuilder();
        String lastStationCode = null;
        DictionaryCache cache = DictionaryCache.get();
        for (BusSegment segment : product.getSegments()) {
            String departureStationName = UNKNOWN_STATION;
            String arriveStationName = UNKNOWN_STATION;
            String departureStationCode = null;
            String arriveStationCode = null;
            BusStation departureStation = null;
            BusStation arriveStation = null;
            if (segment != null) {
                departureStation = (BusStation)cache.resolveReference(segment.getDeparture());
                arriveStation = (BusStation)cache.resolveReference(segment.getArrival());
            }
            departureStationName = segment.getDepartureTitle();
            if (departureStation != null) {
                departureStationCode = departureStation.getCode();
                if (TextUtil.isBlank((String)departureStationName)) {
                    departureStationName = departureStation.toString();
                }
            } else {
                departureStationCode = DictHelper.getCode((DictionaryReference)segment.getDeparture());
            }
            arriveStationName = segment.getArrivalTitle();
            if (arriveStation != null) {
                arriveStationCode = arriveStation.getCode();
                if (TextUtil.isBlank((String)arriveStationName)) {
                    arriveStationName = arriveStation.toString();
                }
            } else {
                arriveStationCode = DictHelper.getCode((DictionaryReference)segment.getArrival());
            }
            if (sb.length() == 0) {
                sb.append(departureStationName);
            } else if (!TextUtil.isSame(lastStationCode, (String)departureStationCode)) {
                sb.append(ROUTE_SEPARATOR);
                sb.append(departureStationName);
            }
            if (!TextUtil.isSame((String)departureStationCode, (String)arriveStationCode)) {
                sb.append(STATION_SEPARATOR);
                sb.append(arriveStationName);
            }
            lastStationCode = arriveStationCode;
        }
        return sb.toString();
    }

    public static void setSupplier(BusProduct prod, EntityReference<Organization> value) {
        prod.setValue("supplier", value);
        GeneralProductHelper.setContractor((SalesChain)BusProductHelper.getSalesChain(prod), (PredefinedContractorType)PredefinedContractorType.SUPPLIER, value);
    }

    public static void setAgency(BusProduct prod, EntityReference<Organization> value) {
        prod.setValue("agency", value);
        GeneralProductHelper.setContractor((SalesChain)BusProductHelper.getSalesChain(prod), (PredefinedContractorType)PredefinedContractorType.AGENCY, value);
    }

    public static void setSubagency(BusProduct prod, EntityReference<Organization> value) {
        prod.setValue("subagency", value);
        GeneralProductHelper.setContractor((SalesChain)BusProductHelper.getSalesChain(prod), (PredefinedContractorType)PredefinedContractorType.SUBAGENCY, value);
    }

    public static List<GeneralProductFop> getVendorFops(BusProduct prod) {
        return BusProductHelper.getVendorContractRelation(prod).getFops();
    }

    public static List<GeneralProductFop> getSubagentFops(BusProduct prod, boolean autoUpdateSalesChain) {
        GeneralProductContractRelationData relation = BusProductHelper.getSubagentContractRelation(prod, autoUpdateSalesChain);
        return relation == null ? Collections.emptyList() : relation.getFops();
    }

    public static List<GeneralProductFop> getClientFops(BusProduct prod) {
        return BusProductHelper.getClientContractRelation(prod).getFops();
    }

    public static GeneralProductContractRelationData getSubagentContractRelation(BusProduct prod, boolean autoUpdateSalesChain) {
        return GeneralProductHelper.getSubagentContractRelationByReflection((BaseProduct)prod, (boolean)autoUpdateSalesChain);
    }

    private static GeneralProductContractRelationData getVendorContractRelation(BusProduct prod) {
        return GeneralProductHelper.getVendorContractRelationByReflection((BaseProduct)prod);
    }

    public static void copy(BusProduct source, BusProduct target) throws Exception {
        target.getTravellers().clear();
        target.getTravellers().addAll(source.getTravellers());
        BusProductHelper.saveFieldValuesExecuter(source, src -> BusProductHelper.saveFieldValuesExecuter(target, tgt -> {
            try {
                XCloneModelHelper.copy((BaseEntity)src, (BaseEntity)tgt, (boolean)true);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }));
        target.setContractRulesApplied(false);
        target.setChecked(false);
        target.setCompleted(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveFieldValuesExecuter(BusProduct product, Consumer<BusProduct> executer) {
        Reservation reservation = product.getReservation();
        product.setReservation(null);
        BusProduct previousProduct = product.getPreviousProduct();
        product.setPreviousProduct(null);
        BusProduct sourceNext = product.getNextProduct();
        product.setNextProduct(null);
        ArrayList travellers = new ArrayList(product.getTravellers());
        product.getTravellers().clear();
        try {
            executer.accept(product);
        }
        finally {
            product.setReservation(reservation);
            product.setPreviousProduct(previousProduct);
            product.setNextProduct(sourceNext);
            product.getTravellers().addAll(travellers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BusProduct createRefund(BusProduct model) throws Exception {
        HashSet excludedUids = new HashSet();
        model.getTravellers().forEach(traveller -> excludedUids.add(traveller.getUid()));
        StatisticalData modelStatisticalData = model.getStatisticalData();
        if (modelStatisticalData != null) {
            modelStatisticalData.getTravellerCostCodes().stream().flatMap(travellerCostCodes -> travellerCostCodes.getCostCodes().stream()).filter(costCode -> costCode.getCostCodeProperties() != null).forEach(costCode -> excludedUids.add(costCode.getCostCodeProperties().getUid()));
        }
        Reservation res = model.getReservation();
        model.setReservation(null);
        try {
            BusProduct refund = (BusProduct)XCloneHelper.clone((XCloneable)model, (boolean)true, excludedUids);
            res.getProducts().add(refund);
            model.setNextProduct(refund);
            refund.setReservation(res);
            refund.setPreviousProduct(model);
            refund.setNextProduct(null);
            refund.setContractRulesApplied(false);
            refund.setStatus(ProductStatus.REFUND);
            refund.setIssueDate(new Date());
            refund.setCompleted(false);
            refund.setChecked(false);
            BusProduct busProduct = refund;
            return busProduct;
        }
        finally {
            model.setReservation(res);
        }
    }

    public static boolean removeProduct(BusProduct product) {
        if (product.getNextProduct() != null) {
            return false;
        }
        product.getReservation().getProducts().remove(product);
        if (product.getPreviousProduct() != null) {
            product.getPreviousProduct().setNextProduct(null);
        }
        for (BaseProduct connectedProduct : BookingHelper.getConnectedProducts((BaseProduct)product)) {
            ProductHandler handler = GeneralProductHelper.getHandler((BaseProduct)connectedProduct);
            if (handler == null) continue;
            handler.removeRelatedProduct(connectedProduct, (BaseProduct)product);
            if (!(connectedProduct instanceof ProductVoiding)) continue;
            handler.removeProduct(connectedProduct);
        }
        return true;
    }

    public static boolean removeRelatedProduct(BusProduct product, BaseProduct relatedProduct) {
        return true;
    }

    public static String getLocations(BusProduct product, Locale locale) {
        StringBuilder locations = new StringBuilder();
        DictionaryReference previousArriveStation = null;
        boolean first = true;
        for (BusSegment segment : product.getSegments()) {
            DictionaryReference departureStation = segment.getDeparture();
            DictionaryReference arriveStation = segment.getArrival();
            if (first) {
                locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureStation)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
                first = false;
            } else if (!MiscUtil.equals(previousArriveStation, (Object)departureStation)) {
                locations.append(ROUTE_SEPARATOR);
                locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureStation)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
            }
            locations.append(" - ");
            locations.append(Optional.ofNullable(DictionaryCache.get().resolveReference(arriveStation)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
            previousArriveStation = arriveStation;
        }
        return locations.length() > 0 ? locations.toString() : null;
    }

    public static String getCountries(BusProduct product, Locale locale) {
        StringBuilder countries = new StringBuilder();
        DictionaryReference previousArriveCountry = null;
        boolean first = true;
        for (BusSegment segment : product.getSegments()) {
            DictionaryReference departureCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(segment.getDeparture())).map(item -> item.getCountry()).orElse(null);
            DictionaryReference arriveCountry = Optional.ofNullable(DictionaryCache.get().resolveReference(segment.getArrival())).map(item -> item.getCountry()).orElse(null);
            if (first) {
                countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCountry)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
                first = false;
            } else if (!MiscUtil.equals(previousArriveCountry, (Object)departureCountry)) {
                countries.append(ROUTE_SEPARATOR);
                countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(departureCountry)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
            }
            countries.append(" - ");
            countries.append(Optional.ofNullable(DictionaryCache.get().resolveReference(arriveCountry)).map(item -> item.toString(locale)).orElse(UNKNOWN_STATION));
            previousArriveCountry = arriveCountry;
        }
        return countries.length() > 0 ? countries.toString() : null;
    }

    public static GeneralProductTax toGeneralProductTax(BusTax busTax) {
        GeneralProductTax result = new GeneralProductTax();
        result.setUid(busTax.getUid());
        result.setCode(busTax.getCode());
        result.setEquivalentAmount(busTax.getEquivalentAmount());
        return result;
    }
}

