/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.helpers;

import com.gridnine.xtrip.common.Environment;
import com.gridnine.xtrip.common.bus.model.BusFare;
import com.gridnine.xtrip.common.midoffice.ReservationStatusHandler;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.PassengerType;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.bus.BusProduct;
import com.gridnine.xtrip.common.model.dict.Country;
import com.gridnine.xtrip.common.model.dict.DictionaryCache;
import com.gridnine.xtrip.common.model.dict.DictionaryReference;
import com.gridnine.xtrip.common.model.dict.bus.BusStation;
import com.gridnine.xtrip.common.model.helpers.BookingStreamHelper;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public class CommonBusHelper {
    private CommonBusHelper() {
    }

    public static DictionaryReference<Country> getStationCountry(DictionaryReference<BusStation> stationRef) {
        BusStation station = (BusStation)DictionaryCache.get().resolveReference(stationRef);
        return station == null ? null : station.getCountry();
    }

    public static Boolean isRussiaStation(DictionaryReference<BusStation> stationRef) {
        DictionaryReference<Country> countryRef = CommonBusHelper.getStationCountry(stationRef);
        if (countryRef == null) {
            return null;
        }
        return "RU".equals(countryRef.getCode());
    }

    public static BusFare findBusFare(List<BusFare> fares, DictionaryReference<PassengerType> passengerType) {
        if (Objects.isNull(passengerType) || Objects.isNull(fares) || fares.isEmpty()) {
            return null;
        }
        return fares.stream().filter(f -> passengerType.equals((Object)f.getPassengerType())).findFirst().orElse(null);
    }

    public static Stream<BusProduct> getProductsStream(Reservation res) {
        if (res == null) {
            return Stream.empty();
        }
        return BookingStreamHelper.getProductsStream((Reservation)res, BusProduct.class);
    }

    public static Stream<BusProduct> getEffectiveProductsStream(Reservation res) {
        if (res == null) {
            return Stream.empty();
        }
        return BookingStreamHelper.getProductsStream((Reservation)res, BusProduct.class).filter(CommonBusHelper::isEffectiveProduct);
    }

    public static boolean isEffectiveProduct(BusProduct product) {
        return product.getStatus() == ProductStatus.SELL && product.getNextProduct() == null;
    }

    public static Stream<BusProduct> filterReservationBusProductsStream(Collection<BaseProduct> products, Reservation reservation) {
        return BookingStreamHelper.getProductsStream(products.stream(), BusProduct.class).filter(pr -> reservation.getProducts().contains(pr));
    }

    public static String getValidateRefundMessage(Reservation reservation, List<BusProduct> busProducts) {
        ReservationStatusHandler statusHandler = (ReservationStatusHandler)Environment.getPublished(ReservationStatusHandler.class);
        if (!statusHandler.isCompleted(reservation)) {
            return "\u0417\u0430\u043a\u0430\u0437 \u0434\u043e\u043b\u0436\u0435\u043d \u0431\u044b\u0442\u044c \u0432\u044b\u043f\u0438\u0441\u0430\u043d";
        }
        if (busProducts.isEmpty()) {
            return "\u041e\u0442\u0441\u0443\u0442\u0441\u0442\u0432\u0443\u044e\u0442 \u0430\u0432\u0442\u043e\u0431\u0443\u0441\u043d\u044b\u0435 \u043f\u0440\u043e\u0434\u0443\u043a\u0442\u044b \u043a \u0432\u043e\u0437\u0432\u0440\u0430\u0442\u0443";
        }
        Date now = new Date();
        for (BusProduct busProduct : busProducts) {
            if (busProduct.getStatus() == ProductStatus.REFUND || busProduct.getNextProduct() != null) {
                return "\u0411\u0438\u043b\u0435\u0442 ".concat(busProduct.getSystemNumber()).concat(" \u0443\u0436\u0435 \u0432\u043e\u0437\u0432\u0440\u0430\u0449\u0435\u043d. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
            }
            if (!Objects.nonNull(busProduct.getRefundTimeLimit()) || !now.after(busProduct.getRefundTimeLimit())) continue;
            return "\u0412\u043e\u0437\u0432\u0440\u0430\u0442 \u0431\u0438\u043b\u0435\u0442\u0430 ".concat(busProduct.getSystemNumber()).concat(" \u043d\u0435 \u0432\u043e\u0437\u043c\u043e\u0436\u0435\u043d. \u041e\u043f\u0435\u0440\u0430\u0446\u0438\u044f \u043e\u0442\u043c\u0435\u043d\u0435\u043d\u0430.");
        }
        return null;
    }

    public static boolean isValidForRefund(BusProduct busProduct) {
        return Objects.isNull(CommonBusHelper.getValidateRefundMessage(busProduct.getReservation(), Collections.singletonList(busProduct)));
    }
}

