/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.rules;

import com.gridnine.xtrip.common.bus.model.BaseBusAccount;
import com.gridnine.xtrip.common.bus.rules.BusParametersActionsProvider;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.entity.EntityStorage;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.model.profile.OrganizationType;
import com.gridnine.xtrip.common.util.TextUtil;
import java.util.HashSet;
import java.util.Set;

public class BusParametersActions
implements BusParametersActionsProvider {
    private static final long serialVersionUID = 6548934366589750659L;
    private final Set<EntityReference<BaseBusAccount>> applicableGdsAccounts = new HashSet<EntityReference<BaseBusAccount>>();
    private boolean excludeFromResult;
    private EntityReference<Organization> blankOwner;

    @Override
    public void addApplicableGDSAccount(EntityReference<BaseBusAccount> account) {
        if (account != null) {
            this.applicableGdsAccounts.add(account);
        }
    }

    public Set<EntityReference<BaseBusAccount>> getApplicableGdsAccounts() {
        return this.applicableGdsAccounts;
    }

    public boolean isExcludeFromResult() {
        return this.excludeFromResult;
    }

    public void setExcludeFromResult(boolean excludeFromResult) {
        this.excludeFromResult = excludeFromResult;
    }

    public EntityReference<Organization> getBlankOwner() {
        return this.blankOwner;
    }

    @Override
    public void setBlankOwner(String blankOwnerCode) throws Exception {
        if (TextUtil.isBlank((String)blankOwnerCode)) {
            this.blankOwner = null;
            return;
        }
        EntityContainer ctr = EntityStorage.get().find(OrganizationIndex.class, OrganizationIndex.Property.code.name(), (Object)blankOwnerCode);
        if (ctr == null) {
            throw new Exception(String.format("can't find organization profile with code %s", blankOwnerCode));
        }
        if (!((Organization)ctr.getEntity()).getTypes().contains(OrganizationType.BLANK_OWNER)) {
            throw new Exception(String.format("organization with code %s is not a blank owner", blankOwnerCode));
        }
        this.blankOwner = ctr.toReference();
    }
}

