/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.common.bus.rules;

import com.gridnine.xtrip.common.bus.rules.BusActions;
import com.gridnine.xtrip.common.bus.rules.BusFilteringCategories;
import com.gridnine.xtrip.common.bus.rules.BusProperties;
import com.gridnine.xtrip.common.bus.rules.BusTargets;
import com.gridnine.xtrip.common.gds.rules.Properties;
import com.gridnine.xtrip.common.model.rules.standard.Actions;
import com.gridnine.xtrip.common.model.rules.standard.CommonProductProperties;
import com.gridnine.xtrip.common.model.rules.standard.ContractActions;
import com.gridnine.xtrip.common.model.rules.standard.ContractsFilteringCategories;
import com.gridnine.xtrip.common.model.rules.standard.RuleEnvironmentHelper;
import com.gridnine.xtrip.common.rules.RuleFilteringCategory;
import com.gridnine.xtrip.common.rules.RulesEnvironment;
import com.gridnine.xtrip.common.rules.elements.RuleAction;
import com.gridnine.xtrip.common.rules.elements.RuleProperty;
import com.gridnine.xtrip.common.rules.elements.RuleTarget;

public class BusRulesEnvironment
implements RulesEnvironment.Hook {
    public void environmentInitialized(RulesEnvironment env) {
        env.registerTargets((RuleTarget[])BusTargets.values());
        env.registerFilteringCategories((RuleFilteringCategory[])BusFilteringCategories.values());
        env.registerProperties((RuleProperty[])BusProperties.values());
        env.registerActions((RuleAction[])BusActions.values());
        this.registerContract(env);
        this.registerInternal(env);
        this.registerSearch(env);
    }

    private void registerContract(RulesEnvironment env) {
        for (BusProperties busProperties : BusProperties.values()) {
            for (String string : busProperties.getTargetIds()) {
                env.registerTarget2propertyAssociation(string, busProperties.getId());
            }
            for (String string : busProperties.getConditionIds()) {
                env.registerProperty2conditionAssociation(busProperties.getId(), string);
            }
            for (String string : ContractsFilteringCategories.values()) {
                env.registerFilteringCategory2propertyAssociation(string.getId(), busProperties.getId());
            }
        }
        RuleEnvironmentHelper.registerPropertyAssociation((RulesEnvironment)env, null, (RuleTarget)BusTargets.BUS_PRODUCT_COMMISSION, (RuleProperty[])new RuleProperty[]{CommonProductProperties.TICKET_TYPE, com.gridnine.xtrip.common.model.rules.standard.Properties.EMPLOYEE_CATEGORIES});
        for (BusProperties busProperties : ContractsFilteringCategories.values()) {
            env.registerFilteringCategory2targetAssociation(busProperties.getId(), BusTargets.BUS_PRODUCT_COMMISSION.getId());
        }
        RuleEnvironmentHelper.registerActionAssociation((RulesEnvironment)env, (RuleFilteringCategory)ContractsFilteringCategories.MODEL_CONTRACT, (RuleTarget)BusTargets.BUS_PRODUCT_COMMISSION, (RuleAction[])new RuleAction[]{BusActions.BUS_RECEIPT});
        RuleEnvironmentHelper.registerActionAssociation((RulesEnvironment)env, null, (RuleTarget)BusTargets.BUS_PRODUCT_COMMISSION, (RuleAction[])new RuleAction[]{Actions.SIMPLE_COMMISSION, Actions.SIMPLE_DISCOUNT, Actions.PAYMENT_FEE, Actions.SIMPLE_FEE});
        for (BusProperties busProperties : ContractActions.values()) {
            env.registerTarget2actionAssociation(BusTargets.BUS_PRODUCT_COMMISSION.getId(), busProperties.getId());
        }
    }

    private void registerInternal(RulesEnvironment env) {
        env.registerFilteringCategory2targetAssociation(BusFilteringCategories.INTERNAL_BUS.getId(), BusTargets.BUS_PARAMETERS.getId());
        RuleEnvironmentHelper.registerPropertyAssociation((RulesEnvironment)env, (RuleFilteringCategory)BusFilteringCategories.INTERNAL_BUS, (RuleTarget)BusTargets.BUS_PARAMETERS, (RuleProperty[])new RuleProperty[]{com.gridnine.xtrip.common.model.rules.standard.Properties.GDS_NAME, Properties.CLIENT_CODE, Properties.HOLDING_CODE, Properties.SUBAGENCY_CODE, BusProperties.BUS_DEPARTURE_DATES, BusProperties.BUS_DEPARTURE_LOCATIONS, BusProperties.BUS_ARRIVE_LOCATIONS});
        RuleEnvironmentHelper.registerActionAssociation((RulesEnvironment)env, (RuleFilteringCategory)BusFilteringCategories.INTERNAL_BUS, (RuleTarget)BusTargets.BUS_PARAMETERS, (RuleAction[])new RuleAction[]{BusActions.APPLICABLE_BUS_ACCOUNTS});
    }

    private void registerSearch(RulesEnvironment env) {
        env.registerFilteringCategory2targetAssociation(BusFilteringCategories.FILTER_BUS_SEARCH.getId(), BusTargets.BUS_PARAMETERS_EX.getId());
        RuleEnvironmentHelper.registerPropertyAssociation((RulesEnvironment)env, (RuleFilteringCategory)BusFilteringCategories.FILTER_BUS_SEARCH, (RuleTarget)BusTargets.BUS_PARAMETERS_EX, (RuleProperty[])new RuleProperty[]{com.gridnine.xtrip.common.model.rules.standard.Properties.GDS_NAME, Properties.GDS_ACCOUNT, Properties.CLIENT_CODE, Properties.HOLDING_CODE, Properties.SUBAGENCY_CODE, BusProperties.BUS_DEPARTURE_DATES, BusProperties.BUS_DEPARTURE_LOCATIONS, BusProperties.BUS_ARRIVE_LOCATIONS, BusProperties.BUS_NUMBERS, BusProperties.BUS_BRANDS});
        RuleEnvironmentHelper.registerActionAssociation((RulesEnvironment)env, (RuleFilteringCategory)BusFilteringCategories.FILTER_BUS_SEARCH, (RuleTarget)BusTargets.BUS_PARAMETERS_EX, (RuleAction[])new RuleAction[]{com.gridnine.xtrip.common.gds.rules.Actions.EXCLUDE_FROM_RESULT});
    }
}

