/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.actions;

import com.gridnine.xtrip.client.fx.core.action.ActionIcon;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityAction;
import com.gridnine.xtrip.client.fx.core.entity.editor.RootEntityPane;
import com.gridnine.xtrip.client.fx.core.lib.widgets.navigator.CompactNavigatorWidget;
import com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks.dialog.CorteosProductConnectDialog;
import com.gridnine.xtrip.client.fx.model.booking.BookingFileSpaceController;
import com.gridnine.xtrip.client.fx.standard.icons.StandardActionIcons;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BaseProduct;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.model.booking.ProductStatus;
import com.gridnine.xtrip.common.model.booking.Reservation;
import com.gridnine.xtrip.common.model.booking.air.Product;
import com.gridnine.xtrip.common.model.booking.railway.RailwayProduct;
import com.gridnine.xtrip.common.model.booking.xtriphotels.HotelProduct;
import com.gridnine.xtrip.common.model.helpers.GeneralProductHelper;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Control;

public class CorteosProductConnectAction
implements RootEntityAction {
    public ActionIcon getIcon(RootEntityPane<?, ?> context) {
        return StandardActionIcons.EMPTY;
    }

    public double getWeight() {
        return 62.0;
    }

    public boolean isAvailable(RootEntityPane<?, ?> context) {
        return context.isLastVersion() && BookingFile.class.isAssignableFrom(context.getEntityHandler().getEntityClass()) && Prefetched.getData().isCorteosV2SyncEnabled();
    }

    public boolean isEnabled(RootEntityPane<?, ?> context) {
        DataTransferPackage dtp = context.getData();
        return dtp != null && dtp.getContainer() != null && !this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity()).isEmpty();
    }

    public void execute(Control source, RootEntityPane<?, ?> context, boolean alt) {
        DataTransferPackage dtp = context.getData();
        Node selectedView = ((CompactNavigatorWidget)((BookingFileSpaceController)context.getEditor().getProperties().get((Object)"controller")).getProductsFull().getView().getContent()).getSelectedView();
        String selectedProductUid = (String)selectedView.getProperties().get((Object)"model-uid");
        new CorteosProductConnectDialog(source, (EntityContainer<BookingFile>)dtp.getContainer(), this.getSuitableProducts((BookingFile)dtp.getContainer().getEntity()), selectedProductUid).showDialog();
    }

    private List<BaseProduct> getSuitableProducts(BookingFile bookingFile) {
        ArrayList<BaseProduct> result = new ArrayList<BaseProduct>();
        for (Reservation reservation : bookingFile.getReservations()) {
            reservation.getProducts().stream().filter(prod -> prod instanceof Product || prod instanceof RailwayProduct || prod instanceof HotelProduct).filter(prod -> GeneralProductHelper.getStatus((BaseProduct)prod) == ProductStatus.SELL).forEach(result::add);
        }
        return result;
    }

    public String getId() {
        return "booking-file-connect";
    }
}

