/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.gds.ibus.corteos.IbusCorteosContextKeys;
import com.gridnine.xtrip.common.model.EntityContainer;
import com.gridnine.xtrip.common.model.booking.BookingFile;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public class CorteosProductConnectTask
extends ClientTask {
    private final EntityContainer<BookingFile> bookingFile;
    private final List<String> productUids;
    private final Integer orderId;

    public CorteosProductConnectTask(EntityContainer<BookingFile> bookingFile, List<String> productUids, Integer orderId) {
        this.bookingFile = Objects.requireNonNull(bookingFile);
        this.productUids = (List)CollectionUtil.requireNonEmpty(productUids);
        this.orderId = Objects.requireNonNull(orderId);
    }

    protected void execute() throws Exception {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        contextMap.put(IbusCorteosContextKeys.SIMPLE_RESERVE_ID.name(), this.orderId);
        contextMap.put(IbusCorteosContextKeys.BOOKING_FILE_REFERENCE.name(), this.bookingFile.toReference());
        contextMap.put(IbusCorteosContextKeys.PRODUCT_UIDS.name(), this.productUids);
        ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:rest:order:connect-products", contextMap, Collections.emptySet());
        EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, new EntityModification(this.bookingFile.toReference(), EntityModification.ModificationType.CHANGE)));
    }

    protected String getTitle() {
        return Messages.CorteosConnectProducts;
    }
}

