/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.entity.tasks;

import com.gridnine.xtrip.client.fx.core.entity.EntityModification;
import com.gridnine.xtrip.client.fx.core.entity.EntityModificationEvent;
import com.gridnine.xtrip.client.fx.core.event.Event;
import com.gridnine.xtrip.client.fx.core.event.EventBus;
import com.gridnine.xtrip.client.fx.core.tasks.ClientTask;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.common.fx.rpc.EntityService;
import com.gridnine.xtrip.common.fx.rpc.service.IntegrationBusRpcService;
import com.gridnine.xtrip.common.l10n.messages.L10n;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.profile.IbusReplaceDetailsContextKey;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.profile.PersonIndex;
import com.gridnine.xtrip.common.model.profile.PersonReplaceDetailsType;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.search.ResultMode;
import com.gridnine.xtrip.common.search.SearchCriterion;
import com.gridnine.xtrip.common.search.SearchQuery;
import com.gridnine.xtrip.common.util.CollectionUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class PersonReplaceDetailsListTask
extends ClientTask {
    private final List<EntityReference<Person>> persons;
    private final Map<PersonReplaceDetailsType, Object> values;
    private final SearchQuery searchQuery;

    public PersonReplaceDetailsListTask(List<EntityReference<Person>> persons, Map<PersonReplaceDetailsType, Object> values) {
        this.persons = (List)CollectionUtil.requireNonEmpty(persons, (String)"persons not selected");
        this.values = CollectionUtil.requireNonEmpty(values, (String)"values not selected");
        this.searchQuery = null;
    }

    public PersonReplaceDetailsListTask(SearchQuery searchQuery, Map<PersonReplaceDetailsType, Object> values) {
        this.persons = new ArrayList<EntityReference<Person>>();
        this.values = CollectionUtil.requireNonEmpty(values, (String)"values not selected");
        this.searchQuery = Objects.requireNonNull(searchQuery, "query is null");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void execute() throws Exception {
        if (this.persons.isEmpty()) {
            EntityService entityService = (EntityService)RpcServiceManager.get().getService(EntityService.class);
            ServiceInvocationContext sic = ServiceInvocationContext.get();
            this.searchQuery.setOffset(0);
            this.searchQuery.setLimit(0);
            this.searchQuery.setResultMode(ResultMode.DATA_ONLY);
            this.searchQuery.getCriteria().getCriterions().add(SearchCriterion.eq((String)PersonIndex.Property.disabled.name(), (Object)Boolean.FALSE));
            List travellerIndexes = entityService.search(sic, PersonIndex.class, this.searchQuery);
            this.persons.addAll(travellerIndexes.stream().map(PersonIndex::getSource).collect(Collectors.toList()));
        }
        try {
            for (int i = 0; i < this.persons.size(); ++i) {
                EntityReference<Person> person2 = this.persons.get(i);
                Thread.sleep(1L);
                this.setProgress((byte)(100 * i / this.persons.size()), L10n.replace((String)Messages.ProcessingPerson, (Object[])new Object[]{person2}));
                this.addMessages(this.processPerson(person2));
            }
        }
        finally {
            EventBus.get().publishAsync((Event)new EntityModificationEvent((Object)this, (Collection)this.persons.stream().map(person -> new EntityModification(person, EntityModification.ModificationType.CHANGE)).collect(Collectors.toList())));
        }
    }

    protected String getTitle() {
        return Messages.Change_of_requisites;
    }

    private List<Message> processPerson(EntityReference<Person> person) throws Exception {
        HashMap<String, Object> ibusContext = new HashMap<String, Object>();
        ibusContext.put(IbusReplaceDetailsContextKey.PERSON_REFERENCE.name(), person);
        ibusContext.put(IbusReplaceDetailsContextKey.VALUES.name(), this.values);
        Set<String> returnValues = Collections.singleton(IbusReplaceDetailsContextKey.MESSAGES.name());
        Map ibusResult = ((IntegrationBusRpcService)RpcServiceManager.get().getService(IntegrationBusRpcService.class)).processRouteSync(ServiceInvocationContext.get(), "corteos:replace-details:replace-details-person", ibusContext, returnValues);
        List messages = (List)ibusResult.get(IbusReplaceDetailsContextKey.MESSAGES.name());
        Objects.requireNonNull(messages, "Messages wasn't returned from server");
        return messages;
    }
}

