/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.factory;

import com.gridnine.xtrip.client.fx.core.factory.FactoryTool;
import com.gridnine.xtrip.client.fx.core.factory.FactoryToolCategory;
import com.gridnine.xtrip.client.fx.gds.corteos.factory.StandardCorteosBookingCreateProcedure;
import com.gridnine.xtrip.client.fx.gds.corteos.factory.StandardCorteosPersonCreateProcedure;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.factory.StandardCategories;
import com.gridnine.xtrip.client.fx.standard.prefetched.Prefetched;
import com.gridnine.xtrip.common.fx.rpc.AclQuery;
import com.gridnine.xtrip.common.model.restriction.resource.ModelRestrictionEntityResources;
import com.gridnine.xtrip.common.restriction.resource.standard.StandardRestrictionResourceOperations;

public enum CorteosFactoryTools implements FactoryTool
{
    CORTEOS_BOOKING{

        public String getName() {
            return Messages.CorteosBooking;
        }

        public void execute() {
            StandardCorteosBookingCreateProcedure proc = new StandardCorteosBookingCreateProcedure();
            proc.run();
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PRODUCT.getId());
        }

        public double getWeight() {
            return 30.0;
        }

        public FactoryToolCategory getCategory() {
            return StandardCategories.BOOKINGS;
        }

        public boolean isAuxiliary() {
            return false;
        }

        public boolean isAvaibleInConfiguration() {
            return Prefetched.getData().isCorteosSyncEnabled();
        }
    }
    ,
    CORTEOS_PERSON{

        public String getName() {
            return Messages.CorteosPerson;
        }

        public void execute() {
            StandardCorteosPersonCreateProcedure proc = new StandardCorteosPersonCreateProcedure();
            proc.run();
        }

        public AclQuery getACLQuery() {
            return new AclQuery(StandardRestrictionResourceOperations.CREATE.getId(), ModelRestrictionEntityResources.ENTITY_PERSON.getId());
        }

        public double getWeight() {
            return 30.0;
        }

        public FactoryToolCategory getCategory() {
            return StandardCategories.PROFILES;
        }

        public boolean isAuxiliary() {
            return false;
        }

        public boolean isAvaibleInConfiguration() {
            return Prefetched.getData().isCorteosSyncEnabled();
        }
    };


    public String getUid() {
        return "corteos-tools:" + this.name();
    }
}

