/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.handlers.organization;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCorteosBasicSyncParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCorteosSyncMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationCorteosTravellersSyncParametersPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationExtSyncMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.OrganizationSpace;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.person.uidata.OrganizationUIData;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;

public class CorteosOrganizationEditorInterceptor
implements RootEntityEditorInterceptor<Organization, OrganizationUIData> {
    public void onLoad(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
    }

    public boolean onSave(DataTransferPackage<Organization, OrganizationUIData> data, Node editor) {
        try {
            OrganizationSpace space = (OrganizationSpace)editor;
            ArrayList<Message> messages = new ArrayList<Message>();
            this.checkCorteosParameters(space, messages);
            FxUtil.waitForFxThread(() -> space.addMessages(messages));
            return !MessagesHelper.hasErrorMessage(messages);
        }
        catch (Exception e) {
            ErrorHandler.handle((Throwable)e);
            return false;
        }
    }

    private void checkCorteosParameters(OrganizationSpace space, List<Message> messages) {
        OrganizationCorteosBasicSyncParametersPanel basicPanel = (OrganizationCorteosBasicSyncParametersPanel)((OrganizationCorteosSyncMainPanel)((OrganizationExtSyncMainPanel)space.getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().getContent()).getBasicParametersCard().getContent();
        OrganizationCorteosTravellersSyncParametersPanel travellersPanel = (OrganizationCorteosTravellersSyncParametersPanel)((OrganizationCorteosSyncMainPanel)((OrganizationExtSyncMainPanel)space.getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().getContent()).getTravellersParametersCard().getContent();
        if (travellersPanel.getEnabledNode().getValue()) {
            if (basicPanel.getCorteosIdNode().getValue() == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CorteosOrganizationIdIsMissing, (Object[])new Object[0]));
            }
            if (basicPanel.getClientAgreementNumberNode().getValue() == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CorteosAgreementNumberIsMissing, (Object[])new Object[0]));
            }
            if (basicPanel.getGroupIdNode().getValue() == null) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CorteosGroupIdIsMissing, (Object[])new Object[0]));
            }
            if (travellersPanel.getCorteosVersionsNode().getValues().isEmpty()) {
                messages.add(MessagesHelper.createMessage((MessageType)MessageType.ERROR, (String)Messages.CorteosVersionsAreMissing, (Object[])new Object[0]));
            }
        }
    }
}

