/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.handlers.person;

import com.gridnine.xtrip.client.fx.core.entity.RootEntityEditorInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllerInterceptor;
import com.gridnine.xtrip.client.fx.core.lib.container.ControllersRegistry;
import com.gridnine.xtrip.client.fx.core.lib.widgets.table.TableWidget;
import com.gridnine.xtrip.client.fx.core.util.ErrorHandler;
import com.gridnine.xtrip.client.fx.core.util.FxUtil;
import com.gridnine.xtrip.client.fx.gds.corteos.handlers.person.CorteosPersonControllerInterceptor;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.client.fx.model.profile.PersonCorteosBasicParametersVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonCorteosProfileDataPanelVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonCorteosSyncDataPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonCorteosSyncMessagesVM;
import com.gridnine.xtrip.client.fx.model.profile.PersonExtSyncMainPanel;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpace;
import com.gridnine.xtrip.client.fx.model.profile.PersonSpaceVM;
import com.gridnine.xtrip.client.fx.standard.entity.handlers.person.PersonHandlerConfigurator;
import com.gridnine.xtrip.client.fx.standard.helpers.VMHelper;
import com.gridnine.xtrip.common.fx.gds.corteos.rpc.CorteosService;
import com.gridnine.xtrip.common.fx.model.CorteosOrganizationWrapper;
import com.gridnine.xtrip.common.fx.rpc.DataTransferPackage;
import com.gridnine.xtrip.common.model.EntityReference;
import com.gridnine.xtrip.common.model.corteos.CorteosPersonData;
import com.gridnine.xtrip.common.model.corteos.CorteosPersonProfileData;
import com.gridnine.xtrip.common.model.person.uidata.PersonUIData;
import com.gridnine.xtrip.common.model.profile.Person;
import com.gridnine.xtrip.common.model.standard.helpers.MessagesHelper;
import com.gridnine.xtrip.common.model.system.Message;
import com.gridnine.xtrip.common.model.system.MessageType;
import com.gridnine.xtrip.common.rpc.RpcServiceManager;
import com.gridnine.xtrip.common.rpc.ServiceInvocationContext;
import com.gridnine.xtrip.common.util.MiscUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.function.BiConsumer;
import javafx.scene.Node;

public class CorteosPersonHandlerConfigurator
implements PersonHandlerConfigurator {
    public void configureController(List<BiConsumer<DataTransferPackage<Person, PersonUIData>, PersonSpaceVM>> toVM, List<BiConsumer<PersonSpaceVM, DataTransferPackage<Person, PersonUIData>>> fromVM) {
        ControllersRegistry.register((ControllerInterceptor)new CorteosPersonControllerInterceptor());
        toVM.add((dtp, vm) -> {
            Person model = (Person)dtp.getContainer().getEntity();
            PersonUIData supplement = (PersonUIData)dtp.getSupplement();
            CorteosPersonData corteosSettings = model.getCorteosSettings();
            VMHelper.transfer((Collection)corteosSettings.getProfileData(), (Collection)vm.getExternalSystemSynchronizationFull().getCorteosSync().getProfileData(), message -> new PersonCorteosProfileDataPanelVM(), (data, dataVm) -> {
                dataVm.setCorteosId(data.getCorteosId());
                CorteosOrganizationWrapper wrapper = new CorteosOrganizationWrapper();
                wrapper.setOrganizationId(data.getCorteosOrganizationId());
                wrapper.setOrganizationReference((EntityReference)supplement.getCorteosIdToOrganizationMap().get(data.getCorteosOrganizationId()));
                dataVm.setCorteosOrganizationId(wrapper);
                dataVm.setDeleted(data.isDeleted());
                dataVm.setAccountId(data.getAccountId());
                dataVm.setRoleId(data.getRoleId());
                dataVm.setBlocked(data.getBlocked());
            });
            PersonCorteosBasicParametersVM corteosBasicParameters = vm.getExternalSystemSynchronizationFull().getCorteosSync().getBasicParameters();
            corteosBasicParameters.setNotCreateAccount(corteosSettings.isNotCreateAccount());
            corteosBasicParameters.setLastSyncDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastSyncDate()));
            corteosBasicParameters.setLastSyncAttemptDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastSyncAttemptDate()));
            corteosBasicParameters.setSyncStatus(corteosSettings.getSyncStatus());
            corteosBasicParameters.setLastUpdateDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastUpdateDate()));
            corteosBasicParameters.setLastUpdateAttemptDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastUpdateAttemptDate()));
            corteosBasicParameters.setUpdateStatus(corteosSettings.getUpdateStatus());
            corteosBasicParameters.setLastDeleteDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastDeleteDate()));
            corteosBasicParameters.setLastDeleteAttemptDate(MiscUtil.toLocalDateTime((Date)corteosSettings.getLastDeleteAttemptDate()));
            corteosBasicParameters.setDeleteStatus(corteosSettings.getDeleteStatus());
            VMHelper.transfer((Collection)corteosSettings.getSyncMessages(), (Collection)vm.getExternalSystemSynchronizationFull().getCorteosSync().getSyncMessages(), message -> new PersonCorteosSyncMessagesVM(), this::messageToVm);
            VMHelper.transfer((Collection)corteosSettings.getUpdateMessages(), (Collection)vm.getExternalSystemSynchronizationFull().getCorteosSync().getUpdateMessages(), message -> new PersonCorteosSyncMessagesVM(), this::messageToVm);
            VMHelper.transfer((Collection)corteosSettings.getDeleteMessages(), (Collection)vm.getExternalSystemSynchronizationFull().getCorteosSync().getDeleteMessages(), message -> new PersonCorteosSyncMessagesVM(), this::messageToVm);
        });
        fromVM.add((vm, dtp) -> {
            Person model = (Person)dtp.getContainer().getEntity();
            PersonUIData supplement = (PersonUIData)dtp.getSupplement();
            CorteosPersonData corteosSettings = model.getCorteosSettings();
            VMHelper.transfer((Collection)vm.getExternalSystemSynchronizationFull().getCorteosSync().getProfileData(), (Collection)corteosSettings.getProfileData(), data -> {
                CorteosPersonProfileData profileData = new CorteosPersonProfileData();
                profileData.setCorteosId(data.getCorteosId());
                CorteosOrganizationWrapper wrapper = data.getCorteosOrganizationId();
                profileData.setCorteosOrganizationId(wrapper != null ? wrapper.getOrganizationId() : null);
                profileData.setDeleted(data.isDeleted());
                profileData.setAccountId(data.getAccountId());
                profileData.setRoleId(data.getRoleId());
                profileData.setBlocked(data.getBlocked());
                return profileData;
            });
            corteosSettings.setNotCreateAccount(vm.getExternalSystemSynchronizationFull().getCorteosSync().getBasicParameters().isNotCreateAccount());
        });
    }

    private void messageToVm(Message message, PersonCorteosSyncMessagesVM messageVm) {
        messageVm.setMessageType(message.getType());
        messageVm.setMessageBody(message.getMessage() != null ? message.getMessage().toString() : null);
        messageVm.getDetails().setType(message.getType());
        messageVm.getDetails().setMessage(message.getMessage() != null ? message.getMessage().toString() : null);
        messageVm.getDetails().setDetails(message.getDetails());
    }

    public void collectEditorInterceptors(List<RootEntityEditorInterceptor<Person, PersonUIData>> editorInterceptors) {
        editorInterceptors.add(new RootEntityEditorInterceptor<Person, PersonUIData>(){

            public void onLoad(DataTransferPackage<Person, PersonUIData> data, Node editor) {
            }

            public boolean onSave(DataTransferPackage<Person, PersonUIData> data, Node editor) {
                ArrayList<Message> messages = new ArrayList<Message>();
                Collection profileDatas = ((TableWidget)((PersonCorteosSyncDataPanel)((PersonExtSyncMainPanel)((PersonSpace)editor).getExternalSystemSynchronizationTile().getFullNode()).getCorteosSyncCard().getContent()).getProfileDataCard().getContent()).getRowsData();
                for (PersonCorteosProfileDataPanelVM personProfileData : profileDatas) {
                    if (personProfileData.getCorteosOrganizationId() == null) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CorteosPersonOrganizationIdMissing, (Object[])new Object[0]));
                    }
                    if (personProfileData.getCorteosId() == null || personProfileData.getCorteosId() < 0) {
                        messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CorteosPersonIdInvalidOrMissing, (Object[])new Object[0]));
                        continue;
                    }
                    EntityReference personByCorteosId = null;
                    try {
                        personByCorteosId = ((CorteosService)RpcServiceManager.get().getService(CorteosService.class)).findPersonByCorteosId(ServiceInvocationContext.get(), personProfileData.getCorteosId().toString());
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                    if (personByCorteosId == null || personByCorteosId.equals((Object)data.getContainer().toReference())) continue;
                    messages.add(MessagesHelper.createMessage((MessageType)MessageType.WARNING, (String)Messages.CorteosPersonIdAlreadyExist, (Object[])new Object[]{personProfileData.getCorteosId()}));
                }
                if (!messages.isEmpty()) {
                    try {
                        FxUtil.waitForFxThread(() -> ((PersonSpace)editor).setMessages(messages));
                    }
                    catch (Exception e) {
                        ErrorHandler.handle((Throwable)e);
                    }
                }
                return true;
            }
        });
    }
}

