/*
 * Decompiled with CFR 0.152.
 */
package com.gridnine.xtrip.client.fx.gds.corteos.lrt.handlers;

import com.gridnine.xtrip.client.fx.core.entity.IndexListParameters;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridCell;
import com.gridnine.xtrip.client.fx.core.lib.container.grid.GridContainer;
import com.gridnine.xtrip.client.fx.core.lib.widgets.Suppliers;
import com.gridnine.xtrip.client.fx.core.lib.widgets.TextFieldWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.multi.MultiEntityWidget;
import com.gridnine.xtrip.client.fx.core.lib.widgets.popup.ComboBoxWidget;
import com.gridnine.xtrip.client.fx.gds.corteos.l10n.Messages;
import com.gridnine.xtrip.client.fx.standard.helpers.ControllerInterceptorsHelper;
import com.gridnine.xtrip.client.fx.standard.helpers.ListParametersHelper;
import com.gridnine.xtrip.client.fx.standard.lrt.LrtHandler;
import com.gridnine.xtrip.common.model.corteos.CorteosLoadPersonsTaskConfiguration;
import com.gridnine.xtrip.common.model.corteos.LoadProfilesTaskMode;
import com.gridnine.xtrip.common.model.profile.Organization;
import com.gridnine.xtrip.common.model.profile.OrganizationIndex;
import com.gridnine.xtrip.common.search.SearchCriterion;
import java.io.Serializable;
import javafx.scene.Node;

public class CorteosLoadPersonsTaskHandler
implements LrtHandler<Configurator> {
    public String getTaskClassName() {
        return "com.gridnine.xtrip.server.gds.corteos.tasks.CorteosLoadPersonsTask";
    }

    public Configurator createConfigurator() {
        return new Configurator();
    }

    public Serializable getConfiguration(Configurator configurator) {
        return configurator.createConfiguration();
    }

    public String getId() {
        return "CorteosLoadPersonsTask";
    }

    static final class Configurator
    extends GridContainer {
        private final MultiEntityWidget<Organization> organizationsWidget = new MultiEntityWidget(Organization.class, false);
        private final ComboBoxWidget<LoadProfilesTaskMode> modeWidget = new ComboBoxWidget(false);
        private final TextFieldWidget uniqueCostCodeNameWidget = new TextFieldWidget(false);

        Configurator() {
            super(3);
            IndexListParameters organizationListParameters = ControllerInterceptorsHelper.getOrganizations();
            organizationListParameters.getPatternSearchFields().add(OrganizationIndex.Property.corteosId.name());
            organizationListParameters.getPatternSearchFields().add(OrganizationIndex.Property.corteosClientAgreementNumber.name());
            organizationListParameters.getPatternSearchFields().add(OrganizationIndex.Property.corteosGroupId.name());
            ListParametersHelper.setColumns((IndexListParameters)organizationListParameters, (String[])new String[]{OrganizationIndex.Property.corteosId.name(), OrganizationIndex.Property.corteosClientAgreementNumber.name(), OrganizationIndex.Property.corteosGroupId.name()});
            organizationListParameters.getSearchCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.corteosId.name(), null));
            organizationListParameters.getSearchCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.corteosGroupId.name(), null));
            organizationListParameters.getSearchCriterions().add(SearchCriterion.ne((String)OrganizationIndex.Property.corteosClientAgreementNumber.name(), null));
            this.organizationsWidget.setListParametersSupplier(() -> organizationListParameters);
            this.organizationsWidget.setNoNulls(true);
            this.organizationsWidget.setFieldName(Messages.OnlySelectedOrganizations);
            this.modeWidget.setItemsSupplier(Suppliers.createEnumSupplier(LoadProfilesTaskMode.class));
            this.modeWidget.setSortItems(false);
            this.modeWidget.setValue((Object)LoadProfilesTaskMode.ONLY_PROFILES_WITHOUT_DIFFERENCES);
            this.modeWidget.setNoNulls(true);
            this.getCells().addAll((Object[])new GridCell[]{new GridCell(Messages.OnlySelectedOrganizations, this.organizationsWidget), new GridCell(Messages.TaskMode, this.modeWidget), new GridCell(Messages.UniqueCostCodeName, (Node)this.uniqueCostCodeNameWidget)});
        }

        CorteosLoadPersonsTaskConfiguration createConfiguration() {
            CorteosLoadPersonsTaskConfiguration result = new CorteosLoadPersonsTaskConfiguration();
            result.getOrganizations().addAll(this.organizationsWidget.getValues());
            result.setMode((LoadProfilesTaskMode)this.modeWidget.getValue());
            result.setUniqueCostCodeName(this.uniqueCostCodeNameWidget.getValue());
            return result;
        }
    }
}

